/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.sai.disk.v1.vector.OptimizeFor;

public class IndexWriterConfig {
    public static final String MAXIMUM_NODE_CONNECTIONS = "maximum_node_connections";
    public static final int MAXIMUM_MAXIMUM_NODE_CONNECTIONS = 512;
    public static final int DEFAULT_MAXIMUM_NODE_CONNECTIONS = 16;
    public static final String CONSTRUCTION_BEAM_WIDTH = "construction_beam_width";
    public static final int MAXIMUM_CONSTRUCTION_BEAM_WIDTH = 3200;
    public static final int DEFAULT_CONSTRUCTION_BEAM_WIDTH = 100;
    public static final String SIMILARITY_FUNCTION = "similarity_function";
    public static final VectorSimilarityFunction DEFAULT_SIMILARITY_FUNCTION = VectorSimilarityFunction.COSINE;
    public static final String validSimilarityFunctions = Arrays.stream(VectorSimilarityFunction.values()).map(Enum::name).collect(Collectors.joining(", "));
    public static final String OPTIMIZE_FOR = "optimize_for";
    private static final OptimizeFor DEFAULT_OPTIMIZE_FOR = OptimizeFor.LATENCY;
    private static final String validOptimizeFor = Arrays.stream(OptimizeFor.values()).map(Enum::name).collect(Collectors.joining(", "));
    public static final int MAX_TOP_K = CassandraRelevantProperties.SAI_VECTOR_SEARCH_MAX_TOP_K.getInt();
    private static final IndexWriterConfig EMPTY_CONFIG = new IndexWriterConfig(-1, -1, null, null);
    private final int maximumNodeConnections;
    private final int constructionBeamWidth;
    private final VectorSimilarityFunction similarityFunction;
    private final OptimizeFor optimizeFor;

    public IndexWriterConfig(int maximumNodeConnections, int constructionBeamWidth, VectorSimilarityFunction similarityFunction, OptimizeFor optimizerFor) {
        this.maximumNodeConnections = maximumNodeConnections;
        this.constructionBeamWidth = constructionBeamWidth;
        this.similarityFunction = similarityFunction;
        this.optimizeFor = optimizerFor;
    }

    public int getMaximumNodeConnections() {
        return this.maximumNodeConnections;
    }

    public int getConstructionBeamWidth() {
        return this.constructionBeamWidth;
    }

    public VectorSimilarityFunction getSimilarityFunction() {
        return this.similarityFunction;
    }

    public OptimizeFor getOptimizeFor() {
        return this.optimizeFor;
    }

    public static IndexWriterConfig fromOptions(String indexName, AbstractType<?> type, Map<String, String> options) {
        int maximumNodeConnections = 16;
        int queueSize = 100;
        VectorSimilarityFunction similarityFunction = DEFAULT_SIMILARITY_FUNCTION;
        OptimizeFor optimizeFor = DEFAULT_OPTIMIZE_FOR;
        if (options.get(MAXIMUM_NODE_CONNECTIONS) != null || options.get(CONSTRUCTION_BEAM_WIDTH) != null || options.get(SIMILARITY_FUNCTION) != null || options.get(OPTIMIZE_FOR) != null) {
            String option;
            if (!type.isVector()) {
                throw new InvalidRequestException(String.format("CQL type %s cannot have vector options", type.asCQL3Type()));
            }
            if (options.containsKey(MAXIMUM_NODE_CONNECTIONS)) {
                if (!CassandraRelevantProperties.SAI_VECTOR_ALLOW_CUSTOM_PARAMETERS.getBoolean()) {
                    throw new InvalidRequestException(String.format("Maximum node connections cannot be set without enabling %s", CassandraRelevantProperties.SAI_VECTOR_ALLOW_CUSTOM_PARAMETERS.name()));
                }
                try {
                    maximumNodeConnections = Integer.parseInt(options.get(MAXIMUM_NODE_CONNECTIONS));
                }
                catch (NumberFormatException e) {
                    throw new InvalidRequestException(String.format("Maximum number of connections %s is not a valid integer for index %s", options.get(MAXIMUM_NODE_CONNECTIONS), indexName));
                }
                if (maximumNodeConnections <= 0 || maximumNodeConnections > 512) {
                    throw new InvalidRequestException(String.format("Maximum number of connections for index %s cannot be <= 0 or > %s, was %s", indexName, 512, maximumNodeConnections));
                }
            }
            if (options.containsKey(CONSTRUCTION_BEAM_WIDTH)) {
                if (!CassandraRelevantProperties.SAI_VECTOR_ALLOW_CUSTOM_PARAMETERS.getBoolean()) {
                    throw new InvalidRequestException(String.format("Construction beam width cannot be set without enabling %s", CassandraRelevantProperties.SAI_VECTOR_ALLOW_CUSTOM_PARAMETERS.name()));
                }
                try {
                    queueSize = Integer.parseInt(options.get(CONSTRUCTION_BEAM_WIDTH));
                }
                catch (NumberFormatException e) {
                    throw new InvalidRequestException(String.format("Construction beam width %s is not a valid integer for index %s", options.get(CONSTRUCTION_BEAM_WIDTH), indexName));
                }
                if (queueSize <= 0 || queueSize > 3200) {
                    throw new InvalidRequestException(String.format("Construction beam width for index %s cannot be <= 0 or > %s, was %s", indexName, 3200, queueSize));
                }
            }
            if (options.containsKey(SIMILARITY_FUNCTION)) {
                option = options.get(SIMILARITY_FUNCTION).toUpperCase();
                try {
                    similarityFunction = VectorSimilarityFunction.valueOf((String)option);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidRequestException(String.format("Similarity function %s was not recognized for index %s. Valid values are: %s", option, indexName, validSimilarityFunctions));
                }
            }
            if (options.containsKey(OPTIMIZE_FOR)) {
                option = options.get(OPTIMIZE_FOR).toUpperCase();
                try {
                    optimizeFor = OptimizeFor.valueOf(option);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidRequestException(String.format("optimize_for '%s' was not recognized for index %s. Valid values are: %s", option, indexName, validOptimizeFor));
                }
            }
        }
        return new IndexWriterConfig(maximumNodeConnections, queueSize, similarityFunction, optimizeFor);
    }

    public static IndexWriterConfig emptyConfig() {
        return EMPTY_CONFIG;
    }

    public String toString() {
        return String.format("IndexWriterConfig{%s=%d, %s=%d, %s=%s, %s=%s}", new Object[]{MAXIMUM_NODE_CONNECTIONS, this.maximumNodeConnections, CONSTRUCTION_BEAM_WIDTH, this.constructionBeamWidth, SIMILARITY_FUNCTION, this.similarityFunction, OPTIMIZE_FOR, this.optimizeFor});
    }
}

