/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.JMXResource;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.utils.Hex;

public final class Resources {
    @Deprecated(since="1.2.0")
    public static final String ROOT = "cassandra";
    @Deprecated(since="1.2.0")
    public static final String KEYSPACES = "keyspaces";

    public static List<? extends IResource> chain(IResource resource) {
        ArrayList<IResource> chain = new ArrayList<IResource>();
        while (true) {
            chain.add(resource);
            if (!resource.hasParent()) break;
            resource = resource.getParent();
        }
        return chain;
    }

    public static IResource fromName(String name) {
        if (name.startsWith(RoleResource.root().getName())) {
            return RoleResource.fromName(name);
        }
        if (name.startsWith(DataResource.root().getName())) {
            return DataResource.fromName(name);
        }
        if (name.startsWith(FunctionResource.root().getName())) {
            return FunctionResource.fromName(name);
        }
        if (name.startsWith(JMXResource.root().getName())) {
            return JMXResource.fromName(name);
        }
        throw new IllegalArgumentException(String.format("Name %s is not valid for any resource type", name));
    }

    @Deprecated(since="1.2.0")
    public static String toString(List<Object> resource) {
        StringBuilder buff = new StringBuilder();
        for (Object component : resource) {
            buff.append("/");
            if (component instanceof byte[]) {
                buff.append(Hex.bytesToHex((byte[])component));
                continue;
            }
            buff.append(component);
        }
        return buff.toString();
    }
}

