/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.shutdown.PriorityHook;

public final class BackgroundResourceReleaser {
    public static final String BACKGROUND_RESOURCE_RELEASER = "background~resource~releaser";
    static final boolean BG_RELEASER = Jvm.getBoolean("background.releaser", true);
    private static final boolean BG_RELEASER_THREAD = BG_RELEASER && Jvm.getBoolean("background.releaser.thread", true);
    private static final BlockingQueue<Object> RESOURCES = new ArrayBlockingQueue<Object>(128);
    private static final AtomicLong COUNTER = new AtomicLong();
    private static final Object POISON_PILL = new Object();
    private static final Thread RELEASER = BG_RELEASER_THREAD ? BackgroundResourceReleaser.runBackgroundReleaserThread() : null;
    private static volatile boolean stopping = !BG_RELEASER;

    private BackgroundResourceReleaser() {
    }

    private static Thread runBackgroundReleaserThread() {
        Thread thread = new Thread(BackgroundResourceReleaser::runReleaseResources, BACKGROUND_RESOURCE_RELEASER);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private static void runReleaseResources() {
        try {
            while (true) {
                Object o;
                if ((o = RESOURCES.take()) == POISON_PILL) {
                    Jvm.debug().on(BackgroundResourceReleaser.class, "Stopped thread");
                    break;
                }
                BackgroundResourceReleaser.performRelease(o, true);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Jvm.warn().on(BackgroundResourceReleaser.class, "Died on interrupt");
        }
    }

    public static void stop() {
        stopping = true;
        BackgroundResourceReleaser.releasePendingResources();
        BackgroundResourceReleaser.offerPoisonPill(true);
    }

    public static void release(AbstractCloseable closeable) {
        if (stopping) {
            BackgroundResourceReleaser.performRelease(closeable, false);
        } else {
            BackgroundResourceReleaser.release0(closeable);
        }
    }

    public static void release(AbstractReferenceCounted referenceCounted) {
        if (stopping) {
            BackgroundResourceReleaser.performRelease(referenceCounted, false);
        } else {
            BackgroundResourceReleaser.release0(referenceCounted);
        }
    }

    public static void run(Runnable runnable) {
        if (stopping) {
            BackgroundResourceReleaser.performRelease(runnable, false);
        } else {
            BackgroundResourceReleaser.release0(runnable);
        }
    }

    private static void release0(Object o) {
        COUNTER.incrementAndGet();
        if (RESOURCES.offer(o)) {
            return;
        }
        BackgroundResourceReleaser.performRelease(o, true);
    }

    public static void releasePendingResources() {
        try {
            Object o;
            while ((o = RESOURCES.poll(1L, TimeUnit.MILLISECONDS)) != null) {
                if (o == POISON_PILL) continue;
                BackgroundResourceReleaser.performRelease(o, true);
            }
            if (stopping) {
                BackgroundResourceReleaser.offerPoisonPill(false);
            }
            for (int i = 0; i < 1000 && COUNTER.get() > 0L; ++i) {
                Thread.sleep(1L);
            }
            long left = COUNTER.get();
            if (left != 0L) {
                Jvm.perf().on(BackgroundResourceReleaser.class, "Still got " + left + " resources to clean");
            }
        }
        catch (InterruptedException e) {
            Jvm.warn().on(BackgroundResourceReleaser.class, "Interrupted in releasePendingResources");
            Thread.currentThread().interrupt();
        }
    }

    private static void performRelease(Object o, boolean counted) {
        try {
            if (o instanceof AbstractCloseable) {
                ((AbstractCloseable)o).callPerformClose();
            } else if (o instanceof AbstractReferenceCounted) {
                ((AbstractReferenceCounted)o).performRelease();
            } else if (o instanceof Runnable) {
                ((Runnable)o).run();
            } else {
                Jvm.warn().on(BackgroundResourceReleaser.class, "Don't know how to release a " + o.getClass());
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(BackgroundResourceReleaser.class, "Failed in release/close", e);
        }
        finally {
            if (counted) {
                COUNTER.decrementAndGet();
            }
        }
    }

    public static boolean isOnBackgroundResourceReleaserThread() {
        return Thread.currentThread() == RELEASER;
    }

    private static void offerPoisonPill(boolean warn) {
        if (!RESOURCES.offer(POISON_PILL) && warn) {
            Jvm.warn().on(BackgroundResourceReleaser.class, "Failed to add a stop object to the resource queue");
        }
    }

    static {
        PriorityHook.add(99, BackgroundResourceReleaser::releasePendingResources);
    }
}

