/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileReader;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceConnector;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceSnitch;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Pair;

@Deprecated
public class CloudstackSnitch
extends AbstractCloudMetadataServiceSnitch {
    static final String ZONE_NAME_QUERY_URI = "/latest/meta-data/availability-zone";
    private static final String[] LEASE_FILES = new String[]{"file:///var/lib/dhcp/dhclient.eth0.leases", "file:///var/lib/dhclient/dhclient.eth0.leases"};

    public CloudstackSnitch() throws IOException {
        this(new SnitchProperties(new Properties()));
    }

    public CloudstackSnitch(SnitchProperties snitchProperties) throws IOException {
        this(new AbstractCloudMetadataServiceConnector.DefaultCloudMetadataServiceConnector(snitchProperties.putIfAbsent("metadata_url", CloudstackSnitch.csMetadataEndpoint())));
    }

    public CloudstackSnitch(AbstractCloudMetadataServiceConnector connector) throws IOException {
        super(connector, CloudstackSnitch.resolveDcAndRack(connector));
        logger.warn("{} is deprecated and not actively maintained. It will be removed in the next major version of Cassandra.", (Object)CloudstackSnitch.class.getName());
    }

    private static Pair<String, String> resolveDcAndRack(AbstractCloudMetadataServiceConnector connector) throws IOException {
        String zone = connector.apiCall(ZONE_NAME_QUERY_URI);
        String[] zoneParts = zone.split("-");
        if (zoneParts.length != 3) {
            throw new ConfigurationException("CloudstackSnitch cannot handle invalid zone format: " + zone);
        }
        return Pair.create(zoneParts[0] + "-" + zoneParts[1], zoneParts[2]);
    }

    private static String csMetadataEndpoint() throws ConfigurationException {
        for (String lease_uri : LEASE_FILES) {
            try {
                File lease_file = new File(new URI(lease_uri));
                if (!lease_file.exists()) continue;
                return CloudstackSnitch.csEndpointFromLease(lease_file);
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable(e);
            }
        }
        throw new ConfigurationException("No valid DHCP lease file could be found.");
    }

    private static String csEndpointFromLease(File lease) throws ConfigurationException {
        String endpoint = null;
        Pattern identifierPattern = Pattern.compile("^[ \t]*option dhcp-server-identifier (.*);$");
        try (BufferedReader reader = new BufferedReader(new FileReader(lease));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = identifierPattern.matcher(line);
                if (!matcher.find()) continue;
                endpoint = matcher.group(1);
                break;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("CloudstackSnitch cannot access lease file.");
        }
        if (endpoint == null) {
            throw new ConfigurationException("No metadata server could be found in lease file.");
        }
        return "http://" + endpoint;
    }
}

