/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.cql3.statements.schema.IndexTarget;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.IndexSearchResultIterator;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.iterators.KeyRangeIntersectionIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.metrics.TableQueryMetrics;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.plan.QueryViewBuilder;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;

public class QueryController {
    private final ColumnFamilyStore cfs;
    private final ReadCommand command;
    private final QueryContext queryContext;
    private final TableQueryMetrics tableQueryMetrics;
    private final RowFilter filterOperation;
    private final List<DataRange> ranges;
    private final AbstractBounds<PartitionPosition> mergeRange;

    public QueryController(ColumnFamilyStore cfs, ReadCommand command, RowFilter filterOperation, QueryContext queryContext, TableQueryMetrics tableQueryMetrics) {
        this.cfs = cfs;
        this.command = command;
        this.queryContext = queryContext;
        this.tableQueryMetrics = tableQueryMetrics;
        this.filterOperation = filterOperation;
        this.ranges = QueryController.dataRanges(command);
        DataRange first = this.ranges.get(0);
        DataRange last = this.ranges.get(this.ranges.size() - 1);
        this.mergeRange = this.ranges.size() == 1 ? first.keyRange() : first.keyRange().withNewRight((PartitionPosition)last.keyRange().right);
    }

    public TableMetadata metadata() {
        return this.command.metadata();
    }

    RowFilter filterOperation() {
        return this.filterOperation;
    }

    List<DataRange> dataRanges() {
        return this.ranges;
    }

    AbstractBounds<PartitionPosition> mergeRange() {
        return this.mergeRange;
    }

    public IndexContext getContext(RowFilter.Expression expression) {
        Set<StorageAttachedIndex> indexes = this.cfs.indexManager.getBestIndexFor(expression, StorageAttachedIndex.class);
        return indexes.isEmpty() ? new IndexContext(this.cfs.metadata().keyspace, this.cfs.metadata().name, this.cfs.metadata().partitionKeyType, this.cfs.metadata().comparator, expression.column(), IndexTarget.Type.VALUES, null) : indexes.iterator().next().getIndexContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnfilteredRowIterator queryStorage(PrimaryKey key, ReadExecutionController executionController) {
        if (key == null) {
            throw new IllegalArgumentException("non-null key required");
        }
        try {
            SinglePartitionReadCommand partition = SinglePartitionReadCommand.create(this.cfs.metadata(), this.command.nowInSec(), this.command.columnFilter(), RowFilter.none(), DataLimits.NONE, key.partitionKey(), this.makeFilter(key));
            UnfilteredRowIterator unfilteredRowIterator = partition.queryMemtableAndDisk(this.cfs, executionController);
            return unfilteredRowIterator;
        }
        finally {
            this.queryContext.checkpoint();
        }
    }

    public KeyRangeIterator.Builder getIndexQueryResults(Collection<Expression> expressions) {
        KeyRangeIntersectionIterator.Builder builder = KeyRangeIntersectionIterator.builder(expressions.size());
        QueryViewBuilder queryViewBuilder = new QueryViewBuilder(expressions, this.mergeRange);
        Collection<Pair<Expression, Collection<SSTableIndex>>> queryView = queryViewBuilder.build();
        try {
            for (Pair<Expression, Collection<SSTableIndex>> queryViewPair : queryView) {
                IndexSearchResultIterator index = IndexSearchResultIterator.build((Expression)queryViewPair.left, (Collection)queryViewPair.right, this.mergeRange, this.queryContext);
                ((KeyRangeIterator.Builder)builder).add(index);
            }
        }
        catch (Throwable t) {
            ((KeyRangeIterator.Builder)builder).cleanup();
            queryView.forEach(pair -> ((Collection)pair.right).forEach(SSTableIndex::releaseQuietly));
            throw t;
        }
        return builder;
    }

    public boolean doesNotSelect(PrimaryKey key) {
        return !key.hasEmptyClustering() && !this.command.clusteringIndexFilter(key.partitionKey()).selects(key.clustering());
    }

    private ClusteringIndexFilter makeFilter(PrimaryKey key) {
        ClusteringIndexFilter clusteringIndexFilter = this.command.clusteringIndexFilter(key.partitionKey());
        if (key.hasEmptyClustering()) {
            return clusteringIndexFilter;
        }
        return new ClusteringIndexNamesFilter(FBUtilities.singleton(key.clustering(), this.cfs.metadata().comparator), clusteringIndexFilter.isReversed());
    }

    public void finish() {
        if (this.tableQueryMetrics != null) {
            this.tableQueryMetrics.record(this.queryContext);
        }
    }

    private static List<DataRange> dataRanges(ReadCommand command) {
        if (command instanceof SinglePartitionReadCommand) {
            SinglePartitionReadCommand cmd = (SinglePartitionReadCommand)command;
            DecoratedKey key = cmd.partitionKey();
            return Lists.newArrayList((Object[])new DataRange[]{new DataRange(new Range<PartitionPosition>(key, key), cmd.clusteringIndexFilter())});
        }
        if (command instanceof PartitionRangeReadCommand) {
            PartitionRangeReadCommand cmd = (PartitionRangeReadCommand)command;
            return Lists.newArrayList((Object[])new DataRange[]{cmd.dataRange()});
        }
        throw new AssertionError((Object)("Unsupported read command type: " + command.getClass().getName()));
    }
}

