/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.segment;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.exceptions.QueryCancelledException;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.disk.io.IndexFileUtils;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.disk.v1.postings.PostingsReader;
import org.apache.cassandra.index.sai.disk.v1.trie.TrieTermsDictionaryReader;
import org.apache.cassandra.index.sai.metrics.QueryEventListener;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.lucene.store.IndexInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralIndexSegmentTermsReader
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(LiteralIndexSegmentTermsReader.class);
    private final IndexContext indexContext;
    private final FileHandle termDictionaryFile;
    private final FileHandle postingsFile;
    private final long termDictionaryRoot;

    public LiteralIndexSegmentTermsReader(IndexContext indexContext, FileHandle termsData, FileHandle postingLists, long root, long termsFooterPointer) throws IOException {
        this.indexContext = indexContext;
        this.termDictionaryFile = termsData;
        this.postingsFile = postingLists;
        this.termDictionaryRoot = root;
        try (IndexInput indexInput = IndexFileUtils.instance.openInput(this.termDictionaryFile);){
            SAICodecUtils.validate(indexInput, termsFooterPointer);
        }
        indexInput = IndexFileUtils.instance.openInput(this.postingsFile);
        try {
            SAICodecUtils.validate(indexInput);
        }
        finally {
            if (indexInput != null) {
                indexInput.close();
            }
        }
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.termDictionaryFile);
        FileUtils.closeQuietly(this.postingsFile);
    }

    public PostingList exactMatch(ByteComparable term, QueryEventListener.TrieIndexEventListener perQueryEventListener, QueryContext context) {
        perQueryEventListener.onSegmentHit();
        return new TermQuery(term, perQueryEventListener, context).execute();
    }

    @VisibleForTesting
    public class TermQuery {
        private final IndexInput postingsInput;
        private final IndexInput postingsSummaryInput;
        private final QueryEventListener.TrieIndexEventListener listener;
        private final long lookupStartTime;
        private final QueryContext context;
        private final ByteComparable term;

        TermQuery(ByteComparable term, QueryEventListener.TrieIndexEventListener listener, QueryContext context) {
            this.listener = listener;
            this.postingsInput = IndexFileUtils.instance.openInput(LiteralIndexSegmentTermsReader.this.postingsFile);
            this.postingsSummaryInput = IndexFileUtils.instance.openInput(LiteralIndexSegmentTermsReader.this.postingsFile);
            this.term = term;
            this.lookupStartTime = Clock.Global.nanoTime();
            this.context = context;
        }

        public PostingList execute() {
            try {
                long postingOffset = this.lookupPostingsOffset(this.term);
                if (postingOffset == -1L) {
                    FileUtils.closeQuietly((Closeable)this.postingsInput);
                    FileUtils.closeQuietly((Closeable)this.postingsSummaryInput);
                    return null;
                }
                this.context.checkpoint();
                return this.getPostingsReader(postingOffset);
            }
            catch (Throwable e) {
                if (!(e instanceof QueryCancelledException)) {
                    logger.error(LiteralIndexSegmentTermsReader.this.indexContext.logMessage("Failed to execute term query"), e);
                }
                this.closeOnException();
                throw Throwables.cleaned(e);
            }
        }

        private void closeOnException() {
            FileUtils.closeQuietly((Closeable)this.postingsInput);
            FileUtils.closeQuietly((Closeable)this.postingsSummaryInput);
        }

        public long lookupPostingsOffset(ByteComparable term) {
            try (TrieTermsDictionaryReader reader = new TrieTermsDictionaryReader(LiteralIndexSegmentTermsReader.this.termDictionaryFile.instantiateRebufferer(null), LiteralIndexSegmentTermsReader.this.termDictionaryRoot);){
                long offset = reader.exactMatch(term);
                this.listener.onTraversalComplete(Clock.Global.nanoTime() - this.lookupStartTime, TimeUnit.NANOSECONDS);
                if (offset == -1L) {
                    long l = -1L;
                    return l;
                }
                long l = offset;
                return l;
            }
        }

        public PostingsReader getPostingsReader(long offset) throws IOException {
            PostingsReader.BlocksSummary header = new PostingsReader.BlocksSummary(this.postingsSummaryInput, offset);
            return new PostingsReader(this.postingsInput, header, this.listener.postingListEventListener());
        }
    }
}

