/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.postings;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.postings.PeekablePostingList;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.io.util.FileUtils;

@NotThreadSafe
public class MergePostingList
implements PostingList {
    private final PriorityQueue<PeekablePostingList> postingLists;
    private final List<PeekablePostingList> temp;
    private final Closeable onClose;
    private final long size;
    private long lastRowId = -1L;

    private MergePostingList(PriorityQueue<PeekablePostingList> postingLists, Closeable onClose) {
        this.temp = new ArrayList<PeekablePostingList>(postingLists.size());
        this.onClose = onClose;
        this.postingLists = postingLists;
        long totalPostings = 0L;
        for (PostingList postingList : postingLists) {
            totalPostings += postingList.size();
        }
        this.size = totalPostings;
    }

    public static PostingList merge(PriorityQueue<PeekablePostingList> postings, Closeable onClose) {
        Preconditions.checkArgument((!postings.isEmpty() ? 1 : 0) != 0, (Object)"Cannot merge an empty queue of posting lists");
        return postings.size() > 1 ? new MergePostingList(postings, onClose) : (PostingList)postings.poll();
    }

    public static PostingList merge(PriorityQueue<PeekablePostingList> postings) {
        return MergePostingList.merge(postings, () -> FileUtils.close(postings));
    }

    @Override
    public long nextPosting() throws IOException {
        while (!this.postingLists.isEmpty()) {
            PeekablePostingList head = this.postingLists.poll();
            long next = head.nextPosting();
            if (next == Long.MAX_VALUE) continue;
            if (next > this.lastRowId) {
                this.lastRowId = next;
                this.postingLists.add(head);
                return next;
            }
            if (next != this.lastRowId) continue;
            this.postingLists.add(head);
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long advance(long targetRowID) throws IOException {
        this.temp.clear();
        while (!this.postingLists.isEmpty()) {
            PeekablePostingList peekable = this.postingLists.poll();
            peekable.advanceWithoutConsuming(targetRowID);
            if (peekable.peek() == Long.MAX_VALUE) continue;
            this.temp.add(peekable);
        }
        this.postingLists.addAll(this.temp);
        return this.nextPosting();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.onClose);
    }
}

