/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bbtree;

import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.TermsIterator;
import org.apache.cassandra.index.sai.utils.TypeUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;
import org.apache.lucene.util.packed.PackedLongValues;

public interface BlockBalancedTreeIterator
extends Iterator<Pair<byte[], PostingList>> {
    public static BlockBalancedTreeIterator fromTermsIterator(final TermsIterator termsIterator, final AbstractType<?> termsComparator) {
        return new BlockBalancedTreeIterator(){
            final byte[] scratch;
            {
                this.scratch = new byte[TypeUtil.fixedSizeOf(termsComparator)];
            }

            @Override
            public boolean hasNext() {
                return termsIterator.hasNext();
            }

            @Override
            public Pair<byte[], PostingList> next() {
                ByteComparable term = (ByteComparable)termsIterator.next();
                ByteSourceInverse.copyBytes(term.asComparableBytes(ByteComparable.Version.OSS50), this.scratch);
                return Pair.create(this.scratch, termsIterator.postings());
            }
        };
    }

    public static BlockBalancedTreeIterator fromTrieIterator(final Iterator<Map.Entry<ByteComparable, PackedLongValues.Builder>> iterator, final int bytesPerValue) {
        return new BlockBalancedTreeIterator(){
            final byte[] scratch;
            {
                this.scratch = new byte[bytesPerValue];
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Pair<byte[], PostingList> next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                ByteSourceInverse.copyBytes(((ByteComparable)entry.getKey()).asComparableBytes(ByteComparable.Version.OSS50), this.scratch);
                final PackedLongValues postings = ((PackedLongValues.Builder)entry.getValue()).build();
                final PackedLongValues.Iterator postingsIterator = postings.iterator();
                return Pair.create(this.scratch, new PostingList(){

                    @Override
                    public long nextPosting() {
                        if (postingsIterator.hasNext()) {
                            return postingsIterator.next();
                        }
                        return Long.MAX_VALUE;
                    }

                    @Override
                    public long size() {
                        return postings.size();
                    }

                    @Override
                    public long advance(long targetRowID) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
    }
}

