/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.LongArray;
import org.apache.cassandra.index.sai.disk.v1.SkinnyPrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.v1.bitpack.NumericValuesMeta;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyLookup;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyLookupMeta;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

@NotThreadSafe
public class WidePrimaryKeyMap
extends SkinnyPrimaryKeyMap {
    private final ClusteringComparator clusteringComparator;
    private final KeyLookup.Cursor clusteringKeyCursor;

    private WidePrimaryKeyMap(LongArray tokenArray, LongArray partitionArray, KeyLookup.Cursor partitionKeyCursor, KeyLookup.Cursor clusteringKeyCursor, IPartitioner partitioner, PrimaryKey.Factory primaryKeyFactory, ClusteringComparator clusteringComparator) {
        super(tokenArray, partitionArray, partitionKeyCursor, partitioner, primaryKeyFactory);
        this.clusteringComparator = clusteringComparator;
        this.clusteringKeyCursor = clusteringKeyCursor;
    }

    @Override
    public long rowIdFromPrimaryKey(PrimaryKey primaryKey) {
        long rowId = this.tokenArray.indexOf(primaryKey.token().getLongValue());
        if (primaryKey.isTokenOnly() || rowId < 0L || this.tokenArray.get(rowId) != primaryKey.token().getLongValue()) {
            return rowId;
        }
        rowId = this.tokenCollisionDetection(primaryKey, rowId);
        return this.clusteringKeyCursor.clusteredSeekToKey(this.clusteringComparator.asByteComparable(primaryKey.clustering()), rowId, this.startOfNextPartition(rowId));
    }

    @Override
    public void close() {
        super.close();
        FileUtils.closeQuietly(this.clusteringKeyCursor);
    }

    @Override
    protected PrimaryKey supplier(long sstableRowId) {
        return this.primaryKeyFactory.create(this.readPartitionKey(sstableRowId), this.readClusteringKey(sstableRowId));
    }

    private Clustering<?> readClusteringKey(long sstableRowId) {
        ByteSource.Peekable peekable = ByteSource.peekable(this.clusteringKeyCursor.seekToPointId(sstableRowId).asComparableBytes(ByteComparable.Version.OSS50));
        Clustering<ByteBuffer> clustering = this.clusteringComparator.clusteringFromByteComparable(ByteBufferAccessor.instance, v -> peekable);
        if (clustering == null) {
            clustering = Clustering.EMPTY;
        }
        return clustering;
    }

    private long startOfNextPartition(long rowId) {
        long nextPartitionRowId;
        long partitionId = this.partitionArray.get(rowId);
        if ((nextPartitionRowId = this.partitionArray.indexOf(++partitionId)) == -1L) {
            nextPartitionRowId = this.partitionArray.length();
        }
        return nextPartitionRowId;
    }

    @ThreadSafe
    public static class Factory
    extends SkinnyPrimaryKeyMap.Factory {
        private final ClusteringComparator clusteringComparator;
        private final KeyLookup clusteringKeyReader;
        private final FileHandle clusteringKeyBlockOffsetsFile;
        private final FileHandle clustingingKeyBlocksFile;

        public Factory(IndexDescriptor indexDescriptor, SSTableReader sstable) {
            super(indexDescriptor, sstable);
            this.clusteringKeyBlockOffsetsFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.CLUSTERING_KEY_BLOCK_OFFSETS, this::close);
            this.clustingingKeyBlocksFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.CLUSTERING_KEY_BLOCKS, this::close);
            try {
                this.clusteringComparator = indexDescriptor.clusteringComparator;
                NumericValuesMeta clusteringKeyBlockOffsetsMeta = new NumericValuesMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.CLUSTERING_KEY_BLOCK_OFFSETS)));
                KeyLookupMeta clusteringKeyMeta = new KeyLookupMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.CLUSTERING_KEY_BLOCKS)));
                this.clusteringKeyReader = new KeyLookup(this.clustingingKeyBlocksFile, this.clusteringKeyBlockOffsetsFile, clusteringKeyMeta, clusteringKeyBlockOffsetsMeta);
            }
            catch (Throwable t) {
                throw Throwables.unchecked(t);
            }
        }

        @Override
        public PrimaryKeyMap newPerSSTablePrimaryKeyMap() throws IOException {
            LongArray.DeferredLongArray rowIdToToken = new LongArray.DeferredLongArray(this.tokenReaderFactory::open);
            LongArray.DeferredLongArray partitionIdToToken = new LongArray.DeferredLongArray(this.partitionReaderFactory::open);
            return new WidePrimaryKeyMap(rowIdToToken, partitionIdToToken, this.partitionKeyReader.openCursor(), this.clusteringKeyReader.openCursor(), this.partitioner, this.primaryKeyFactory, this.clusteringComparator);
        }

        @Override
        public void close() {
            super.close();
            FileUtils.closeQuietly(Arrays.asList(this.clustingingKeyBlocksFile, this.clusteringKeyBlockOffsetsFile));
        }
    }
}

