/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.QueryCancelledException;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeUnionIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSearchResultIterator
extends KeyRangeIterator {
    private static final Logger logger = LoggerFactory.getLogger(IndexSearchResultIterator.class);
    private final QueryContext context;
    private final KeyRangeIterator union;
    private final Collection<SSTableIndex> referencedIndexes;

    private IndexSearchResultIterator(KeyRangeIterator union, Collection<SSTableIndex> referencedIndexes, QueryContext queryContext) {
        super(union.getMinimum(), union.getMaximum(), union.getCount());
        this.union = union;
        this.referencedIndexes = referencedIndexes;
        this.context = queryContext;
    }

    public static IndexSearchResultIterator build(Expression expression, Collection<SSTableIndex> sstableIndexes, AbstractBounds<PartitionPosition> keyRange, QueryContext queryContext) {
        ArrayList<KeyRangeIterator> subIterators = new ArrayList<KeyRangeIterator>(1 + sstableIndexes.size());
        KeyRangeIterator memtableIterator = expression.context.getMemtableIndexManager().searchMemtableIndexes(expression, keyRange);
        if (memtableIterator != null) {
            subIterators.add(memtableIterator);
        }
        for (SSTableIndex sstableIndex : sstableIndexes) {
            try {
                queryContext.checkpoint();
                ++queryContext.sstablesHit;
                if (sstableIndex.isReleased()) {
                    throw new IllegalStateException(sstableIndex.getIndexContext().logMessage("Index was released from the view during the query"));
                }
                List<KeyRangeIterator> segmentIterators = sstableIndex.search(expression, keyRange, queryContext);
                if (segmentIterators.isEmpty()) continue;
                subIterators.addAll(segmentIterators);
            }
            catch (Throwable e) {
                if (!(e instanceof QueryCancelledException)) {
                    logger.debug(sstableIndex.getIndexContext().logMessage(String.format("Failed search an index %s, aborting query.", sstableIndex.getSSTable())), e);
                }
                throw Throwables.cleaned(e);
            }
        }
        KeyRangeIterator union = KeyRangeUnionIterator.build(subIterators);
        return new IndexSearchResultIterator(union, sstableIndexes, queryContext);
    }

    @Override
    protected PrimaryKey computeNext() {
        try {
            PrimaryKey primaryKey = this.union.hasNext() ? (PrimaryKey)this.union.next() : (PrimaryKey)this.endOfData();
            return primaryKey;
        }
        finally {
            this.context.checkpoint();
        }
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        try {
            this.union.skipTo(nextKey);
        }
        finally {
            this.context.checkpoint();
        }
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.union);
        this.referencedIndexes.forEach(IndexSearchResultIterator::releaseQuietly);
        this.referencedIndexes.clear();
    }

    private static void releaseQuietly(SSTableIndex index) {
        try {
            index.release();
        }
        catch (Throwable e) {
            logger.error(index.getIndexContext().logMessage(String.format("Failed to release index on SSTable %s", index.getSSTable())), e);
        }
    }
}

