/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SimpleBuilders;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.BTreePartitionData;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.RowIterators;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorSerializer;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.UpdateFunction;
import org.apache.cassandra.utils.vint.VIntCoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionUpdate
extends AbstractBTreePartition {
    protected static final Logger logger = LoggerFactory.getLogger(PartitionUpdate.class);
    public static final PartitionUpdateSerializer serializer = new PartitionUpdateSerializer();
    private final BTreePartitionData holder;
    private final DeletionInfo deletionInfo;
    private final TableMetadata metadata;
    private final boolean canHaveShadowedData;

    private PartitionUpdate(TableMetadata metadata, DecoratedKey key, BTreePartitionData holder, MutableDeletionInfo deletionInfo, boolean canHaveShadowedData) {
        super(key);
        this.metadata = metadata;
        this.holder = holder;
        this.deletionInfo = deletionInfo;
        this.canHaveShadowedData = canHaveShadowedData;
    }

    public static PartitionUpdate emptyUpdate(TableMetadata metadata, DecoratedKey key) {
        MutableDeletionInfo deletionInfo = MutableDeletionInfo.live();
        BTreePartitionData holder = new BTreePartitionData(RegularAndStaticColumns.NONE, BTree.empty(), deletionInfo, Rows.EMPTY_STATIC_ROW, EncodingStats.NO_STATS);
        return new PartitionUpdate(metadata, key, holder, deletionInfo, false);
    }

    public static PartitionUpdate fullPartitionDelete(TableMetadata metadata, DecoratedKey key, long timestamp, long nowInSec) {
        MutableDeletionInfo deletionInfo = new MutableDeletionInfo(timestamp, nowInSec);
        BTreePartitionData holder = new BTreePartitionData(RegularAndStaticColumns.NONE, BTree.empty(), deletionInfo, Rows.EMPTY_STATIC_ROW, EncodingStats.NO_STATS);
        return new PartitionUpdate(metadata, key, holder, deletionInfo, false);
    }

    public static PartitionUpdate singleRowUpdate(TableMetadata metadata, DecoratedKey key, Row row, Row staticRow) {
        MutableDeletionInfo deletionInfo = MutableDeletionInfo.live();
        BTreePartitionData holder = new BTreePartitionData(new RegularAndStaticColumns(staticRow == null ? Columns.NONE : Columns.from(staticRow), row == null ? Columns.NONE : Columns.from(row)), row == null ? BTree.empty() : BTree.singleton(row), deletionInfo, staticRow == null ? Rows.EMPTY_STATIC_ROW : staticRow, EncodingStats.NO_STATS);
        return new PartitionUpdate(metadata, key, holder, deletionInfo, false);
    }

    public static PartitionUpdate singleRowUpdate(TableMetadata metadata, DecoratedKey key, Row row) {
        return PartitionUpdate.singleRowUpdate(metadata, key, row.isStatic() ? null : row, row.isStatic() ? row : null);
    }

    public static PartitionUpdate singleRowUpdate(TableMetadata metadata, ByteBuffer key, Row row) {
        return PartitionUpdate.singleRowUpdate(metadata, metadata.partitioner.decorateKey(key), row);
    }

    public static PartitionUpdate fromIterator(UnfilteredRowIterator iterator, ColumnFilter filter) {
        iterator = UnfilteredRowIterators.withOnlyQueriedData(iterator, filter);
        BTreePartitionData holder = PartitionUpdate.build(iterator, 16);
        MutableDeletionInfo deletionInfo = (MutableDeletionInfo)holder.deletionInfo;
        return new PartitionUpdate(iterator.metadata(), iterator.partitionKey(), holder, deletionInfo, false);
    }

    public static PartitionUpdate fromIterator(RowIterator iterator, ColumnFilter filter) {
        iterator = RowIterators.withOnlyQueriedData(iterator, filter);
        MutableDeletionInfo deletionInfo = MutableDeletionInfo.live();
        BTreePartitionData holder = PartitionUpdate.build(iterator, deletionInfo, true);
        return new PartitionUpdate(iterator.metadata(), iterator.partitionKey(), holder, deletionInfo, false);
    }

    public PartitionUpdate withOnlyPresentColumns() {
        HashSet<ColumnMetadata> columnSet = new HashSet<ColumnMetadata>();
        for (Row row : this) {
            for (ColumnData column : row) {
                columnSet.add(column.column());
            }
        }
        RegularAndStaticColumns columns = RegularAndStaticColumns.builder().addAll(columnSet).build();
        return new PartitionUpdate(this.metadata, this.partitionKey, this.holder.withColumns(columns), this.deletionInfo.mutableCopy(), false);
    }

    @Override
    protected boolean canHaveShadowedData() {
        return this.canHaveShadowedData;
    }

    public static PartitionUpdate fromBytes(ByteBuffer bytes, int version) {
        if (bytes == null) {
            return null;
        }
        try {
            return serializer.deserialize(new DataInputBuffer(bytes, true), version, DeserializationHelper.Flag.LOCAL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer toBytes(PartitionUpdate update, int version) {
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            serializer.serialize(update, out, version);
            ByteBuffer byteBuffer = out.buffer();
            out.close();
            return byteBuffer;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static PartitionUpdate fullPartitionDelete(TableMetadata metadata, ByteBuffer key, long timestamp, long nowInSec) {
        return PartitionUpdate.fullPartitionDelete(metadata, metadata.partitioner.decorateKey(key), timestamp, nowInSec);
    }

    public static PartitionUpdate merge(List<PartitionUpdate> updates) {
        assert (!updates.isEmpty());
        int size = updates.size();
        if (size == 1) {
            return (PartitionUpdate)Iterables.getOnlyElement(updates);
        }
        List asIterators = Lists.transform(updates, AbstractBTreePartition::unfilteredIterator);
        return PartitionUpdate.fromIterator(UnfilteredRowIterators.merge(asIterators), ColumnFilter.all(updates.get(0).metadata()));
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.deletionInfo;
    }

    public int operationCount() {
        return this.rowCount() + (this.staticRow().isEmpty() ? 0 : 1) + this.deletionInfo.rangeCount() + (this.deletionInfo.getPartitionDeletion().isLive() ? 0 : 1);
    }

    public int dataSize() {
        return Ints.saturatedCast((long)(BTree.accumulate(this.holder.tree, (row, value) -> (long)row.dataSize() + value, 0L) + (long)this.holder.staticRow.dataSize() + (long)this.holder.deletionInfo.dataSize()));
    }

    public long unsharedHeapSize() {
        return BTree.accumulate(this.holder.tree, (row, value) -> row.unsharedHeapSize() + value, 0L) + this.holder.staticRow.unsharedHeapSize() + this.holder.deletionInfo.unsharedHeapSize();
    }

    @Override
    public TableMetadata metadata() {
        return this.metadata;
    }

    @Override
    public RegularAndStaticColumns columns() {
        return this.holder.columns;
    }

    @Override
    protected BTreePartitionData holder() {
        return this.holder;
    }

    @Override
    public EncodingStats stats() {
        return this.holder().stats;
    }

    public void validate() {
        for (Row row : this) {
            this.metadata().comparator.validate(row.clustering());
            for (ColumnData cd : row) {
                cd.validate();
            }
        }
    }

    public long maxTimestamp() {
        long maxTimestamp = this.deletionInfo.maxTimestamp();
        for (Row row : this) {
            maxTimestamp = Math.max(maxTimestamp, row.primaryKeyLivenessInfo().timestamp());
            for (ColumnData cd : row) {
                if (cd.column().isSimple()) {
                    maxTimestamp = Math.max(maxTimestamp, ((Cell)cd).timestamp());
                    continue;
                }
                ComplexColumnData complexData = (ComplexColumnData)cd;
                maxTimestamp = Math.max(maxTimestamp, complexData.complexDeletion().markedForDeleteAt());
                for (Cell<?> cell : complexData) {
                    maxTimestamp = Math.max(maxTimestamp, cell.timestamp());
                }
            }
        }
        if (this.holder.staticRow != null) {
            for (ColumnData cd : this.holder.staticRow.columnData()) {
                if (cd.column().isSimple()) {
                    maxTimestamp = Math.max(maxTimestamp, ((Cell)cd).timestamp());
                    continue;
                }
                ComplexColumnData complexData = (ComplexColumnData)cd;
                maxTimestamp = Math.max(maxTimestamp, complexData.complexDeletion().markedForDeleteAt());
                for (Cell<?> cell : complexData) {
                    maxTimestamp = Math.max(maxTimestamp, cell.timestamp());
                }
            }
        }
        return maxTimestamp;
    }

    public List<CounterMark> collectCounterMarks() {
        assert (this.metadata().isCounter());
        ArrayList<CounterMark> marks = new ArrayList<CounterMark>();
        PartitionUpdate.addMarksForRow(this.staticRow(), marks);
        for (Row row : this) {
            PartitionUpdate.addMarksForRow(row, marks);
        }
        return marks;
    }

    public int affectedRowCount() {
        if (!this.partitionLevelDeletion().isLive()) {
            return 1;
        }
        int count = 0;
        if (this.deletionInfo().hasRanges()) {
            count += this.deletionInfo().rangeCount();
        }
        count += this.rowCount();
        if (!this.staticRow().isEmpty()) {
            ++count;
        }
        return count;
    }

    public int affectedColumnCount() {
        if (!this.partitionLevelDeletion().isLive()) {
            return this.metadata().regularAndStaticColumns().size();
        }
        int count = 0;
        if (this.deletionInfo().hasRanges()) {
            count += this.deletionInfo().rangeCount() * this.metadata().regularColumns().size();
        }
        for (Row row : this) {
            if (row.deletion().isLive()) {
                count += row.columnCount();
                continue;
            }
            count += this.metadata().regularColumns().size();
        }
        if (!this.staticRow().isEmpty()) {
            count += this.staticRow().columnCount();
        }
        return count;
    }

    private static void addMarksForRow(Row row, List<CounterMark> marks) {
        for (Cell<?> cell : row.cells()) {
            if (!cell.isCounterCell()) continue;
            marks.add(new CounterMark(row, cell.column(), cell.path()));
        }
    }

    public static SimpleBuilder simpleBuilder(TableMetadata metadata, Object ... partitionKeyValues) {
        return new SimpleBuilders.PartitionUpdateBuilder(metadata, partitionKeyValues);
    }

    public void validateIndexedColumns() {
        IndexRegistry.obtain(this.metadata()).validate(this);
    }

    @VisibleForTesting
    public static PartitionUpdate unsafeConstruct(TableMetadata metadata, DecoratedKey key, BTreePartitionData holder, MutableDeletionInfo deletionInfo, boolean canHaveShadowedData) {
        return new PartitionUpdate(metadata, key, holder, deletionInfo, canHaveShadowedData);
    }

    public static class Builder {
        private final TableMetadata metadata;
        private final DecoratedKey key;
        private final MutableDeletionInfo deletionInfo;
        private final boolean canHaveShadowedData;
        private Object[] tree = BTree.empty();
        private final BTree.Builder<Row> rowBuilder;
        private Row staticRow = Rows.EMPTY_STATIC_ROW;
        private final RegularAndStaticColumns columns;
        private boolean isBuilt = false;

        public Builder(TableMetadata metadata, DecoratedKey key, RegularAndStaticColumns columns, int initialRowCapacity, boolean canHaveShadowedData) {
            this(metadata, key, columns, initialRowCapacity, canHaveShadowedData, Rows.EMPTY_STATIC_ROW, MutableDeletionInfo.live(), BTree.empty());
        }

        private Builder(TableMetadata metadata, DecoratedKey key, RegularAndStaticColumns columns, int initialRowCapacity, boolean canHaveShadowedData, BTreePartitionData holder) {
            this(metadata, key, columns, initialRowCapacity, canHaveShadowedData, holder.staticRow, holder.deletionInfo, holder.tree);
        }

        private Builder(TableMetadata metadata, DecoratedKey key, RegularAndStaticColumns columns, int initialRowCapacity, boolean canHaveShadowedData, Row staticRow, DeletionInfo deletionInfo, Object[] tree) {
            this.metadata = metadata;
            this.key = key;
            this.columns = columns;
            this.rowBuilder = this.rowBuilder(initialRowCapacity);
            this.canHaveShadowedData = canHaveShadowedData;
            this.deletionInfo = deletionInfo.mutableCopy();
            this.staticRow = staticRow;
            this.tree = tree;
        }

        public Builder(TableMetadata metadata, DecoratedKey key, RegularAndStaticColumns columnDefinitions, int size) {
            this(metadata, key, columnDefinitions, size, true);
        }

        public Builder(PartitionUpdate base, int initialRowCapacity) {
            this(base.metadata, base.partitionKey, base.columns(), initialRowCapacity, base.canHaveShadowedData, base.holder);
        }

        public Builder(TableMetadata metadata, ByteBuffer key, RegularAndStaticColumns columns, int initialRowCapacity) {
            this(metadata, metadata.partitioner.decorateKey(key), columns, initialRowCapacity, true);
        }

        public void add(Row row) {
            if (row.isEmpty()) {
                return;
            }
            if (row.isStatic()) {
                assert (this.columns().statics.containsAll(row.columns())) : this.columns().statics + " is not superset of " + row.columns();
                this.staticRow = this.staticRow.isEmpty() ? row : Rows.merge(this.staticRow, row);
            } else {
                assert (this.columns().regulars.containsAll(row.columns())) : this.columns().regulars + " is not superset of " + row.columns();
                this.rowBuilder.add(row);
            }
        }

        public void addPartitionDeletion(DeletionTime deletionTime) {
            this.deletionInfo.add(deletionTime);
        }

        public void add(RangeTombstone range) {
            this.deletionInfo.add(range, this.metadata.comparator);
        }

        public DecoratedKey partitionKey() {
            return this.key;
        }

        public TableMetadata metadata() {
            return this.metadata;
        }

        public PartitionUpdate build() {
            assert (!this.isBuilt) : "A PartitionUpdate.Builder should only get built once";
            Object[] add = this.rowBuilder.build();
            Object[] merged = BTree.update(this.tree, add, this.metadata.comparator, UpdateFunction.Simple.of(Rows::merge));
            EncodingStats newStats = EncodingStats.Collector.collect(this.staticRow, BTree.iterator(merged), this.deletionInfo);
            this.isBuilt = true;
            return new PartitionUpdate(this.metadata, this.partitionKey(), new BTreePartitionData(this.columns, merged, this.deletionInfo, this.staticRow, newStats), this.deletionInfo, this.canHaveShadowedData);
        }

        public RegularAndStaticColumns columns() {
            return this.columns;
        }

        public DeletionTime partitionLevelDeletion() {
            return this.deletionInfo.getPartitionDeletion();
        }

        private BTree.Builder<Row> rowBuilder(int initialCapacity) {
            return BTree.builder(this.metadata.comparator, initialCapacity).setQuickResolver(Rows::merge);
        }

        public Builder updateAllTimestamp(long newTimestamp) {
            this.deletionInfo.updateAllTimestamp(newTimestamp - 1L);
            this.tree = BTree.transformAndFilter(this.tree, x -> x.updateAllTimestamp(newTimestamp));
            this.staticRow = this.staticRow.updateAllTimestamp(newTimestamp);
            return this;
        }

        public String toString() {
            return "Builder{metadata=" + this.metadata + ", key=" + this.key + ", deletionInfo=" + this.deletionInfo + ", canHaveShadowedData=" + this.canHaveShadowedData + ", staticRow=" + this.staticRow + ", columns=" + this.columns + ", isBuilt=" + this.isBuilt + "}";
        }
    }

    public static class CounterMark {
        private final Row row;
        private final ColumnMetadata column;
        private final CellPath path;

        private CounterMark(Row row, ColumnMetadata column, CellPath path) {
            this.row = row;
            this.column = column;
            this.path = path;
        }

        public Clustering<?> clustering() {
            return this.row.clustering();
        }

        public ColumnMetadata column() {
            return this.column;
        }

        public CellPath path() {
            return this.path;
        }

        public ByteBuffer value() {
            return this.path == null ? this.row.getCell(this.column).buffer() : this.row.getCell(this.column, this.path).buffer();
        }

        public void setValue(ByteBuffer value) {
            assert (this.row instanceof BTreeRow);
            ((BTreeRow)this.row).setValue(this.column, this.path, value);
        }
    }

    public static class PartitionUpdateSerializer {
        public void serialize(PartitionUpdate update, DataOutputPlus out, int version) throws IOException {
            try (UnfilteredRowIterator iter = update.unfilteredIterator();){
                assert (!iter.isReverseOrder());
                update.metadata.id.serialize(out);
                UnfilteredRowIteratorSerializer.serializer.serialize(iter, null, out, version, update.rowCount());
            }
        }

        public PartitionUpdate deserialize(DataInputPlus in, int version, DeserializationHelper.Flag flag) throws IOException {
            Object[] rows;
            TableMetadata metadata = Schema.instance.getExistingTableMetadata(TableId.deserialize(in));
            UnfilteredRowIteratorSerializer.Header header = UnfilteredRowIteratorSerializer.serializer.deserializeHeader(metadata, null, in, version, flag);
            if (header.isEmpty) {
                return PartitionUpdate.emptyUpdate(metadata, header.key);
            }
            assert (!header.isReversed);
            assert (header.rowEstimate >= 0);
            MutableDeletionInfo.Builder deletionBuilder = MutableDeletionInfo.builder(header.partitionDeletion, metadata.comparator, false);
            try (BTree.FastBuilder<Row> builder = BTree.fastBuilder();
                 UnfilteredRowIterator partition = UnfilteredRowIteratorSerializer.serializer.deserialize(in, version, metadata, flag, header);){
                while (partition.hasNext()) {
                    Unfiltered unfiltered = (Unfiltered)partition.next();
                    if (unfiltered.kind() == Unfiltered.Kind.ROW) {
                        builder.add((Row)unfiltered);
                        continue;
                    }
                    deletionBuilder.add((RangeTombstoneMarker)unfiltered);
                }
                rows = builder.build();
            }
            MutableDeletionInfo deletionInfo = deletionBuilder.build();
            return new PartitionUpdate(metadata, header.key, new BTreePartitionData(header.sHeader.columns(), rows, deletionInfo, header.staticRow, header.sHeader.stats()), deletionInfo, false);
        }

        public static boolean isEmpty(ByteBuffer in, DeserializationHelper.Flag flag, DecoratedKey key) throws IOException {
            int keyLength;
            int position = in.position();
            if ((position += 16) >= in.limit()) {
                throw new EOFException();
            }
            if ((position += (keyLength = VIntCoding.getUnsignedVInt32(in, position)) + VIntCoding.computeUnsignedVIntSize(keyLength)) >= in.limit()) {
                throw new EOFException();
            }
            int flags = in.get(position) & 0xFF;
            return (flags & 1) != 0;
        }

        public long serializedSize(PartitionUpdate update, int version) {
            try (UnfilteredRowIterator iter = update.unfilteredIterator();){
                long l = (long)update.metadata.id.serializedSize() + UnfilteredRowIteratorSerializer.serializer.serializedSize(iter, null, version, update.rowCount());
                return l;
            }
        }
    }

    public static interface SimpleBuilder {
        public TableMetadata metadata();

        public SimpleBuilder timestamp(long var1);

        public SimpleBuilder ttl(int var1);

        public SimpleBuilder nowInSec(long var1);

        public Row.SimpleBuilder row(Object ... var1);

        public SimpleBuilder delete();

        public RangeTombstoneBuilder addRangeTombstone();

        public SimpleBuilder addRangeTombstone(RangeTombstone var1);

        public PartitionUpdate build();

        public Mutation buildAsMutation();

        public static interface RangeTombstoneBuilder {
            public RangeTombstoneBuilder start(Object ... var1);

            public RangeTombstoneBuilder end(Object ... var1);

            public RangeTombstoneBuilder inclStart();

            public RangeTombstoneBuilder exclStart();

            public RangeTombstoneBuilder inclEnd();

            public RangeTombstoneBuilder exclEnd();
        }
    }
}

