/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Vectors;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.JsonUtils;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public final class VectorType<T>
extends AbstractType<List<T>> {
    private static final ConcurrentHashMap<Key, VectorType> instances = new ConcurrentHashMap();
    public final AbstractType<T> elementType;
    public final int dimension;
    private final TypeSerializer<T> elementSerializer;
    private final int valueLengthIfFixed;
    private final VectorSerializer serializer;

    private VectorType(AbstractType<T> elementType, int dimension) {
        super(AbstractType.ComparisonType.CUSTOM);
        if (dimension <= 0) {
            throw new InvalidRequestException(String.format("vectors may only have positive dimensions; given %d", dimension));
        }
        this.elementType = elementType;
        this.dimension = dimension;
        this.elementSerializer = elementType.getSerializer();
        this.valueLengthIfFixed = elementType.isValueLengthFixed() ? elementType.valueLengthIfFixed() * dimension : super.valueLengthIfFixed();
        this.serializer = elementType.isValueLengthFixed() ? new FixedLengthSerializer() : new VariableLengthSerializer();
    }

    public static <T> VectorType<T> getInstance(AbstractType<T> elements, int dimension) {
        Key key = new Key(elements, dimension);
        return instances.computeIfAbsent(key, rec$ -> ((Key)rec$).create());
    }

    public static VectorType<?> getInstance(TypeParser parser) {
        TypeParser.Vector v = parser.getVectorParameters();
        return VectorType.getInstance(v.type.freeze(), v.dimension);
    }

    @Override
    public boolean isVector() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return this.getSerializer().compareCustom(left, accessorL, right, accessorR);
    }

    @Override
    public int valueLengthIfFixed() {
        return this.valueLengthIfFixed;
    }

    public VectorSerializer getSerializer() {
        return this.serializer;
    }

    public List<ByteBuffer> split(ByteBuffer buffer) {
        return this.split(buffer, ByteBufferAccessor.instance);
    }

    public <V> List<V> split(V buffer, ValueAccessor<V> accessor) {
        return this.getSerializer().split(buffer, accessor);
    }

    public float[] composeAsFloat(ByteBuffer input) {
        return this.composeAsFloat(input, ByteBufferAccessor.instance);
    }

    public <V> float[] composeAsFloat(V input, ValueAccessor<V> accessor) {
        if (!(this.elementType instanceof FloatType)) {
            throw new IllegalStateException("Attempted to read as float, but element type is " + this.elementType.asCQL3Type());
        }
        if (this.isNull(input, accessor)) {
            return null;
        }
        float[] array = new float[this.dimension];
        int offset = 0;
        for (int i = 0; i < this.dimension; ++i) {
            array[i] = accessor.getFloat(input, offset);
            offset += 4;
        }
        return array;
    }

    public ByteBuffer decomposeAsFloat(float[] value) {
        return this.decomposeAsFloat(ByteBufferAccessor.instance, value);
    }

    public <V> V decomposeAsFloat(ValueAccessor<V> accessor, float[] value) {
        if (!(this.elementType instanceof FloatType)) {
            throw new IllegalStateException("Attempted to read as float, but element type is " + this.elementType.asCQL3Type());
        }
        if (value == null) {
            return null;
        }
        if (value.length != this.dimension) {
            throw new IllegalArgumentException(String.format("Attempted to add float vector of dimension %d to %s", value.length, this.asCQL3Type()));
        }
        V buffer = accessor.allocate(4 * this.dimension);
        int offset = 0;
        for (int i = 0; i < this.dimension; ++i) {
            accessor.putFloat(buffer, offset, value[i]);
            offset += 4;
        }
        return buffer;
    }

    public ByteBuffer decomposeRaw(List<ByteBuffer> elements) {
        return this.decomposeRaw(elements, ByteBufferAccessor.instance);
    }

    public <V> V decomposeRaw(List<V> elements, ValueAccessor<V> accessor) {
        return this.getSerializer().serializeRaw(elements, accessor);
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V value, ByteComparable.Version version) {
        if (this.isNull(value, accessor)) {
            return null;
        }
        ByteSource[] srcs = new ByteSource[this.dimension];
        List<V> split = this.split(value, accessor);
        for (int i = 0; i < this.dimension; ++i) {
            srcs[i] = this.elementType.asComparableBytes(accessor, split.get(i), version);
        }
        return ByteSource.withTerminatorMaybeLegacy(version, 0, srcs);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        if (comparableBytes == null) {
            return accessor.empty();
        }
        assert (version != ByteComparable.Version.LEGACY);
        ArrayList<V> buffers = new ArrayList<V>();
        int separator = comparableBytes.next();
        while (separator != 56) {
            buffers.add(this.elementType.fromComparableBytes(accessor, comparableBytes, version));
            separator = comparableBytes.next();
        }
        return (V)this.decomposeRaw(buffers, accessor);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return new CQL3Type.Vector(this);
    }

    public AbstractType<T> getElementsType() {
        return this.elementType;
    }

    @Override
    public <V> String getString(V value, ValueAccessor<V> accessor) {
        return BytesType.instance.getString(value, accessor);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        try {
            return ByteBufferUtil.hexToBytes(source);
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public List<AbstractType<?>> subTypes() {
        return Collections.singletonList(this.elementType);
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return this.toJSONString(buffer, ByteBufferAccessor.instance, protocolVersion);
    }

    @Override
    public <V> String toJSONString(V value, ValueAccessor<V> accessor, ProtocolVersion protocolVersion) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        List<V> split = this.split(value, accessor);
        for (int i = 0; i < this.dimension; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.elementType.toJSONString(split.get(i), accessor, protocolVersion));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            parsed = JsonUtils.decodeJson((String)parsed);
        }
        if (!(parsed instanceof List)) {
            throw new MarshalException(String.format("Expected a list, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        List list = (List)parsed;
        if (list.size() != this.dimension) {
            throw new MarshalException(String.format("List had incorrect size: expected %d but given %d; %s", this.dimension, list.size(), list));
        }
        ArrayList<Term> terms = new ArrayList<Term>(list.size());
        for (Object element : list) {
            if (element == null) {
                throw new MarshalException("Invalid null element in list");
            }
            terms.add(this.elementType.fromJSONObject(element));
        }
        return new Vectors.DelayedValue(this, terms);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorType that = (VectorType)o;
        return this.dimension == that.dimension && Objects.equals(this.elementType, that.elementType);
    }

    public int hashCode() {
        return Objects.hash(this.elementType, this.dimension);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean ignoreFreezing) {
        return this.getClass().getName() + TypeParser.stringifyVectorParameters(this.elementType, ignoreFreezing, this.dimension);
    }

    private void check(List<?> values) {
        if (values.size() != this.dimension) {
            throw new MarshalException(String.format("Required %d elements, but saw %d", this.dimension, values.size()));
        }
        for (int i = 0; i < this.dimension; ++i) {
            Object value = values.get(i);
            if (value != null && (!(value instanceof ByteBuffer) || !this.elementSerializer.isNull((ByteBuffer)value))) continue;
            throw new MarshalException(String.format("Element at index %d is null (expected type %s); given %s", i, this.elementType.asCQL3Type(), values));
        }
    }

    private <V> void checkConsumedFully(V buffer, ValueAccessor<V> accessor, int offset) {
        int remaining = accessor.sizeFromOffset(buffer, offset);
        if (remaining > 0) {
            throw new MarshalException("Unexpected " + remaining + " extraneous bytes after " + this.asCQL3Type() + " value");
        }
    }

    private class VariableLengthSerializer
    extends VectorSerializer {
        private VariableLengthSerializer() {
        }

        @Override
        public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
            if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
                return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
            }
            int leftOffset = 0;
            int rightOffset = 0;
            for (int i = 0; i < VectorType.this.dimension; ++i) {
                VL leftBytes = this.readValue(left, accessorL, leftOffset);
                leftOffset += this.sizeOf(leftBytes, accessorL);
                VR rightBytes = this.readValue(right, accessorR, rightOffset);
                rightOffset += this.sizeOf(rightBytes, accessorR);
                int rc = VectorType.this.elementType.compare(leftBytes, accessorL, rightBytes, accessorR);
                if (rc == 0) continue;
                return rc;
            }
            return 0;
        }

        private <V> V readValue(V input, ValueAccessor<V> accessor, int offset) {
            int size = accessor.getUnsignedVInt32(input, offset);
            if (size < 0) {
                throw new AssertionError((Object)("Invalidate data at offset " + offset + "; saw size of " + size + " but only >= 0 is expected"));
            }
            return accessor.slice(input, offset + TypeSizes.sizeofUnsignedVInt(size), size);
        }

        private <V> int writeValue(V src, V dst, ValueAccessor<V> accessor, int offset) {
            int size = accessor.size(src);
            int written = 0;
            written += accessor.putUnsignedVInt32(dst, offset + written, size);
            written += accessor.copyTo(src, 0, dst, accessor, offset + written, size);
            return written;
        }

        private <V> int sizeOf(V bb, ValueAccessor<V> accessor) {
            return accessor.sizeWithVIntLength(bb);
        }

        @Override
        public <V> List<V> split(V buffer, ValueAccessor<V> accessor) {
            ArrayList<V> result = new ArrayList<V>(VectorType.this.dimension);
            int offset = 0;
            for (int i = 0; i < VectorType.this.dimension; ++i) {
                V bb = this.readValue(buffer, accessor, offset);
                offset += this.sizeOf(bb, accessor);
                VectorType.this.elementSerializer.validate(bb, accessor);
                result.add(bb);
            }
            VectorType.this.checkConsumedFully(buffer, accessor, offset);
            return result;
        }

        @Override
        public <V> V serializeRaw(List<V> value, ValueAccessor<V> accessor) {
            if (value == null) {
                return accessor.empty();
            }
            VectorType.this.check(value);
            V bb = accessor.allocate(value.stream().mapToInt(v -> this.sizeOf(v, accessor)).sum());
            int offset = 0;
            for (V b : value) {
                offset += this.writeValue(b, bb, accessor, offset);
            }
            return bb;
        }

        @Override
        public ByteBuffer serialize(List<T> value) {
            if (value == null) {
                return ByteBufferUtil.EMPTY_BYTE_BUFFER;
            }
            VectorType.this.check(value);
            ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(VectorType.this.dimension);
            for (int i = 0; i < VectorType.this.dimension; ++i) {
                bbs.add(VectorType.this.elementSerializer.serialize(value.get(i)));
            }
            return this.serializeRaw(bbs, ByteBufferAccessor.instance);
        }

        @Override
        public <V> List<T> deserialize(V input, ValueAccessor<V> accessor) {
            if (this.isNull(input, accessor)) {
                return null;
            }
            ArrayList result = new ArrayList(VectorType.this.dimension);
            int offset = 0;
            for (int i = 0; i < VectorType.this.dimension; ++i) {
                V bb = this.readValue(input, accessor, offset);
                offset += this.sizeOf(bb, accessor);
                VectorType.this.elementSerializer.validate(bb, accessor);
                result.add(VectorType.this.elementSerializer.deserialize(bb, accessor));
            }
            VectorType.this.checkConsumedFully(input, accessor, offset);
            return result;
        }

        @Override
        public <V> void validate(V input, ValueAccessor<V> accessor) throws MarshalException {
            if (accessor.isEmpty(input)) {
                return;
            }
            int offset = 0;
            for (int i = 0; i < VectorType.this.dimension; ++i) {
                if (offset >= accessor.size(input)) {
                    throw new MarshalException("Not enough bytes to read a " + VectorType.this.asCQL3Type());
                }
                V bb = this.readValue(input, accessor, offset);
                offset += this.sizeOf(bb, accessor);
                VectorType.this.elementSerializer.validate(bb, accessor);
            }
            VectorType.this.checkConsumedFully(input, accessor, offset);
        }
    }

    private class FixedLengthSerializer
    extends VectorSerializer {
        private FixedLengthSerializer() {
        }

        @Override
        public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
            if (VectorType.this.elementType.isByteOrderComparable) {
                return ValueAccessor.compare(left, accessorL, right, accessorR);
            }
            if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
                return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
            }
            int offset = 0;
            int elementLength = VectorType.this.elementType.valueLengthIfFixed();
            for (int i = 0; i < VectorType.this.dimension; ++i) {
                VR rightBytes;
                VL leftBytes = accessorL.slice(left, offset, elementLength);
                int rc = VectorType.this.elementType.compare(leftBytes, accessorL, rightBytes = accessorR.slice(right, offset, elementLength), accessorR);
                if (rc != 0) {
                    return rc;
                }
                offset += elementLength;
            }
            return 0;
        }

        @Override
        public <V> List<V> split(V buffer, ValueAccessor<V> accessor) {
            ArrayList<V> result = new ArrayList<V>(VectorType.this.dimension);
            int offset = 0;
            int elementLength = VectorType.this.elementType.valueLengthIfFixed();
            for (int i = 0; i < VectorType.this.dimension; ++i) {
                V bb = accessor.slice(buffer, offset, elementLength);
                offset += elementLength;
                VectorType.this.elementSerializer.validate(bb, accessor);
                result.add(bb);
            }
            VectorType.this.checkConsumedFully(buffer, accessor, offset);
            return result;
        }

        @Override
        public <V> V serializeRaw(List<V> value, ValueAccessor<V> accessor) {
            if (value == null) {
                return accessor.empty();
            }
            VectorType.this.check(value);
            int size = VectorType.this.elementType.valueLengthIfFixed();
            V bb = accessor.allocate(size * VectorType.this.dimension);
            int position = 0;
            for (V v : value) {
                position += accessor.copyTo(v, 0, bb, accessor, position, size);
            }
            return bb;
        }

        @Override
        public ByteBuffer serialize(List<T> value) {
            if (value == null) {
                return ByteBufferUtil.EMPTY_BYTE_BUFFER;
            }
            VectorType.this.check(value);
            ByteBuffer bb = ByteBuffer.allocate(VectorType.this.elementType.valueLengthIfFixed() * VectorType.this.dimension);
            for (Object v : value) {
                bb.put(VectorType.this.elementSerializer.serialize(v).duplicate());
            }
            bb.flip();
            return bb;
        }

        @Override
        public <V> List<T> deserialize(V input, ValueAccessor<V> accessor) {
            if (this.isNull(input, accessor)) {
                return null;
            }
            ArrayList result = new ArrayList(VectorType.this.dimension);
            int offset = 0;
            int elementLength = VectorType.this.elementType.valueLengthIfFixed();
            for (int i = 0; i < VectorType.this.dimension; ++i) {
                V bb = accessor.slice(input, offset, elementLength);
                offset += elementLength;
                VectorType.this.elementSerializer.validate(bb, accessor);
                result.add(VectorType.this.elementSerializer.deserialize(bb, accessor));
            }
            VectorType.this.checkConsumedFully(input, accessor, offset);
            return result;
        }

        @Override
        public <V> void validate(V input, ValueAccessor<V> accessor) throws MarshalException {
            if (accessor.isEmpty(input)) {
                return;
            }
            int offset = 0;
            int elementSize = VectorType.this.elementType.valueLengthIfFixed();
            int expectedSize = elementSize * VectorType.this.dimension;
            if (accessor.size(input) < expectedSize) {
                throw new MarshalException("Not enough bytes to read a " + VectorType.this.asCQL3Type());
            }
            for (int i = 0; i < VectorType.this.dimension; ++i) {
                V bb = accessor.slice(input, offset, elementSize);
                offset += elementSize;
                VectorType.this.elementSerializer.validate(bb, accessor);
            }
            VectorType.this.checkConsumedFully(input, accessor, offset);
        }
    }

    public abstract class VectorSerializer
    extends TypeSerializer<List<T>> {
        public abstract <VL, VR> int compareCustom(VL var1, ValueAccessor<VL> var2, VR var3, ValueAccessor<VR> var4);

        public abstract <V> List<V> split(V var1, ValueAccessor<V> var2);

        public abstract <V> V serializeRaw(List<V> var1, ValueAccessor<V> var2);

        @Override
        public String toString(List<T> value) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            sb.append('[');
            for (Object element : value) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(VectorType.this.elementSerializer.toString(element));
            }
            sb.append(']');
            return sb.toString();
        }

        @Override
        public Class<List<T>> getType() {
            return List.class;
        }
    }

    private static class Key {
        private final AbstractType<?> type;
        private final int dimension;

        private Key(AbstractType<?> type, int dimension) {
            this.type = type;
            this.dimension = dimension;
        }

        private VectorType<?> create() {
            return new VectorType(this.type, this.dimension);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.dimension == key.dimension && Objects.equals(this.type, key.type);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.dimension);
        }
    }
}

