/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.IntegerSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public final class IntegerType
extends NumberType<BigInteger> {
    public static final IntegerType instance = new IntegerType();
    private static final ArgumentDeserializer ARGUMENT_DESERIALIZER = new AbstractType.DefaultArgumentDeserializer(instance);
    private static final ByteBuffer MASKED_VALUE = instance.decompose(BigInteger.ZERO);
    private static final int POSITIVE_VARINT_HEADER = 128;
    private static final int NEGATIVE_VARINT_LENGTH_HEADER = 0;
    private static final int POSITIVE_VARINT_LENGTH_HEADER = 255;
    private static final byte BIG_INTEGER_NEGATIVE_LEADING_ZERO = -1;
    private static final byte BIG_INTEGER_POSITIVE_LEADING_ZERO = 0;
    public static final int FULL_FORM_THRESHOLD = 7;

    private static <V> int findMostSignificantByte(V value, ValueAccessor<V> accessor) {
        byte b0;
        int i;
        int len = accessor.size(value) - 1;
        for (i = 0; i < len && ((b0 = accessor.getByte(value, i)) == 0 || b0 == -1); ++i) {
            byte b1 = accessor.getByte(value, i + 1);
            if (b0 == 0 && b1 != 0) {
                if (b1 <= 0) break;
                ++i;
                break;
            }
            if (b0 != -1 || b1 == -1) continue;
            if (b1 >= 0) break;
            ++i;
            break;
        }
        return i;
    }

    IntegerType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return IntegerType.compareIntegers(left, accessorL, right, accessorR);
    }

    public static <VL, VR> int compareIntegers(VL lhs, ValueAccessor<VL> accessorL, VR rhs, ValueAccessor<VR> accessorR) {
        int lhsLen = accessorL.size(lhs);
        int rhsLen = accessorR.size(rhs);
        if (lhsLen == 0) {
            return rhsLen == 0 ? 0 : -1;
        }
        if (rhsLen == 0) {
            return 1;
        }
        int lhsMsbIdx = IntegerType.findMostSignificantByte(lhs, accessorL);
        int rhsMsbIdx = IntegerType.findMostSignificantByte(rhs, accessorR);
        int lhsLenDiff = lhsLen - lhsMsbIdx;
        int rhsLenDiff = rhsLen - rhsMsbIdx;
        byte lhsMsb = accessorL.getByte(lhs, lhsMsbIdx);
        byte rhsMsb = accessorR.getByte(rhs, rhsMsbIdx);
        if (lhsLenDiff != rhsLenDiff) {
            if (lhsMsb < 0) {
                return rhsMsb < 0 ? rhsLenDiff - lhsLenDiff : -1;
            }
            if (rhsMsb < 0) {
                return 1;
            }
            return lhsLenDiff - rhsLenDiff;
        }
        if (lhsMsb != rhsMsb) {
            return lhsMsb - rhsMsb;
        }
        ++lhsMsbIdx;
        ++rhsMsbIdx;
        while (lhsMsbIdx < lhsLen) {
            if ((lhsMsb = accessorL.getByte(lhs, lhsMsbIdx++)) == (rhsMsb = accessorR.getByte(rhs, rhsMsbIdx++))) continue;
            return (lhsMsb & 0xFF) - (rhsMsb & 0xFF);
        }
        return 0;
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        int limit = accessor.size(data);
        if (limit == 0) {
            return null;
        }
        int p = 0;
        byte signbyte = accessor.getByte(data, p);
        if (signbyte == -1 || signbyte == 0) {
            while (p + 1 < limit && accessor.getByte(data, ++p) == signbyte) {
            }
        }
        if (version != ByteComparable.Version.LEGACY) {
            return limit - p < 7 ? this.encodeAsVarInt(accessor, data, limit) : this.asComparableBytesCurrent(accessor, data, p, limit, signbyte >> 7 & 0xFF);
        }
        return this.asComparableBytesLegacy(accessor, data, p, limit, signbyte);
    }

    private <V> ByteSource encodeAsVarInt(ValueAccessor<V> accessor, V data, int limit) {
        long v;
        switch (limit) {
            case 1: {
                v = accessor.getByte(data, 0);
                break;
            }
            case 2: {
                v = accessor.getShort(data, 0);
                break;
            }
            case 3: {
                v = accessor.getShort(data, 0) << 8 | accessor.getByte(data, 2) & 0xFF;
                break;
            }
            case 4: {
                v = accessor.getInt(data, 0);
                break;
            }
            case 5: {
                v = (long)accessor.getInt(data, 0) << 8 | (long)(accessor.getByte(data, 4) & 0xFF);
                break;
            }
            case 6: {
                v = (long)accessor.getInt(data, 0) << 16 | (long)(accessor.getShort(data, 4) & 0xFFFF);
                break;
            }
            case 7: {
                v = (long)accessor.getInt(data, 0) << 24 | (long)((accessor.getShort(data, 4) & 0xFFFF) << 8) | (long)(accessor.getByte(data, 6) & 0xFF);
                break;
            }
            case 8: {
                v = accessor.getLong(data, 0);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return ByteSource.variableLengthInteger(v);
    }

    private <V> ByteSource asComparableBytesCurrent(final ValueAccessor<V> accessor, final V data, final int startpos, final int limit, final int signbyte) {
        return new ByteSource(){
            int pos = -2;
            ByteSource lengthEncoding = new ByteSource.VariableLengthUnsignedInteger(limit - startpos - 7);

            @Override
            public int next() {
                if (this.pos == -2) {
                    ++this.pos;
                    return signbyte ^ 0xFF;
                }
                if (this.pos == -1) {
                    int nextByte = this.lengthEncoding.next();
                    if (nextByte != -1) {
                        return nextByte ^ signbyte;
                    }
                    this.pos = startpos;
                }
                if (this.pos == limit) {
                    return -1;
                }
                return accessor.getByte(data, this.pos++) & 0xFF;
            }
        };
    }

    private <V> ByteSource asComparableBytesLegacy(final ValueAccessor<V> accessor, final V data, final int startpos, final int limit, final int signbyte) {
        return new ByteSource(){
            int pos;
            int sizeToReport;
            boolean sizeReported;
            {
                this.pos = startpos;
                this.sizeToReport = limit - startpos;
                this.sizeReported = false;
            }

            @Override
            public int next() {
                if (!this.sizeReported) {
                    if (this.sizeToReport >= 128) {
                        this.sizeToReport -= 128;
                        return signbyte >= 0 ? 255 : 0;
                    }
                    this.sizeReported = true;
                    return signbyte >= 0 ? 128 + (this.sizeToReport - 1) : 128 - this.sizeToReport;
                }
                if (this.pos == limit) {
                    return -1;
                }
                return accessor.getByte(data, this.pos++) & 0xFF;
            }
        };
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        assert (version != ByteComparable.Version.LEGACY);
        if (comparableBytes == null) {
            return accessor.empty();
        }
        int sign = comparableBytes.peek() ^ 0xFF;
        if (sign != 255 && sign != 0) {
            return this.extractVarIntBytes(accessor, ByteSourceInverse.getVariableLengthInteger(comparableBytes));
        }
        comparableBytes.next();
        int valueBytes = Math.toIntExact(ByteSourceInverse.getVariableLengthUnsignedIntegerXoring(comparableBytes, sign) + 7L);
        return this.extractBytes(accessor, comparableBytes, sign, valueBytes);
    }

    private <V> V extractVarIntBytes(ValueAccessor<V> accessor, long value) {
        int length = (64 - Long.numberOfLeadingZeros(value ^ value >> 63) + 8) / 8;
        V buf = accessor.allocate(length);
        switch (length) {
            case 1: {
                accessor.putByte(buf, 0, (byte)value);
                break;
            }
            case 2: {
                accessor.putShort(buf, 0, (short)value);
                break;
            }
            case 3: {
                accessor.putShort(buf, 0, (short)(value >> 8));
                accessor.putByte(buf, 2, (byte)value);
                break;
            }
            case 4: {
                accessor.putInt(buf, 0, (int)value);
                break;
            }
            case 5: {
                accessor.putInt(buf, 0, (int)(value >> 8));
                accessor.putByte(buf, 4, (byte)value);
                break;
            }
            case 6: {
                accessor.putInt(buf, 0, (int)(value >> 16));
                accessor.putShort(buf, 4, (short)value);
                break;
            }
            case 7: {
                accessor.putInt(buf, 0, (int)(value >> 24));
                accessor.putShort(buf, 4, (short)(value >> 8));
                accessor.putByte(buf, 6, (byte)value);
                break;
            }
            case 8: {
                accessor.putLong(buf, 0, value);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return buf;
    }

    private <V> V extractBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, int sign, int valueBytes) {
        V buf;
        int writtenBytes = 0;
        int curr = comparableBytes.next();
        if ((curr & 0x80) != (sign & 0x80)) {
            buf = accessor.allocate(++valueBytes);
            accessor.putByte(buf, writtenBytes++, (byte)sign);
        } else {
            buf = accessor.allocate(valueBytes);
        }
        accessor.putByte(buf, writtenBytes++, (byte)curr);
        while (writtenBytes < valueBytes) {
            accessor.putByte(buf, writtenBytes++, (byte)comparableBytes.next());
        }
        return buf;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        BigInteger integerType;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            integerType = new BigInteger(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make int from '%s'", source), e);
        }
        return this.decompose(integerType);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.getSerializer().serialize(new BigInteger(parsed.toString())));
        }
        catch (NumberFormatException exc) {
            throw new MarshalException(String.format("Value '%s' is not a valid representation of a varint value", parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return Objects.toString(this.getSerializer().deserialize(buffer), "\"\"");
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || Int32Type.instance.isValueCompatibleWith(otherType) || LongType.instance.isValueCompatibleWith(otherType);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.VARINT;
    }

    @Override
    public TypeSerializer<BigInteger> getSerializer() {
        return IntegerSerializer.instance;
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return ARGUMENT_DESERIALIZER;
    }

    private BigInteger toBigInteger(Number number) {
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    @Override
    public ByteBuffer add(Number left, Number right) {
        return this.decompose(this.toBigInteger(left).add(this.toBigInteger(right)));
    }

    @Override
    public ByteBuffer substract(Number left, Number right) {
        return this.decompose(this.toBigInteger(left).subtract(this.toBigInteger(right)));
    }

    @Override
    public ByteBuffer multiply(Number left, Number right) {
        return this.decompose(this.toBigInteger(left).multiply(this.toBigInteger(right)));
    }

    @Override
    public ByteBuffer divide(Number left, Number right) {
        return this.decompose(this.toBigInteger(left).divide(this.toBigInteger(right)));
    }

    @Override
    public ByteBuffer mod(Number left, Number right) {
        return this.decompose(this.toBigInteger(left).remainder(this.toBigInteger(right)));
    }

    @Override
    public ByteBuffer negate(Number input) {
        return this.decompose(this.toBigInteger(input).negate());
    }

    @Override
    public ByteBuffer abs(Number input) {
        return this.decompose(this.toBigInteger(input).abs());
    }

    @Override
    public ByteBuffer exp(Number input) {
        BigInteger bi = this.toBigInteger(input);
        BigDecimal bd = new BigDecimal(bi);
        BigDecimal result = DecimalType.instance.exp(bd);
        BigInteger out = result.toBigInteger();
        return instance.decompose(out);
    }

    @Override
    public ByteBuffer log(Number input) {
        BigInteger bi = this.toBigInteger(input);
        if (bi.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Natural log of number zero or less");
        }
        BigDecimal bd = new BigDecimal(bi);
        BigDecimal result = DecimalType.instance.log(bd);
        BigInteger out = result.toBigInteger();
        return instance.decompose(out);
    }

    @Override
    public ByteBuffer log10(Number input) {
        BigInteger bi = this.toBigInteger(input);
        if (bi.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Log10 of number zero or less");
        }
        BigDecimal bd = new BigDecimal(bi);
        BigDecimal result = DecimalType.instance.log10(bd);
        BigInteger out = result.toBigInteger();
        return instance.decompose(out);
    }

    @Override
    public ByteBuffer round(Number input) {
        return this.decompose(this.toBigInteger(input));
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return MASKED_VALUE;
    }
}

