/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.Int32Serializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;
import org.apache.commons.lang3.mutable.MutableInt;

public class Int32Type
extends NumberType<Integer> {
    public static final Int32Type instance = new Int32Type();
    private static final ByteBuffer MASKED_VALUE = instance.decompose(0);

    Int32Type() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        int diff = accessorL.getByte(left, 0) - accessorR.getByte(right, 0);
        if (diff != 0) {
            return diff;
        }
        return ValueAccessor.compare(left, accessorL, right, accessorR);
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        return ByteSource.optionalSignedFixedLengthNumber(accessor, data);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        return ByteSourceInverse.getOptionalSignedFixedLength(accessor, comparableBytes, 4);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        int int32Type;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            int32Type = Integer.parseInt(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("Unable to make int from '%s'", source), e);
        }
        return this.decompose(int32Type);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            if (parsed instanceof String) {
                return new Constants.Value(this.fromString((String)parsed));
            }
            Number parsedNumber = (Number)parsed;
            if (!(parsedNumber instanceof Integer)) {
                throw new MarshalException(String.format("Expected an int value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
            }
            return new Constants.Value(this.getSerializer().serialize(parsedNumber.intValue()));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected an int value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return Objects.toString(this.getSerializer().deserialize(buffer), "\"\"");
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.INT;
    }

    @Override
    public TypeSerializer<Integer> getSerializer() {
        return Int32Serializer.instance;
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return new NumberType.NumberArgumentDeserializer<MutableInt>(new MutableInt()){

            @Override
            protected void setMutableValue(MutableInt mutable, ByteBuffer buffer) {
                mutable.setValue(ByteBufferUtil.toInt(buffer));
            }
        };
    }

    @Override
    public int valueLengthIfFixed() {
        return 4;
    }

    @Override
    public ByteBuffer add(Number left, Number right) {
        return ByteBufferUtil.bytes(left.intValue() + right.intValue());
    }

    @Override
    public ByteBuffer substract(Number left, Number right) {
        return ByteBufferUtil.bytes(left.intValue() - right.intValue());
    }

    @Override
    public ByteBuffer multiply(Number left, Number right) {
        return ByteBufferUtil.bytes(left.intValue() * right.intValue());
    }

    @Override
    public ByteBuffer divide(Number left, Number right) {
        return ByteBufferUtil.bytes(left.intValue() / right.intValue());
    }

    @Override
    public ByteBuffer mod(Number left, Number right) {
        return ByteBufferUtil.bytes(left.intValue() % right.intValue());
    }

    @Override
    public ByteBuffer negate(Number input) {
        return ByteBufferUtil.bytes(-input.intValue());
    }

    @Override
    public ByteBuffer abs(Number input) {
        return ByteBufferUtil.bytes(Math.abs(input.intValue()));
    }

    @Override
    public ByteBuffer exp(Number input) {
        return ByteBufferUtil.bytes((int)Math.exp(input.intValue()));
    }

    @Override
    public ByteBuffer log(Number input) {
        return ByteBufferUtil.bytes((int)Math.log(input.intValue()));
    }

    @Override
    public ByteBuffer log10(Number input) {
        return ByteBufferUtil.bytes((int)Math.log10(input.intValue()));
    }

    @Override
    public ByteBuffer round(Number input) {
        return ByteBufferUtil.bytes(input.intValue());
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return MASKED_VALUE;
    }
}

