/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.unified;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.ShardManager;
import org.apache.cassandra.db.compaction.UnifiedCompactionStrategy;
import org.apache.cassandra.db.compaction.unified.Controller;
import org.apache.cassandra.db.compaction.unified.ShardedCompactionWriter;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class UnifiedCompactionTask
extends CompactionTask {
    private final ShardManager shardManager;
    private final Controller controller;

    public UnifiedCompactionTask(ColumnFamilyStore cfs, UnifiedCompactionStrategy strategy, LifecycleTransaction txn, long gcBefore, ShardManager shardManager) {
        super(cfs, txn, gcBefore, strategy.getController().getIgnoreOverlapsInExpirationCheck());
        this.controller = strategy.getController();
        this.shardManager = shardManager;
    }

    @Override
    public CompactionAwareWriter getCompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
        double density = this.shardManager.calculateCombinedDensity(nonExpiredSSTables);
        int numShards = this.controller.getNumShards(density * this.shardManager.shardSetCoverage());
        return new ShardedCompactionWriter(cfs, directories, txn, nonExpiredSSTables, this.keepOriginals, this.shardManager.boundaries(numShards));
    }
}

