/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.unified;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.compaction.ShardTracker;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.TimeUUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedMultiWriter
implements SSTableMultiWriter {
    protected static final Logger logger = LoggerFactory.getLogger(ShardedMultiWriter.class);
    private final ColumnFamilyStore cfs;
    private final Descriptor descriptor;
    private final long keyCount;
    private final long repairedAt;
    private final TimeUUID pendingRepair;
    private final boolean isTransient;
    private final IntervalSet<CommitLogPosition> commitLogPositions;
    private final SerializationHeader header;
    private final Collection<Index.Group> indexGroups;
    private final LifecycleNewTracker lifecycleNewTracker;
    private final ShardTracker boundaries;
    private final SSTableWriter[] writers;
    private int currentWriter;

    public ShardedMultiWriter(ColumnFamilyStore cfs, Descriptor descriptor, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, IntervalSet<CommitLogPosition> commitLogPositions, SerializationHeader header, Collection<Index.Group> indexGroups, LifecycleNewTracker lifecycleNewTracker, ShardTracker boundaries) {
        this.cfs = cfs;
        this.descriptor = descriptor;
        this.keyCount = keyCount;
        this.repairedAt = repairedAt;
        this.pendingRepair = pendingRepair;
        this.isTransient = isTransient;
        this.commitLogPositions = commitLogPositions;
        this.header = header;
        this.indexGroups = indexGroups;
        this.lifecycleNewTracker = lifecycleNewTracker;
        this.boundaries = boundaries;
        this.writers = new SSTableWriter[this.boundaries.count()];
        this.currentWriter = 0;
        this.writers[this.currentWriter] = this.createWriter(descriptor);
    }

    private SSTableWriter createWriter() {
        Descriptor newDesc = this.cfs.newSSTableDescriptor(this.descriptor.directory);
        return this.createWriter(newDesc);
    }

    private SSTableWriter createWriter(Descriptor descriptor) {
        MetadataCollector metadataCollector = new MetadataCollector(this.cfs.metadata().comparator).commitLogIntervals(this.commitLogPositions != null ? this.commitLogPositions : IntervalSet.empty());
        return ((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTable.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)descriptor.getFormat().getWriterFactory().builder(descriptor)).setKeyCount(this.forSplittingKeysBy(this.boundaries.count()))).setRepairedAt(this.repairedAt)).setPendingRepair(this.pendingRepair)).setTransientSSTable(this.isTransient)).setTableMetadataRef(this.cfs.metadata)).setMetadataCollector(metadataCollector)).setSerializationHeader(this.header)).addDefaultComponents(this.indexGroups)).addFlushObserversForSecondaryIndexes(this.indexGroups, this.lifecycleNewTracker, this.cfs.metadata.get())).build(this.lifecycleNewTracker, this.cfs);
    }

    private long forSplittingKeysBy(long splits) {
        return splits <= 1L ? this.keyCount : this.keyCount / splits;
    }

    @Override
    public void append(UnfilteredRowIterator partition) {
        DecoratedKey key = partition.partitionKey();
        long currentUncompressedSize = this.writers[this.currentWriter].getFilePointer();
        if (this.boundaries.advanceTo(key.getToken()) && currentUncompressedSize > 0L) {
            logger.debug("Switching writer at boundary {}/{} index {}, with uncompressed size {} for {}.{}", new Object[]{key.getToken(), this.boundaries.shardStart(), this.currentWriter, FBUtilities.prettyPrintMemory(currentUncompressedSize), this.cfs.getKeyspaceName(), this.cfs.getTableName()});
            this.writers[++this.currentWriter] = this.createWriter();
        }
        this.writers[this.currentWriter].append(partition);
    }

    @Override
    public Collection<SSTableReader> finish(boolean openResult) {
        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>(this.writers.length);
        for (SSTableWriter writer : this.writers) {
            if (writer == null) continue;
            this.boundaries.applyTokenSpaceCoverage(writer);
            sstables.add(writer.finish(openResult));
        }
        return sstables;
    }

    @Override
    public Collection<SSTableReader> finished() {
        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>(this.writers.length);
        for (SSTableWriter writer : this.writers) {
            if (writer == null) continue;
            sstables.add(writer.finished());
        }
        return sstables;
    }

    @Override
    public SSTableMultiWriter setOpenResult(boolean openResult) {
        for (SSTableWriter writer : this.writers) {
            if (writer == null) continue;
            writer.setOpenResult(openResult);
        }
        return this;
    }

    @Override
    public String getFilename() {
        for (SSTableWriter writer : this.writers) {
            if (writer == null) continue;
            return writer.getFilename();
        }
        return "";
    }

    @Override
    public long getBytesWritten() {
        long bytesWritten = 0L;
        for (int i = 0; i <= this.currentWriter; ++i) {
            bytesWritten += this.writers[i].getFilePointer();
        }
        return bytesWritten;
    }

    @Override
    public long getOnDiskBytesWritten() {
        long bytesWritten = 0L;
        for (int i = 0; i <= this.currentWriter; ++i) {
            bytesWritten += this.writers[i].getEstimatedOnDiskBytesWritten();
        }
        return bytesWritten;
    }

    @Override
    public TableId getTableId() {
        return this.cfs.metadata().id;
    }

    @Override
    public Throwable commit(Throwable accumulate) {
        Throwable t = accumulate;
        for (SSTableWriter writer : this.writers) {
            if (writer == null) continue;
            t = writer.commit(t);
        }
        return t;
    }

    @Override
    public Throwable abort(Throwable accumulate) {
        Throwable t = accumulate;
        for (SSTableWriter writer : this.writers) {
            if (writer == null) continue;
            this.lifecycleNewTracker.untrackNew(writer);
            t = writer.abort(t);
        }
        return t;
    }

    @Override
    public void prepareToCommit() {
        for (SSTableWriter writer : this.writers) {
            if (writer == null) continue;
            this.boundaries.applyTokenSpaceCoverage(writer);
            writer.prepareToCommit();
        }
    }

    @Override
    public void close() {
        for (SSTableWriter writer : this.writers) {
            if (writer == null) continue;
            writer.close();
        }
    }
}

