/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.Callable;
import org.apache.cassandra.concurrent.DebuggableTask;
import org.apache.cassandra.concurrent.ExecutionFailure;
import org.apache.cassandra.concurrent.ExecutorLocals;
import org.apache.cassandra.concurrent.FutureTask;
import org.apache.cassandra.concurrent.FutureTaskWithResources;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.WithResources;
import org.apache.cassandra.utils.concurrent.RunnableFuture;

@Shared(scope={Shared.Scope.SIMULATION}, inner=Shared.Recursive.INTERFACES)
public interface TaskFactory {
    public Runnable toExecute(Runnable var1);

    public <T> RunnableFuture<T> toSubmit(Runnable var1);

    public <T> RunnableFuture<T> toSubmit(Runnable var1, T var2);

    public <T> RunnableFuture<T> toSubmit(Callable<T> var1);

    public Runnable toExecute(WithResources var1, Runnable var2);

    public <T> RunnableFuture<T> toSubmit(WithResources var1, Runnable var2);

    public <T> RunnableFuture<T> toSubmit(WithResources var1, Runnable var2, T var3);

    public <T> RunnableFuture<T> toSubmit(WithResources var1, Callable<T> var2);

    public static TaskFactory standard() {
        return Standard.INSTANCE;
    }

    public static TaskFactory localAware() {
        return LocalAware.INSTANCE;
    }

    public static class LocalAware
    extends Standard {
        static final LocalAware INSTANCE = new LocalAware();

        protected LocalAware() {
        }

        @Override
        public Runnable toExecute(Runnable runnable) {
            if (runnable instanceof DebuggableTask.RunnableDebuggableTask) {
                return ExecutionFailure.suppressingDebuggable(ExecutorLocals.propagate(), (DebuggableTask.RunnableDebuggableTask)runnable);
            }
            return ExecutionFailure.suppressing(ExecutorLocals.propagate(), runnable);
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(Runnable runnable) {
            return super.toSubmit(ExecutorLocals.propagate(), runnable);
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(Runnable runnable, T result) {
            return super.toSubmit(ExecutorLocals.propagate(), runnable, result);
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(Callable<T> callable) {
            return super.toSubmit(ExecutorLocals.propagate(), callable);
        }

        @Override
        public Runnable toExecute(WithResources withResources, Runnable runnable) {
            return ExecutionFailure.suppressing(LocalAware.withLocals(withResources), runnable);
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(WithResources withResources, Runnable runnable) {
            return super.toSubmit(LocalAware.withLocals(withResources), runnable);
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(WithResources withResources, Runnable runnable, T result) {
            return super.toSubmit(LocalAware.withLocals(withResources), runnable, result);
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(WithResources withResources, Callable<T> callable) {
            return super.toSubmit(LocalAware.withLocals(withResources), callable);
        }

        private static WithResources withLocals(WithResources withResources) {
            return withResources instanceof ExecutorLocals ? withResources : ExecutorLocals.propagate().and(withResources);
        }
    }

    public static class Standard
    implements TaskFactory {
        static final Standard INSTANCE = new Standard();

        protected Standard() {
        }

        @Override
        public Runnable toExecute(Runnable runnable) {
            return ExecutionFailure.suppressing(runnable);
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(Runnable runnable) {
            return this.newTask(FutureTask.callable(runnable));
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(Runnable runnable, T result) {
            return this.newTask(FutureTask.callable(runnable, result));
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(Callable<T> callable) {
            return this.newTask(callable);
        }

        @Override
        public Runnable toExecute(WithResources withResources, Runnable runnable) {
            return ExecutionFailure.suppressing(withResources, runnable);
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(WithResources withResources, Runnable runnable) {
            return withResources.isNoOp() ? this.newTask(FutureTask.callable(runnable)) : this.newTask(withResources, FutureTask.callable(runnable));
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(WithResources withResources, Runnable runnable, T result) {
            return withResources.isNoOp() ? this.newTask(FutureTask.callable(runnable, result)) : this.newTask(withResources, FutureTask.callable(runnable, result));
        }

        @Override
        public <T> RunnableFuture<T> toSubmit(WithResources withResources, Callable<T> callable) {
            return withResources.isNoOp() ? this.newTask(callable) : this.newTask(withResources, callable);
        }

        protected <T> RunnableFuture<T> newTask(Callable<T> call) {
            return new FutureTask<T>(call);
        }

        protected <T> RunnableFuture<T> newTask(WithResources withResources, Callable<T> call) {
            return new FutureTaskWithResources<T>(withResources, call);
        }
    }
}

