/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.analyzer;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.index.sasi.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sasi.analyzer.StandardTokenizerImpl;
import org.apache.cassandra.index.sasi.analyzer.StandardTokenizerInterface;
import org.apache.cassandra.index.sasi.analyzer.StandardTokenizerOptions;
import org.apache.cassandra.index.sasi.analyzer.filter.BasicResultFilters;
import org.apache.cassandra.index.sasi.analyzer.filter.FilterPipelineBuilder;
import org.apache.cassandra.index.sasi.analyzer.filter.FilterPipelineExecutor;
import org.apache.cassandra.index.sasi.analyzer.filter.FilterPipelineTask;
import org.apache.cassandra.index.sasi.analyzer.filter.StemmingFilters;
import org.apache.cassandra.index.sasi.analyzer.filter.StopWordFilters;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class StandardAnalyzer
extends AbstractAnalyzer {
    private static final Set<AbstractType<?>> VALID_ANALYZABLE_TYPES = new HashSet<AbstractType<?>>(){
        {
            this.add(UTF8Type.instance);
            this.add(AsciiType.instance);
        }
    };
    private AbstractType<?> validator;
    private StandardTokenizerInterface scanner;
    private StandardTokenizerOptions options;
    private FilterPipelineTask filterPipeline;
    protected Reader inputReader = null;

    public String getToken() {
        return this.scanner.getText();
    }

    public final boolean incrementToken() throws IOException {
        do {
            TokenType currentTokenType;
            if ((currentTokenType = TokenType.fromValue(this.scanner.getNextToken())) != TokenType.EOF) continue;
            return false;
        } while (this.scanner.yylength() > this.options.getMaxTokenLength() || this.scanner.yylength() < this.options.getMinTokenLength());
        return true;
    }

    protected String getFilteredCurrentToken() throws IOException {
        boolean reachedEOF;
        String pipelineRes;
        String token = this.getToken();
        while ((pipelineRes = FilterPipelineExecutor.execute(this.filterPipeline, token)) == null && (reachedEOF = this.incrementToken())) {
            token = this.getToken();
        }
        return pipelineRes;
    }

    private FilterPipelineTask getFilterPipeline() {
        FilterPipelineBuilder builder = new FilterPipelineBuilder(new BasicResultFilters.NoOperation());
        if (!this.options.isCaseSensitive() && this.options.shouldLowerCaseTerms()) {
            builder = builder.add("to_lower", new BasicResultFilters.LowerCase());
        }
        if (!this.options.isCaseSensitive() && this.options.shouldUpperCaseTerms()) {
            builder = builder.add("to_upper", new BasicResultFilters.UpperCase());
        }
        if (this.options.shouldIgnoreStopTerms()) {
            builder = builder.add("skip_stop_words", new StopWordFilters.DefaultStopWordFilter(this.options.getLocale()));
        }
        if (this.options.shouldStemTerms()) {
            builder = builder.add("term_stemming", new StemmingFilters.DefaultStemmingFilter(this.options.getLocale()));
        }
        return builder.build();
    }

    @Override
    public void init(Map<String, String> options, AbstractType<?> validator) {
        this.init(StandardTokenizerOptions.buildFromMap(options), validator);
    }

    @VisibleForTesting
    protected void init(StandardTokenizerOptions options) {
        this.init(options, UTF8Type.instance);
    }

    public void init(StandardTokenizerOptions tokenizerOptions, AbstractType<?> validator) {
        this.validator = validator;
        this.options = tokenizerOptions;
        this.filterPipeline = this.getFilterPipeline();
        InputStreamReader reader = new InputStreamReader((InputStream)new DataInputBuffer(ByteBufferUtil.EMPTY_BYTE_BUFFER, false), StandardCharsets.UTF_8);
        this.scanner = new StandardTokenizerImpl(reader);
        this.inputReader = reader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.incrementToken() && this.getFilteredCurrentToken() != null) {
                this.next = this.validator.fromString(StandardAnalyzer.normalize(this.getFilteredCurrentToken()));
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void reset(ByteBuffer input) {
        this.next = null;
        InputStreamReader reader = new InputStreamReader((InputStream)new DataInputBuffer(input, false), StandardCharsets.UTF_8);
        this.scanner.yyreset(reader);
        this.inputReader = reader;
    }

    @VisibleForTesting
    public void reset(InputStream input) {
        this.next = null;
        InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
        this.scanner.yyreset(reader);
        this.inputReader = reader;
    }

    @Override
    public boolean isTokenizing() {
        return true;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> validator) {
        return VALID_ANALYZABLE_TYPES.contains(validator);
    }

    public static enum TokenType {
        EOF(-1),
        ALPHANUM(0),
        NUM(6),
        SOUTHEAST_ASIAN(9),
        IDEOGRAPHIC(10),
        HIRAGANA(11),
        KATAKANA(12),
        HANGUL(13);

        private static final IntObjectMap<TokenType> TOKENS;
        public final int value;

        private TokenType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TokenType fromValue(int val) {
            return (TokenType)((Object)TOKENS.get(val));
        }

        static {
            TOKENS = new IntObjectHashMap();
            for (TokenType type : TokenType.values()) {
                TOKENS.put(type.value, (Object)type);
            }
        }
    }
}

