/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.WriteFailureException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.Replicas;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.Condition;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWriteResponseHandler<T>
implements RequestCallback<T> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractWriteResponseHandler.class);
    private AtomicInteger responsesAndExpirations;
    private final Condition condition = Condition.newOneTimeCondition();
    protected final ReplicaPlan.ForWrite replicaPlan;
    protected final Runnable callback;
    protected final WriteType writeType;
    private static final AtomicIntegerFieldUpdater<AbstractWriteResponseHandler> failuresUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractWriteResponseHandler.class, "failures");
    private volatile int failures = 0;
    private final Map<InetAddressAndPort, RequestFailureReason> failureReasonByEndpoint;
    private final Dispatcher.RequestTime requestTime;
    @Nullable
    private final Supplier<Mutation> hintOnFailure;
    private AbstractWriteResponseHandler idealCLDelegate;
    private boolean requestedCLAchieved = false;

    protected AbstractWriteResponseHandler(ReplicaPlan.ForWrite replicaPlan, Runnable callback, WriteType writeType, Supplier<Mutation> hintOnFailure, Dispatcher.RequestTime requestTime) {
        this.replicaPlan = replicaPlan;
        this.callback = callback;
        this.writeType = writeType;
        this.hintOnFailure = hintOnFailure;
        this.failureReasonByEndpoint = new ConcurrentHashMap<InetAddressAndPort, RequestFailureReason>();
        this.requestTime = requestTime;
    }

    public void get() throws WriteTimeoutException, WriteFailureException {
        boolean success;
        long timeoutNanos = this.currentTimeoutNanos();
        try {
            success = this.condition.await(timeoutNanos, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        if (!success) {
            int blockedFor = this.blockFor();
            int acks = this.ackCount();
            if (acks >= blockedFor) {
                acks = blockedFor - 1;
            }
            throw new WriteTimeoutException(this.writeType, this.replicaPlan.consistencyLevel(), acks, blockedFor);
        }
        if (this.blockFor() + this.failures > this.candidateReplicaCount()) {
            throw new WriteFailureException(this.replicaPlan.consistencyLevel(), this.ackCount(), this.blockFor(), this.writeType, this.failureReasonByEndpoint);
        }
    }

    public final long currentTimeoutNanos() {
        long now = Clock.Global.nanoTime();
        long requestTimeout = this.writeType == WriteType.COUNTER ? DatabaseDescriptor.getCounterWriteRpcTimeout(TimeUnit.NANOSECONDS) : DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.NANOSECONDS);
        return this.requestTime.computeTimeout(now, requestTimeout);
    }

    public void setIdealCLResponseHandler(AbstractWriteResponseHandler handler) {
        this.idealCLDelegate = handler;
        this.idealCLDelegate.responsesAndExpirations = new AtomicInteger(((EndpointsForToken)this.replicaPlan.contacts()).size());
    }

    protected final void logResponseToIdealCLDelegate(Message<T> m) {
        if (this.idealCLDelegate == null) {
            return;
        }
        if (this.idealCLDelegate == this) {
            this.decrementResponseOrExpired();
        } else {
            this.idealCLDelegate.onResponse(m);
        }
    }

    protected final void logFailureOrTimeoutToIdealCLDelegate() {
        if (this.idealCLDelegate == null) {
            return;
        }
        if (this.idealCLDelegate == this) {
            this.decrementResponseOrExpired();
        } else {
            this.idealCLDelegate.decrementResponseOrExpired();
        }
    }

    public final void expired() {
        this.logFailureOrTimeoutToIdealCLDelegate();
    }

    protected int blockFor() {
        return this.replicaPlan.writeQuorum();
    }

    protected int candidateReplicaCount() {
        if (this.replicaPlan.consistencyLevel().isDatacenterLocal()) {
            return Replicas.countInOurDc(this.replicaPlan.liveAndDown()).allReplicas();
        }
        return this.replicaPlan.liveAndDown().size();
    }

    public ConsistencyLevel consistencyLevel() {
        return this.replicaPlan.consistencyLevel();
    }

    protected boolean waitingFor(InetAddressAndPort from) {
        return true;
    }

    protected abstract int ackCount();

    @Override
    public abstract void onResponse(Message<T> var1);

    protected void signal() {
        if (this.idealCLDelegate != null && this.blockFor() + this.failures <= this.candidateReplicaCount()) {
            this.idealCLDelegate.requestedCLAchieved = true;
            if (this.idealCLDelegate == this) {
                this.replicaPlan.keyspace().metric.idealCLWriteLatency.addNano(Clock.Global.nanoTime() - this.requestTime.startedAtNanos());
            }
        }
        this.condition.signalAll();
        if (this.callback != null) {
            this.callback.run();
        }
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
        logger.trace("Got failure from {}", (Object)from);
        int n = this.waitingFor(from) ? failuresUpdater.incrementAndGet(this) : this.failures;
        this.failureReasonByEndpoint.put(from, failureReason);
        this.logFailureOrTimeoutToIdealCLDelegate();
        if (this.blockFor() + n > this.candidateReplicaCount()) {
            this.signal();
        }
        if (this.hintOnFailure != null && StorageProxy.shouldHint(this.replicaPlan.lookup(from)) && this.requestTime.shouldSendHints()) {
            StorageProxy.submitHint(this.hintOnFailure.get(), this.replicaPlan.lookup(from), null);
        }
    }

    @Override
    public boolean invokeOnFailure() {
        return true;
    }

    private final void decrementResponseOrExpired() {
        int decrementedValue = this.responsesAndExpirations.decrementAndGet();
        if (decrementedValue == 0 && !this.condition.isSignalled() && this.requestedCLAchieved) {
            this.replicaPlan.keyspace().metric.writeFailedIdealCL.inc();
        }
    }

    public void maybeTryAdditionalReplicas(IMutation mutation, StorageProxy.WritePerformer writePerformer, String localDC) {
        EndpointsForToken uncontacted = this.replicaPlan.liveUncontacted();
        if (uncontacted.isEmpty()) {
            return;
        }
        long timeout = Long.MAX_VALUE;
        List cfs = mutation.getTableIds().stream().map(Schema.instance::getColumnFamilyStoreInstance).collect(Collectors.toList());
        for (ColumnFamilyStore cf : cfs) {
            timeout = Math.min(timeout, cf.additionalWriteLatencyMicros);
        }
        if (timeout > mutation.getTimeout(TimeUnit.MICROSECONDS)) {
            return;
        }
        try {
            if (!this.condition.await(timeout, TimeUnit.MICROSECONDS)) {
                for (ColumnFamilyStore cf : cfs) {
                    cf.metric.additionalWrites.inc();
                }
                writePerformer.apply(mutation, this.replicaPlan.withContacts(uncontacted), this, localDC, this.requestTime);
            }
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }
}

