/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.exceptions.ConfigurationException;

public enum CassandraRelevantProperties {
    JAVA_HOME("java.home"),
    CASSANDRA_PID_FILE("cassandra-pidfile"),
    JAVA_IO_TMPDIR("java.io.tmpdir"),
    JAVA_LIBRARY_PATH("java.library.path"),
    JAVA_SECURITY_EGD("java.security.egd"),
    JAVA_VERSION("java.version"),
    JAVA_VM_NAME("java.vm.name"),
    LINE_SEPARATOR("line.separator"),
    JAVA_CLASS_PATH("java.class.path"),
    OS_ARCH("os.arch"),
    OS_NAME("os.name"),
    USER_HOME("user.home"),
    SUN_ARCH_DATA_MODEL("sun.arch.data.model"),
    JAVA_RMI_SERVER_HOSTNAME("java.rmi.server.hostname"),
    JAVA_RMI_SERVER_RANDOM_ID("java.rmi.server.randomIDs"),
    COM_SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE("com.sun.management.jmxremote.authenticate"),
    SUN_RMI_TRANSPORT_TCP_THREADKEEPALIVETIME("sun.rmi.transport.tcp.threadKeepAliveTime"),
    JAVA_RMI_DGC_LEASE_VALUE_IN_JVM_DTEST("java.rmi.dgc.leaseValue"),
    COM_SUN_MANAGEMENT_JMXREMOTE_RMI_PORT("com.sun.management.jmxremote.rmi.port", "0"),
    CASSANDRA_JMX_REMOTE_PORT("cassandra.jmx.remote.port"),
    CASSANDRA_JMX_LOCAL_PORT("cassandra.jmx.local.port"),
    COM_SUN_MANAGEMENT_JMXREMOTE_SSL("com.sun.management.jmxremote.ssl"),
    COM_SUN_MANAGEMENT_JMXREMOTE_SSL_NEED_CLIENT_AUTH("com.sun.management.jmxremote.ssl.need.client.auth"),
    COM_SUN_MANAGEMENT_JMXREMOTE_ACCESS_FILE("com.sun.management.jmxremote.access.file"),
    COM_SUN_MANAGEMENT_JMXREMOTE_PASSWORD_FILE("com.sun.management.jmxremote.password.file"),
    COM_SUN_MANAGEMENT_JMXREMOTE_PORT("com.sun.management.jmxremote.port"),
    COM_SUN_MANAGEMENT_JMXREMOTE_SSL_ENABLED_PROTOCOLS("com.sun.management.jmxremote.ssl.enabled.protocols"),
    COM_SUN_MANAGEMENT_JMXREMOTE_SSL_ENABLED_CIPHER_SUITES("com.sun.management.jmxremote.ssl.enabled.cipher.suites"),
    MX4JADDRESS("mx4jaddress"),
    MX4JPORT("mx4jport"),
    RING_DELAY("cassandra.ring_delay_ms"),
    FAILED_BOOTSTRAP_TIMEOUT("cassandra.failed_bootstrap_timeout_ms"),
    BOOTSTRAP_SKIP_SCHEMA_CHECK("cassandra.skip_schema_check"),
    BOOTSTRAP_SCHEMA_DELAY_MS("cassandra.schema_delay_ms"),
    DRAIN_EXECUTOR_TIMEOUT_MS("cassandra.drain_executor_timeout_ms", String.valueOf(TimeUnit.MINUTES.toMillis(5L))),
    GOSSIPER_QUARANTINE_DELAY("cassandra.gossip_quarantine_delay_ms"),
    GOSSIPER_SKIP_WAITING_TO_SETTLE("cassandra.skip_wait_for_gossip_to_settle", "-1"),
    IGNORED_SCHEMA_CHECK_VERSIONS("cassandra.skip_schema_check_for_versions"),
    IGNORED_SCHEMA_CHECK_ENDPOINTS("cassandra.skip_schema_check_for_endpoints"),
    SHUTDOWN_ANNOUNCE_DELAY_IN_MS("cassandra.shutdown_announce_in_ms", "2000"),
    REPLACEMENT_ALLOW_EMPTY("cassandra.allow_empty_replace_address", "true"),
    LOG_DIR("cassandra.logdir", "."),
    LOG_DIR_AUDIT("cassandra.logdir.audit"),
    CONSISTENT_DIRECTORY_LISTINGS("cassandra.consistent_directory_listings", "false"),
    CLOCK_GLOBAL("cassandra.clock", null),
    CLOCK_MONOTONIC_APPROX("cassandra.monotonic_clock.approx", null),
    CLOCK_MONOTONIC_PRECISE("cassandra.monotonic_clock.precise", null),
    ENABLE_NODELOCAL_QUERIES("cassandra.enable_nodelocal_queries", "false"),
    CASSANDRA_FOREGROUND("cassandra-foreground"),
    DEFAULT_PROVIDE_OVERLAPPING_TOMBSTONES("default.provide.overlapping.tombstones"),
    ORG_APACHE_CASSANDRA_DISABLE_MBEAN_REGISTRATION("org.apache.cassandra.disable_mbean_registration"),
    IS_DISABLED_MBEAN_REGISTRATION("org.apache.cassandra.disable_mbean_registration"),
    SNAPSHOT_CLEANUP_PERIOD_SECONDS("cassandra.snapshot.ttl_cleanup_period_seconds", "60"),
    SNAPSHOT_CLEANUP_INITIAL_DELAY_SECONDS("cassandra.snapshot.ttl_cleanup_initial_delay_seconds", "5"),
    SNAPSHOT_MIN_ALLOWED_TTL_SECONDS("cassandra.snapshot.min_allowed_ttl_seconds", "60"),
    MBEAN_REGISTRATION_CLASS("org.apache.cassandra.mbean_registration_class"),
    DTEST_IS_IN_JVM_DTEST("org.apache.cassandra.dtest.is_in_jvm_dtest"),
    BATCH_COMMIT_LOG_SYNC_INTERVAL("cassandra.batch_commitlog_sync_interval_millis", "1000"),
    SYSTEM_AUTH_DEFAULT_RF("cassandra.system_auth.default_rf", "1"),
    SYSTEM_TRACES_DEFAULT_RF("cassandra.system_traces.default_rf", "2"),
    SYSTEM_DISTRIBUTED_DEFAULT_RF("cassandra.system_distributed.default_rf", "3"),
    MEMTABLE_OVERHEAD_SIZE("cassandra.memtable.row_overhead_size", "-1"),
    MEMTABLE_OVERHEAD_COMPUTE_STEPS("cassandra.memtable_row_overhead_computation_step", "100000"),
    MIGRATION_DELAY("cassandra.migration_delay_ms", "60000"),
    SCHEMA_PULL_INTERVAL_MS("cassandra.schema_pull_interval_ms", "60000"),
    PAXOS_REPAIR_RETRY_TIMEOUT_IN_MS("cassandra.paxos_repair_retry_timeout_millis", "60000"),
    ALLOW_DUPLICATE_CONFIG_KEYS("cassandra.allow_duplicate_config_keys", "true"),
    ALLOW_NEW_OLD_CONFIG_KEYS("cassandra.allow_new_old_config_keys", "false"),
    LIBJEMALLOC("cassandra.libjemalloc"),
    IGNORE_DC("cassandra.ignore_dc"),
    IGNORE_RACK("cassandra.ignore_rack"),
    FILE_SYSTEM_CHECK_ENABLE("cassandra.enable_fs_ownership_check"),
    FILE_SYSTEM_CHECK_OWNERSHIP_FILENAME("cassandra.fs_ownership_filename", ".cassandra_fs_ownership"),
    FILE_SYSTEM_CHECK_OWNERSHIP_TOKEN("CassandraOwnershipToken"),
    CHECK_DATA_RESURRECTION_HEARTBEAT_PERIOD("check_data_resurrection_heartbeat_period_milli", "60000"),
    CONFIG_ALLOW_SYSTEM_PROPERTIES("cassandra.config.allow_system_properties", "false"),
    TEST_SIMULATOR_PRINT_ASM("cassandra.test.simulator.print_asm", "none"),
    TEST_SIMULATOR_PRINT_ASM_TYPES("cassandra.test.simulator.print_asm_types", ""),
    TEST_SIMULATOR_LIVENESS_CHECK("cassandra.test.simulator.livenesscheck", "true"),
    TEST_SIMULATOR_DEBUG("cassandra.test.simulator.debug", "false"),
    TEST_SIMULATOR_DETERMINISM_CHECK("cassandra.test.simulator.determinismcheck", "none"),
    TEST_JVM_DTEST_DISABLE_SSL("cassandra.test.disable_ssl", "false"),
    DETERMINISM_SSTABLE_COMPRESSION_DEFAULT("cassandra.sstable_compression_default", "true"),
    DETERMINISM_CONSISTENT_DIRECTORY_LISTINGS("cassandra.consistent_directory_listings", "false"),
    DETERMINISM_UNSAFE_UUID_NODE("cassandra.unsafe.deterministicuuidnode", "false"),
    FAILURE_LOGGING_INTERVAL_SECONDS("cassandra.request_failure_log_interval_seconds", "60"),
    DISABLE_GOSSIP_ENDPOINT_REMOVAL("cassandra.gossip.disable_endpoint_removal"),
    IGNORE_MISSING_NATIVE_FILE_HINTS("cassandra.require_native_file_hints", "false"),
    DISABLE_SSTABLE_ACTIVITY_TRACKING("cassandra.sstable_activity_tracking", "true"),
    TEST_IGNORE_SIGAR("cassandra.test.ignore_sigar", "false"),
    PAXOS_EXECUTE_ON_SELF("cassandra.paxos.use_self_execution", "true"),
    DISK_USAGE_MONITOR_INTERVAL_MS("cassandra.disk_usage.monitor_interval_ms", Long.toString(TimeUnit.SECONDS.toMillis(30L))),
    DISK_USAGE_NOTIFY_INTERVAL_MS("cassandra.disk_usage.notify_interval_ms", Long.toString(TimeUnit.MINUTES.toMillis(30L))),
    ORG_APACHE_CASSANDRA_CONF_CASSANDRA_RELEVANT_PROPERTIES_TEST("org.apache.cassandra.conf.CassandraRelevantPropertiesTest"),
    ORG_APACHE_CASSANDRA_DB_VIRTUAL_SYSTEM_PROPERTIES_TABLE_TEST("org.apache.cassandra.db.virtual.SystemPropertiesTableTest"),
    FORCE_LOAD_LOCAL_KEYSPACES("cassandra.schema.force_load_local_keyspaces"),
    USE_NIX_RECURSIVE_DELETE("cassandra.use_nix_recursive_delete"),
    NON_GRACEFUL_SHUTDOWN("cassandra.test.messagingService.nonGracefulShutdown"),
    FLUSH_LOCAL_SCHEMA_CHANGES("cassandra.test.flush_local_schema_changes", "true"),
    GOSSIP_SETTLE_MIN_WAIT_MS("cassandra.gossip_settle_min_wait_ms", "5000"),
    GOSSIP_SETTLE_POLL_INTERVAL_MS("cassandra.gossip_settle_interval_ms", "1000"),
    GOSSIP_SETTLE_POLL_SUCCESSES_REQUIRED("cassandra.gossip_settle_poll_success_required", "3");

    private final String key;
    private final String defaultVal;
    private static final PropertyConverter<String> STRING_CONVERTER;
    private static final PropertyConverter<Boolean> BOOLEAN_CONVERTER;
    private static final PropertyConverter<Integer> INTEGER_CONVERTER;
    private static final PropertyConverter<Long> LONG_CONVERTER;

    private CassandraRelevantProperties(String key, String defaultVal) {
        this.key = key;
        this.defaultVal = defaultVal;
    }

    private CassandraRelevantProperties(String key) {
        this.key = key;
        this.defaultVal = null;
    }

    public String getKey() {
        return this.key;
    }

    public String getString() {
        String value = System.getProperty(this.key);
        return value == null ? this.defaultVal : STRING_CONVERTER.convert(value);
    }

    public String getDefaultValue() {
        return this.defaultVal;
    }

    public void reset() {
        if (this.defaultVal != null) {
            System.setProperty(this.key, this.defaultVal);
        } else {
            System.getProperties().remove(this.key);
        }
    }

    public String getString(String overrideDefaultValue) {
        String value = System.getProperty(this.key);
        if (value == null) {
            return overrideDefaultValue;
        }
        return STRING_CONVERTER.convert(value);
    }

    public <T> T convert(PropertyConverter<T> converter) {
        String value = System.getProperty(this.key);
        if (value == null) {
            value = this.defaultVal;
        }
        return converter.convert(value);
    }

    public void setString(String value) {
        System.setProperty(this.key, value);
    }

    public boolean getBoolean() {
        String value = System.getProperty(this.key);
        return BOOLEAN_CONVERTER.convert(value == null ? this.defaultVal : value);
    }

    public boolean getBoolean(boolean overrideDefaultValue) {
        String value = System.getProperty(this.key);
        if (value == null) {
            return overrideDefaultValue;
        }
        return BOOLEAN_CONVERTER.convert(value);
    }

    public void clearValue() {
        System.clearProperty(this.key);
    }

    public void setBoolean(boolean value) {
        System.setProperty(this.key, Boolean.toString(value));
    }

    public int getInt() {
        String value = System.getProperty(this.key);
        return INTEGER_CONVERTER.convert(value == null ? this.defaultVal : value);
    }

    public long getLong() {
        String value = System.getProperty(this.key);
        return LONG_CONVERTER.convert(value == null ? this.defaultVal : value);
    }

    public int getInt(int overrideDefaultValue) {
        String value = System.getProperty(this.key);
        if (value == null) {
            return overrideDefaultValue;
        }
        return INTEGER_CONVERTER.convert(value);
    }

    public void setInt(int value) {
        System.setProperty(this.key, Integer.toString(value));
    }

    public void setLong(long value) {
        System.setProperty(this.key, Long.toString(value));
    }

    public boolean isPresent() {
        return System.getProperties().containsKey(this.key);
    }

    static {
        STRING_CONVERTER = value -> value;
        BOOLEAN_CONVERTER = Boolean::parseBoolean;
        INTEGER_CONVERTER = value -> {
            try {
                return Integer.decode(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(String.format("Invalid value for system property: expected integer value but got '%s'", value));
            }
        };
        LONG_CONVERTER = value -> {
            try {
                return Long.decode(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(String.format("Invalid value for system property: expected integer value but got '%s'", value));
            }
        };
    }

    public static interface PropertyConverter<T> {
        public T convert(String var1);
    }
}

