/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool.commands;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.threads.MilliPauser;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.transport.ProtocolVersion;

@Command(name="dump", description="Dump the contents of a full query log")
public class Dump
implements Runnable {
    static final char[] HEXI_DECIMAL = "0123456789ABCDEF".toCharArray();
    @Arguments(usage="<path1> [<path2>...<pathN>]", description="Path containing the full query logs to dump.", required=true)
    private List<String> arguments = new ArrayList<String>();
    @Option(title="roll_cycle", name={"--roll-cycle"}, description="How often to roll the log file was rolled. May be necessary for Chronicle to correctly parse file names. (MINUTELY, HOURLY, DAILY). Default HOURLY.")
    private String rollCycle = "HOURLY";
    @Option(title="follow", name={"--follow"}, description="Upon reacahing the end of the log continue indefinitely waiting for more records")
    private boolean follow = false;

    @Override
    public void run() {
        Dump.dump(this.arguments, this.rollCycle, this.follow);
    }

    public static void dump(List<String> arguments, String rollCycle, boolean follow) {
        StringBuilder sb = new StringBuilder();
        ReadMarshallable reader = wireIn -> {
            sb.setLength(0);
            short version = wireIn.read("version").int16();
            if ((long)version > 0L) {
                throw new IORuntimeException("Unsupported record version [" + version + "] - highest supported version is [" + 0L + ']');
            }
            String type = wireIn.read("type").text();
            if (!"single-query".equals(type) && !"batch".equals(type)) {
                throw new IORuntimeException("Unsupported record type field [" + type + "] - supported record types are [" + "single-query" + ", " + "batch" + ']');
            }
            sb.append("Type: ").append(type).append(System.lineSeparator());
            long queryStartTime = wireIn.read("query-start-time").int64();
            sb.append("Query start time: ").append(queryStartTime).append(System.lineSeparator());
            int protocolVersion = wireIn.read("protocol-version").int32();
            sb.append("Protocol version: ").append(protocolVersion).append(System.lineSeparator());
            QueryOptions options = (QueryOptions)QueryOptions.codec.decode(Unpooled.wrappedBuffer((byte[])wireIn.read("query-options").bytes()), ProtocolVersion.decode((int)protocolVersion, (boolean)true));
            long generatedTimestamp = wireIn.read("generated-timestamp").int64();
            sb.append("Generated timestamp:").append(generatedTimestamp).append(System.lineSeparator());
            int generatedNowInSeconds = wireIn.read("generated-now-in-seconds").int32();
            sb.append("Generated nowInSeconds:").append(generatedNowInSeconds).append(System.lineSeparator());
            switch (type) {
                case "single-query": {
                    Dump.dumpQuery(options, wireIn, sb);
                    break;
                }
                case "batch": {
                    Dump.dumpBatch(options, wireIn, sb);
                    break;
                }
                default: {
                    throw new IORuntimeException("Log entry of unsupported type " + type);
                }
            }
            System.out.print(sb.toString());
            System.out.flush();
        };
        MilliPauser pauser = Pauser.millis((int)100);
        List queues = arguments.stream().distinct().map(path -> SingleChronicleQueueBuilder.single((File)new File((String)path)).readOnly(true).rollCycle((RollCycle)RollCycles.valueOf((String)rollCycle)).build()).collect(Collectors.toList());
        List tailers = queues.stream().map(ChronicleQueue::createTailer).collect(Collectors.toList());
        boolean hadWork = true;
        while (hadWork) {
            hadWork = false;
            for (ExcerptTailer tailer : tailers) {
                while (tailer.readDocument(reader)) {
                    hadWork = true;
                }
            }
            if (!follow) continue;
            if (!hadWork) {
                pauser.pause();
            }
            hadWork = true;
        }
    }

    @VisibleForTesting
    static void dumpQuery(QueryOptions options, WireIn wireIn, StringBuilder sb) {
        sb.append("Query: ").append(wireIn.read("query").text()).append(System.lineSeparator());
        List values = options.getValues() != null ? options.getValues() : Collections.emptyList();
        sb.append("Values: ").append(System.lineSeparator());
        Dump.appendValuesToStringBuilder(values, sb);
        sb.append(System.lineSeparator());
    }

    private static void dumpBatch(QueryOptions options, WireIn wireIn, StringBuilder sb) {
        sb.append("Batch type: ").append(wireIn.read("batch-type").text()).append(System.lineSeparator());
        ValueIn in = wireIn.read("queries");
        int numQueries = in.int32();
        ArrayList<String> queries = new ArrayList<String>(numQueries);
        for (int i = 0; i < numQueries; ++i) {
            queries.add(in.text());
        }
        in = wireIn.read("values");
        int numValues = in.int32();
        for (int i = 0; i < numValues; ++i) {
            int numSubValues = in.int32();
            ArrayList<ByteBuffer> subValues = new ArrayList<ByteBuffer>(numSubValues);
            for (int j = 0; j < numSubValues; ++j) {
                subValues.add(ByteBuffer.wrap(in.bytes()));
            }
            sb.append("Query: ").append((String)queries.get(i)).append(System.lineSeparator());
            sb.append("Values: ").append(System.lineSeparator());
            Dump.appendValuesToStringBuilder(subValues, sb);
        }
        sb.append(System.lineSeparator());
    }

    private static void appendValuesToStringBuilder(List<ByteBuffer> values, StringBuilder sb) {
        for (ByteBuffer value : values) {
            if (null == value) {
                sb.append("null").append(System.lineSeparator());
            } else {
                Bytes bytes = Bytes.wrapForRead((ByteBuffer)value);
                long maxLength2 = Math.min(1024L, bytes.readLimit() - bytes.readPosition());
                Dump.toHexString(bytes, bytes.readPosition(), maxLength2, sb);
                if (maxLength2 < bytes.readLimit() - bytes.readPosition()) {
                    sb.append("... truncated").append(System.lineSeparator());
                }
            }
            sb.append("-----").append(System.lineSeparator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toHexString(Bytes bytes, long offset, long len, StringBuilder builder) throws BufferUnderflowException {
        if (len == 0L) {
            return "";
        }
        int width = 16;
        int[] lastLine = new int[width];
        String sep = "";
        long position = bytes.readPosition();
        long limit = bytes.readLimit();
        try {
            bytes.readPositionRemaining(offset, len);
            long start = offset / (long)width * (long)width;
            long end = (offset + len + (long)width - 1L) / (long)width * (long)width;
            for (long i = start; i < end; i += (long)width) {
                int ch;
                int j;
                if (i + (long)width < end) {
                    boolean same = true;
                    for (j = 0; j < width && i + (long)j < offset + len; ++j) {
                        ch = bytes.readUnsignedByte(i + (long)j);
                        same &= ch == lastLine[j];
                        lastLine[j] = ch;
                    }
                    if (i > start && same) {
                        sep = "........\n";
                        continue;
                    }
                }
                builder.append(sep);
                sep = "";
                String str = Long.toHexString(i);
                for (j = str.length(); j < 8; ++j) {
                    builder.append('0');
                }
                builder.append(str);
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < offset || i + (long)j >= offset + len) {
                        builder.append("   ");
                        continue;
                    }
                    builder.append(' ');
                    ch = bytes.readUnsignedByte(i + (long)j);
                    builder.append(HEXI_DECIMAL[ch >> 4]);
                    builder.append(HEXI_DECIMAL[ch & 0xF]);
                }
                builder.append(' ');
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < offset || i + (long)j >= offset + len) {
                        builder.append(' ');
                        continue;
                    }
                    ch = bytes.readUnsignedByte(i + (long)j);
                    if (ch < 32 || ch > 126) {
                        ch = 183;
                    }
                    builder.append((char)ch);
                }
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            bytes.readLimit(limit);
            bytes.readPosition(position);
        }
    }
}

