/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteArrayUtil;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.TimeUUID;

@Shared(scope={Shared.Scope.SIMULATION}, inner=Shared.Recursive.INTERFACES)
public class Ballot
extends TimeUUID {
    public static final long serialVersionUID = 1L;
    private static final Ballot epoch = Ballot.atUnixMicrosWithLsb(0L, 0L, Flag.NONE);

    public static Ballot none() {
        return epoch;
    }

    private Ballot(long rawTimestamp, long lsb) {
        super(rawTimestamp, lsb);
    }

    @Override
    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        if (that.getClass() != Ballot.class) {
            return false;
        }
        return super.equals((TimeUUID)that);
    }

    public static Ballot atUnixMicrosWithLsb(long unixMicros, long uniqueLsb, Flag flag) {
        return new Ballot(Ballot.unixMicrosToRawTimestamp(unixMicros) + (long)flag.ordinal(), uniqueLsb);
    }

    public static Ballot fromUuid(UUID uuid) {
        return Ballot.fromBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static Ballot fromBytes(long msb, long lsb) {
        return new Ballot(Ballot.msbToRawTimestamp(msb), lsb);
    }

    public static Ballot fromString(String uuidString) {
        return Ballot.fromUuid(UUID.fromString(uuidString));
    }

    public static Ballot deserialize(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        return Ballot.fromBytes(ByteArrayUtil.getLong(bytes, 0), ByteArrayUtil.getLong(bytes, 8));
    }

    public static Ballot deserialize(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return null;
        }
        return Ballot.fromBytes(buffer.getLong(buffer.position()), buffer.getLong(buffer.position() + 8));
    }

    public static Ballot deserialize(DataInputPlus in) throws IOException {
        long msb = in.readLong();
        long lsb = in.readLong();
        return Ballot.fromBytes(msb, lsb);
    }

    public Flag flag() {
        int i = (int)(this.uuidTimestamp() % 10L);
        if (i < Flag.FLAGS.length) {
            return Flag.FLAGS[i];
        }
        return Flag.NONE;
    }

    public static class Serializer
    extends TimeUUID.AbstractSerializer<Ballot>
    implements IVersionedSerializer<Ballot> {
        public static final Serializer instance = new Serializer();

        @Override
        public <V> Ballot deserialize(V value, ValueAccessor<V> accessor) {
            return accessor.isEmpty(value) ? null : accessor.toBallot(value);
        }

        @Override
        public Class<Ballot> getType() {
            return Ballot.class;
        }

        @Override
        public void serialize(Ballot t, DataOutputPlus out, int version) throws IOException {
            t.serialize(out);
        }

        @Override
        public Ballot deserialize(DataInputPlus in, int version) throws IOException {
            return Ballot.deserialize(in);
        }

        @Override
        public long serializedSize(Ballot t, int version) {
            return TimeUUID.sizeInBytes();
        }
    }

    public static enum Flag {
        NONE,
        LOCAL,
        GLOBAL;

        static final Flag[] FLAGS;

        static {
            FLAGS = Flag.values();
        }
    }
}

