/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.TypeCodec;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.UpdateStatement;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.cql3.statements.schema.CreateTypeStatement;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableSimpleUnsortedWriter;
import org.apache.cassandra.io.sstable.SSTableSimpleWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaTransformations;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.commons.lang3.ArrayUtils;

public class StressCQLSSTableWriter
implements Closeable {
    public static final ByteBuffer UNSET_VALUE = ByteBufferUtil.UNSET_BYTE_BUFFER;
    private final AbstractSSTableSimpleWriter writer;
    private final UpdateStatement insert;
    private final List<ColumnSpecification> boundNames;
    private final List<TypeCodec> typeCodecs;
    private final ColumnFamilyStore cfs;

    private StressCQLSSTableWriter(ColumnFamilyStore cfs, AbstractSSTableSimpleWriter writer, UpdateStatement insert, List<ColumnSpecification> boundNames) {
        this.cfs = cfs;
        this.writer = writer;
        this.insert = insert;
        this.boundNames = boundNames;
        this.typeCodecs = boundNames.stream().map(bn -> UDHelper.codecFor((DataType)UDHelper.driverType((AbstractType)bn.type))).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public StressCQLSSTableWriter addRow(Object ... values) throws InvalidRequestException, IOException {
        return this.addRow(Arrays.asList(values));
    }

    public StressCQLSSTableWriter addRow(List<Object> values) throws InvalidRequestException, IOException {
        int size = Math.min(values.size(), this.boundNames.size());
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            Object value = values.get(i);
            rawValues.add(this.serialize(value, this.typeCodecs.get(i)));
        }
        return this.rawAddRow(rawValues);
    }

    public StressCQLSSTableWriter addRow(Map<String, Object> values) throws InvalidRequestException, IOException {
        int size = this.boundNames.size();
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            ColumnSpecification spec = this.boundNames.get(i);
            Object value = values.get(spec.name.toString());
            rawValues.add(this.serialize(value, this.typeCodecs.get(i)));
        }
        return this.rawAddRow(rawValues);
    }

    public StressCQLSSTableWriter rawAddRow(ByteBuffer ... values) throws InvalidRequestException, IOException {
        return this.rawAddRow(Arrays.asList(values));
    }

    public StressCQLSSTableWriter rawAddRow(List<ByteBuffer> values) throws InvalidRequestException, IOException {
        if (values.size() != this.boundNames.size()) {
            throw new InvalidRequestException(String.format("Invalid number of arguments, expecting %d values but got %d", this.boundNames.size(), values.size()));
        }
        QueryOptions options = QueryOptions.forInternalCalls(null, values);
        ClientState state = ClientState.forInternalCalls();
        List keys = this.insert.buildPartitionKeyNames(options, state);
        NavigableSet clusterings = this.insert.createClustering(options, state);
        long now = Clock.Global.currentTimeMillis();
        UpdateParameters params = new UpdateParameters(this.insert.metadata(), this.insert.updatedColumns(), ClientState.forInternalCalls(), options, this.insert.getTimestamp(TimeUnit.MILLISECONDS.toMicros(now), options), (int)TimeUnit.MILLISECONDS.toSeconds(now), this.insert.getTimeToLive(options), Collections.emptyMap());
        try {
            for (ByteBuffer key : keys) {
                for (Clustering clustering : clusterings) {
                    this.insert.addUpdateForKey(this.writer.getUpdateFor(key), clustering, params);
                }
            }
            return this;
        }
        catch (SSTableSimpleUnsortedWriter.SyncException e) {
            throw (IOException)e.getCause();
        }
    }

    public StressCQLSSTableWriter rawAddRow(Map<String, ByteBuffer> values) throws InvalidRequestException, IOException {
        int size = Math.min(values.size(), this.boundNames.size());
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            ColumnSpecification spec = this.boundNames.get(i);
            rawValues.add(values.get(spec.name.toString()));
        }
        return this.rawAddRow(rawValues);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private ByteBuffer serialize(Object value, TypeCodec codec) {
        if (value == null || value == UNSET_VALUE) {
            return (ByteBuffer)value;
        }
        return codec.serialize(value, ProtocolVersion.CURRENT);
    }

    public File getInnermostDirectory() {
        return this.cfs.getDirectories().getDirectoryForNewSSTables().toJavaIOFile();
    }

    public static <T extends CQLStatement.Raw> T parseStatement(String query, Class<T> klass, String type) {
        try {
            CQLStatement.Raw stmt = (CQLStatement.Raw)CQLFragmentParser.parseAnyUnhandled(CqlParser::query, (String)query);
            if (!stmt.getClass().equals(klass)) {
                throw new IllegalArgumentException("Invalid query, must be a " + type + " statement but was: " + stmt.getClass());
            }
            return (T)((CQLStatement.Raw)klass.cast(stmt));
        }
        catch (RecognitionException | RequestValidationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    static {
        DatabaseDescriptor.clientInitialization((boolean)false);
        if (DatabaseDescriptor.getPartitioner() == null) {
            DatabaseDescriptor.setPartitionerUnsafe((IPartitioner)Murmur3Partitioner.instance);
        }
    }

    public static class Builder {
        private final List<File> directoryList;
        private ColumnFamilyStore cfs;
        protected SSTableFormat.Type formatType = null;
        private Boolean makeRangeAware = false;
        private CreateTableStatement.Raw schemaStatement;
        private final List<CreateTypeStatement.Raw> typeStatements = new ArrayList<CreateTypeStatement.Raw>();
        private UpdateStatement.ParsedInsert insertStatement;
        private IPartitioner partitioner;
        private boolean sorted = false;
        private long bufferSizeInMiB = 128L;

        protected Builder() {
            this.directoryList = new ArrayList<File>();
        }

        public Builder inDirectory(String directory) {
            return this.inDirectory(new File(directory));
        }

        public Builder inDirectory(File directory) {
            if (!directory.exists()) {
                throw new IllegalArgumentException(directory + " doesn't exists");
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(directory + " exists but is not writable");
            }
            this.directoryList.add(directory);
            return this;
        }

        public Builder withCfs(ColumnFamilyStore cfs) {
            this.cfs = cfs;
            return this;
        }

        public Builder withType(String typeDefinition) throws SyntaxException {
            this.typeStatements.add(StressCQLSSTableWriter.parseStatement(typeDefinition, CreateTypeStatement.Raw.class, "CREATE TYPE"));
            return this;
        }

        public Builder forTable(String schema) {
            this.schemaStatement = StressCQLSSTableWriter.parseStatement(schema, CreateTableStatement.Raw.class, "CREATE TABLE");
            return this;
        }

        public Builder withPartitioner(IPartitioner partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public Builder rangeAware(boolean makeRangeAware) {
            this.makeRangeAware = makeRangeAware;
            return this;
        }

        public Builder using(String insert) {
            this.insertStatement = StressCQLSSTableWriter.parseStatement(insert, UpdateStatement.ParsedInsert.class, "INSERT");
            return this;
        }

        public Builder withBufferSizeInMiB(int size) {
            this.bufferSizeInMiB = size;
            return this;
        }

        public Builder withBufferSizeInMB(int size) {
            return this.withBufferSizeInMiB(size);
        }

        public Builder sorted() {
            this.sorted = true;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StressCQLSSTableWriter build() {
            if (this.directoryList.isEmpty() && this.cfs == null) {
                throw new IllegalStateException("No output directories specified, you should provide a directory with inDirectory()");
            }
            if (this.schemaStatement == null && this.cfs == null) {
                throw new IllegalStateException("Missing schema, you should provide the schema for the SSTable to create with forTable()");
            }
            if (this.insertStatement == null) {
                throw new IllegalStateException("No insert statement specified, you should provide an insert statement through using()");
            }
            Class<StressCQLSSTableWriter> clazz = StressCQLSSTableWriter.class;
            synchronized (StressCQLSSTableWriter.class) {
                SSTableSimpleWriter writer;
                if (this.cfs == null) {
                    this.cfs = Builder.createOfflineTable(this.schemaStatement, this.typeStatements, this.directoryList);
                }
                if (this.partitioner == null) {
                    this.partitioner = this.cfs.getPartitioner();
                }
                UpdateStatement preparedInsert = this.prepareInsert();
                Object object = writer = this.sorted ? new SSTableSimpleWriter(this.cfs.getDirectories().getDirectoryForNewSSTables(), this.cfs.metadata, preparedInsert.updatedColumns()) : new SSTableSimpleUnsortedWriter(this.cfs.getDirectories().getDirectoryForNewSSTables(), this.cfs.metadata, preparedInsert.updatedColumns(), this.bufferSizeInMiB);
                if (this.formatType != null) {
                    writer.setSSTableFormatType(this.formatType);
                }
                writer.setRangeAwareWriting(this.makeRangeAware.booleanValue());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new StressCQLSSTableWriter(this.cfs, (AbstractSSTableSimpleWriter)writer, preparedInsert, preparedInsert.getBindVariables());
            }
        }

        private static Types createTypes(String keyspace, List<CreateTypeStatement.Raw> typeStatements) {
            KeyspaceMetadata ksm = Schema.instance.getKeyspaceMetadata(keyspace);
            Types.RawBuilder builder = Types.rawBuilder((String)keyspace);
            for (CreateTypeStatement.Raw st : typeStatements) {
                st.addToRawBuilder(builder);
            }
            return builder.build();
        }

        public static ColumnFamilyStore createOfflineTable(String schema, List<File> directoryList) {
            return Builder.createOfflineTable(StressCQLSSTableWriter.parseStatement(schema, CreateTableStatement.Raw.class, "CREATE TABLE"), Collections.EMPTY_LIST, directoryList);
        }

        public static ColumnFamilyStore createOfflineTable(CreateTableStatement.Raw schemaStatement, List<CreateTypeStatement.Raw> typeStatements, List<File> directoryList) {
            String keyspace = schemaStatement.keyspace();
            Schema.instance.transform(SchemaTransformations.addKeyspace((KeyspaceMetadata)KeyspaceMetadata.create((String)keyspace, (KeyspaceParams)KeyspaceParams.simple((int)1)), (boolean)true));
            Types types = Builder.createTypes(keyspace, typeStatements);
            Schema.instance.transform(SchemaTransformations.addTypes((Types)types, (boolean)true));
            KeyspaceMetadata ksm = Schema.instance.getKeyspaceMetadata(keyspace);
            TableMetadata tableMetadata = ksm.tables.getNullable(schemaStatement.table());
            if (tableMetadata != null) {
                return Schema.instance.getColumnFamilyStoreInstance(tableMetadata.id);
            }
            ClientState state = ClientState.forInternalCalls();
            CreateTableStatement statement = schemaStatement.prepare(state);
            statement.validate(state);
            tableMetadata = statement.builder(ksm.types).id(Builder.deterministicId(schemaStatement.keyspace(), schemaStatement.table())).build();
            Keyspace.setInitialized();
            Directories directories = new Directories(tableMetadata, (Collection)directoryList.stream().map(f -> new Directories.DataDirectory(new org.apache.cassandra.io.util.File(f.toPath()))).collect(Collectors.toList()));
            Keyspace ks = Keyspace.openWithoutSSTables((String)keyspace);
            ColumnFamilyStore cfs = ColumnFamilyStore.createColumnFamilyStore((Keyspace)ks, (String)tableMetadata.name, (TableMetadataRef)TableMetadataRef.forOfflineTools((TableMetadata)tableMetadata), (Directories)directories, (boolean)false, (boolean)false, (boolean)true);
            ks.initCfCustom(cfs);
            Schema.instance.transform(SchemaTransformations.addTable((TableMetadata)tableMetadata, (boolean)true));
            return cfs;
        }

        private static TableId deterministicId(String keyspace, String table) {
            return TableId.fromUUID((UUID)UUID.nameUUIDFromBytes(ArrayUtils.addAll((byte[])keyspace.getBytes(), (byte[])table.getBytes())));
        }

        private UpdateStatement prepareInsert() {
            ClientState state = ClientState.forInternalCalls();
            ModificationStatement cqlStatement = this.insertStatement.prepare(state);
            UpdateStatement insert = (UpdateStatement)cqlStatement;
            insert.validate(state);
            if (insert.hasConditions()) {
                throw new IllegalArgumentException("Conditional statements are not supported");
            }
            if (insert.isCounter()) {
                throw new IllegalArgumentException("Counter update statements are not supported");
            }
            if (insert.getBindVariables().isEmpty()) {
                throw new IllegalArgumentException("Provided insert statement has no bind variables");
            }
            return insert;
        }
    }
}

