/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.triggers;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomClassLoader
extends URLClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(CustomClassLoader.class);
    private final Map<String, Class<?>> cache = new ConcurrentHashMap();
    private final ClassLoader parent;

    public CustomClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        assert (parent != null);
        this.parent = this.getParent();
    }

    public CustomClassLoader(ClassLoader parent, File classPathDir) {
        super(new URL[0], parent);
        assert (parent != null);
        this.parent = this.getParent();
        this.addClassPath(classPathDir);
    }

    public void addClassPath(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        BiPredicate<File, String> filter = (ignore, name) -> name.endsWith(".jar");
        for (File inputJar : dir.tryList(filter)) {
            File lib = new File(FileUtils.getTempDir(), "lib");
            if (!lib.exists()) {
                lib.tryCreateDirectory();
                lib.deleteOnExit();
            }
            File out = FileUtils.createTempFile("cassandra-", ".jar", lib);
            out.deleteOnExit();
            logger.info("Loading new jar {}", (Object)inputJar.absolutePath());
            try {
                Files.copy(inputJar.toPath(), out.toPath(), new CopyOption[0]);
                this.addURL(out.toPath().toUri().toURL());
            }
            catch (IOException ex) {
                throw new FSWriteError((Throwable)ex, out);
            }
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.cache.get(name);
        if (clazz == null) {
            return this.loadClassInternal(name);
        }
        return clazz;
    }

    public synchronized Class<?> loadClassInternal(String name) throws ClassNotFoundException {
        try {
            return this.parent.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            logger.trace("Class not found using parent class loader,", (Throwable)ex);
            Class<?> clazz = this.findClass(name);
            this.cache.put(name, clazz);
            return clazz;
        }
    }
}

