/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.AbstractRepairTask;
import org.apache.cassandra.repair.CommonRange;
import org.apache.cassandra.repair.CoordinatedRepairResult;
import org.apache.cassandra.repair.RepairNotifier;
import org.apache.cassandra.repair.RepairRunnable;
import org.apache.cassandra.repair.consistent.CoordinatorSession;
import org.apache.cassandra.repair.messages.RepairOption;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Future;

public class IncrementalRepairTask
extends AbstractRepairTask {
    private final TimeUUID parentSession;
    private final RepairRunnable.NeighborsAndRanges neighborsAndRanges;
    private final String[] cfnames;

    protected IncrementalRepairTask(RepairOption options, String keyspace, RepairNotifier notifier, TimeUUID parentSession, RepairRunnable.NeighborsAndRanges neighborsAndRanges, String[] cfnames) {
        super(options, keyspace, notifier);
        this.parentSession = parentSession;
        this.neighborsAndRanges = neighborsAndRanges;
        this.cfnames = cfnames;
    }

    @Override
    public String name() {
        return "Repair";
    }

    @Override
    public Future<CoordinatedRepairResult> performUnsafe(ExecutorPlus executor) throws Exception {
        ImmutableSet allParticipants = ImmutableSet.builder().addAll(this.neighborsAndRanges.participants).add((Object)FBUtilities.getBroadcastAddressAndPort()).build();
        List<CommonRange> allRanges = this.neighborsAndRanges.filterCommonRanges(this.keyspace, this.cfnames);
        CoordinatorSession coordinatorSession = ActiveRepairService.instance.consistent.coordinated.registerSession(this.parentSession, (Set<InetAddressAndPort>)allParticipants, this.neighborsAndRanges.shouldExcludeDeadParticipants);
        return coordinatorSession.execute(() -> this.runRepair(this.parentSession, true, executor, allRanges, this.cfnames));
    }
}

