/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.util.Iterator;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.memory.HeapAllocator;

public abstract class EnsureOnHeap
extends Transformation {
    @Override
    public abstract DecoratedKey applyToPartitionKey(DecoratedKey var1);

    public abstract UnfilteredRowIterator applyToPartition(UnfilteredRowIterator var1);

    public abstract SearchIterator<Clustering<?>, Row> applyToPartition(SearchIterator<Clustering<?>, Row> var1);

    public abstract Iterator<Row> applyToPartition(Iterator<Row> var1);

    public abstract DeletionInfo applyToDeletionInfo(DeletionInfo var1);

    @Override
    public abstract Row applyToRow(Row var1);

    @Override
    public abstract Row applyToStatic(Row var1);

    @Override
    public abstract RangeTombstoneMarker applyToMarker(RangeTombstoneMarker var1);

    static class NoOp
    extends EnsureOnHeap {
        NoOp() {
        }

        protected BaseRowIterator<?> applyToPartition(BaseRowIterator partition) {
            return partition;
        }

        @Override
        public DecoratedKey applyToPartitionKey(DecoratedKey key) {
            return key;
        }

        @Override
        public Row applyToRow(Row row) {
            return row;
        }

        @Override
        public Row applyToStatic(Row row) {
            return row;
        }

        @Override
        public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
            return marker;
        }

        @Override
        public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
            return partition;
        }

        @Override
        public SearchIterator<Clustering<?>, Row> applyToPartition(SearchIterator<Clustering<?>, Row> partition) {
            return partition;
        }

        @Override
        public Iterator<Row> applyToPartition(Iterator<Row> partition) {
            return partition;
        }

        @Override
        public DeletionInfo applyToDeletionInfo(DeletionInfo deletionInfo) {
            return deletionInfo;
        }
    }

    static class CloneToHeap
    extends EnsureOnHeap {
        CloneToHeap() {
        }

        protected BaseRowIterator<?> applyToPartition(BaseRowIterator partition) {
            return partition instanceof UnfilteredRowIterator ? Transformation.apply((UnfilteredRowIterator)partition, this) : Transformation.apply((RowIterator)partition, this);
        }

        @Override
        public DecoratedKey applyToPartitionKey(DecoratedKey key) {
            return new BufferDecoratedKey(key.getToken(), HeapAllocator.instance.clone(key.getKey()));
        }

        @Override
        public Row applyToRow(Row row) {
            if (row == null) {
                return null;
            }
            return Rows.copy(row, HeapAllocator.instance.cloningBTreeRowBuilder()).build();
        }

        @Override
        public Row applyToStatic(Row row) {
            if (row == Rows.EMPTY_STATIC_ROW) {
                return row;
            }
            return this.applyToRow(row);
        }

        @Override
        public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
            return marker.copy(HeapAllocator.instance);
        }

        @Override
        public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
            return Transformation.apply(partition, this);
        }

        @Override
        public SearchIterator<Clustering<?>, Row> applyToPartition(final SearchIterator<Clustering<?>, Row> partition) {
            return new SearchIterator<Clustering<?>, Row>(){

                @Override
                public Row next(Clustering<?> key) {
                    return this.applyToRow((Row)partition.next(key));
                }
            };
        }

        @Override
        public Iterator<Row> applyToPartition(final Iterator<Row> partition) {
            return new Iterator<Row>(){

                @Override
                public boolean hasNext() {
                    return partition.hasNext();
                }

                @Override
                public Row next() {
                    return this.applyToRow((Row)partition.next());
                }

                @Override
                public void remove() {
                    partition.remove();
                }
            };
        }

        @Override
        public DeletionInfo applyToDeletionInfo(DeletionInfo deletionInfo) {
            return deletionInfo.copy(HeapAllocator.instance);
        }
    }
}

