/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.addthis.metrics3.reporter.config.ReporterConfig;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXConnectorServer;
import org.apache.cassandra.audit.AuditLogManager;
import org.apache.cassandra.auth.AuthCacheService;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SizeEstimatesRecorder;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.SystemKeyspaceMigrator41;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.virtual.SystemViewsKeyspace;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.db.virtual.VirtualSchemaKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.StartupException;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.sstable.SSTableHeaderFix;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.net.StartupClusterConnectivityChecker;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.security.ThreadAwareSecurityManager;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.DefaultFSErrorHandler;
import org.apache.cassandra.service.FileSystemOwnershipCheck;
import org.apache.cassandra.service.GCInspector;
import org.apache.cassandra.service.NativeAccessMBean;
import org.apache.cassandra.service.NativeTransportService;
import org.apache.cassandra.service.StartupChecks;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JMXServerUtils;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.Mx4jTool;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.FutureCombiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=NativeAccess";
    private static final Logger logger;
    @VisibleForTesting
    public static Runnable SPECULATION_THRESHOLD_UPDATER;
    static final CassandraDaemon instance;
    private volatile NativeTransportService nativeTransportService;
    private JMXConnectorServer jmxServer;
    private final boolean runManaged;
    protected final StartupChecks startupChecks;
    private boolean setupCompleted;

    @VisibleForTesting
    public static CassandraDaemon getInstanceForTesting() {
        return instance;
    }

    private void maybeInitJmx() {
        if (CassandraRelevantProperties.COM_SUN_MANAGEMENT_JMXREMOTE_PORT.isPresent()) {
            logger.warn("JMX settings in cassandra-env.sh have been bypassed as the JMX connector server is already initialized. Please refer to cassandra-env.(sh|ps1) for JMX configuration info");
            return;
        }
        System.setProperty("java.rmi.server.randomIDs", "true");
        boolean localOnly = false;
        String jmxPort = CassandraRelevantProperties.CASSANDRA_JMX_REMOTE_PORT.getString();
        if (jmxPort == null) {
            localOnly = true;
            jmxPort = System.getProperty("cassandra.jmx.local.port");
        }
        if (jmxPort == null) {
            return;
        }
        try {
            this.jmxServer = JMXServerUtils.createJMXServer(Integer.parseInt(jmxPort), localOnly);
            if (this.jmxServer == null) {
                return;
            }
        }
        catch (IOException e) {
            this.exitOrFail(1, e.getMessage(), e.getCause());
        }
    }

    public CassandraDaemon() {
        this(false);
    }

    public CassandraDaemon(boolean runManaged) {
        this.runManaged = runManaged;
        this.startupChecks = new StartupChecks().withDefaultTests().withTest(new FileSystemOwnershipCheck());
        this.setupCompleted = false;
    }

    protected void setup() {
        FileUtils.setFSErrorHandler(new DefaultFSErrorHandler());
        try {
            this.migrateSystemDataIfNeeded();
        }
        catch (IOException e) {
            this.exitOrFail(3, e.getMessage(), e);
        }
        this.maybeInitJmx();
        Mx4jTool.maybeLoad();
        ThreadAwareSecurityManager.install();
        this.logSystemInfo();
        NativeLibrary.tryMlockall();
        CommitLog.instance.start();
        this.runStartupChecks();
        try {
            SystemKeyspace.snapshotOnVersionChange();
        }
        catch (IOException e) {
            this.exitOrFail(3, e.getMessage(), e.getCause());
        }
        SystemKeyspace.persistLocalMetadata();
        Thread.setDefaultUncaughtExceptionHandler(JVMStabilityInspector::uncaughtException);
        SystemKeyspaceMigrator41.migrate();
        StorageService.instance.populateTokenMetadata();
        try {
            Schema.instance.loadFromDisk();
        }
        catch (Exception e) {
            logger.error("Error while loading schema: ", (Throwable)e);
            throw e;
        }
        this.setupVirtualKeyspaces();
        SSTableHeaderFix.fixNonFrozenUDTIfUpgradeFrom30();
        for (String keyspaceName : Schema.instance.getKeyspaces()) {
            if (keyspaceName.equals("system")) continue;
            for (TableMetadata cfm : Schema.instance.getTablesAndViews(keyspaceName)) {
                try {
                    ColumnFamilyStore.scrubDataDirectories(cfm);
                }
                catch (StartupException e) {
                    this.exitOrFail(e.returnCode, e.getMessage(), e.getCause());
                }
            }
        }
        Keyspace.setInitialized();
        for (String keyspaceName : Schema.instance.getKeyspaces()) {
            if (logger.isDebugEnabled()) {
                logger.debug("opening keyspace {}", (Object)keyspaceName);
            }
            for (ColumnFamilyStore cfs : Keyspace.open(keyspaceName).getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.disableAutoCompaction();
                }
            }
        }
        try {
            this.loadRowAndKeyCacheAsync().get();
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            logger.warn("Error loading key or row cache", t);
        }
        try {
            GCInspector.register();
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            logger.warn("Unable to start GCInspector (currently only supported on the Sun JVM)");
        }
        PaxosState.initializeTrackers();
        try {
            CommitLog.instance.recoverSegmentsOnDisk();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StorageService.instance.populateTokenMetadata();
        try {
            PaxosState.maybeRebuildUncommittedState();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StorageService.instance.cleanupSizeEstimates();
        int sizeRecorderInterval = Integer.getInteger("cassandra.size_recorder_interval", 300);
        if (sizeRecorderInterval > 0) {
            ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(SizeEstimatesRecorder.instance, 30L, sizeRecorderInterval, TimeUnit.SECONDS);
        }
        ActiveRepairService.instance.start();
        StreamManager.instance.start();
        QueryProcessor.instance.preloadPreparedStatements();
        String metricsReporterConfigFile = System.getProperty("cassandra.metricsReporterConfigFile");
        if (metricsReporterConfigFile != null) {
            logger.info("Trying to load metrics-reporter-config from file: {}", (Object)metricsReporterConfigFile);
            try {
                CassandraMetricsRegistry.Metrics.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
                CassandraMetricsRegistry.Metrics.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
                CassandraMetricsRegistry.Metrics.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
                CassandraMetricsRegistry.Metrics.register("jvm.fd.usage", (Metric)new FileDescriptorRatioGauge());
                URL resource = CassandraDaemon.class.getClassLoader().getResource(metricsReporterConfigFile);
                if (resource == null) {
                    logger.warn("Failed to load metrics-reporter-config, file does not exist: {}", (Object)metricsReporterConfigFile);
                } else {
                    String reportFileLocation = resource.getFile();
                    ReporterConfig.loadFromFile((String)reportFileLocation).enableAll((MetricRegistry)CassandraMetricsRegistry.Metrics);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to load metrics-reporter-config, metric sinks will not be activated", (Throwable)e);
            }
        }
        StorageService.instance.registerDaemon(this);
        try {
            StorageService.instance.initServer();
        }
        catch (ConfigurationException e) {
            System.err.println(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            this.exitOrFail(1, "Fatal configuration error", e);
        }
        Runnable viewRebuild = () -> {
            for (Keyspace keyspace : Keyspace.all()) {
                keyspace.viewManager.buildAllViews();
            }
            logger.debug("Completed submission of build tasks for any materialized views defined at startup");
        };
        ScheduledExecutors.optionalTasks.schedule(viewRebuild, (long)StorageService.RING_DELAY_MILLIS, TimeUnit.MILLISECONDS);
        if (!FBUtilities.getBroadcastAddressAndPort().equals(InetAddressAndPort.getLoopbackAddress())) {
            Gossiper.waitToSettle();
        }
        StorageService.instance.doAuthSetup(false);
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.reload();
                    if (!store.getCompactionStrategyManager().shouldBeEnabled()) continue;
                    if (DatabaseDescriptor.getAutocompactionOnStartupEnabled()) {
                        store.enableAutoCompaction();
                        continue;
                    }
                    logger.info("Not enabling compaction for {}.{}; autocompaction_on_startup_enabled is set to false", (Object)store.keyspace.getName(), (Object)store.name);
                }
            }
        }
        AuditLogManager.instance.initialize();
        ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(ColumnFamilyStore.getBackgroundCompactionTaskSubmitter(), 5L, 1L, TimeUnit.MINUTES);
        ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(SPECULATION_THRESHOLD_UPDATER, DatabaseDescriptor.getReadRpcTimeout(TimeUnit.NANOSECONDS), DatabaseDescriptor.getReadRpcTimeout(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        this.initializeClientTransports();
        if (DatabaseDescriptor.getAuthCacheWarmingEnabled()) {
            AuthCacheService.instance.warmCaches();
        } else {
            logger.info("Prewarming of auth caches is disabled");
        }
        this.completeSetup();
    }

    public void runStartupChecks() {
        try {
            this.startupChecks.verify(DatabaseDescriptor.getStartupChecksOptions());
        }
        catch (StartupException e) {
            this.exitOrFail(e.returnCode, e.getMessage(), e.getCause());
        }
    }

    public void migrateSystemDataIfNeeded() throws IOException {
        String[] sources;
        if (!DatabaseDescriptor.useSpecificLocationForLocalSystemData() && DatabaseDescriptor.getNonLocalSystemKeyspacesDataFileLocations().length <= 1) {
            return;
        }
        Path target = Paths.get(DatabaseDescriptor.getLocalSystemKeyspacesDataFileLocations()[0], new String[0]);
        String[] nonLocalSystemKeyspacesFileLocations = DatabaseDescriptor.getNonLocalSystemKeyspacesDataFileLocations();
        for (String source : sources = DatabaseDescriptor.useSpecificLocationForLocalSystemData() ? nonLocalSystemKeyspacesFileLocations : Arrays.copyOfRange(nonLocalSystemKeyspacesFileLocations, 1, nonLocalSystemKeyspacesFileLocations.length)) {
            Path dataFileLocation = Paths.get(source, new String[0]);
            if (!Files.exists(dataFileLocation, new LinkOption[0])) continue;
            try (Stream<Path> locationChildren = Files.list(dataFileLocation);){
                Path[] keyspaceDirectories;
                for (Path keyspaceDirectory : keyspaceDirectories = (Path[])locationChildren.filter(p -> SchemaConstants.isLocalSystemKeyspace(p.getFileName().toString())).toArray(Path[]::new)) {
                    try (Stream<Path> keyspaceChildren = Files.list(keyspaceDirectory);){
                        Path[] tableDirectories;
                        for (Path tableDirectory : tableDirectories = (Path[])keyspaceChildren.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> !SystemKeyspace.TABLES_SPLIT_ACROSS_MULTIPLE_DISKS.contains(p.getFileName().toString())).toArray(Path[]::new)) {
                            FileUtils.moveRecursively(tableDirectory, target.resolve(dataFileLocation.relativize(tableDirectory)));
                        }
                        if ("system".equals(keyspaceDirectory.getFileName().toString())) continue;
                        FileUtils.deleteDirectoryIfEmpty(keyspaceDirectory);
                    }
                }
            }
        }
    }

    public void setupVirtualKeyspaces() {
        VirtualKeyspaceRegistry.instance.register(VirtualSchemaKeyspace.instance);
        VirtualKeyspaceRegistry.instance.register(SystemViewsKeyspace.instance);
    }

    public synchronized void initializeClientTransports() {
        if (this.nativeTransportService == null) {
            this.nativeTransportService = new NativeTransportService();
        }
    }

    private Future<?> loadRowAndKeyCacheAsync() {
        Future<Integer> keyCacheLoad = CacheService.instance.keyCache.loadSavedAsync();
        Future<Integer> rowCacheLoad = CacheService.instance.rowCache.loadSavedAsync();
        Future retval = FutureCombiner.allOf(ImmutableList.of(keyCacheLoad, rowCacheLoad));
        return retval;
    }

    @VisibleForTesting
    public void completeSetup() {
        this.setupCompleted = true;
    }

    public boolean setupCompleted() {
        return this.setupCompleted;
    }

    private void logSystemInfo() {
        if (logger.isInfoEnabled()) {
            try {
                logger.info("Hostname: {}", (Object)(InetAddress.getLocalHost().getHostName() + ":" + DatabaseDescriptor.getStoragePort() + ":" + DatabaseDescriptor.getSSLStoragePort()));
            }
            catch (UnknownHostException e1) {
                logger.info("Could not resolve local host");
            }
            logger.info("JVM vendor/version: {}/{}", (Object)CassandraRelevantProperties.JAVA_VM_NAME.getString(), (Object)CassandraRelevantProperties.JAVA_VERSION.getString());
            logger.info("Heap size: {}/{}", (Object)FBUtilities.prettyPrintMemory(Runtime.getRuntime().totalMemory()), (Object)FBUtilities.prettyPrintMemory(Runtime.getRuntime().maxMemory()));
            for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                logger.info("{} {}: {}", new Object[]{pool.getName(), pool.getType(), pool.getPeakUsage()});
            }
            logger.info("Classpath: {}", (Object)CassandraRelevantProperties.JAVA_CLASS_PATH.getString());
            logger.info("JVM Arguments: {}", ManagementFactory.getRuntimeMXBean().getInputArguments());
        }
    }

    public void init(String[] arguments) throws IOException {
        this.setup();
    }

    public void start() {
        StartupClusterConnectivityChecker connectivityChecker = StartupClusterConnectivityChecker.create(DatabaseDescriptor.getBlockForPeersTimeoutInSeconds(), DatabaseDescriptor.getBlockForPeersInRemoteDatacenters());
        connectivityChecker.execute((Set<InetAddressAndPort>)Gossiper.instance.getEndpoints(), DatabaseDescriptor.getEndpointSnitch()::getDatacenter);
        try {
            this.validateTransportsCanStart();
        }
        catch (IllegalStateException isx) {
            logger.warn(isx.getMessage());
            return;
        }
        this.startClientTransports();
    }

    private void startClientTransports() {
        String nativeFlag = System.getProperty("cassandra.start_native_transport");
        if (nativeFlag != null && Boolean.parseBoolean(nativeFlag) || nativeFlag == null && DatabaseDescriptor.startNativeTransport()) {
            this.startNativeTransport();
            StorageService.instance.setRpcReady(true);
        } else {
            logger.info("Not starting native transport as requested. Use JMX (StorageService->startNativeTransport()) or nodetool (enablebinary) to start it");
        }
    }

    public void stop() {
        logger.info("Cassandra shutting down...");
        this.destroyClientTransports();
        StorageService.instance.setRpcReady(false);
        if (this.jmxServer != null) {
            try {
                this.jmxServer.stop();
            }
            catch (IOException e) {
                logger.error("Error shutting down local JMX server: ", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public void destroyClientTransports() {
        this.stopNativeTransport();
        if (this.nativeTransportService != null) {
            this.nativeTransportService.destroy();
        }
    }

    public void destroy() {
    }

    public void activate() {
        try {
            this.applyConfig();
            CassandraDaemon.registerNativeAccess();
            this.setup();
            String pidFile = CassandraRelevantProperties.CASSANDRA_PID_FILE.getString();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (CassandraRelevantProperties.CASSANDRA_FOREGROUND.getString() == null) {
                System.out.close();
                System.err.close();
            }
            this.start();
            logger.info("Startup complete");
        }
        catch (Throwable e) {
            boolean logStackTrace = e instanceof ConfigurationException ? ((ConfigurationException)e).logStackTrace : true;
            System.out.println("Exception (" + e.getClass().getName() + ") encountered during startup: " + e.getMessage());
            if (logStackTrace) {
                if (this.runManaged) {
                    logger.error("Exception encountered during startup", e);
                }
                e.printStackTrace();
                this.exitOrFail(3, "Exception encountered during startup", e);
            }
            if (this.runManaged) {
                logger.error("Exception encountered during startup: {}", (Object)e.getMessage());
            }
            System.err.println(e.getMessage());
            this.exitOrFail(3, "Exception encountered during startup: " + e.getMessage());
        }
    }

    @VisibleForTesting
    public static void registerNativeAccess() throws NotCompliantMBeanException {
        MBeanWrapper.instance.registerMBean((Object)new StandardMBean(new NativeAccess(), NativeAccessMBean.class), MBEAN_NAME, MBeanWrapper.OnException.LOG);
    }

    public void applyConfig() {
        DatabaseDescriptor.daemonInitialization();
    }

    public void validateTransportsCanStart() {
        if (StorageService.instance.hasJoined()) {
            if (StorageService.instance.isSurveyMode()) {
                if (StorageService.instance.isBootstrapMode() || DatabaseDescriptor.getAuthenticator().requireAuthentication()) {
                    throw new IllegalStateException("Not starting client transports in write_survey mode as it's bootstrapping or auth is enabled");
                }
            } else if (!SystemKeyspace.bootstrapComplete()) {
                throw new IllegalStateException("Node is not yet bootstrapped completely. Use nodetool to check bootstrap state and resume. For more, see `nodetool help bootstrap`");
            }
        }
    }

    public void startNativeTransport() {
        this.validateTransportsCanStart();
        if (this.nativeTransportService == null) {
            throw new IllegalStateException("setup() must be called first for CassandraDaemon");
        }
        this.nativeTransportService.start();
    }

    public void stopNativeTransport() {
        if (this.nativeTransportService != null) {
            this.nativeTransportService.stop();
        }
    }

    public boolean isNativeTransportRunning() {
        return this.nativeTransportService != null && this.nativeTransportService.isRunning();
    }

    public void deactivate() {
        this.stop();
        this.destroy();
        if (!this.runManaged) {
            System.exit(0);
        }
    }

    public static void stop(String[] args) {
        instance.deactivate();
    }

    public static void main(String[] args) {
        instance.activate();
    }

    public void clearConnectionHistory() {
        this.nativeTransportService.clearConnectionHistory();
    }

    private void exitOrFail(int code, String message) {
        this.exitOrFail(code, message, null);
    }

    private void exitOrFail(int code, String message, Throwable cause) {
        if (this.runManaged) {
            RuntimeException t = cause != null ? new RuntimeException(message, cause) : new RuntimeException(message);
            throw t;
        }
        logger.error(message, cause);
        System.exit(code);
    }

    static {
        SharedMetricRegistries.getOrCreate((String)"logback-metrics").addListener((MetricRegistryListener)new MetricRegistryListener.Base(){

            public void onMeterAdded(String metricName, Meter meter) {
                int separator = metricName.lastIndexOf(46);
                String appenderName = metricName.substring(0, separator);
                String metric = metricName.substring(separator + 1);
                ObjectName name = DefaultNameFactory.createMetricName(appenderName, metric, null).getMBeanName();
                CassandraMetricsRegistry.Metrics.registerMBean((Metric)meter, name);
            }
        });
        logger = LoggerFactory.getLogger(CassandraDaemon.class);
        SPECULATION_THRESHOLD_UPDATER = () -> {
            try {
                Keyspace.allExisting().forEach(k -> k.getColumnFamilyStores().forEach(ColumnFamilyStore::updateSpeculationThreshold));
            }
            catch (Throwable t) {
                logger.warn("Failed to update speculative retry thresholds.", t);
                JVMStabilityInspector.inspectThrowable(t);
            }
        };
        instance = new CassandraDaemon();
    }

    public static interface Server {
        public void start();

        public void stop();

        public boolean isRunning();

        public void clearConnectionHistory();
    }

    static class NativeAccess
    implements NativeAccessMBean {
        NativeAccess() {
        }

        @Override
        public boolean isAvailable() {
            return NativeLibrary.isAvailable();
        }

        @Override
        public boolean isMemoryLockable() {
            return NativeLibrary.jnaMemoryLockable();
        }
    }
}

