/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import javax.annotation.Nonnull;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.File;

public class ChecksumWriter {
    private final CRC32 incrementalChecksum = new CRC32();
    private final DataOutput incrementalOut;
    private final CRC32 fullChecksum = new CRC32();

    public ChecksumWriter(DataOutput incrementalOut) {
        this.incrementalOut = incrementalOut;
    }

    public void writeChunkSize(int length) {
        try {
            this.incrementalOut.writeInt(length);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void appendDirect(ByteBuffer bb, boolean checksumIncrementalResult) {
        try {
            ByteBuffer toAppend = bb.duplicate();
            toAppend.mark();
            this.incrementalChecksum.update(toAppend);
            toAppend.reset();
            int incrementalChecksumValue = (int)this.incrementalChecksum.getValue();
            this.incrementalOut.writeInt(incrementalChecksumValue);
            this.fullChecksum.update(toAppend);
            if (checksumIncrementalResult) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                byteBuffer.putInt(incrementalChecksumValue);
                assert (byteBuffer.arrayOffset() == 0);
                this.fullChecksum.update(byteBuffer.array(), 0, byteBuffer.array().length);
            }
            this.incrementalChecksum.reset();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void writeFullChecksum(@Nonnull File digestFile) {
        try (FileOutputStream fos = new FileOutputStream(digestFile.toJavaIOFile());
             DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos));){
            out.write(String.valueOf(this.fullChecksum.getValue()).getBytes(StandardCharsets.UTF_8));
            out.flush();
            fos.getFD().sync();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, digestFile);
        }
    }
}

