/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.util.Objects;
import org.apache.cassandra.db.ArrayClusteringBoundary;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.AbstractRangeTombstoneMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class RangeTombstoneBoundaryMarker
extends AbstractRangeTombstoneMarker<ClusteringBoundary<?>> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new RangeTombstoneBoundaryMarker(new ArrayClusteringBoundary(ClusteringPrefix.Kind.INCL_END_EXCL_START_BOUNDARY, new byte[][]{new byte[0]}), null, null));
    private final DeletionTime endDeletion;
    private final DeletionTime startDeletion;

    public RangeTombstoneBoundaryMarker(ClusteringBoundary<?> bound, DeletionTime endDeletion, DeletionTime startDeletion) {
        super(bound);
        assert (bound.isBoundary());
        this.endDeletion = endDeletion;
        this.startDeletion = startDeletion;
    }

    public static <V> RangeTombstoneBoundaryMarker exclusiveCloseInclusiveOpen(boolean reversed, V[] boundValues, ValueAccessor<V> accessor, DeletionTime closeDeletion, DeletionTime openDeletion) {
        ClusteringBoundary<V> bound = accessor.factory().exclusiveCloseInclusiveOpen(reversed, boundValues);
        DeletionTime endDeletion = reversed ? openDeletion : closeDeletion;
        DeletionTime startDeletion = reversed ? closeDeletion : openDeletion;
        return new RangeTombstoneBoundaryMarker(bound, endDeletion, startDeletion);
    }

    public static <V> RangeTombstoneBoundaryMarker exclusiveCloseInclusiveOpen(boolean reversed, ClusteringPrefix<V> from, DeletionTime closeDeletion, DeletionTime openDeletion) {
        return RangeTombstoneBoundaryMarker.exclusiveCloseInclusiveOpen(reversed, from.getRawValues(), from.accessor(), closeDeletion, openDeletion);
    }

    public static <V> RangeTombstoneBoundaryMarker inclusiveCloseExclusiveOpen(boolean reversed, V[] boundValues, ValueAccessor<V> accessor, DeletionTime closeDeletion, DeletionTime openDeletion) {
        ClusteringBoundary<V> bound = accessor.factory().inclusiveCloseExclusiveOpen(reversed, boundValues);
        DeletionTime endDeletion = reversed ? openDeletion : closeDeletion;
        DeletionTime startDeletion = reversed ? closeDeletion : openDeletion;
        return new RangeTombstoneBoundaryMarker(bound, endDeletion, startDeletion);
    }

    public static <V> RangeTombstoneBoundaryMarker inclusiveCloseExclusiveOpen(boolean reversed, ClusteringPrefix<V> from, DeletionTime closeDeletion, DeletionTime openDeletion) {
        return RangeTombstoneBoundaryMarker.inclusiveCloseExclusiveOpen(reversed, from.getRawValues(), from.accessor(), closeDeletion, openDeletion);
    }

    public DeletionTime endDeletionTime() {
        return this.endDeletion;
    }

    public DeletionTime startDeletionTime() {
        return this.startDeletion;
    }

    @Override
    public DeletionTime closeDeletionTime(boolean reversed) {
        return reversed ? this.startDeletion : this.endDeletion;
    }

    @Override
    public DeletionTime openDeletionTime(boolean reversed) {
        return reversed ? this.endDeletion : this.startDeletion;
    }

    @Override
    public boolean openIsInclusive(boolean reversed) {
        return ((ClusteringBoundary)this.bound).kind() == ClusteringPrefix.Kind.EXCL_END_INCL_START_BOUNDARY ^ reversed;
    }

    @Override
    public ClusteringBound<?> openBound(boolean reversed) {
        return ((ClusteringBoundary)this.bound).openBound(reversed);
    }

    @Override
    public ClusteringBound<?> closeBound(boolean reversed) {
        return ((ClusteringBoundary)this.bound).closeBound(reversed);
    }

    @Override
    public boolean closeIsInclusive(boolean reversed) {
        return ((ClusteringBoundary)this.bound).kind() == ClusteringPrefix.Kind.INCL_END_EXCL_START_BOUNDARY ^ reversed;
    }

    @Override
    public boolean isOpen(boolean reversed) {
        return true;
    }

    @Override
    public boolean isClose(boolean reversed) {
        return true;
    }

    @Override
    public boolean hasInvalidDeletions() {
        return !this.startDeletion.validate() || !this.endDeletion.validate();
    }

    @Override
    public RangeTombstoneBoundaryMarker copy(AbstractAllocator allocator) {
        return new RangeTombstoneBoundaryMarker((ClusteringBoundary)((ClusteringBoundary)this.clustering()).copy(allocator), this.endDeletion, this.startDeletion);
    }

    @Override
    public RangeTombstoneBoundaryMarker withNewOpeningDeletionTime(boolean reversed, DeletionTime newDeletionTime) {
        return new RangeTombstoneBoundaryMarker((ClusteringBoundary)this.clustering(), reversed ? newDeletionTime : this.endDeletion, reversed ? this.startDeletion : newDeletionTime);
    }

    public static <V1, V2> RangeTombstoneBoundaryMarker makeBoundary(boolean reversed, ClusteringBound<V1> close, ClusteringBound<V2> open, DeletionTime closeDeletion, DeletionTime openDeletion) {
        assert (ClusteringPrefix.Kind.compare(close.kind(), open.kind()) == 0) : "Both bound don't form a boundary";
        boolean isExclusiveClose = close.isExclusive() || close.isInclusive() && open.isInclusive() && openDeletion.supersedes(closeDeletion);
        return isExclusiveClose ? RangeTombstoneBoundaryMarker.exclusiveCloseInclusiveOpen(reversed, close.getRawValues(), close.accessor(), closeDeletion, openDeletion) : RangeTombstoneBoundaryMarker.inclusiveCloseExclusiveOpen(reversed, close.getRawValues(), close.accessor(), closeDeletion, openDeletion);
    }

    public RangeTombstoneBoundMarker createCorrespondingCloseMarker(boolean reversed) {
        return new RangeTombstoneBoundMarker(this.closeBound(reversed), this.closeDeletionTime(reversed));
    }

    public RangeTombstoneBoundMarker createCorrespondingOpenMarker(boolean reversed) {
        return new RangeTombstoneBoundMarker(this.openBound(reversed), this.openDeletionTime(reversed));
    }

    @Override
    public void digest(Digest digest) {
        ((ClusteringBoundary)this.bound).digest(digest);
        this.endDeletion.digest(digest);
        this.startDeletion.digest(digest);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + this.startDeletion.unsharedHeapSize() + this.endDeletion.unsharedHeapSize();
    }

    @Override
    public String toString(TableMetadata metadata) {
        return String.format("Marker %s@%d/%d-%d/%d", ((ClusteringBoundary)this.bound).toString(metadata), this.endDeletion.markedForDeleteAt(), this.endDeletion.localDeletionTime(), this.startDeletion.markedForDeleteAt(), this.startDeletion.localDeletionTime());
    }

    public boolean equals(Object other) {
        if (!(other instanceof RangeTombstoneBoundaryMarker)) {
            return false;
        }
        RangeTombstoneBoundaryMarker that = (RangeTombstoneBoundaryMarker)other;
        return ((ClusteringBoundary)this.bound).equals(that.bound) && this.endDeletion.equals(that.endDeletion) && this.startDeletion.equals(that.startDeletion);
    }

    public int hashCode() {
        return Objects.hash(this.bound, this.endDeletion, this.startDeletion);
    }
}

