/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.memtable.AbstractAllocatorMemtable;
import org.apache.cassandra.db.memtable.AbstractMemtable;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.memtable.ShardBoundaries;
import org.apache.cassandra.db.memtable.SkipListMemtable;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.AtomicBTreePartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReadsListener;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.github.jamm.Unmetered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedSkipListMemtable
extends AbstractAllocatorMemtable {
    private static final Logger logger = LoggerFactory.getLogger(ShardedSkipListMemtable.class);
    public static final String SHARDS_OPTION = "shards";
    public static final String LOCKING_OPTION = "serialize_writes";
    @Unmetered
    final ShardBoundaries boundaries;
    final MemtableShard[] shards;
    @VisibleForTesting
    public static final String SHARD_COUNT_PROPERTY = "cassandra.memtable.shard.count";
    private static final int SHARD_COUNT = Integer.getInteger("cassandra.memtable.shard.count", FBUtilities.getAvailableProcessors());
    private final Factory factory;

    ShardedSkipListMemtable(AtomicReference<CommitLogPosition> commitLogLowerBound, TableMetadataRef metadataRef, Memtable.Owner owner, Integer shardCountOption, Factory factory) {
        super(commitLogLowerBound, metadataRef, owner);
        int shardCount = shardCountOption != null ? shardCountOption : SHARD_COUNT;
        this.boundaries = owner.localRangeSplits(shardCount);
        this.shards = ShardedSkipListMemtable.generatePartitionShards(this.boundaries.shardCount(), this.allocator, metadataRef);
        this.factory = factory;
    }

    private static MemtableShard[] generatePartitionShards(int splits, MemtableAllocator allocator, TableMetadataRef metadata) {
        MemtableShard[] partitionMapContainer = new MemtableShard[splits];
        for (int i = 0; i < splits; ++i) {
            partitionMapContainer[i] = new MemtableShard(metadata, allocator);
        }
        return partitionMapContainer;
    }

    @Override
    public boolean isClean() {
        for (MemtableShard shard : this.shards) {
            if (shard.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Memtable.Factory factory() {
        return this.factory;
    }

    @Override
    public long put(PartitionUpdate update, UpdateTransaction indexer, OpOrder.Group opGroup) {
        DecoratedKey key = update.partitionKey();
        MemtableShard shard = this.shards[this.boundaries.getShardForKey(key)];
        return shard.put(key, update, indexer, opGroup);
    }

    @Override
    public long getLiveDataSize() {
        long total = 0L;
        for (MemtableShard shard : this.shards) {
            total += shard.liveDataSize();
        }
        return total;
    }

    @Override
    public long operationCount() {
        long total = 0L;
        for (MemtableShard shard : this.shards) {
            total += shard.currentOperations();
        }
        return total;
    }

    @Override
    public long partitionCount() {
        int total = 0;
        for (MemtableShard shard : this.shards) {
            total += shard.size();
        }
        return total;
    }

    @Override
    public long getMinTimestamp() {
        long min = Long.MAX_VALUE;
        for (MemtableShard shard : this.shards) {
            min = Long.min(min, shard.minTimestamp());
        }
        return min;
    }

    @Override
    public int getMinLocalDeletionTime() {
        int min = Integer.MAX_VALUE;
        for (MemtableShard shard : this.shards) {
            min = Integer.min(min, shard.minLocalDeletionTime());
        }
        return min;
    }

    @Override
    RegularAndStaticColumns columns() {
        for (MemtableShard shard : this.shards) {
            this.columnsCollector.update(shard.columnsCollector);
        }
        return this.columnsCollector.get();
    }

    @Override
    EncodingStats encodingStats() {
        for (MemtableShard shard : this.shards) {
            this.statsCollector.update(shard.statsCollector.get());
        }
        return this.statsCollector.get();
    }

    @Override
    public MemtableUnfilteredPartitionIterator partitionIterator(ColumnFilter columnFilter, DataRange dataRange, SSTableReadsListener readsListener) {
        AbstractBounds<PartitionPosition> keyRange = dataRange.keyRange();
        PartitionPosition left = (PartitionPosition)keyRange.left;
        PartitionPosition right = (PartitionPosition)keyRange.right;
        boolean isBound = keyRange instanceof Bounds;
        boolean includeStart = isBound || keyRange instanceof IncludingExcludingBounds;
        boolean includeStop = isBound || keyRange instanceof Range;
        Iterator<AtomicBTreePartition> iterator = this.getPartitionIterator(left, includeStart, right, includeStop);
        return new MemtableUnfilteredPartitionIterator(this.metadata(), iterator, columnFilter, dataRange);
    }

    private Iterator<AtomicBTreePartition> getPartitionIterator(PartitionPosition left, boolean includeStart, PartitionPosition right, boolean includeStop) {
        Iterator iterator;
        int rightShard;
        int leftShard = left != null && !left.isMinimum() ? this.boundaries.getShardForKey(left) : 0;
        int n = rightShard = right != null && !right.isMinimum() ? this.boundaries.getShardForKey(right) : this.boundaries.shardCount() - 1;
        if (leftShard == rightShard) {
            iterator = this.shards[leftShard].getPartitionsSubMap(left, includeStart, right, includeStop).values().iterator();
        } else {
            Iterator[] iters = new Iterator[rightShard - leftShard + 1];
            int i = leftShard;
            iters[0] = this.shards[leftShard].getPartitionsSubMap(left, includeStart, null, true).values().iterator();
            ++i;
            while (i < rightShard) {
                iters[i - leftShard] = this.shards[i].partitions.values().iterator();
                ++i;
            }
            iters[i - leftShard] = this.shards[i].getPartitionsSubMap(null, true, right, includeStop).values().iterator();
            iterator = Iterators.concat((Iterator[])iters);
        }
        return iterator;
    }

    private Partition getPartition(DecoratedKey key) {
        int shardIndex = this.boundaries.getShardForKey(key);
        return (Partition)this.shards[shardIndex].partitions.get(key);
    }

    @Override
    public UnfilteredRowIterator rowIterator(DecoratedKey key, Slices slices, ColumnFilter selectedColumns, boolean reversed, SSTableReadsListener listener) {
        Partition p = this.getPartition(key);
        if (p == null) {
            return null;
        }
        return p.unfilteredIterator(selectedColumns, slices, reversed);
    }

    @Override
    public UnfilteredRowIterator rowIterator(DecoratedKey key) {
        Partition p = this.getPartition(key);
        return p != null ? p.unfilteredIterator() : null;
    }

    public Memtable.FlushablePartitionSet<AtomicBTreePartition> getFlushSet(final PartitionPosition from, final PartitionPosition to) {
        long keySize = 0L;
        int keyCount = 0;
        Iterator<AtomicBTreePartition> it = this.getPartitionIterator(from, true, to, false);
        while (it.hasNext()) {
            AtomicBTreePartition en = it.next();
            keySize += (long)en.partitionKey().getKey().remaining();
            ++keyCount;
        }
        final long partitionKeySize = keySize;
        final int partitionCount = keyCount;
        final Iterator<AtomicBTreePartition> toFlush = this.getPartitionIterator(from, true, to, false);
        return new AbstractMemtable.AbstractFlushablePartitionSet<AtomicBTreePartition>(){

            @Override
            public Memtable memtable() {
                return ShardedSkipListMemtable.this;
            }

            @Override
            public PartitionPosition from() {
                return from;
            }

            @Override
            public PartitionPosition to() {
                return to;
            }

            @Override
            public long partitionCount() {
                return partitionCount;
            }

            @Override
            public Iterator<AtomicBTreePartition> iterator() {
                return toFlush;
            }

            @Override
            public long partitionKeysSize() {
                return partitionKeySize;
            }
        };
    }

    public static Factory factory(Map<String, String> optionsCopy) {
        String shardsString = optionsCopy.remove(SHARDS_OPTION);
        Integer shardCount = shardsString != null ? Integer.valueOf(Integer.parseInt(shardsString)) : null;
        boolean isLocking = Boolean.parseBoolean(optionsCopy.remove(LOCKING_OPTION));
        return new Factory(shardCount, isLocking);
    }

    static class Factory
    implements Memtable.Factory {
        final Integer shardCount;
        final boolean isLocking;

        Factory(Integer shardCount, boolean isLocking) {
            this.shardCount = shardCount;
            this.isLocking = isLocking;
        }

        @Override
        public Memtable create(AtomicReference<CommitLogPosition> commitLogLowerBound, TableMetadataRef metadataRef, Memtable.Owner owner) {
            return this.isLocking ? new Locking(commitLogLowerBound, metadataRef, owner, this.shardCount, this) : new ShardedSkipListMemtable(commitLogLowerBound, metadataRef, owner, this.shardCount, this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Factory factory = (Factory)o;
            return Objects.equals(this.shardCount, factory.shardCount);
        }

        public int hashCode() {
            return Objects.hash(this.shardCount);
        }
    }

    static class Locking
    extends ShardedSkipListMemtable {
        Locking(AtomicReference<CommitLogPosition> commitLogLowerBound, TableMetadataRef metadataRef, Memtable.Owner owner, Integer shardCountOption, Factory factory) {
            super(commitLogLowerBound, metadataRef, owner, shardCountOption, factory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long put(PartitionUpdate update, UpdateTransaction indexer, OpOrder.Group opGroup) {
            MemtableShard shard;
            DecoratedKey key = update.partitionKey();
            MemtableShard memtableShard = shard = this.shards[this.boundaries.getShardForKey(key)];
            synchronized (memtableShard) {
                return shard.put(key, update, indexer, opGroup);
            }
        }
    }

    public static class MemtableUnfilteredPartitionIterator
    extends AbstractUnfilteredPartitionIterator
    implements UnfilteredPartitionIterator {
        private final TableMetadata metadata;
        private final Iterator<AtomicBTreePartition> iter;
        private final ColumnFilter columnFilter;
        private final DataRange dataRange;

        public MemtableUnfilteredPartitionIterator(TableMetadata metadata, Iterator<AtomicBTreePartition> iterator, ColumnFilter columnFilter, DataRange dataRange) {
            this.metadata = metadata;
            this.iter = iterator;
            this.columnFilter = columnFilter;
            this.dataRange = dataRange;
        }

        @Override
        public TableMetadata metadata() {
            return this.metadata;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public UnfilteredRowIterator next() {
            AtomicBTreePartition entry = this.iter.next();
            DecoratedKey key = entry.partitionKey();
            ClusteringIndexFilter filter = this.dataRange.clusteringIndexFilter(key);
            return filter.getUnfilteredRowIterator(this.columnFilter, entry);
        }
    }

    static class MemtableShard {
        private final AtomicLong minTimestamp = new AtomicLong(Long.MAX_VALUE);
        private final AtomicInteger minLocalDeletionTime = new AtomicInteger(Integer.MAX_VALUE);
        private final AtomicLong liveDataSize = new AtomicLong(0L);
        private final AtomicLong currentOperations = new AtomicLong(0L);
        private final ConcurrentNavigableMap<PartitionPosition, AtomicBTreePartition> partitions = new ConcurrentSkipListMap<PartitionPosition, AtomicBTreePartition>();
        private final AbstractMemtable.ColumnsCollector columnsCollector;
        private final AbstractMemtable.StatsCollector statsCollector;
        @Unmetered
        private final MemtableAllocator allocator;
        private final TableMetadataRef metadata;

        @VisibleForTesting
        MemtableShard(TableMetadataRef metadata, MemtableAllocator allocator) {
            this.columnsCollector = new AbstractMemtable.ColumnsCollector(metadata.get().regularAndStaticColumns());
            this.statsCollector = new AbstractMemtable.StatsCollector();
            this.allocator = allocator;
            this.metadata = metadata;
        }

        public long put(DecoratedKey key, PartitionUpdate update, UpdateTransaction indexer, OpOrder.Group opGroup) {
            AtomicBTreePartition empty;
            DecoratedKey cloneKey;
            AtomicBTreePartition previous = (AtomicBTreePartition)this.partitions.get(key);
            long initialSize = 0L;
            if (previous == null && (previous = this.partitions.putIfAbsent(cloneKey = this.allocator.clone(key, opGroup), empty = new AtomicBTreePartition(this.metadata, cloneKey, this.allocator))) == null) {
                previous = empty;
                int overhead = (int)(cloneKey.getToken().getHeapSize() + (long)SkipListMemtable.ROW_OVERHEAD_HEAP_SIZE);
                this.allocator.onHeap().allocate(overhead, opGroup);
                initialSize = 8L;
            }
            long[] pair = previous.addAllWithSizeDelta(update, opGroup, indexer);
            AbstractMemtable.updateMin(this.minTimestamp, update.stats().minTimestamp);
            AbstractMemtable.updateMin(this.minLocalDeletionTime, update.stats().minLocalDeletionTime);
            this.liveDataSize.addAndGet(initialSize + pair[0]);
            this.columnsCollector.update(update.columns());
            this.statsCollector.update(update.stats());
            this.currentOperations.addAndGet(update.operationCount());
            return pair[1];
        }

        private Map<PartitionPosition, AtomicBTreePartition> getPartitionsSubMap(PartitionPosition left, boolean includeLeft, PartitionPosition right, boolean includeRight) {
            if (left != null && left.isMinimum()) {
                left = null;
            }
            if (right != null && right.isMinimum()) {
                right = null;
            }
            try {
                if (left == null) {
                    return right == null ? this.partitions : this.partitions.headMap((Object)right, includeRight);
                }
                return right == null ? this.partitions.tailMap((Object)left, includeLeft) : this.partitions.subMap((Object)left, includeLeft, (Object)right, includeRight);
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid range requested {} - {}", (Object)left, (Object)right);
                throw e;
            }
        }

        public boolean isEmpty() {
            return this.partitions.isEmpty();
        }

        public int size() {
            return this.partitions.size();
        }

        long minTimestamp() {
            return this.minTimestamp.get();
        }

        long liveDataSize() {
            return this.liveDataSize.get();
        }

        long currentOperations() {
            return this.currentOperations.get();
        }

        public int minLocalDeletionTime() {
            return this.minLocalDeletionTime.get();
        }
    }
}

