/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.auth.AuthKeyspace;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.CassandraAuthorizer;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.PasswordAuthenticator;
import org.apache.cassandra.auth.Role;
import org.apache.cassandra.auth.RoleOptions;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.Roles;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.commons.lang3.StringUtils;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraRoleManager
implements IRoleManager {
    private static final Logger logger = LoggerFactory.getLogger(CassandraRoleManager.class);
    public static final String DEFAULT_SUPERUSER_NAME = "cassandra";
    static final String DEFAULT_SUPERUSER_PASSWORD = "cassandra";
    static final ConsistencyLevel DEFAULT_SUPERUSER_CONSISTENCY_LEVEL = ConsistencyLevel.QUORUM;
    private static final Function<UntypedResultSet.Row, Role> ROW_TO_ROLE = row -> {
        try {
            return new Role(row.getString("role"), row.getBoolean("is_superuser"), row.getBoolean("can_login"), Collections.emptyMap(), row.has("member_of") ? row.getSet("member_of", UTF8Type.instance) : Collections.emptySet());
        }
        catch (NullPointerException e) {
            logger.warn("An invalid value has been detected in the {} table for role {}. If you are unable to login, you may need to disable authentication and confirm that values in that table are accurate", (Object)"roles", (Object)row.getString("role"));
            throw new RuntimeException(String.format("Invalid metadata has been detected for role %s", row.getString("role")), e);
        }
    };
    @VisibleForTesting
    public static final String GENSALT_LOG2_ROUNDS_PROPERTY = "cassandra.auth_bcrypt_gensalt_log2_rounds";
    private static final int GENSALT_LOG2_ROUNDS = CassandraRoleManager.getGensaltLogRounds();
    private SelectStatement loadRoleStatement;
    private final Set<IRoleManager.Option> supportedOptions = DatabaseDescriptor.getAuthenticator() instanceof PasswordAuthenticator ? ImmutableSet.of((Object)((Object)IRoleManager.Option.LOGIN), (Object)((Object)IRoleManager.Option.SUPERUSER), (Object)((Object)IRoleManager.Option.PASSWORD), (Object)((Object)IRoleManager.Option.HASHED_PASSWORD)) : ImmutableSet.of((Object)((Object)IRoleManager.Option.LOGIN), (Object)((Object)IRoleManager.Option.SUPERUSER));
    private final Set<IRoleManager.Option> alterableOptions = DatabaseDescriptor.getAuthenticator() instanceof PasswordAuthenticator ? ImmutableSet.of((Object)((Object)IRoleManager.Option.PASSWORD), (Object)((Object)IRoleManager.Option.HASHED_PASSWORD)) : ImmutableSet.of();

    static int getGensaltLogRounds() {
        int rounds = Integer.getInteger(GENSALT_LOG2_ROUNDS_PROPERTY, 10);
        if (rounds < 4 || rounds > 30) {
            throw new ConfigurationException(String.format("Bad value for system property -D%s.Please use a value between 4 and 30 inclusively", GENSALT_LOG2_ROUNDS_PROPERTY));
        }
        return rounds;
    }

    @Override
    public void setup() {
        this.loadRoleStatement();
        this.scheduleSetupTask(() -> {
            CassandraRoleManager.setupDefaultRole();
            return null;
        });
    }

    protected final void loadRoleStatement() {
        this.loadRoleStatement = (SelectStatement)this.prepare("SELECT * from %s.%s WHERE role = ?", "system_auth", "roles");
    }

    @Override
    public Set<IRoleManager.Option> supportedOptions() {
        return this.supportedOptions;
    }

    @Override
    public Set<IRoleManager.Option> alterableOptions() {
        return this.alterableOptions;
    }

    @Override
    public void createRole(AuthenticatedUser performer, RoleResource role, RoleOptions options) throws RequestValidationException, RequestExecutionException {
        String insertCql = options.getPassword().isPresent() || options.getHashedPassword().isPresent() ? String.format("INSERT INTO %s.%s (role, is_superuser, can_login, salted_hash) VALUES ('%s', %s, %s, '%s')", "system_auth", "roles", CassandraRoleManager.escape(role.getRoleName()), options.getSuperuser().orElse(false), options.getLogin().orElse(false), options.getHashedPassword().orElseGet(() -> CassandraRoleManager.escape(CassandraRoleManager.hashpw(options.getPassword().get())))) : String.format("INSERT INTO %s.%s (role, is_superuser, can_login) VALUES ('%s', %s, %s)", "system_auth", "roles", CassandraRoleManager.escape(role.getRoleName()), options.getSuperuser().orElse(false), options.getLogin().orElse(false));
        this.process(insertCql, CassandraRoleManager.consistencyForRoleWrite(role.getRoleName()));
    }

    @Override
    public void dropRole(AuthenticatedUser performer, RoleResource role) throws RequestValidationException, RequestExecutionException {
        this.process(String.format("DELETE FROM %s.%s WHERE role = '%s'", "system_auth", "roles", CassandraRoleManager.escape(role.getRoleName())), CassandraRoleManager.consistencyForRoleWrite(role.getRoleName()));
        this.removeAllMembers(role.getRoleName());
    }

    @Override
    public void alterRole(AuthenticatedUser performer, RoleResource role, RoleOptions options) {
        String assignments = this.optionsToAssignments(options.getOptions());
        if (!Strings.isNullOrEmpty((String)assignments)) {
            this.process(String.format("UPDATE %s.%s SET %s WHERE role = '%s'", "system_auth", "roles", assignments, CassandraRoleManager.escape(role.getRoleName())), CassandraRoleManager.consistencyForRoleWrite(role.getRoleName()));
        }
    }

    @Override
    public void grantRole(AuthenticatedUser performer, RoleResource role, RoleResource grantee) throws RequestValidationException, RequestExecutionException {
        if (this.getRoles(grantee, true).contains(role)) {
            throw new InvalidRequestException(String.format("%s is a member of %s", grantee.getRoleName(), role.getRoleName()));
        }
        if (this.getRoles(role, true).contains(grantee)) {
            throw new InvalidRequestException(String.format("%s is a member of %s", role.getRoleName(), grantee.getRoleName()));
        }
        this.modifyRoleMembership(grantee.getRoleName(), role.getRoleName(), "+");
        this.process(String.format("INSERT INTO %s.%s (role, member) values ('%s', '%s')", "system_auth", "role_members", CassandraRoleManager.escape(role.getRoleName()), CassandraRoleManager.escape(grantee.getRoleName())), CassandraRoleManager.consistencyForRoleWrite(role.getRoleName()));
    }

    @Override
    public void revokeRole(AuthenticatedUser performer, RoleResource role, RoleResource revokee) throws RequestValidationException, RequestExecutionException {
        if (!this.getRoles(revokee, false).contains(role)) {
            throw new InvalidRequestException(String.format("%s is not a member of %s", revokee.getRoleName(), role.getRoleName()));
        }
        this.modifyRoleMembership(revokee.getRoleName(), role.getRoleName(), "-");
        this.process(String.format("DELETE FROM %s.%s WHERE role = '%s' and member = '%s'", "system_auth", "role_members", CassandraRoleManager.escape(role.getRoleName()), CassandraRoleManager.escape(revokee.getRoleName())), CassandraRoleManager.consistencyForRoleWrite(role.getRoleName()));
    }

    @Override
    public Set<RoleResource> getRoles(RoleResource grantee, boolean includeInherited) throws RequestValidationException, RequestExecutionException {
        return this.collectRoles(this.getRole(grantee.getRoleName()), includeInherited, CassandraRoleManager.filter(), this::getRole).map(r -> r.resource).collect(Collectors.toSet());
    }

    @Override
    public Set<Role> getRoleDetails(RoleResource grantee) {
        return this.collectRoles(this.getRole(grantee.getRoleName()), true, CassandraRoleManager.filter(), this::getRole).collect(Collectors.toSet());
    }

    @Override
    public Set<RoleResource> getAllRoles() throws RequestValidationException, RequestExecutionException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        UntypedResultSet rows = this.process(String.format("SELECT role from %s.%s", "system_auth", "roles"), ConsistencyLevel.QUORUM);
        rows.forEach(row -> builder.add((Object)RoleResource.role(row.getString("role"))));
        return builder.build();
    }

    @Override
    public boolean isSuper(RoleResource role) {
        try {
            return this.getRole((String)role.getRoleName()).isSuper;
        }
        catch (RequestExecutionException e) {
            logger.debug("Failed to authorize {} for super-user permission", (Object)role.getRoleName());
            throw new UnauthorizedException("Unable to perform authorization of super-user permission: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean canLogin(RoleResource role) {
        try {
            return this.getRole((String)role.getRoleName()).canLogin;
        }
        catch (RequestExecutionException e) {
            logger.debug("Failed to authorize {} for login permission", (Object)role.getRoleName());
            throw new UnauthorizedException("Unable to perform authorization of login permission: " + e.getMessage(), e);
        }
    }

    @Override
    public Map<String, String> getCustomOptions(RoleResource role) {
        return Collections.emptyMap();
    }

    @Override
    public boolean isExistingRole(RoleResource role) {
        return !Roles.isNullRole(this.getRole(role.getRoleName()));
    }

    @Override
    public Set<? extends IResource> protectedResources() {
        return ImmutableSet.of((Object)DataResource.table("system_auth", "roles"), (Object)DataResource.table("system_auth", "role_members"));
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    private static void setupDefaultRole() {
        if (StorageService.instance.getTokenMetadata().sortedTokens().isEmpty()) {
            throw new IllegalStateException("CassandraRoleManager skipped default role setup: no known tokens in ring");
        }
        try {
            if (!CassandraRoleManager.hasExistingRoles()) {
                QueryProcessor.process(CassandraRoleManager.createDefaultRoleQuery(), CassandraRoleManager.consistencyForRoleWrite("cassandra"));
                logger.info("Created default superuser role '{}'", (Object)"cassandra");
            }
        }
        catch (RequestExecutionException e) {
            logger.warn("CassandraRoleManager skipped default role setup: some nodes were not ready");
            throw e;
        }
    }

    @VisibleForTesting
    public static String createDefaultRoleQuery() {
        return String.format("INSERT INTO %s.%s (role, is_superuser, can_login, salted_hash) VALUES ('%s', true, true, '%s')", "system_auth", "roles", "cassandra", CassandraRoleManager.escape(CassandraRoleManager.hashpw("cassandra")));
    }

    @VisibleForTesting
    public static boolean hasExistingRoles() throws RequestExecutionException {
        String defaultSUQuery = String.format("SELECT * FROM %s.%s WHERE role = '%s'", "system_auth", "roles", "cassandra");
        String allUsersQuery = String.format("SELECT * FROM %s.%s LIMIT 1", "system_auth", "roles");
        return !QueryProcessor.process(defaultSUQuery, ConsistencyLevel.ONE).isEmpty() || !QueryProcessor.process(defaultSUQuery, ConsistencyLevel.QUORUM).isEmpty() || !QueryProcessor.process(allUsersQuery, ConsistencyLevel.QUORUM).isEmpty();
    }

    protected void scheduleSetupTask(Callable<Void> setupTask) {
        ScheduledExecutors.optionalTasks.scheduleSelfRecurring(() -> {
            try {
                setupTask.call();
            }
            catch (Exception e) {
                logger.info("Setup task failed with error, rescheduling");
                this.scheduleSetupTask(setupTask);
            }
        }, AuthKeyspace.SUPERUSER_SETUP_DELAY, TimeUnit.MILLISECONDS);
    }

    private CQLStatement prepare(String template, String keyspace, String table) {
        try {
            return QueryProcessor.parseStatement(String.format(template, keyspace, table)).prepare(ClientState.forInternalCalls());
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Stream<Role> collectRoles(Role role, boolean includeInherited, Predicate<String> distinctFilter, Function<String, Role> loaderFunction) {
        if (Roles.isNullRole(role)) {
            return Stream.empty();
        }
        if (!includeInherited) {
            return Stream.concat(Stream.of(role), role.memberOf.stream().map(loaderFunction));
        }
        return Stream.concat(Stream.of(role), role.memberOf.stream().filter(distinctFilter).flatMap(r -> this.collectRoles((Role)loaderFunction.apply((String)r), true, distinctFilter, loaderFunction)));
    }

    private static Predicate<String> filter() {
        HashSet seen = new HashSet();
        return seen::add;
    }

    private Role getRole(String name) {
        QueryOptions options = QueryOptions.forInternalCalls(CassandraRoleManager.consistencyForRoleRead(name), Collections.singletonList(ByteBufferUtil.bytes(name)));
        ResultMessage.Rows rows = this.select(this.loadRoleStatement, options);
        if (rows.result.isEmpty()) {
            return Roles.nullRole();
        }
        return ROW_TO_ROLE.apply(UntypedResultSet.create(rows.result).one());
    }

    private void modifyRoleMembership(String grantee, String role, String op) throws RequestExecutionException {
        this.process(String.format("UPDATE %s.%s SET member_of = member_of %s {'%s'} WHERE role = '%s'", "system_auth", "roles", op, CassandraRoleManager.escape(role), CassandraRoleManager.escape(grantee)), CassandraRoleManager.consistencyForRoleWrite(grantee));
    }

    private void removeAllMembers(String role) throws RequestValidationException, RequestExecutionException {
        UntypedResultSet rows = this.process(String.format("SELECT member FROM %s.%s WHERE role = '%s'", "system_auth", "role_members", CassandraRoleManager.escape(role)), CassandraRoleManager.consistencyForRoleRead(role));
        if (rows.isEmpty()) {
            return;
        }
        for (UntypedResultSet.Row row : rows) {
            this.modifyRoleMembership(row.getString("member"), role, "-");
        }
        this.process(String.format("DELETE FROM %s.%s WHERE role = '%s'", "system_auth", "role_members", CassandraRoleManager.escape(role)), CassandraRoleManager.consistencyForRoleWrite(role));
    }

    private String optionsToAssignments(Map<IRoleManager.Option, Object> options) {
        return options.entrySet().stream().map(entry -> {
            switch ((IRoleManager.Option)((Object)((Object)entry.getKey()))) {
                case LOGIN: {
                    return String.format("can_login = %s", entry.getValue());
                }
                case SUPERUSER: {
                    return String.format("is_superuser = %s", entry.getValue());
                }
                case PASSWORD: {
                    return String.format("salted_hash = '%s'", CassandraRoleManager.escape(CassandraRoleManager.hashpw((String)entry.getValue())));
                }
                case HASHED_PASSWORD: {
                    return String.format("salted_hash = '%s'", (String)entry.getValue());
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(","));
    }

    private static String hashpw(String password) {
        return BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)GENSALT_LOG2_ROUNDS));
    }

    private static String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    protected static ConsistencyLevel consistencyForRoleWrite(String role) {
        return role.equals("cassandra") ? DEFAULT_SUPERUSER_CONSISTENCY_LEVEL : CassandraAuthorizer.authWriteConsistencyLevel();
    }

    protected static ConsistencyLevel consistencyForRoleRead(String role) {
        return role.equals("cassandra") ? DEFAULT_SUPERUSER_CONSISTENCY_LEVEL : CassandraAuthorizer.authReadConsistencyLevel();
    }

    @VisibleForTesting
    UntypedResultSet process(String query, ConsistencyLevel consistencyLevel) throws RequestValidationException, RequestExecutionException {
        return QueryProcessor.process(query, consistencyLevel);
    }

    @VisibleForTesting
    ResultMessage.Rows select(SelectStatement statement, QueryOptions options) {
        return statement.execute(QueryState.forInternalCalls(), options, Clock.Global.nanoTime());
    }

    @Override
    public Supplier<Map<RoleResource, Set<Role>>> bulkLoader() {
        return () -> {
            HashMap entries = new HashMap();
            logger.info("Warming roles cache from roles table");
            UntypedResultSet results = this.process("SELECT * FROM system_auth.roles", CassandraAuthorizer.authReadConsistencyLevel());
            HashMap<String, Role> roles = new HashMap<String, Role>();
            results.forEach(row -> roles.put(row.getString("role"), ROW_TO_ROLE.apply((UntypedResultSet.Row)row)));
            roles.forEach((key, value) -> entries.put(RoleResource.role(key), this.collectRoles((Role)value, true, CassandraRoleManager.filter(), roles::get).collect(Collectors.toSet())));
            return entries;
        };
    }
}

