/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radix.node.concrete.chararray;

import com.googlecode.concurrenttrees.common.CharSequences;
import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.util.AtomicReferenceArrayListAdapter;
import com.googlecode.concurrenttrees.radix.node.util.NodeCharacterComparator;
import com.googlecode.concurrenttrees.radix.node.util.NodeUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class CharArrayNodeDefault
implements Node {
    private final char[] incomingEdgeCharArray;
    private final AtomicReferenceArray<Node> outgoingEdges;
    private final Object value;

    public CharArrayNodeDefault(CharSequence edgeCharSequence, Object value, List<Node> outgoingEdges) {
        Node[] childNodeArray = outgoingEdges.toArray(new Node[outgoingEdges.size()]);
        Arrays.sort(childNodeArray, new NodeCharacterComparator());
        this.outgoingEdges = new AtomicReferenceArray<Node>(childNodeArray);
        this.incomingEdgeCharArray = CharSequences.toCharArray(edgeCharSequence);
        this.value = value;
    }

    @Override
    public CharSequence getIncomingEdge() {
        return CharSequences.fromCharArray(this.incomingEdgeCharArray);
    }

    @Override
    public Character getIncomingEdgeFirstCharacter() {
        return Character.valueOf(this.incomingEdgeCharArray[0]);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Node getOutgoingEdge(Character edgeFirstCharacter) {
        int index = NodeUtil.binarySearchForEdge(this.outgoingEdges, edgeFirstCharacter);
        if (index < 0) {
            return null;
        }
        return this.outgoingEdges.get(index);
    }

    @Override
    public void updateOutgoingEdge(Node childNode) {
        int index = NodeUtil.binarySearchForEdge(this.outgoingEdges, childNode.getIncomingEdgeFirstCharacter());
        if (index < 0) {
            throw new IllegalStateException("Cannot update the reference to the following child node for the edge starting with '" + childNode.getIncomingEdgeFirstCharacter() + "', no such edge already exists: " + childNode);
        }
        this.outgoingEdges.set(index, childNode);
    }

    @Override
    public List<Node> getOutgoingEdges() {
        return new AtomicReferenceArrayListAdapter<Node>(this.outgoingEdges);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node{");
        sb.append("edge=").append(this.incomingEdgeCharArray);
        sb.append(", value=").append(this.value);
        sb.append(", edges=").append(this.getOutgoingEdges());
        sb.append("}");
        return sb.toString();
    }
}

