/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.PropertyFileSnitch;
import org.apache.cassandra.locator.ReconnectableSnitchHelper;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipingPropertyFileSnitch
extends AbstractNetworkTopologySnitch {
    private static final Logger logger = LoggerFactory.getLogger(GossipingPropertyFileSnitch.class);
    private PropertyFileSnitch psnitch;
    private final String myDC;
    private final String myRack;
    private final boolean preferLocal;
    private final AtomicReference<ReconnectableSnitchHelper> snitchHelperReference;
    private Map<InetAddressAndPort, Map<String, String>> savedEndpoints;
    private static final String DEFAULT_DC = "UNKNOWN_DC";
    private static final String DEFAULT_RACK = "UNKNOWN_RACK";

    public GossipingPropertyFileSnitch() throws ConfigurationException {
        SnitchProperties properties = GossipingPropertyFileSnitch.loadConfiguration();
        this.myDC = properties.get("dc", DEFAULT_DC).trim();
        this.myRack = properties.get("rack", DEFAULT_RACK).trim();
        this.preferLocal = Boolean.parseBoolean(properties.get("prefer_local", "false"));
        this.snitchHelperReference = new AtomicReference();
        try {
            this.psnitch = new PropertyFileSnitch();
            logger.info("Loaded {} for compatibility", (Object)"cassandra-topology.properties");
        }
        catch (ConfigurationException e) {
            logger.info("Unable to load {}; compatibility mode disabled", (Object)"cassandra-topology.properties");
        }
    }

    private static SnitchProperties loadConfiguration() throws ConfigurationException {
        SnitchProperties properties = new SnitchProperties();
        if (!properties.contains("dc") || !properties.contains("rack")) {
            throw new ConfigurationException("DC or rack not found in snitch properties, check your configuration in: cassandra-rackdc.properties");
        }
        return properties;
    }

    @Override
    public String getDatacenter(InetAddressAndPort endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return this.myDC;
        }
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || epState.getApplicationState(ApplicationState.DC) == null) {
            if (this.psnitch == null) {
                if (this.savedEndpoints == null) {
                    this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
                }
                if (this.savedEndpoints.containsKey(endpoint)) {
                    return this.savedEndpoints.get(endpoint).get("data_center");
                }
                return DEFAULT_DC;
            }
            return this.psnitch.getDatacenter(endpoint);
        }
        return epState.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }

    @Override
    public String getRack(InetAddressAndPort endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return this.myRack;
        }
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || epState.getApplicationState(ApplicationState.RACK) == null) {
            if (this.psnitch == null) {
                if (this.savedEndpoints == null) {
                    this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
                }
                if (this.savedEndpoints.containsKey(endpoint)) {
                    return this.savedEndpoints.get(endpoint).get("rack");
                }
                return DEFAULT_RACK;
            }
            return this.psnitch.getRack(endpoint);
        }
        return epState.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public void gossiperStarting() {
        super.gossiperStarting();
        Gossiper.instance.addLocalApplicationState(ApplicationState.INTERNAL_ADDRESS_AND_PORT, StorageService.instance.valueFactory.internalAddressAndPort(FBUtilities.getLocalAddressAndPort()));
        Gossiper.instance.addLocalApplicationState(ApplicationState.INTERNAL_IP, StorageService.instance.valueFactory.internalIP(FBUtilities.getJustLocalAddress()));
        this.loadGossiperState();
    }

    private void loadGossiperState() {
        assert (Gossiper.instance != null);
        ReconnectableSnitchHelper pendingHelper = new ReconnectableSnitchHelper(this, this.myDC, this.preferLocal);
        Gossiper.instance.register(pendingHelper);
        pendingHelper = this.snitchHelperReference.getAndSet(pendingHelper);
        if (pendingHelper != null) {
            Gossiper.instance.unregister(pendingHelper);
        }
    }
}

