/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadataRef;

public class SimpleSSTableMultiWriter
implements SSTableMultiWriter {
    private final SSTableWriter writer;
    private final LifecycleNewTracker lifecycleNewTracker;

    protected SimpleSSTableMultiWriter(SSTableWriter writer, LifecycleNewTracker lifecycleNewTracker) {
        this.lifecycleNewTracker = lifecycleNewTracker;
        this.writer = writer;
    }

    @Override
    public boolean append(UnfilteredRowIterator partition) {
        RowIndexEntry indexEntry = this.writer.append(partition);
        return indexEntry != null;
    }

    @Override
    public Collection<SSTableReader> finish(long repairedAt, long maxDataAge, boolean openResult) {
        return Collections.singleton(this.writer.finish(repairedAt, maxDataAge, openResult));
    }

    @Override
    public Collection<SSTableReader> finish(boolean openResult) {
        return Collections.singleton(this.writer.finish(openResult));
    }

    @Override
    public Collection<SSTableReader> finished() {
        return Collections.singleton(this.writer.finished());
    }

    @Override
    public SSTableMultiWriter setOpenResult(boolean openResult) {
        this.writer.setOpenResult(openResult);
        return this;
    }

    @Override
    public String getFilename() {
        return this.writer.getFilename();
    }

    @Override
    public long getFilePointer() {
        return this.writer.getFilePointer();
    }

    @Override
    public TableId getTableId() {
        return this.writer.metadata().id;
    }

    @Override
    public Throwable commit(Throwable accumulate) {
        return this.writer.commit(accumulate);
    }

    @Override
    public Throwable abort(Throwable accumulate) {
        this.lifecycleNewTracker.untrackNew(this.writer);
        return this.writer.abort(accumulate);
    }

    @Override
    public void prepareToCommit() {
        this.writer.prepareToCommit();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public static SSTableMultiWriter create(Descriptor descriptor, long keyCount, long repairedAt, UUID pendingRepair, boolean isTransient, TableMetadataRef metadata, MetadataCollector metadataCollector, SerializationHeader header, Collection<Index> indexes, LifecycleNewTracker lifecycleNewTracker) {
        SSTableWriter writer = SSTableWriter.create(descriptor, keyCount, (Long)repairedAt, pendingRepair, isTransient, metadata, metadataCollector, header, indexes, lifecycleNewTracker);
        return new SimpleSSTableMultiWriter(writer, lifecycleNewTracker);
    }
}

