/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.UUIDSerializer;

public class PrepareMessage
extends RepairMessage {
    public final List<TableId> tableIds;
    public final Collection<Range<Token>> ranges;
    public final UUID parentRepairSession;
    public final boolean isIncremental;
    public final long timestamp;
    public final boolean isGlobal;
    public final PreviewKind previewKind;
    private static final String MIXED_MODE_ERROR = "Some nodes involved in repair are on an incompatible major version. Repair is not supported in mixed major version clusters.";
    public static final IVersionedSerializer<PrepareMessage> serializer = new IVersionedSerializer<PrepareMessage>(){

        @Override
        public void serialize(PrepareMessage message, DataOutputPlus out, int version) throws IOException {
            Preconditions.checkArgument((version == 12 ? 1 : 0) != 0, (Object)PrepareMessage.MIXED_MODE_ERROR);
            out.writeInt(message.tableIds.size());
            for (TableId tableId : message.tableIds) {
                tableId.serialize(out);
            }
            UUIDSerializer.serializer.serialize(message.parentRepairSession, out, version);
            out.writeInt(message.ranges.size());
            for (Range range : message.ranges) {
                IPartitioner.validate(range);
                Range.tokenSerializer.serialize(range, out, version);
            }
            out.writeBoolean(message.isIncremental);
            out.writeLong(message.timestamp);
            out.writeBoolean(message.isGlobal);
            out.writeInt(message.previewKind.getSerializationVal());
        }

        @Override
        public PrepareMessage deserialize(DataInputPlus in, int version) throws IOException {
            Preconditions.checkArgument((version == 12 ? 1 : 0) != 0, (Object)PrepareMessage.MIXED_MODE_ERROR);
            int tableIdCount = in.readInt();
            ArrayList<TableId> tableIds = new ArrayList<TableId>(tableIdCount);
            for (int i = 0; i < tableIdCount; ++i) {
                tableIds.add(TableId.deserialize(in));
            }
            UUID parentRepairSession = UUIDSerializer.serializer.deserialize(in, version);
            int rangeCount = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(rangeCount);
            for (int i = 0; i < rangeCount; ++i) {
                ranges.add((Range)Range.tokenSerializer.deserialize(in, IPartitioner.global(), version));
            }
            boolean isIncremental = in.readBoolean();
            long timestamp = in.readLong();
            boolean isGlobal = in.readBoolean();
            PreviewKind previewKind = PreviewKind.deserialize(in.readInt());
            return new PrepareMessage(parentRepairSession, tableIds, ranges, isIncremental, timestamp, isGlobal, previewKind);
        }

        @Override
        public long serializedSize(PrepareMessage message, int version) {
            long size = TypeSizes.sizeof(message.tableIds.size());
            for (TableId tableId : message.tableIds) {
                size += (long)tableId.serializedSize();
            }
            size += UUIDSerializer.serializer.serializedSize(message.parentRepairSession, version);
            size += (long)TypeSizes.sizeof(message.ranges.size());
            for (Range range : message.ranges) {
                size += Range.tokenSerializer.serializedSize(range, version);
            }
            size += (long)TypeSizes.sizeof(message.isIncremental);
            size += (long)TypeSizes.sizeof(message.timestamp);
            size += (long)TypeSizes.sizeof(message.isGlobal);
            return size += (long)TypeSizes.sizeof(message.previewKind.getSerializationVal());
        }
    };

    public PrepareMessage(UUID parentRepairSession, List<TableId> tableIds, Collection<Range<Token>> ranges, boolean isIncremental, long timestamp, boolean isGlobal, PreviewKind previewKind) {
        super(null);
        this.parentRepairSession = parentRepairSession;
        this.tableIds = tableIds;
        this.ranges = ranges;
        this.isIncremental = isIncremental;
        this.timestamp = timestamp;
        this.isGlobal = isGlobal;
        this.previewKind = previewKind;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PrepareMessage)) {
            return false;
        }
        PrepareMessage other = (PrepareMessage)o;
        return this.parentRepairSession.equals(other.parentRepairSession) && this.isIncremental == other.isIncremental && this.isGlobal == other.isGlobal && this.previewKind == other.previewKind && this.timestamp == other.timestamp && this.tableIds.equals(other.tableIds) && this.ranges.equals(other.ranges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parentRepairSession, this.isGlobal, this.previewKind, this.isIncremental, this.timestamp, this.tableIds, this.ranges});
    }

    public String toString() {
        return "PrepareMessage{tableIds='" + this.tableIds + '\'' + ", ranges=" + this.ranges + ", parentRepairSession=" + this.parentRepairSession + ", isIncremental=" + this.isIncremental + ", timestamp=" + this.timestamp + ", isGlobal=" + this.isGlobal + '}';
    }
}

