/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.schema.TableMetadata;

public class TombstoneOverwhelmingException
extends RuntimeException {
    public TombstoneOverwhelmingException(int numTombstones, String query, TableMetadata metadata, DecoratedKey lastPartitionKey, ClusteringPrefix<?> lastClustering) {
        super(String.format("Scanned over %d tombstones during query '%s' (last scanned row token was %s and partion key was (%s)); query aborted", numTombstones, query, lastPartitionKey.getToken(), TombstoneOverwhelmingException.makePKString(metadata, lastPartitionKey.getKey(), lastClustering)));
    }

    private static String makePKString(TableMetadata metadata, ByteBuffer partitionKey, ClusteringPrefix<?> clustering) {
        AbstractType<?> pkType;
        StringBuilder sb = new StringBuilder();
        if (clustering.size() > 0) {
            sb.append("(");
        }
        if ((pkType = metadata.partitionKeyType) instanceof CompositeType) {
            CompositeType ct = (CompositeType)pkType;
            ByteBuffer[] values = ct.split(partitionKey);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(ct.types.get(i).getString(values[i]));
            }
        } else {
            sb.append(pkType.getString(partitionKey));
        }
        if (clustering.size() > 0) {
            sb.append(")");
        }
        for (int i = 0; i < clustering.size(); ++i) {
            sb.append(", ").append(clustering.stringAt(i, metadata.comparator));
        }
        return sb.toString();
    }
}

