/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongPredicate;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.AbstractReadQuery;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.RepairedDataInfo;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.db.partitions.PurgeFunction;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.RTBoundCloser;
import org.apache.cassandra.db.transform.RTBoundValidator;
import org.apache.cassandra.db.transform.StoppingTransformation;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.exceptions.UnknownIndexException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexNotAvailableException;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageFlag;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.SchemaProvider;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadCommand
extends AbstractReadQuery {
    private static final int TEST_ITERATION_DELAY_MILLIS = Integer.parseInt(System.getProperty("cassandra.test.read_iteration_delay_ms", "0"));
    protected static final Logger logger = LoggerFactory.getLogger(ReadCommand.class);
    public static final IVersionedSerializer<ReadCommand> serializer = new Serializer();
    private final Kind kind;
    private final boolean isDigestQuery;
    private final boolean acceptsTransient;
    private int digestVersion;
    @Nullable
    private final IndexMetadata index;

    protected ReadCommand(Kind kind, boolean isDigestQuery, int digestVersion, boolean acceptsTransient, TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, IndexMetadata index) {
        super(metadata, nowInSec, columnFilter, rowFilter, limits);
        if (acceptsTransient && isDigestQuery) {
            throw new IllegalArgumentException("Attempted to issue a digest response to transient replica");
        }
        this.kind = kind;
        this.isDigestQuery = isDigestQuery;
        this.digestVersion = digestVersion;
        this.acceptsTransient = acceptsTransient;
        this.index = index;
    }

    protected abstract void serializeSelection(DataOutputPlus var1, int var2) throws IOException;

    protected abstract long selectionSerializedSize(int var1);

    public abstract boolean isLimitedToOnePartition();

    public boolean isSinglePartitionRead() {
        return this.kind == Kind.SINGLE_PARTITION;
    }

    public abstract boolean isRangeRequest();

    public abstract ReadCommand withUpdatedLimit(DataLimits var1);

    public abstract long getTimeout(TimeUnit var1);

    public boolean isDigestQuery() {
        return this.isDigestQuery;
    }

    public int digestVersion() {
        return this.digestVersion;
    }

    public ReadCommand setDigestVersion(int digestVersion) {
        this.digestVersion = digestVersion;
        return this;
    }

    public boolean acceptsTransient() {
        return this.acceptsTransient;
    }

    @Nullable
    public IndexMetadata indexMetadata() {
        return this.index;
    }

    public abstract ClusteringIndexFilter clusteringIndexFilter(DecoratedKey var1);

    public abstract ReadCommand copy();

    public ReadCommand copyAsTransientQuery(Replica replica) {
        Preconditions.checkArgument((boolean)replica.isTransient(), (Object)("Can't make a transient request on a full replica: " + replica));
        return this.copyAsTransientQuery();
    }

    public ReadCommand copyAsTransientQuery(Iterable<Replica> replicas) {
        if (Iterables.any(replicas, Replica::isFull)) {
            throw new IllegalArgumentException("Can't make a transient request on full replicas: " + Iterables.toString((Iterable)Iterables.filter(replicas, Replica::isFull)));
        }
        return this.copyAsTransientQuery();
    }

    protected abstract ReadCommand copyAsTransientQuery();

    public ReadCommand copyAsDigestQuery(Replica replica) {
        Preconditions.checkArgument((boolean)replica.isFull(), (Object)("Can't make a digest request on a transient replica " + replica));
        return this.copyAsDigestQuery();
    }

    public ReadCommand copyAsDigestQuery(Iterable<Replica> replicas) {
        if (Iterables.any(replicas, Replica::isTransient)) {
            throw new IllegalArgumentException("Can't make a digest request on a transient replica " + Iterables.toString((Iterable)Iterables.filter(replicas, Replica::isTransient)));
        }
        return this.copyAsDigestQuery();
    }

    protected abstract ReadCommand copyAsDigestQuery();

    protected abstract UnfilteredPartitionIterator queryStorage(ColumnFamilyStore var1, ReadExecutionController var2);

    public abstract boolean isReversed();

    public ReadResponse createResponse(UnfilteredPartitionIterator iterator, RepairedDataInfo rdi) {
        iterator = RTBoundValidator.validate(iterator, RTBoundValidator.Stage.PROCESSED, true);
        return this.isDigestQuery() ? ReadResponse.createDigestResponse(iterator, this) : ReadResponse.createDataResponse(iterator, this, rdi);
    }

    long indexSerializedSize(int version) {
        return null != this.index ? IndexMetadata.serializer.serializedSize(this.index, version) : 0L;
    }

    public Index getIndex(ColumnFamilyStore cfs) {
        return null != this.index ? cfs.indexManager.getIndex(this.index) : null;
    }

    static IndexMetadata findIndex(TableMetadata table, RowFilter rowFilter) {
        if (table.indexes.isEmpty() || rowFilter.isEmpty()) {
            return null;
        }
        ColumnFamilyStore cfs = Keyspace.openAndGetStore(table);
        Index index = cfs.indexManager.getBestIndexFor(rowFilter);
        return null != index ? index.getIndexMetadata() : null;
    }

    @Override
    public void maybeValidateIndex() {
        if (null != this.index) {
            IndexRegistry.obtain(this.metadata()).getIndex(this.index).validate(this);
        }
    }

    @Override
    public UnfilteredPartitionIterator executeLocally(ReadExecutionController executionController) {
        long startTimeNanos = System.nanoTime();
        ColumnFamilyStore cfs = Keyspace.openAndGetStore(this.metadata());
        Index index = this.getIndex(cfs);
        Index.Searcher searcher = null;
        if (index != null) {
            if (!cfs.indexManager.isIndexQueryable(index)) {
                throw new IndexNotAvailableException(index);
            }
            searcher = index.searcherFor(this);
            Tracing.trace("Executing read on {}.{} using index {}", cfs.metadata.keyspace, cfs.metadata.name, index.getIndexMetadata().name);
        }
        UnfilteredPartitionIterator iterator = null == searcher ? this.queryStorage(cfs, executionController) : searcher.search(executionController);
        iterator = RTBoundValidator.validate(iterator, RTBoundValidator.Stage.MERGED, false);
        try {
            iterator = this.withStateTracking(iterator);
            iterator = RTBoundValidator.validate(this.withoutPurgeableTombstones(iterator, cfs, executionController), RTBoundValidator.Stage.PURGED, false);
            iterator = this.withMetricsRecording(iterator, cfs.metric, startTimeNanos);
            RowFilter filter = null == searcher ? this.rowFilter() : index.getPostIndexQueryFilter(this.rowFilter());
            iterator = filter.filter(iterator, this.nowInSec());
            if (executionController.isTrackingRepairedStatus()) {
                DataLimits.Counter limit = this.limits().newCounter(this.nowInSec(), false, this.selectsFullPartition(), this.metadata().enforceStrictLiveness());
                iterator = limit.applyTo(iterator);
                iterator = executionController.getRepairedDataInfo().extend(iterator, limit);
            } else {
                iterator = this.limits().filter(iterator, this.nowInSec(), this.selectsFullPartition());
            }
            return RTBoundCloser.close(iterator);
        }
        catch (Error | RuntimeException e) {
            iterator.close();
            throw e;
        }
    }

    protected abstract void recordLatency(TableMetrics var1, long var2);

    public ReadExecutionController executionController(boolean trackRepairedStatus) {
        return ReadExecutionController.forCommand(this, trackRepairedStatus);
    }

    @Override
    public ReadExecutionController executionController() {
        return ReadExecutionController.forCommand(this, false);
    }

    private UnfilteredPartitionIterator withMetricsRecording(UnfilteredPartitionIterator iter, final TableMetrics metric, final long startTimeNanos) {
        class MetricRecording
        extends Transformation<UnfilteredRowIterator> {
            private final int failureThreshold = DatabaseDescriptor.getTombstoneFailureThreshold();
            private final int warningThreshold = DatabaseDescriptor.getTombstoneWarnThreshold();
            private final boolean respectTombstoneThresholds;
            private final boolean enforceStrictLiveness;
            private int liveRows;
            private int tombstones;
            private DecoratedKey currentKey;

            MetricRecording() {
                this.respectTombstoneThresholds = !SchemaConstants.isLocalSystemKeyspace(ReadCommand.this.metadata().keyspace);
                this.enforceStrictLiveness = ReadCommand.this.metadata().enforceStrictLiveness();
                this.liveRows = 0;
                this.tombstones = 0;
            }

            @Override
            public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator iter) {
                this.currentKey = iter.partitionKey();
                return Transformation.apply(iter, this);
            }

            @Override
            public Row applyToStatic(Row row) {
                return this.applyToRow(row);
            }

            @Override
            public Row applyToRow(Row row) {
                boolean hasTombstones = false;
                for (Cell<?> cell : row.cells()) {
                    if (cell.isLive(ReadCommand.this.nowInSec())) continue;
                    this.countTombstone(row.clustering());
                    hasTombstones = true;
                }
                if (row.hasLiveData(ReadCommand.this.nowInSec(), this.enforceStrictLiveness)) {
                    ++this.liveRows;
                } else if (!row.primaryKeyLivenessInfo().isLive(ReadCommand.this.nowInSec()) && row.hasDeletion(ReadCommand.this.nowInSec()) && !hasTombstones) {
                    this.countTombstone(row.clustering());
                }
                return row;
            }

            @Override
            public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
                this.countTombstone(marker.clustering());
                return marker;
            }

            private void countTombstone(ClusteringPrefix<?> clustering) {
                ++this.tombstones;
                if (this.tombstones > this.failureThreshold && this.respectTombstoneThresholds) {
                    String query = ReadCommand.this.toCQLString();
                    Tracing.trace("Scanned over {} tombstones for query {}; query aborted (see tombstone_failure_threshold)", (Object)this.failureThreshold, (Object)query);
                    metric.tombstoneFailures.inc();
                    throw new TombstoneOverwhelmingException(this.tombstones, query, ReadCommand.this.metadata(), this.currentKey, clustering);
                }
            }

            @Override
            public void onClose() {
                boolean warnTombstones;
                ReadCommand.this.recordLatency(metric, System.nanoTime() - startTimeNanos);
                metric.tombstoneScannedHistogram.update(this.tombstones);
                metric.liveScannedHistogram.update(this.liveRows);
                boolean bl = warnTombstones = this.tombstones > this.warningThreshold && this.respectTombstoneThresholds;
                if (warnTombstones) {
                    String msg = String.format("Read %d live rows and %d tombstone cells for query %1.512s; token %s (see tombstone_warn_threshold)", this.liveRows, this.tombstones, ReadCommand.this.toCQLString(), this.currentKey.getToken());
                    ClientWarn.instance.warn(msg);
                    if (this.tombstones < this.failureThreshold) {
                        metric.tombstoneWarnings.inc();
                    }
                    logger.warn(msg);
                }
                Tracing.trace("Read {} live rows and {} tombstone cells{}", this.liveRows, this.tombstones, warnTombstones ? " (see tombstone_warn_threshold)" : "");
            }
        }
        return Transformation.apply(iter, new MetricRecording());
    }

    protected UnfilteredPartitionIterator withStateTracking(UnfilteredPartitionIterator iter) {
        return Transformation.apply(iter, new CheckForAbort());
    }

    public Message<ReadCommand> createMessage(boolean trackRepairedData) {
        return trackRepairedData ? Message.outWithFlags(this.verb(), this, MessageFlag.CALL_BACK_ON_FAILURE, MessageFlag.TRACK_REPAIRED_DATA) : Message.outWithFlag(this.verb(), this, MessageFlag.CALL_BACK_ON_FAILURE);
    }

    public abstract Verb verb();

    @Override
    protected abstract void appendCQLWhereClause(StringBuilder var1);

    protected UnfilteredPartitionIterator withoutPurgeableTombstones(final UnfilteredPartitionIterator iterator, final ColumnFamilyStore cfs, final ReadExecutionController controller) {
        class WithoutPurgeableTombstones
        extends PurgeFunction {
            public WithoutPurgeableTombstones() {
                super(ReadCommand.this.nowInSec(), columnFamilyStore.gcBefore(ReadCommand.this.nowInSec()), readExecutionController.oldestUnrepairedTombstone(), columnFamilyStore.getCompactionStrategyManager().onlyPurgeRepairedTombstones(), unfilteredPartitionIterator.metadata().enforceStrictLiveness());
            }

            @Override
            protected LongPredicate getPurgeEvaluator() {
                return time -> true;
            }
        }
        return Transformation.apply(iterator, new WithoutPurgeableTombstones());
    }

    @Override
    public String toCQLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(this.columnFilter().toCQLString());
        sb.append(" FROM ").append(this.metadata().keyspace).append('.').append(this.metadata().name);
        this.appendCQLWhereClause(sb);
        if (this.limits() != DataLimits.NONE) {
            sb.append(' ').append(this.limits());
        }
        return sb.toString();
    }

    @Override
    public String name() {
        return this.toCQLString();
    }

    InputCollector<UnfilteredRowIterator> iteratorsForPartition(ColumnFamilyStore.ViewFragment view, ReadExecutionController controller) {
        BiFunction<List, RepairedDataInfo, UnfilteredRowIterator> merge = (unfilteredRowIterators, repairedDataInfo) -> {
            UnfilteredRowIterator repaired = UnfilteredRowIterators.merge(unfilteredRowIterators);
            return repairedDataInfo.withRepairedDataInfo(repaired);
        };
        Function<UnfilteredRowIterator, UnfilteredPartitionIterator> postLimitPartitions = rows -> EmptyIterators.unfilteredPartition(this.metadata());
        return new InputCollector<UnfilteredRowIterator>(view, controller, merge, postLimitPartitions);
    }

    InputCollector<UnfilteredPartitionIterator> iteratorsForRange(ColumnFamilyStore.ViewFragment view, ReadExecutionController controller) {
        BiFunction<List, RepairedDataInfo, UnfilteredPartitionIterator> merge = (unfilteredPartitionIterators, repairedDataInfo) -> {
            UnfilteredPartitionIterator repaired = UnfilteredPartitionIterators.merge(unfilteredPartitionIterators, UnfilteredPartitionIterators.MergeListener.NOOP);
            return repairedDataInfo.withRepairedDataInfo(repaired);
        };
        return new InputCollector<UnfilteredPartitionIterator>(view, controller, merge, Function.identity());
    }

    @VisibleForTesting
    public static class Serializer
    implements IVersionedSerializer<ReadCommand> {
        private final SchemaProvider schema;

        public Serializer() {
            this(Schema.instance);
        }

        @VisibleForTesting
        public Serializer(SchemaProvider schema) {
            this.schema = Objects.requireNonNull(schema, "schema");
        }

        private static int digestFlag(boolean isDigest) {
            return isDigest ? 1 : 0;
        }

        private static boolean isDigest(int flags) {
            return (flags & 1) != 0;
        }

        private static boolean acceptsTransient(int flags) {
            return (flags & 8) != 0;
        }

        private static int acceptsTransientFlag(boolean acceptsTransient) {
            return acceptsTransient ? 8 : 0;
        }

        private static boolean isForThrift(int flags) {
            return (flags & 2) != 0;
        }

        private static int indexFlag(boolean hasIndex) {
            return hasIndex ? 4 : 0;
        }

        private static boolean hasIndex(int flags) {
            return (flags & 4) != 0;
        }

        @Override
        public void serialize(ReadCommand command, DataOutputPlus out, int version) throws IOException {
            out.writeByte(command.kind.ordinal());
            out.writeByte(Serializer.digestFlag(command.isDigestQuery()) | Serializer.indexFlag(null != command.indexMetadata()) | Serializer.acceptsTransientFlag(command.acceptsTransient()));
            if (command.isDigestQuery()) {
                out.writeUnsignedVInt(command.digestVersion());
            }
            command.metadata().id.serialize(out);
            out.writeInt(command.nowInSec());
            ColumnFilter.serializer.serialize(command.columnFilter(), out, version);
            RowFilter.serializer.serialize(command.rowFilter(), out, version);
            DataLimits.serializer.serialize(command.limits(), out, version, command.metadata().comparator);
            if (null != command.index) {
                IndexMetadata.serializer.serialize(command.index, out, version);
            }
            command.serializeSelection(out, version);
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version) throws IOException {
            Kind kind = Kind.values()[in.readByte()];
            byte flags = in.readByte();
            boolean isDigest = Serializer.isDigest(flags);
            boolean acceptsTransient = Serializer.acceptsTransient(flags);
            if (Serializer.isForThrift(flags)) {
                throw new IllegalStateException("Received a command with the thrift flag set. This means thrift is in use in a mixed 3.0/3.X and 4.0+ cluster, which is unsupported. Make sure to stop using thrift before upgrading to 4.0");
            }
            boolean hasIndex = Serializer.hasIndex(flags);
            int digestVersion = isDigest ? (int)in.readUnsignedVInt() : 0;
            TableMetadata metadata = this.schema.getExistingTableMetadata(TableId.deserialize(in));
            int nowInSec = in.readInt();
            ColumnFilter columnFilter = ColumnFilter.serializer.deserialize(in, version, metadata);
            RowFilter rowFilter = RowFilter.serializer.deserialize(in, version, metadata);
            DataLimits limits = DataLimits.serializer.deserialize(in, version, metadata.comparator);
            IndexMetadata index = hasIndex ? this.deserializeIndexMetadata(in, version, metadata) : null;
            return kind.selectionDeserializer.deserialize(in, version, isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, index);
        }

        private IndexMetadata deserializeIndexMetadata(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            try {
                return IndexMetadata.serializer.deserialize(in, version, metadata);
            }
            catch (UnknownIndexException e) {
                logger.info("Couldn't find a defined index on {}.{} with the id {}. If an index was just created, this is likely due to the schema not being fully propagated. Local read will proceed without using the index. Please wait for schema agreement after index creation.", new Object[]{metadata.keyspace, metadata.name, e.indexId});
                return null;
            }
        }

        @Override
        public long serializedSize(ReadCommand command, int version) {
            return (long)(2 + (command.isDigestQuery() ? TypeSizes.sizeofUnsignedVInt(command.digestVersion()) : 0) + command.metadata().id.serializedSize() + TypeSizes.sizeof(command.nowInSec())) + ColumnFilter.serializer.serializedSize(command.columnFilter(), version) + RowFilter.serializer.serializedSize(command.rowFilter(), version) + DataLimits.serializer.serializedSize(command.limits(), version, command.metadata().comparator) + command.selectionSerializedSize(version) + command.indexSerializedSize(version);
        }
    }

    static class InputCollector<T extends AutoCloseable> {
        final RepairedDataInfo repairedDataInfo;
        private final boolean isTrackingRepairedStatus;
        Set<SSTableReader> repairedSSTables;
        BiFunction<List<T>, RepairedDataInfo, T> repairedMerger;
        Function<T, UnfilteredPartitionIterator> postLimitAdditionalPartitions;
        List<T> repairedIters;
        List<T> unrepairedIters;

        InputCollector(ColumnFamilyStore.ViewFragment view, ReadExecutionController controller, BiFunction<List<T>, RepairedDataInfo, T> repairedMerger, Function<T, UnfilteredPartitionIterator> postLimitAdditionalPartitions) {
            this.repairedDataInfo = controller.getRepairedDataInfo();
            this.isTrackingRepairedStatus = controller.isTrackingRepairedStatus();
            if (this.isTrackingRepairedStatus) {
                for (SSTableReader sstable : view.sstables) {
                    if (!this.considerRepairedForTracking(sstable)) continue;
                    if (this.repairedSSTables == null) {
                        this.repairedSSTables = Sets.newHashSetWithExpectedSize((int)view.sstables.size());
                    }
                    this.repairedSSTables.add(sstable);
                }
            }
            if (this.repairedSSTables == null) {
                this.repairedIters = Collections.emptyList();
                this.unrepairedIters = new ArrayList<T>(view.sstables.size());
            } else {
                this.repairedIters = new ArrayList<T>(this.repairedSSTables.size());
                this.unrepairedIters = new ArrayList<T>(view.sstables.size() - this.repairedSSTables.size() + Iterables.size(view.memtables) + 1);
            }
            this.repairedMerger = repairedMerger;
            this.postLimitAdditionalPartitions = postLimitAdditionalPartitions;
        }

        void addMemtableIterator(T iter) {
            this.unrepairedIters.add(iter);
        }

        void addSSTableIterator(SSTableReader sstable, T iter) {
            if (this.repairedSSTables != null && this.repairedSSTables.contains(sstable)) {
                this.repairedIters.add(iter);
            } else {
                this.unrepairedIters.add(iter);
            }
        }

        List<T> finalizeIterators(ColumnFamilyStore cfs, int nowInSec, int oldestUnrepairedTombstone) {
            if (this.repairedIters.isEmpty()) {
                return this.unrepairedIters;
            }
            this.repairedDataInfo.prepare(cfs, nowInSec, oldestUnrepairedTombstone);
            AutoCloseable repairedIter = (AutoCloseable)this.repairedMerger.apply(this.repairedIters, this.repairedDataInfo);
            this.repairedDataInfo.finalize(this.postLimitAdditionalPartitions.apply(repairedIter));
            this.unrepairedIters.add(repairedIter);
            return this.unrepairedIters;
        }

        boolean isEmpty() {
            return this.repairedIters.isEmpty() && this.unrepairedIters.isEmpty();
        }

        private boolean considerRepairedForTracking(SSTableReader sstable) {
            if (!this.isTrackingRepairedStatus) {
                return false;
            }
            UUID pendingRepair = sstable.getPendingRepair();
            if (pendingRepair != ActiveRepairService.NO_PENDING_REPAIR) {
                if (ActiveRepairService.instance.consistent.local.isSessionFinalized(pendingRepair)) {
                    return true;
                }
                if (!ActiveRepairService.instance.consistent.local.sessionExists(pendingRepair)) {
                    return false;
                }
                this.repairedDataInfo.markInconclusive();
            }
            return sstable.isRepaired();
        }

        void markInconclusive() {
            this.repairedDataInfo.markInconclusive();
        }

        public void close() throws Exception {
            FBUtilities.closeAll(this.unrepairedIters);
            FBUtilities.closeAll(this.repairedIters);
        }
    }

    protected class CheckForAbort
    extends StoppingTransformation<UnfilteredRowIterator> {
        long lastChecked = 0L;

        protected CheckForAbort() {
        }

        @Override
        protected UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
            if (this.maybeAbort()) {
                partition.close();
                return null;
            }
            return Transformation.apply(partition, this);
        }

        @Override
        protected Row applyToRow(Row row) {
            if (TEST_ITERATION_DELAY_MILLIS > 0) {
                this.maybeDelayForTesting();
            }
            return this.maybeAbort() ? null : row;
        }

        private boolean maybeAbort() {
            if (this.lastChecked == MonotonicClock.approxTime.now()) {
                return false;
            }
            this.lastChecked = MonotonicClock.approxTime.now();
            if (ReadCommand.this.isAborted()) {
                this.stop();
                return true;
            }
            return false;
        }

        private void maybeDelayForTesting() {
            if (!ReadCommand.this.metadata().keyspace.startsWith("system")) {
                FBUtilities.sleepQuietly(TEST_ITERATION_DELAY_MILLIS);
            }
        }
    }

    protected static enum Kind {
        SINGLE_PARTITION(SinglePartitionReadCommand.selectionDeserializer),
        PARTITION_RANGE(PartitionRangeReadCommand.selectionDeserializer);

        private final SelectionDeserializer selectionDeserializer;

        private Kind(SelectionDeserializer selectionDeserializer) {
            this.selectionDeserializer = selectionDeserializer;
        }
    }

    protected static abstract class SelectionDeserializer {
        protected SelectionDeserializer() {
        }

        public abstract ReadCommand deserialize(DataInputPlus var1, int var2, boolean var3, int var4, boolean var5, TableMetadata var6, int var7, ColumnFilter var8, RowFilter var9, DataLimits var10, IndexMetadata var11) throws IOException;
    }
}

