/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.trie;

import org.psjava.ds.map.KeysInMap;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.map.MutableMapFactory;
import org.psjava.ds.tree.trie.TrieNode;
import org.psjava.ds.tree.trie.TrieNodeFactory;

public class TrieNodeFactoryUsingMap {
    public static <T> TrieNodeFactory<T> create(final MutableMapFactory mapFactory) {
        return new TrieNodeFactory<T>(){

            @Override
            public TrieNode<T> create() {
                return new Node(mapFactory);
            }
        };
    }

    private TrieNodeFactoryUsingMap() {
    }

    private static class Node<T>
    implements TrieNode<T> {
        private final MutableMap<T, TrieNode<T>> children;

        public Node(MutableMapFactory mapFactory) {
            this.children = mapFactory.create();
        }

        @Override
        public boolean hasChild(T ch) {
            return this.children.containsKey(ch);
        }

        @Override
        public TrieNode<T> getChildOrNull(T ch) {
            return (TrieNode)this.children.getOrNull(ch);
        }

        @Override
        public void putChild(T ch, TrieNode<T> node) {
            this.children.addOrReplace(ch, node);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public TrieNode<T> getChild(T ch) {
            return (TrieNode)this.children.get(ch);
        }

        @Override
        public Iterable<T> getEdges() {
            return KeysInMap.get(this.children);
        }
    }
}

