/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public enum ChecksumType {
    Adler32{

        @Override
        public Checksum newInstance() {
            return new Adler32();
        }

        @Override
        public void update(Checksum checksum, ByteBuffer buf) {
            ((Adler32)checksum).update(buf);
        }
    }
    ,
    CRC32{

        @Override
        public Checksum newInstance() {
            return new CRC32();
        }

        @Override
        public void update(Checksum checksum, ByteBuffer buf) {
            ((CRC32)checksum).update(buf);
        }
    };

    private FastThreadLocal<Checksum> instances = new FastThreadLocal<Checksum>(){

        protected Checksum initialValue() throws Exception {
            return ChecksumType.this.newInstance();
        }
    };

    public abstract Checksum newInstance();

    public abstract void update(Checksum var1, ByteBuffer var2);

    public long of(ByteBuffer buf) {
        Checksum checksum = (Checksum)this.instances.get();
        checksum.reset();
        this.update(checksum, buf);
        return checksum.getValue();
    }

    public long of(byte[] data, int off, int len) {
        Checksum checksum = (Checksum)this.instances.get();
        checksum.reset();
        checksum.update(data, off, len);
        return checksum.getValue();
    }
}

