/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import org.apache.cassandra.exceptions.ExceptionCode;
import org.apache.cassandra.exceptions.TransportException;
import org.apache.cassandra.transport.ProtocolVersion;

public class ProtocolException
extends RuntimeException
implements TransportException {
    private final ProtocolVersion forcedProtocolVersion;

    public ProtocolException(String msg) {
        this(msg, (ProtocolVersion)null);
    }

    public ProtocolException(String msg, ProtocolVersion forcedProtocolVersion) {
        super(msg);
        this.forcedProtocolVersion = forcedProtocolVersion;
    }

    @Override
    public ExceptionCode code() {
        return ExceptionCode.PROTOCOL_ERROR;
    }

    public ProtocolVersion getForcedProtocolVersion() {
        return this.forcedProtocolVersion;
    }

    public boolean isSilent() {
        return false;
    }

    public static ProtocolException toSilentException(ProtocolException e) {
        return new Silent(e);
    }

    private static class Silent
    extends ProtocolException {
        public Silent(ProtocolException cause) {
            super(cause.getMessage(), cause.forcedProtocolVersion);
        }

        @Override
        public boolean isSilent() {
            return true;
        }
    }
}

