/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.transport.Server;

public class ClientMetrics {
    private static final MetricNameFactory factory = new DefaultNameFactory("Client");
    public static final ClientMetrics instance = new ClientMetrics();
    private volatile boolean initialized = false;
    private Collection<Server> servers = Collections.emptyList();
    private AtomicInteger pausedConnections;
    private Gauge<Integer> pausedConnectionsGauge;
    private Meter requestDiscarded;
    private Meter protocolException;
    private Meter unknownException;

    private ClientMetrics() {
    }

    public void pauseConnection() {
        this.pausedConnections.incrementAndGet();
    }

    public void unpauseConnection() {
        this.pausedConnections.decrementAndGet();
    }

    public void markRequestDiscarded() {
        this.requestDiscarded.mark();
    }

    public void markProtocolException() {
        this.protocolException.mark();
    }

    public void markUnknownException() {
        this.unknownException.mark();
    }

    public synchronized void init(Collection<Server> servers) {
        if (this.initialized) {
            return;
        }
        this.servers = servers;
        this.registerGauge("connectedNativeClients", this::countConnectedClients);
        this.pausedConnections = new AtomicInteger();
        this.pausedConnectionsGauge = this.registerGauge("PausedConnections", this.pausedConnections::get);
        this.requestDiscarded = this.registerMeter("RequestDiscarded");
        this.protocolException = this.registerMeter("ProtocolException");
        this.unknownException = this.registerMeter("UnknownException");
        this.initialized = true;
    }

    public void addCounter(String name, Callable<Integer> provider) {
        CassandraMetricsRegistry.Metrics.register(factory.createMetricName(name), () -> {
            try {
                return (Integer)provider.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private int countConnectedClients() {
        int count = 0;
        for (Server server : this.servers) {
            count += server.getConnectedClients();
        }
        return count;
    }

    private <T> Gauge<T> registerGauge(String name, Gauge<T> gauge) {
        return CassandraMetricsRegistry.Metrics.register(factory.createMetricName(name), gauge);
    }

    public Meter registerMeter(String name) {
        return CassandraMetricsRegistry.Metrics.meter(factory.createMetricName(name));
    }
}

