/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.ClientState;

public abstract class CFStatement
extends ParsedStatement {
    protected final CFName cfName;
    protected Boolean fullyQualified;

    protected CFStatement(CFName cfName) {
        this.cfName = cfName;
        this.fullyQualified = cfName != null ? Boolean.valueOf(cfName.hasKeyspace()) : null;
    }

    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.cfName.hasKeyspace()) {
            this.cfName.setKeyspace(state.getKeyspace(), true);
        }
    }

    public void prepareKeyspace(String keyspace) {
        if (!this.cfName.hasKeyspace()) {
            this.cfName.setKeyspace(keyspace, true);
        }
    }

    public boolean isFullyQualified() {
        if (this.fullyQualified == null) {
            throw new IllegalStateException("Cannot determine whether or not the query was fully qualified");
        }
        return this.fullyQualified;
    }

    public String keyspace() {
        assert (this.cfName.hasKeyspace()) : "The statement hasn't be prepared correctly";
        return this.cfName.getKeyspace();
    }

    public String columnFamily() {
        return this.cfName.getColumnFamily();
    }
}

