/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.caffinitas.ohc.OHCacheBuilder;
import org.caffinitas.ohc.histo.EstimatedHistogram;
import org.caffinitas.ohc.linked.HashEntries;
import org.caffinitas.ohc.linked.KeyBuffer;
import org.caffinitas.ohc.linked.LongArrayList;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;

final class OffHeapMap {
    private static final int MAX_TABLE_SIZE = 0x40000000;
    private long lruHead;
    private long lruTail;
    private long size;
    private Table table;
    private long hitCount;
    private long missCount;
    private long putAddCount;
    private long putReplaceCount;
    private long removeCount;
    private long threshold;
    private final float loadFactor;
    private long rehashes;
    private long evictedEntries;
    private long freeCapacity;
    private final ReentrantLock lock = new ReentrantLock();
    private final boolean throwOOME;

    OffHeapMap(OHCacheBuilder builder, long freeCapacity) {
        this.freeCapacity = freeCapacity;
        this.throwOOME = builder.isThrowOOME();
        int hts = builder.getHashTableSize();
        if (hts <= 0) {
            hts = 8192;
        }
        if (hts < 256) {
            hts = 256;
        }
        this.table = Table.create((int)Util.roundUpToPowerOf2(hts, 0x40000000L), this.throwOOME);
        if (this.table == null) {
            throw new RuntimeException("unable to allocate off-heap memory for segment");
        }
        float lf = builder.getLoadFactor();
        if ((double)lf <= 0.0) {
            lf = 0.75f;
        }
        this.loadFactor = lf;
        this.threshold = (long)((double)this.table.size() * (double)this.loadFactor);
    }

    void release() {
        this.lock.lock();
        try {
            this.table.release();
            this.table = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    long size() {
        return this.size;
    }

    long hitCount() {
        return this.hitCount;
    }

    long missCount() {
        return this.missCount;
    }

    long putAddCount() {
        return this.putAddCount;
    }

    long putReplaceCount() {
        return this.putReplaceCount;
    }

    long removeCount() {
        return this.removeCount;
    }

    void resetStatistics() {
        this.rehashes = 0L;
        this.evictedEntries = 0L;
        this.hitCount = 0L;
        this.missCount = 0L;
        this.putAddCount = 0L;
        this.putReplaceCount = 0L;
        this.removeCount = 0L;
    }

    long rehashes() {
        return this.rehashes;
    }

    long freeCapacity() {
        return this.freeCapacity;
    }

    void updateFreeCapacity(long diff) {
        this.lock.lock();
        try {
            this.freeCapacity += diff;
        }
        finally {
            this.lock.unlock();
        }
    }

    long evictedEntries() {
        return this.evictedEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEntry(KeyBuffer key, boolean reference, boolean updateLRU) {
        this.lock.lock();
        try {
            long hashEntryAdr = this.table.getFirst(key.hash());
            while (hashEntryAdr != 0L) {
                if (!OffHeapMap.notSameKey(key, hashEntryAdr)) {
                    if (updateLRU) {
                        this.touch(hashEntryAdr);
                    }
                    if (reference) {
                        HashEntries.reference(hashEntryAdr);
                    }
                    ++this.hitCount;
                    long l = hashEntryAdr;
                    return l;
                }
                hashEntryAdr = HashEntries.getNext(hashEntryAdr);
            }
            ++this.missCount;
            long l = 0L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean putEntry(long newHashEntryAdr, long hash, long keyLen, long bytes, boolean ifAbsent, long oldValueAddr, long oldValueOffset, long oldValueLen) {
        long removeHashEntryAdr = 0L;
        LongArrayList derefList = null;
        this.lock.lock();
        try {
            long oldHashEntryAdr = 0L;
            long prevEntryAdr = 0L;
            long hashEntryAdr = this.table.getFirst(hash);
            while (hashEntryAdr != 0L) {
                if (!OffHeapMap.notSameKey(newHashEntryAdr, hash, keyLen, hashEntryAdr)) {
                    long valueLen;
                    if (ifAbsent) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!(oldValueAddr == 0L || (valueLen = HashEntries.getValueLen(hashEntryAdr)) == oldValueLen && HashEntries.compare(hashEntryAdr, 56L + Util.roundUpTo8(keyLen), oldValueAddr, oldValueOffset, oldValueLen))) {
                        boolean bl = false;
                        return bl;
                    }
                    this.removeInternal(hashEntryAdr, prevEntryAdr);
                    removeHashEntryAdr = hashEntryAdr;
                    oldHashEntryAdr = hashEntryAdr;
                    break;
                }
                prevEntryAdr = hashEntryAdr;
                hashEntryAdr = HashEntries.getNext(hashEntryAdr);
            }
            while (this.freeCapacity < bytes) {
                long eldestHashAdr = this.removeEldest();
                if (eldestHashAdr == 0L) {
                    if (oldHashEntryAdr != 0L) {
                        --this.size;
                    }
                    boolean bl = false;
                    return bl;
                }
                if (derefList == null) {
                    derefList = new LongArrayList();
                }
                derefList.add(eldestHashAdr);
            }
            if (hashEntryAdr == 0L) {
                if (this.size >= this.threshold) {
                    this.rehash();
                }
                ++this.size;
            }
            this.freeCapacity -= bytes;
            this.add(newHashEntryAdr, hash);
            if (hashEntryAdr == 0L) {
                ++this.putAddCount;
            } else {
                ++this.putReplaceCount;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
            if (removeHashEntryAdr != 0L) {
                HashEntries.dereference(removeHashEntryAdr);
            }
            if (derefList != null) {
                for (int i = 0; i < derefList.size(); ++i) {
                    HashEntries.dereference(derefList.getLong(i));
                }
            }
        }
    }

    private long removeEldest() {
        long hashEntryAdr = this.lruTail;
        if (hashEntryAdr == 0L) {
            return 0L;
        }
        this.removeInternal(hashEntryAdr, -1L);
        --this.size;
        ++this.evictedEntries;
        return hashEntryAdr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        this.lock.lock();
        try {
            this.lruTail = 0L;
            this.lruHead = 0L;
            this.size = 0L;
            long freed = 0L;
            for (int p = 0; p < this.table.size(); ++p) {
                long hashEntryAdr = this.table.getFirst(p);
                while (hashEntryAdr != 0L) {
                    long next = HashEntries.getNext(hashEntryAdr);
                    freed += HashEntries.getAllocLen(hashEntryAdr);
                    HashEntries.dereference(hashEntryAdr);
                    hashEntryAdr = next;
                }
            }
            this.freeCapacity += freed;
            this.table.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(long removeHashEntryAdr) {
        this.lock.lock();
        try {
            long hash = HashEntries.getHash(removeHashEntryAdr);
            long prevEntryAdr = 0L;
            long hashEntryAdr = this.table.getFirst(hash);
            while (hashEntryAdr != 0L) {
                if (hashEntryAdr == removeHashEntryAdr) {
                    this.removeIt(prevEntryAdr, hashEntryAdr);
                    return;
                }
                prevEntryAdr = hashEntryAdr;
                hashEntryAdr = HashEntries.getNext(hashEntryAdr);
            }
            removeHashEntryAdr = 0L;
        }
        finally {
            this.lock.unlock();
            if (removeHashEntryAdr != 0L) {
                HashEntries.dereference(removeHashEntryAdr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(KeyBuffer key) {
        long removeHashEntryAdr = 0L;
        this.lock.lock();
        try {
            long prevEntryAdr = 0L;
            long hashEntryAdr = this.table.getFirst(key.hash());
            while (hashEntryAdr != 0L) {
                if (!OffHeapMap.notSameKey(key, hashEntryAdr)) {
                    removeHashEntryAdr = hashEntryAdr;
                    this.removeIt(prevEntryAdr, hashEntryAdr);
                    return;
                }
                prevEntryAdr = hashEntryAdr;
                hashEntryAdr = HashEntries.getNext(hashEntryAdr);
            }
        }
        finally {
            this.lock.unlock();
            if (removeHashEntryAdr != 0L) {
                HashEntries.dereference(removeHashEntryAdr);
            }
        }
    }

    private void removeIt(long prevEntryAdr, long hashEntryAdr) {
        this.removeInternal(hashEntryAdr, prevEntryAdr);
        --this.size;
        ++this.removeCount;
    }

    private static boolean notSameKey(KeyBuffer key, long hashEntryAdr) {
        if (HashEntries.getHash(hashEntryAdr) != key.hash()) {
            return true;
        }
        long serKeyLen = HashEntries.getKeyLen(hashEntryAdr);
        return serKeyLen != (long)key.size() || !HashEntries.compareKey(hashEntryAdr, key, serKeyLen);
    }

    private static boolean notSameKey(long newHashEntryAdr, long newHash, long newKeyLen, long hashEntryAdr) {
        if (HashEntries.getHash(hashEntryAdr) != newHash) {
            return true;
        }
        long serKeyLen = HashEntries.getKeyLen(hashEntryAdr);
        return serKeyLen != newKeyLen || !HashEntries.compare(hashEntryAdr, 56L, newHashEntryAdr, 56L, serKeyLen);
    }

    private void rehash() {
        Table tab = this.table;
        int tableSize = tab.size();
        if (tableSize > 0x40000000) {
            return;
        }
        Table newTable = Table.create(tableSize * 2, this.throwOOME);
        if (newTable == null) {
            return;
        }
        for (int part = 0; part < tableSize; ++part) {
            long hashEntryAdr = tab.getFirst(part);
            while (hashEntryAdr != 0L) {
                long next = HashEntries.getNext(hashEntryAdr);
                HashEntries.setNext(hashEntryAdr, 0L);
                newTable.addAsHead(HashEntries.getHash(hashEntryAdr), hashEntryAdr);
                hashEntryAdr = next;
            }
        }
        this.threshold = (long)((float)newTable.size() * this.loadFactor);
        this.table.release();
        this.table = newTable;
        ++this.rehashes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] hotN(int n) {
        this.lock.lock();
        try {
            long[] r = new long[n];
            int i = 0;
            long hashEntryAdr = this.lruHead;
            while (hashEntryAdr != 0L && i < n) {
                r[i++] = hashEntryAdr;
                HashEntries.reference(hashEntryAdr);
                hashEntryAdr = HashEntries.getLRUNext(hashEntryAdr);
            }
            long[] lArray = r;
            return lArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    float loadFactor() {
        return this.loadFactor;
    }

    int hashTableSize() {
        return this.table.size();
    }

    void updateBucketHistogram(EstimatedHistogram hist) {
        this.lock.lock();
        try {
            this.table.updateBucketHistogram(hist);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getEntryAddresses(int mapSegmentIndex, int nSegments, List<Long> hashEntryAdrs) {
        this.lock.lock();
        try {
            while (nSegments-- > 0 && mapSegmentIndex < this.table.size()) {
                long hashEntryAdr = this.table.getFirst(mapSegmentIndex);
                while (hashEntryAdr != 0L) {
                    hashEntryAdrs.add(hashEntryAdr);
                    HashEntries.reference(hashEntryAdr);
                    hashEntryAdr = HashEntries.getNext(hashEntryAdr);
                }
                ++mapSegmentIndex;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeInternal(long hashEntryAdr, long prevEntryAdr) {
        long hash = HashEntries.getHash(hashEntryAdr);
        this.table.removeLink(hash, hashEntryAdr, prevEntryAdr);
        long next = HashEntries.getLRUNext(hashEntryAdr);
        long prev = HashEntries.getLRUPrev(hashEntryAdr);
        if (this.lruHead == hashEntryAdr) {
            this.lruHead = next;
        }
        if (this.lruTail == hashEntryAdr) {
            this.lruTail = prev;
        }
        if (next != 0L) {
            HashEntries.setLRUPrev(next, prev);
        }
        if (prev != 0L) {
            HashEntries.setLRUNext(prev, next);
        }
        this.freeCapacity += HashEntries.getAllocLen(hashEntryAdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replaceEntry(long hash, long oldHashEntryAdr, long newHashEntryAdr, long bytes) {
        LongArrayList derefList = null;
        this.lock.lock();
        try {
            long prevEntryAdr = 0L;
            long hashEntryAdr = this.table.getFirst(hash);
            while (hashEntryAdr != 0L) {
                if (hashEntryAdr == oldHashEntryAdr) {
                    this.replaceInternal(oldHashEntryAdr, prevEntryAdr, newHashEntryAdr);
                    while (this.freeCapacity < bytes) {
                        long eldestHashAdr = this.removeEldest();
                        if (eldestHashAdr == 0L) {
                            boolean bl = false;
                            return bl;
                        }
                        if (derefList == null) {
                            derefList = new LongArrayList();
                        }
                        derefList.add(eldestHashAdr);
                    }
                    boolean bl = true;
                    return bl;
                }
                prevEntryAdr = hashEntryAdr;
                hashEntryAdr = HashEntries.getNext(hashEntryAdr);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            if (derefList != null) {
                for (int i = 0; i < derefList.size(); ++i) {
                    HashEntries.dereference(derefList.getLong(i));
                }
            }
        }
    }

    private void replaceInternal(long hashEntryAdr, long prevEntryAdr, long newHashEntryAdr) {
        long hash = HashEntries.getHash(hashEntryAdr);
        this.table.replaceLink(hash, hashEntryAdr, prevEntryAdr, newHashEntryAdr);
        long next = HashEntries.getLRUNext(hashEntryAdr);
        long prev = HashEntries.getLRUPrev(hashEntryAdr);
        HashEntries.setLRUNext(newHashEntryAdr, next);
        HashEntries.setLRUPrev(newHashEntryAdr, prev);
        if (this.lruHead == hashEntryAdr) {
            this.lruHead = newHashEntryAdr;
        }
        if (this.lruTail == hashEntryAdr) {
            this.lruTail = newHashEntryAdr;
        }
        if (next != 0L) {
            HashEntries.setLRUPrev(next, newHashEntryAdr);
        }
        if (prev != 0L) {
            HashEntries.setLRUNext(prev, newHashEntryAdr);
        }
        this.freeCapacity += HashEntries.getAllocLen(hashEntryAdr);
    }

    private void add(long hashEntryAdr, long hash) {
        this.table.addAsHead(hash, hashEntryAdr);
        long h = this.lruHead;
        HashEntries.setLRUNext(hashEntryAdr, h);
        if (h != 0L) {
            HashEntries.setLRUPrev(h, hashEntryAdr);
        }
        HashEntries.setLRUPrev(hashEntryAdr, 0L);
        this.lruHead = hashEntryAdr;
        if (this.lruTail == 0L) {
            this.lruTail = hashEntryAdr;
        }
    }

    private void touch(long hashEntryAdr) {
        long head = this.lruHead;
        if (head == hashEntryAdr) {
            return;
        }
        long next = HashEntries.getAndSetLRUNext(hashEntryAdr, head);
        long prev = HashEntries.getAndSetLRUPrev(hashEntryAdr, 0L);
        long tail = this.lruTail;
        if (tail == hashEntryAdr) {
            this.lruTail = prev == 0L ? hashEntryAdr : prev;
        } else if (tail == 0L) {
            this.lruTail = hashEntryAdr;
        }
        if (next != 0L) {
            HashEntries.setLRUPrev(next, prev);
        }
        if (prev != 0L) {
            HashEntries.setLRUNext(prev, next);
        }
        if (head != 0L) {
            HashEntries.setLRUPrev(head, hashEntryAdr);
        }
        this.lruHead = hashEntryAdr;
    }

    public String toString() {
        return String.valueOf(this.size);
    }

    static final class Table {
        final int mask;
        final long address;
        private boolean released;

        static Table create(int hashTableSize, boolean throwOOME) {
            int msz = 8 * hashTableSize;
            long address = Uns.allocate(msz, throwOOME);
            return address != 0L ? new Table(address, hashTableSize) : null;
        }

        private Table(long address, int hashTableSize) {
            this.address = address;
            this.mask = hashTableSize - 1;
            this.clear();
        }

        void clear() {
            Uns.setMemory(this.address, 0L, 8L * (long)this.size(), (byte)0);
        }

        void release() {
            Uns.free(this.address);
            this.released = true;
        }

        protected void finalize() throws Throwable {
            if (!this.released) {
                Uns.free(this.address);
            }
            super.finalize();
        }

        long getFirst(long hash) {
            return Uns.getLong(this.address, this.bucketOffset(hash));
        }

        void setFirst(long hash, long hashEntryAdr) {
            Uns.putLong(this.address, this.bucketOffset(hash), hashEntryAdr);
        }

        private long bucketOffset(long hash) {
            return (long)this.bucketIndexForHash(hash) * 8L;
        }

        private int bucketIndexForHash(long hash) {
            return (int)(hash & (long)this.mask);
        }

        void removeLink(long hash, long hashEntryAdr, long prevEntryAdr) {
            long next = HashEntries.getNext(hashEntryAdr);
            long head = this.getFirst(hash);
            if (head == hashEntryAdr) {
                this.setFirst(hash, next);
            } else if (prevEntryAdr != 0L) {
                if (prevEntryAdr == -1L) {
                    long adr = head;
                    while (adr != 0L && adr != hashEntryAdr) {
                        prevEntryAdr = adr;
                        adr = HashEntries.getNext(adr);
                    }
                }
                HashEntries.setNext(prevEntryAdr, next);
            }
        }

        void replaceLink(long hash, long hashEntryAdr, long prevEntryAdr, long newHashEntryAdr) {
            HashEntries.setNext(newHashEntryAdr, HashEntries.getNext(hashEntryAdr));
            long head = this.getFirst(hash);
            if (head == hashEntryAdr) {
                this.setFirst(hash, newHashEntryAdr);
            } else if (prevEntryAdr != 0L) {
                if (prevEntryAdr == -1L) {
                    long adr = head;
                    while (adr != 0L && adr != hashEntryAdr) {
                        prevEntryAdr = adr;
                        adr = HashEntries.getNext(adr);
                    }
                }
                HashEntries.setNext(prevEntryAdr, newHashEntryAdr);
            }
        }

        void addAsHead(long hash, long hashEntryAdr) {
            long head = this.getFirst(hash);
            HashEntries.setNext(hashEntryAdr, head);
            this.setFirst(hash, hashEntryAdr);
        }

        int size() {
            return this.mask + 1;
        }

        void updateBucketHistogram(EstimatedHistogram h) {
            for (int i = 0; i < this.size(); ++i) {
                int len = 0;
                long adr = this.getFirst(i);
                while (adr != 0L) {
                    ++len;
                    adr = HashEntries.getNext(adr);
                }
                h.add(len + 1);
            }
        }
    }
}

