/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.datastax.driver.core.Metadata;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.ConnectionAPI;
import org.apache.cassandra.stress.settings.Legacy;
import org.apache.cassandra.stress.settings.SettingsColumn;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.SettingsCommandUser;
import org.apache.cassandra.stress.settings.SettingsErrors;
import org.apache.cassandra.stress.settings.SettingsInsert;
import org.apache.cassandra.stress.settings.SettingsLog;
import org.apache.cassandra.stress.settings.SettingsMisc;
import org.apache.cassandra.stress.settings.SettingsMode;
import org.apache.cassandra.stress.settings.SettingsNode;
import org.apache.cassandra.stress.settings.SettingsPopulation;
import org.apache.cassandra.stress.settings.SettingsPort;
import org.apache.cassandra.stress.settings.SettingsRate;
import org.apache.cassandra.stress.settings.SettingsSamples;
import org.apache.cassandra.stress.settings.SettingsSchema;
import org.apache.cassandra.stress.settings.SettingsTokenRange;
import org.apache.cassandra.stress.settings.SettingsTransport;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.SimpleThriftClient;
import org.apache.cassandra.stress.util.SmartThriftClient;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.transport.SimpleClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class StressSettings
implements Serializable {
    public final SettingsCommand command;
    public final SettingsRate rate;
    public final SettingsPopulation generate;
    public final SettingsInsert insert;
    public final SettingsColumn columns;
    public final SettingsSamples samples;
    public final SettingsErrors errors;
    public final SettingsLog log;
    public final SettingsMode mode;
    public final SettingsNode node;
    public final SettingsSchema schema;
    public final SettingsTransport transport;
    public final SettingsPort port;
    public final String sendToDaemon;
    public final SettingsTokenRange tokenRange;
    private SmartThriftClient tclient;
    private static volatile JavaDriverClient client;

    public StressSettings(SettingsCommand command, SettingsRate rate, SettingsPopulation generate, SettingsInsert insert, SettingsColumn columns, SettingsSamples samples, SettingsErrors errors, SettingsLog log, SettingsMode mode, SettingsNode node, SettingsSchema schema, SettingsTransport transport, SettingsPort port, String sendToDaemon, SettingsTokenRange tokenRange) {
        this.command = command;
        this.rate = rate;
        this.insert = insert;
        this.generate = generate;
        this.columns = columns;
        this.samples = samples;
        this.errors = errors;
        this.log = log;
        this.mode = mode;
        this.node = node;
        this.schema = schema;
        this.transport = transport;
        this.port = port;
        this.sendToDaemon = sendToDaemon;
        this.tokenRange = tokenRange;
    }

    public synchronized ThriftClient getThriftClient() {
        if (this.mode.api != ConnectionAPI.THRIFT_SMART) {
            return this.getSimpleThriftClient();
        }
        if (this.tclient == null) {
            this.tclient = this.getSmartThriftClient();
        }
        return this.tclient;
    }

    private SmartThriftClient getSmartThriftClient() {
        Metadata metadata = this.getJavaDriverClient().getCluster().getMetadata();
        return new SmartThriftClient(this, this.schema.keyspace, metadata);
    }

    private SimpleThriftClient getSimpleThriftClient() {
        return new SimpleThriftClient(this.getRawThriftClient(this.node.randomNode(), true));
    }

    public Cassandra.Client getRawThriftClient(boolean setKeyspace) {
        return this.getRawThriftClient(this.node.randomNode(), setKeyspace);
    }

    public Cassandra.Client getRawThriftClient(String host) {
        return this.getRawThriftClient(host, true);
    }

    public Cassandra.Client getRawThriftClient(String host, boolean setKeyspace) {
        Cassandra.Client client;
        try {
            TTransport transport = this.transport.getFactory().openTransport(host, this.port.thriftPort);
            client = new Cassandra.Client((TProtocol)new TBinaryProtocol(transport));
            if (this.mode.cqlVersion.isCql()) {
                client.set_cql_version(this.mode.cqlVersion.connectVersion);
            }
            if (setKeyspace) {
                client.set_keyspace(this.schema.keyspace);
            }
            if (this.mode.username != null) {
                client.login(new AuthenticationRequest((Map)ImmutableMap.of((Object)"username", (Object)this.mode.username, (Object)"password", (Object)this.mode.password)));
            }
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return client;
    }

    public SimpleClient getSimpleNativeClient() {
        try {
            String currentNode = this.node.randomNode();
            SimpleClient client = new SimpleClient(currentNode, this.port.nativePort);
            client.connect(false);
            client.execute("USE \"" + this.schema.keyspace + "\";", ConsistencyLevel.ONE);
            return client;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public JavaDriverClient getJavaDriverClient() {
        return this.getJavaDriverClient(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaDriverClient getJavaDriverClient(boolean setKeyspace) {
        if (client != null) {
            return client;
        }
        try {
            StressSettings stressSettings = this;
            synchronized (stressSettings) {
                String currentNode = this.node.randomNode();
                if (client != null) {
                    return client;
                }
                EncryptionOptions.ClientEncryptionOptions encOptions = this.transport.getEncryptionOptions();
                JavaDriverClient c = new JavaDriverClient(this, currentNode, this.port.nativePort, encOptions);
                c.connect(this.mode.compression());
                if (setKeyspace) {
                    c.execute("USE \"" + this.schema.keyspace + "\";", ConsistencyLevel.ONE);
                }
                client = c;
                return client;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void maybeCreateKeyspaces() {
        if (this.command.type == Command.WRITE || this.command.type == Command.COUNTER_WRITE) {
            this.schema.createKeySpaces(this);
        } else if (this.command.type == Command.USER) {
            ((SettingsCommandUser)this.command).profile.maybeCreateSchema(this);
        }
    }

    public static StressSettings parse(String[] args) {
        try {
            args = StressSettings.repairParams(args);
            Map<String, String[]> clArgs = StressSettings.parseMap(args);
            if (clArgs.containsKey("legacy")) {
                return Legacy.build(Arrays.copyOfRange(args, 1, args.length));
            }
            if (SettingsMisc.maybeDoSpecial(clArgs)) {
                System.exit(1);
            }
            return StressSettings.get(clArgs);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            System.exit(1);
            throw new AssertionError();
        }
    }

    private static String[] repairParams(String[] args) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                sb.append(" ");
            }
            sb.append(arg);
            first = false;
        }
        return sb.toString().replaceAll("\\s+([,=()])", "$1").replaceAll("([,=(])\\s+", "$1").split(" +");
    }

    public static StressSettings get(Map<String, String[]> clArgs) {
        SettingsCommand command = SettingsCommand.get(clArgs);
        if (command == null) {
            throw new IllegalArgumentException("No command specified");
        }
        String sendToDaemon = SettingsMisc.getSendToDaemon(clArgs);
        SettingsPort port = SettingsPort.get(clArgs);
        SettingsRate rate = SettingsRate.get(clArgs, command);
        SettingsPopulation generate = SettingsPopulation.get(clArgs, command);
        SettingsTokenRange tokenRange = SettingsTokenRange.get(clArgs);
        SettingsInsert insert = SettingsInsert.get(clArgs);
        SettingsColumn columns = SettingsColumn.get(clArgs);
        SettingsSamples samples = SettingsSamples.get(clArgs);
        SettingsErrors errors = SettingsErrors.get(clArgs);
        SettingsLog log = SettingsLog.get(clArgs);
        SettingsMode mode = SettingsMode.get(clArgs);
        SettingsNode node = SettingsNode.get(clArgs);
        SettingsSchema schema = SettingsSchema.get(clArgs, command);
        SettingsTransport transport = SettingsTransport.get(clArgs);
        if (!clArgs.isEmpty()) {
            StressSettings.printHelp();
            System.out.println("Error processing command line arguments. The following were ignored:");
            for (Map.Entry<String, String[]> e : clArgs.entrySet()) {
                System.out.print(e.getKey());
                for (String v : e.getValue()) {
                    System.out.print(" ");
                    System.out.print(v);
                }
                System.out.println();
            }
            System.exit(1);
        }
        return new StressSettings(command, rate, generate, insert, columns, samples, errors, log, mode, node, schema, transport, port, sendToDaemon, tokenRange);
    }

    private static Map<String, String[]> parseMap(String[] args) {
        if (args.length == 0) {
            System.out.println("No command provided");
            StressSettings.printHelp();
            System.exit(1);
        }
        LinkedHashMap<String, String[]> r = new LinkedHashMap<String, String[]>();
        String key = null;
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (i == 0 || args[i].startsWith("-")) {
                if (i > 0) {
                    StressSettings.putParam(key, params.toArray(new String[0]), r);
                }
                key = args[i].toLowerCase();
                params.clear();
                continue;
            }
            params.add(args[i]);
        }
        StressSettings.putParam(key, params.toArray(new String[0]), r);
        return r;
    }

    private static void putParam(String key, String[] args, Map<String, String[]> clArgs) {
        String[] prev = clArgs.put(key, args);
        if (prev != null) {
            throw new IllegalArgumentException(key + " is defined multiple times. Each option/command can be specified at most once.");
        }
    }

    public static void printHelp() {
        SettingsMisc.printHelp();
    }

    public synchronized void disconnect() {
        if (client == null) {
            return;
        }
        client.disconnect();
        client = null;
    }
}

