/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.ContextAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtableBufferAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.DirectBuffer;

public class SlabAllocator
extends MemtableBufferAllocator {
    private static final Logger logger = LoggerFactory.getLogger(SlabAllocator.class);
    private static final int REGION_SIZE = 0x100000;
    private static final int MAX_CLONED_SIZE = 131072;
    private static final ConcurrentLinkedQueue<Region> RACE_ALLOCATED = new ConcurrentLinkedQueue();
    private final AtomicReference<Region> currentRegion = new AtomicReference();
    private final AtomicInteger regionCount = new AtomicInteger(0);
    private final ConcurrentLinkedQueue<Region> offHeapRegions = new ConcurrentLinkedQueue();
    private AtomicLong unslabbedSize = new AtomicLong(0L);
    private final boolean allocateOnHeapOnly;

    SlabAllocator(MemtableAllocator.SubAllocator onHeap, MemtableAllocator.SubAllocator offHeap, boolean allocateOnHeapOnly) {
        super(onHeap, offHeap);
        this.allocateOnHeapOnly = allocateOnHeapOnly;
    }

    public ByteBuffer allocate(int size) {
        return this.allocate(size, null);
    }

    @Override
    public ByteBuffer allocate(int size, OpOrder.Group opGroup) {
        assert (size >= 0);
        if (size == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        (this.allocateOnHeapOnly ? this.onHeap() : this.offHeap()).allocate(size, opGroup);
        if (size > 131072) {
            this.unslabbedSize.addAndGet(size);
            if (this.allocateOnHeapOnly) {
                return ByteBuffer.allocate(size);
            }
            Region region = new Region(ByteBuffer.allocateDirect(size));
            this.offHeapRegions.add(region);
            return region.allocate(size);
        }
        Region region;
        ByteBuffer cloned;
        while ((cloned = (region = this.getRegion()).allocate(size)) == null) {
            this.currentRegion.compareAndSet(region, null);
        }
        return cloned;
    }

    @Override
    public void setDiscarded() {
        for (Region region : this.offHeapRegions) {
            ((DirectBuffer)((Object)region.data)).cleaner().clean();
        }
        super.setDiscarded();
    }

    private Region getRegion() {
        Region region;
        while ((region = this.currentRegion.get()) == null) {
            region = RACE_ALLOCATED.poll();
            if (region == null) {
                region = new Region(this.allocateOnHeapOnly ? ByteBuffer.allocate(0x100000) : ByteBuffer.allocateDirect(0x100000));
            }
            if (this.currentRegion.compareAndSet(null, region)) {
                if (!this.allocateOnHeapOnly) {
                    this.offHeapRegions.add(region);
                }
                this.regionCount.incrementAndGet();
                logger.trace("{} regions now allocated in {}", (Object)this.regionCount, (Object)this);
                return region;
            }
            RACE_ALLOCATED.add(region);
        }
        return region;
    }

    @Override
    protected AbstractAllocator allocator(OpOrder.Group writeOp) {
        return new ContextAllocator(writeOp, this);
    }

    private static class Region {
        private ByteBuffer data;
        private AtomicInteger nextFreeOffset = new AtomicInteger(0);

        private Region(ByteBuffer buffer) {
            this.data = buffer;
        }

        public ByteBuffer allocate(int size) {
            int newOffset = this.nextFreeOffset.getAndAdd(size);
            if (newOffset + size > this.data.capacity()) {
                return null;
            }
            return (ByteBuffer)this.data.duplicate().position(newOffset).limit(newOffset + size);
        }

        public String toString() {
            return "Region@" + System.identityHashCode(this) + "waste=" + Math.max(0, this.data.capacity() - this.nextFreeOffset.get());
        }
    }
}

