/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.Multimap;
import io.airlift.command.Command;
import java.io.PrintStream;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="tpstats", description="Print usage statistics of thread pools")
public class TpStats
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        out.printf("%-25s%10s%10s%15s%10s%18s%n", "Pool Name", "Active", "Pending", "Completed", "Blocked", "All time blocked");
        Multimap<String, String> threadPools = probe.getThreadPools();
        for (Map.Entry entry : threadPools.entries()) {
            out.printf("%-25s%10s%10s%15s%10s%18s%n", entry.getValue(), probe.getThreadPoolMetric((String)entry.getKey(), (String)entry.getValue(), "ActiveTasks"), probe.getThreadPoolMetric((String)entry.getKey(), (String)entry.getValue(), "PendingTasks"), probe.getThreadPoolMetric((String)entry.getKey(), (String)entry.getValue(), "CompletedTasks"), probe.getThreadPoolMetric((String)entry.getKey(), (String)entry.getValue(), "CurrentlyBlockedTasks"), probe.getThreadPoolMetric((String)entry.getKey(), (String)entry.getValue(), "TotalBlockedTasks"));
        }
        out.printf("%n%-20s%10s%n", "Message type", "Dropped");
        for (Map.Entry entry : probe.getDroppedMessages().entrySet()) {
            out.printf("%-20s%10s%n", entry.getKey(), entry.getValue());
        }
    }
}

