/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.utils.FBUtilities;

public class DeflateCompressor
implements ICompressor {
    public static final DeflateCompressor instance = new DeflateCompressor();
    private final ThreadLocal<Deflater> deflater = new ThreadLocal<Deflater>(){

        @Override
        protected Deflater initialValue() {
            return new Deflater();
        }
    };
    private final ThreadLocal<Inflater> inflater = new ThreadLocal<Inflater>(){

        @Override
        protected Inflater initialValue() {
            return new Inflater();
        }
    };

    public static DeflateCompressor create(Map<String, String> compressionOptions) {
        return instance;
    }

    private DeflateCompressor() {
    }

    @Override
    public Set<String> supportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public int initialCompressedBufferLength(int sourceLen) {
        return sourceLen + (sourceLen >> 12) + (sourceLen >> 14) + (sourceLen >> 25) + 13;
    }

    @Override
    public void compress(ByteBuffer input, ByteBuffer output) {
        if (input.hasArray() && output.hasArray()) {
            int length = this.compressArray(input.array(), input.arrayOffset() + input.position(), input.remaining(), output.array(), output.arrayOffset() + output.position(), output.remaining());
            input.position(input.limit());
            output.position(output.position() + length);
        } else {
            this.compressBuffer(input, output);
        }
    }

    public int compressArray(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        Deflater def = this.deflater.get();
        def.reset();
        def.setInput(input, inputOffset, inputLength);
        def.finish();
        if (def.needsInput()) {
            return 0;
        }
        int len = def.deflate(output, outputOffset, maxOutputLength);
        assert (def.finished());
        return len;
    }

    public void compressBuffer(ByteBuffer input, ByteBuffer output) {
        Deflater def = this.deflater.get();
        def.reset();
        byte[] buffer = FBUtilities.getThreadLocalScratchBuffer();
        int chunkLen = buffer.length / 2;
        while (input.remaining() > chunkLen) {
            input.get(buffer, 0, chunkLen);
            def.setInput(buffer, 0, chunkLen);
            while (!def.needsInput()) {
                int len = def.deflate(buffer, chunkLen, chunkLen);
                output.put(buffer, chunkLen, len);
            }
        }
        int inputLength = input.remaining();
        input.get(buffer, 0, inputLength);
        def.setInput(buffer, 0, inputLength);
        def.finish();
        while (!def.finished()) {
            int len = def.deflate(buffer, chunkLen, chunkLen);
            output.put(buffer, chunkLen, len);
        }
    }

    @Override
    public void uncompress(ByteBuffer input, ByteBuffer output) throws IOException {
        if (input.hasArray() && output.hasArray()) {
            int length = this.uncompress(input.array(), input.arrayOffset() + input.position(), input.remaining(), output.array(), output.arrayOffset() + output.position(), output.remaining());
            input.position(input.limit());
            output.position(output.position() + length);
        } else {
            this.uncompressBuffer(input, output);
        }
    }

    public void uncompressBuffer(ByteBuffer input, ByteBuffer output) throws IOException {
        try {
            Inflater inf = this.inflater.get();
            inf.reset();
            byte[] buffer = FBUtilities.getThreadLocalScratchBuffer();
            int chunkLen = buffer.length / 2;
            while (input.remaining() > chunkLen) {
                input.get(buffer, 0, chunkLen);
                inf.setInput(buffer, 0, chunkLen);
                while (!inf.needsInput()) {
                    int len = inf.inflate(buffer, chunkLen, chunkLen);
                    output.put(buffer, chunkLen, len);
                }
            }
            int inputLength = input.remaining();
            input.get(buffer, 0, inputLength);
            inf.setInput(buffer, 0, inputLength);
            while (!inf.needsInput()) {
                int len = inf.inflate(buffer, chunkLen, chunkLen);
                output.put(buffer, chunkLen, len);
            }
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        return this.uncompress(input, inputOffset, inputLength, output, outputOffset, output.length - outputOffset);
    }

    public int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws IOException {
        Inflater inf = this.inflater.get();
        inf.reset();
        inf.setInput(input, inputOffset, inputLength);
        if (inf.needsInput()) {
            return 0;
        }
        try {
            return inf.inflate(output, outputOffset, maxOutputLength);
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean supports(BufferType bufferType) {
        return true;
    }

    @Override
    public BufferType preferredBufferType() {
        return BufferType.ON_HEAP;
    }
}

