/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jmx.JMXConfiguratorMBean;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.hook.DelayingShutdownHook;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.management.JMX;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.cassandra.auth.AuthKeyspace;
import org.apache.cassandra.auth.AuthMigrationListener;
import org.apache.cassandra.batchlog.BatchRemoveVerbHandler;
import org.apache.cassandra.batchlog.BatchStoreVerbHandler;
import org.apache.cassandra.batchlog.BatchlogManager;
import org.apache.cassandra.concurrent.LocalAwareExecutorService;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterMutationVerbHandler;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DefinitionsUpdateVerbHandler;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.MigrationRequestVerbHandler;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.MutationVerbHandler;
import org.apache.cassandra.db.RangeSliceVerbHandler;
import org.apache.cassandra.db.ReadCommandVerbHandler;
import org.apache.cassandra.db.ReadRepairVerbHandler;
import org.apache.cassandra.db.SchemaCheckVerbHandler;
import org.apache.cassandra.db.SizeEstimatesRecorder;
import org.apache.cassandra.db.SnapshotDetailsTabularData;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.TruncateVerbHandler;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.dht.BootStrapper;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RangeStreamer;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.StreamStateStore;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.GossipDigestAck2VerbHandler;
import org.apache.cassandra.gms.GossipDigestAckVerbHandler;
import org.apache.cassandra.gms.GossipDigestSynVerbHandler;
import org.apache.cassandra.gms.GossipShutdownVerbHandler;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.TokenSerializer;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.hints.HintVerbHandler;
import org.apache.cassandra.hints.HintsService;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.sstable.format.VersionAndType;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.ResponseVerbHandler;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.repair.RepairMessageVerbHandler;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.repair.RepairRunnable;
import org.apache.cassandra.repair.SystemDistributedKeyspace;
import org.apache.cassandra.repair.messages.RepairOption;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.EchoVerbHandler;
import org.apache.cassandra.service.IEndpointLifecycleSubscriber;
import org.apache.cassandra.service.LoadBroadcaster;
import org.apache.cassandra.service.MigrationCoordinator;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.PendingRangeCalculatorService;
import org.apache.cassandra.service.SSTablesGlobalTracker;
import org.apache.cassandra.service.SSTablesVersionsInUseChangeNotification;
import org.apache.cassandra.service.SnapshotVerbHandler;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.service.paxos.CommitVerbHandler;
import org.apache.cassandra.service.paxos.PrepareVerbHandler;
import org.apache.cassandra.service.paxos.ProposeVerbHandler;
import org.apache.cassandra.streaming.ReplicationFinishedVerbHandler;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.thrift.EndpointDetails;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.tracing.TraceKeyspace;
import org.apache.cassandra.utils.BackgroundActivityMonitor;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WindowsTimer;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventType;
import org.apache.cassandra.utils.progress.jmx.JMXProgressSupport;
import org.apache.cassandra.utils.progress.jmx.LegacyJMXProgressSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageService
extends NotificationBroadcasterSupport
implements IEndpointStateChangeSubscriber,
StorageServiceMBean {
    private static final Logger logger = LoggerFactory.getLogger(StorageService.class);
    public static final int RING_DELAY = StorageService.getRingDelay();
    public static final int SCHEMA_DELAY_MILLIS = StorageService.getSchemaDelay();
    private static final boolean REQUIRE_SCHEMAS = !Boolean.getBoolean("cassandra.skip_schema_check");
    private final JMXProgressSupport progressSupport = new JMXProgressSupport(this);
    @Deprecated
    private final LegacyJMXProgressSupport legacyProgressSupport;
    private TokenMetadata tokenMetadata = new TokenMetadata();
    public volatile VersionedValue.VersionedValueFactory valueFactory;
    private Thread drainOnShutdown;
    private volatile boolean isShutdown;
    public static final StorageService instance = new StorageService();
    private final Set<InetAddress> replicatingNodes;
    private CassandraDaemon daemon;
    private InetAddress removingNode;
    private volatile boolean isBootstrapMode;
    private boolean isSurveyMode;
    private final AtomicBoolean isRebuilding;
    private boolean initialized;
    private volatile boolean joined;
    private final AtomicBoolean authSetupCalled;
    private double traceProbability;
    private volatile Mode operationMode;
    private volatile int totalCFs;
    private volatile int remainingCFs;
    private static final AtomicInteger nextRepairCommand = new AtomicInteger();
    private final List<IEndpointLifecycleSubscriber> lifecycleSubscribers;
    private static final BackgroundActivityMonitor bgMonitor = new BackgroundActivityMonitor();
    private final String jmxObjectName;
    private Collection<Token> bootstrapTokens;
    private boolean useStrictConsistency;
    private static final boolean allowSimultaneousMoves = Boolean.valueOf(System.getProperty("cassandra.consistent.simultaneousmoves.allow", "false"));
    private static final boolean joinRing = Boolean.parseBoolean(System.getProperty("cassandra.join_ring", "true"));
    private boolean replacing;
    private UUID replacingId;
    private final StreamStateStore streamStateStore;
    public final SSTablesGlobalTracker sstablesTracker;

    private static int getRingDelay() {
        String newdelay = System.getProperty("cassandra.ring_delay_ms");
        if (newdelay != null) {
            logger.info("Overriding RING_DELAY to {}ms", (Object)newdelay);
            return Integer.parseInt(newdelay);
        }
        return 30000;
    }

    private static int getSchemaDelay() {
        String newdelay = System.getProperty("cassandra.schema_delay_ms");
        if (newdelay != null) {
            logger.info("Overriding SCHEMA_DELAY to {}ms", (Object)newdelay);
            return Integer.parseInt(newdelay);
        }
        return 30000;
    }

    @Deprecated
    public boolean isInShutdownHook() {
        return this.isShutdown();
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    @VisibleForTesting
    public void setIsShutdownUnsafeForTests(boolean isShutdown) {
        this.isShutdown = isShutdown;
    }

    public Collection<Range<Token>> getLocalRanges(String keyspaceName) {
        return this.getRangesForEndpoint(keyspaceName, FBUtilities.getBroadcastAddress());
    }

    public Collection<Range<Token>> getPrimaryRanges(String keyspace) {
        return this.getPrimaryRangesForEndpoint(keyspace, FBUtilities.getBroadcastAddress());
    }

    public Collection<Range<Token>> getPrimaryRangesWithinDC(String keyspace) {
        return this.getPrimaryRangeForEndpointWithinDC(keyspace, FBUtilities.getBroadcastAddress());
    }

    public boolean isSurveyMode() {
        return this.isSurveyMode;
    }

    public boolean hasJoined() {
        return this.joined;
    }

    public void setTokens(Collection<Token> tokens) {
        assert (tokens != null && !tokens.isEmpty()) : "Node needs at least one token.";
        if (logger.isDebugEnabled()) {
            logger.debug("Setting tokens to {}", tokens);
        }
        SystemKeyspace.updateTokens(tokens);
        Collection<Token> localTokens = this.getLocalTokens();
        this.setGossipTokens(localTokens);
        this.tokenMetadata.updateNormalTokens(tokens, FBUtilities.getBroadcastAddress());
        this.setMode(Mode.NORMAL, false);
    }

    public void setGossipTokens(Collection<Token> tokens) {
        ArrayList<Pair<ApplicationState, VersionedValue>> states = new ArrayList<Pair<ApplicationState, VersionedValue>>();
        states.add(Pair.create(ApplicationState.TOKENS, this.valueFactory.tokens(tokens)));
        states.add(Pair.create(ApplicationState.STATUS, this.valueFactory.normal(tokens)));
        Gossiper.instance.addLocalApplicationStates(states);
    }

    public StorageService() {
        super(Executors.newSingleThreadExecutor());
        this.valueFactory = new VersionedValue.VersionedValueFactory(this.tokenMetadata.partitioner);
        this.drainOnShutdown = null;
        this.isShutdown = false;
        this.replicatingNodes = Collections.synchronizedSet(new HashSet());
        this.isSurveyMode = Boolean.parseBoolean(System.getProperty("cassandra.write_survey", "false"));
        this.isRebuilding = new AtomicBoolean();
        this.joined = false;
        this.authSetupCalled = new AtomicBoolean(false);
        this.traceProbability = 0.0;
        this.operationMode = Mode.STARTING;
        this.lifecycleSubscribers = new CopyOnWriteArrayList<IEndpointLifecycleSubscriber>();
        this.bootstrapTokens = null;
        this.useStrictConsistency = Boolean.parseBoolean(System.getProperty("cassandra.consistent.rangemovement", "true"));
        this.streamStateStore = new StreamStateStore();
        this.jmxObjectName = "org.apache.cassandra.db:type=StorageService";
        MBeanWrapper.instance.registerMBean((Object)this, this.jmxObjectName);
        MBeanWrapper.instance.registerMBean((Object)StreamManager.instance, "org.apache.cassandra.net:type=StreamManager");
        this.legacyProgressSupport = new LegacyJMXProgressSupport(this, this.jmxObjectName);
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.MUTATION, new MutationVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.READ_REPAIR, new ReadRepairVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.READ, new ReadCommandVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.RANGE_SLICE, new RangeSliceVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.PAGED_RANGE, new RangeSliceVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.COUNTER_MUTATION, new CounterMutationVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.TRUNCATE, new TruncateVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.PAXOS_PREPARE, new PrepareVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.PAXOS_PROPOSE, new ProposeVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.PAXOS_COMMIT, new CommitVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.HINT, new HintVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.REPLICATION_FINISHED, new ReplicationFinishedVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.REQUEST_RESPONSE, new ResponseVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.INTERNAL_RESPONSE, new ResponseVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.REPAIR_MESSAGE, new RepairMessageVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_SHUTDOWN, new GossipShutdownVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_DIGEST_SYN, new GossipDigestSynVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_DIGEST_ACK, new GossipDigestAckVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_DIGEST_ACK2, new GossipDigestAck2VerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.DEFINITIONS_UPDATE, new DefinitionsUpdateVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.SCHEMA_CHECK, new SchemaCheckVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.MIGRATION_REQUEST, new MigrationRequestVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.SNAPSHOT, new SnapshotVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.ECHO, new EchoVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.BATCH_STORE, new BatchStoreVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.BATCH_REMOVE, new BatchRemoveVerbHandler());
        this.sstablesTracker = new SSTablesGlobalTracker(DatabaseDescriptor.getSSTableFormat());
    }

    public void registerDaemon(CassandraDaemon daemon) {
        this.daemon = daemon;
    }

    public void register(IEndpointLifecycleSubscriber subscriber) {
        this.lifecycleSubscribers.add(subscriber);
    }

    public void unregister(IEndpointLifecycleSubscriber subscriber) {
        this.lifecycleSubscribers.remove(subscriber);
    }

    @Override
    public void stopGossiping() {
        if (this.initialized) {
            if (!this.isNormal()) {
                throw new IllegalStateException("Unable to stop gossip because the node is not in the normal state. Try to stop the node instead.");
            }
            logger.warn("Stopping gossip by operator request");
            if (this.isNativeTransportRunning()) {
                logger.warn("Disabling gossip while native transport is still active is unsafe");
            }
            Gossiper.instance.stop();
            this.initialized = false;
        }
    }

    @Override
    public synchronized void startGossiping() {
        if (!this.initialized) {
            boolean validTokens;
            this.checkServiceAllowedToStart("gossip");
            logger.warn("Starting gossip by operator request");
            Collection<Token> tokens = SystemKeyspace.getSavedTokens();
            boolean bl = validTokens = tokens != null && !tokens.isEmpty();
            if (this.joined || joinRing) assert (validTokens) : "Cannot start gossiping for a node intended to join without valid tokens";
            if (validTokens) {
                this.setGossipTokens(tokens);
            }
            Gossiper.instance.forceNewerGeneration();
            Gossiper.instance.start((int)(System.currentTimeMillis() / 1000L));
            this.initialized = true;
        }
    }

    @Override
    public boolean isGossipRunning() {
        return Gossiper.instance.isEnabled();
    }

    @Override
    public synchronized void startRPCServer() {
        this.checkServiceAllowedToStart("thrift");
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        if (instance.hasJoined()) {
            if (instance.isSurveyMode()) {
                if (instance.isBootstrapMode() || DatabaseDescriptor.getAuthenticator().requireAuthentication()) {
                    throw new IllegalStateException("Not starting RPC server in write_survey mode as it's bootstrapping or auth is enabled");
                }
            } else if (!SystemKeyspace.bootstrapComplete()) {
                throw new IllegalStateException("Node is not yet bootstrapped completely. Use nodetool to check bootstrap state and resume. For more, see `nodetool help bootstrap`");
            }
        }
        this.daemon.startThriftServer();
    }

    @Override
    public void stopRPCServer() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        this.daemon.stopThriftServer();
    }

    @Override
    public boolean isRPCServerRunning() {
        if (this.daemon == null) {
            return false;
        }
        return this.daemon.isThriftServerRunning();
    }

    @Override
    public synchronized void startNativeTransport() {
        this.checkServiceAllowedToStart("native transport");
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        try {
            this.daemon.startNativeTransport();
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting native transport: " + e.getMessage());
        }
    }

    @Override
    public void stopNativeTransport() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        this.daemon.stopNativeTransport();
    }

    @Override
    public boolean isNativeTransportRunning() {
        if (this.daemon == null) {
            return false;
        }
        return this.daemon.isNativeTransportRunning();
    }

    @Override
    public int getMaxNativeProtocolVersion() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        return this.daemon.getMaxNativeProtocolVersion();
    }

    private void refreshMaxNativeProtocolVersion() {
        if (this.daemon != null) {
            this.daemon.refreshMaxNativeProtocolVersion();
        }
    }

    public void stopTransports() {
        if (this.isRPCServerRunning()) {
            logger.error("Stopping RPC server");
            this.stopRPCServer();
        }
        if (this.isNativeTransportRunning()) {
            logger.error("Stopping native transport");
            this.stopNativeTransport();
        }
        if (this.isInitialized()) {
            logger.error("Stopping gossiper");
            this.stopGossiping();
        }
    }

    private void shutdownClientServers() {
        this.setRpcReady(false);
        this.stopRPCServer();
        this.stopNativeTransport();
    }

    public void stopClient() {
        Gossiper.instance.unregister(this);
        Gossiper.instance.stop();
        MessagingService.instance().shutdown();
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        StageManager.shutdownNow();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isSetupCompleted() {
        return this.daemon == null ? false : this.daemon.setupCompleted();
    }

    @Override
    public void stopDaemon() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        this.daemon.deactivate();
    }

    public synchronized Collection<Token> prepareReplacementInfo() throws ConfigurationException {
        logger.info("Gathering node replacement information for {}", (Object)DatabaseDescriptor.getReplaceAddress());
        if (!MessagingService.instance().isListening()) {
            MessagingService.instance().listen();
        }
        if (!this.shouldBootstrap() && !Boolean.getBoolean("cassandra.allow_unsafe_replace")) {
            throw new RuntimeException("Replacing a node without bootstrapping risks invalidating consistency guarantees as the expected data may not be present until repair is run. To perform this operation, please restart with -Dcassandra.allow_unsafe_replace=true");
        }
        Map<InetAddress, EndpointState> epStates = Gossiper.instance.doShadowRound();
        if (epStates.get(DatabaseDescriptor.getReplaceAddress()) == null) {
            throw new RuntimeException("Cannot replace_address " + DatabaseDescriptor.getReplaceAddress() + " because it doesn't exist in gossip");
        }
        this.replacingId = Gossiper.instance.getHostId(DatabaseDescriptor.getReplaceAddress(), epStates);
        try {
            VersionedValue tokensVersionedValue = epStates.get(DatabaseDescriptor.getReplaceAddress()).getApplicationState(ApplicationState.TOKENS);
            if (tokensVersionedValue == null) {
                throw new RuntimeException("Could not find tokens for " + DatabaseDescriptor.getReplaceAddress() + " to replace");
            }
            Collection<Token> tokens = TokenSerializer.deserialize(this.tokenMetadata.partitioner, new DataInputStream(new ByteArrayInputStream(tokensVersionedValue.toBytes())));
            if (StorageService.isReplacingSameAddress()) {
                SystemKeyspace.setLocalHostId(this.replacingId);
            }
            return tokens;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void checkForEndpointCollision() throws ConfigurationException {
        logger.debug("Starting shadow gossip round to check for endpoint collision");
        if (!MessagingService.instance().isListening()) {
            MessagingService.instance().listen();
        }
        Map<InetAddress, EndpointState> epStates = Gossiper.instance.doShadowRound();
        if (!Gossiper.instance.isSafeForBootstrap(FBUtilities.getBroadcastAddress(), epStates)) {
            throw new RuntimeException(String.format("A node with address %s already exists, cancelling join. Use cassandra.replace_address if you want to replace this node.", FBUtilities.getBroadcastAddress()));
        }
        if (this.useStrictConsistency && !this.allowSimultaneousMoves()) {
            for (Map.Entry<InetAddress, EndpointState> entry : epStates.entrySet()) {
                if (entry.getKey().equals(FBUtilities.getBroadcastAddress()) || entry.getValue().getApplicationState(ApplicationState.STATUS) == null) continue;
                String[] pieces = StorageService.splitValue(entry.getValue().getApplicationState(ApplicationState.STATUS));
                assert (pieces.length > 0);
                String state = pieces[0];
                if (!state.equals("BOOT") && !state.equals("LEAVING") && !state.equals("MOVING")) continue;
                throw new UnsupportedOperationException("Other bootstrapping/leaving/moving nodes detected, cannot bootstrap while cassandra.consistent.rangemovement is true");
            }
        }
    }

    private boolean allowSimultaneousMoves() {
        return allowSimultaneousMoves && DatabaseDescriptor.getNumTokens() == 1;
    }

    public void unsafeInitialize() throws ConfigurationException {
        this.initialized = true;
        Gossiper.instance.register(this);
        Gossiper.instance.start((int)(System.currentTimeMillis() / 1000L));
        Gossiper.instance.addLocalApplicationState(ApplicationState.NET_VERSION, this.valueFactory.networkVersion());
        if (!MessagingService.instance().isListening()) {
            MessagingService.instance().listen();
        }
    }

    public void populateTokenMetadata() {
        if (Boolean.parseBoolean(System.getProperty("cassandra.load_ring_state", "true"))) {
            logger.info("Populating token metadata from system tables");
            SetMultimap<InetAddress, Token> loadedTokens = SystemKeyspace.loadTokens();
            if (!this.shouldBootstrap()) {
                loadedTokens.putAll((Object)FBUtilities.getBroadcastAddress(), SystemKeyspace.getSavedTokens());
            }
            for (InetAddress ep : loadedTokens.keySet()) {
                this.tokenMetadata.updateNormalTokens(loadedTokens.get((Object)ep), ep);
            }
            logger.info("Token metadata: {}", (Object)this.tokenMetadata);
        }
    }

    public synchronized void initServer() throws ConfigurationException {
        this.initServer(RING_DELAY);
    }

    public synchronized void initServer(int delay) throws ConfigurationException {
        logger.info("Cassandra version: {}", (Object)FBUtilities.getReleaseVersionString());
        logger.info("Thrift API version: {}", (Object)"20.1.0");
        logger.info("CQL supported versions: {} (default: {})", (Object)StringUtils.join((Object[])ClientState.getCQLSupportedVersion(), (String)","), (Object)ClientState.DEFAULT_CQL_VERSION);
        this.initialized = true;
        try {
            Class.forName("org.apache.cassandra.service.StorageProxy");
            Class.forName("org.apache.cassandra.io.sstable.IndexSummaryManager");
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        if (Boolean.parseBoolean(System.getProperty("cassandra.load_ring_state", "true"))) {
            logger.info("Loading persisted ring state");
            SetMultimap<InetAddress, Token> loadedTokens = SystemKeyspace.loadTokens();
            Map<InetAddress, UUID> loadedHostIds = SystemKeyspace.loadHostIds();
            for (InetAddress ep : loadedTokens.keySet()) {
                if (ep.equals(FBUtilities.getBroadcastAddress())) {
                    SystemKeyspace.removeEndpoint(ep);
                    continue;
                }
                if (loadedHostIds.containsKey(ep)) {
                    this.tokenMetadata.updateHostId(loadedHostIds.get(ep), ep);
                }
                Gossiper.runInGossipStageBlocking(() -> Gossiper.instance.addSavedEndpoint(ep));
            }
        }
        this.drainOnShutdown = new Thread(NamedThreadFactory.threadLocalDeallocator(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws InterruptedException, ExecutionException, IOException {
                StorageService.this.drain(true);
                if (FBUtilities.isWindows()) {
                    WindowsTimer.endTimerPeriod(DatabaseDescriptor.getWindowsTimerInterval());
                }
                DelayingShutdownHook logbackHook = new DelayingShutdownHook();
                logbackHook.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
                logbackHook.run();
                ScheduledExecutors.nonPeriodicTasks.shutdown();
                if (!ScheduledExecutors.nonPeriodicTasks.awaitTermination(1L, TimeUnit.MINUTES)) {
                    logger.warn("Miscellaneous task executor still busy after one minute; proceeding with shutdown");
                }
            }
        }), "StorageServiceShutdownHook");
        Runtime.getRuntime().addShutdownHook(this.drainOnShutdown);
        this.replacing = DatabaseDescriptor.isReplacing();
        if (!Boolean.parseBoolean(System.getProperty("cassandra.start_gossip", "true"))) {
            logger.info("Not starting gossip as requested.");
            return;
        }
        this.prepareToJoin();
        try {
            CacheService.instance.counterCache.loadSavedAsync().get();
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            logger.warn("Error loading counter cache", t);
        }
        if (joinRing) {
            this.joinTokenRing(delay);
        } else {
            Collection<Token> tokens = SystemKeyspace.getSavedTokens();
            if (!tokens.isEmpty()) {
                this.tokenMetadata.updateNormalTokens(tokens, FBUtilities.getBroadcastAddress());
                ArrayList<Pair<ApplicationState, VersionedValue>> states = new ArrayList<Pair<ApplicationState, VersionedValue>>();
                states.add(Pair.create(ApplicationState.TOKENS, this.valueFactory.tokens(tokens)));
                states.add(Pair.create(ApplicationState.STATUS, this.valueFactory.hibernate(true)));
                Gossiper.instance.addLocalApplicationStates(states);
            }
            this.doAuthSetup(true);
            logger.info("Not joining ring as requested. Use JMX (StorageService->joinRing()) to initiate ring joining");
        }
    }

    public void removeShutdownHook() {
        if (this.drainOnShutdown != null) {
            Runtime.getRuntime().removeShutdownHook(this.drainOnShutdown);
        }
        if (FBUtilities.isWindows()) {
            WindowsTimer.endTimerPeriod(DatabaseDescriptor.getWindowsTimerInterval());
        }
    }

    private boolean shouldBootstrap() {
        return DatabaseDescriptor.isAutoBootstrap() && !SystemKeyspace.bootstrapComplete() && !DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress());
    }

    @VisibleForTesting
    public void prepareToJoin() throws ConfigurationException {
        MigrationCoordinator.instance.start();
        if (!this.joined) {
            EnumMap<ApplicationState, VersionedValue> appStates = new EnumMap<ApplicationState, VersionedValue>(ApplicationState.class);
            if (SystemKeyspace.wasDecommissioned()) {
                if (Boolean.getBoolean("cassandra.override_decommission")) {
                    logger.warn("This node was decommissioned, but overriding by operator request.");
                    SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.COMPLETED);
                } else {
                    throw new ConfigurationException("This node was decommissioned and will not rejoin the ring unless cassandra.override_decommission=true has been set, or all existing data is removed and the node is bootstrapped again");
                }
            }
            if (this.replacing && !joinRing) {
                throw new ConfigurationException("Cannot set both join_ring=false and attempt to replace a node");
            }
            if (DatabaseDescriptor.getReplaceTokens().size() > 0 || DatabaseDescriptor.getReplaceNode() != null) {
                throw new RuntimeException("Replace method removed; use cassandra.replace_address instead");
            }
            if (this.replacing) {
                if (SystemKeyspace.bootstrapComplete()) {
                    throw new RuntimeException("Cannot replace address with a node that is already bootstrapped");
                }
                this.bootstrapTokens = this.prepareReplacementInfo();
                if (!this.shouldBootstrap()) {
                    SystemKeyspace.updateTokens(this.bootstrapTokens);
                }
                if (StorageService.isReplacingSameAddress()) {
                    logger.warn("Writes will not be forwarded to this node during replacement because it has the same address as the node to be replaced ({}). If the previous node has been down for longer than max_hint_window_in_ms, repair must be run after the replacement process in order to make this node consistent.", (Object)DatabaseDescriptor.getReplaceAddress());
                    appStates.put(ApplicationState.TOKENS, this.valueFactory.tokens(this.bootstrapTokens));
                    appStates.put(ApplicationState.STATUS, this.valueFactory.hibernate(true));
                }
                MigrationCoordinator.instance.removeAndIgnoreEndpoint(DatabaseDescriptor.getReplaceAddress());
            } else if (this.shouldBootstrap()) {
                this.checkForEndpointCollision();
            } else if (SystemKeyspace.bootstrapComplete()) {
                Preconditions.checkState((!Config.isClientMode() ? 1 : 0) != 0);
                Collection<Token> savedTokens = SystemKeyspace.getSavedTokens();
                if (!savedTokens.isEmpty()) {
                    appStates.put(ApplicationState.TOKENS, this.valueFactory.tokens(savedTokens));
                }
            }
            UUID localHostId = SystemKeyspace.getOrInitializeLocalHostId();
            this.getTokenMetadata().updateHostId(localHostId, FBUtilities.getBroadcastAddress());
            appStates.put(ApplicationState.NET_VERSION, this.valueFactory.networkVersion());
            appStates.put(ApplicationState.HOST_ID, this.valueFactory.hostId(localHostId));
            appStates.put(ApplicationState.RPC_ADDRESS, this.valueFactory.rpcaddress(FBUtilities.getBroadcastRpcAddress()));
            appStates.put(ApplicationState.RELEASE_VERSION, this.valueFactory.releaseVersion());
            appStates.put(ApplicationState.SSTABLE_VERSIONS, this.valueFactory.sstableVersions(this.sstablesTracker.versionsInUse()));
            logger.info("Starting up server gossip");
            Gossiper.instance.register(this);
            Gossiper.instance.start(SystemKeyspace.incrementAndGetGeneration(), appStates);
            this.sstablesTracker.register((INotification notification, Object o) -> {
                if (!(notification instanceof SSTablesVersionsInUseChangeNotification)) {
                    return;
                }
                ImmutableSet<VersionAndType> versions = ((SSTablesVersionsInUseChangeNotification)notification).versionsInUse;
                logger.debug("Updating local sstables version in Gossip to {}", versions);
                Gossiper.instance.addLocalApplicationState(ApplicationState.SSTABLE_VERSIONS, this.valueFactory.sstableVersions((Set<VersionAndType>)versions));
            });
            this.gossipSnitchInfo();
            Schema.instance.updateVersionAndAnnounce();
            if (!MessagingService.instance().isListening()) {
                MessagingService.instance().listen();
            }
            LoadBroadcaster.instance.startBroadcasting();
            HintsService.instance.startDispatch();
            BatchlogManager.instance.start();
        }
    }

    public void waitForSchema(int delay) {
        boolean schemasReceived;
        for (long i = 0L; i < (long)delay; i += 1000L) {
            if (!Schema.instance.isEmpty()) {
                logger.debug("current schema version: {}", (Object)Schema.instance.getVersion());
                break;
            }
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        if (schemasReceived = MigrationCoordinator.instance.awaitSchemaRequests(SCHEMA_DELAY_MILLIS)) {
            return;
        }
        logger.warn(String.format("There are nodes in the cluster with a different schema version than us we did not merged schemas from, our version : (%s), outstanding versions -> endpoints : %s. Use -Dcassandra.skip_schema_check=true to ignore this, -Dcassandra.skip_schema_check_for_endpoints=<ep1[,epN]> to skip specific endpoints,or -Dcassandra.skip_schema_check_for_versions=<ver1[,verN]> to skip specific schema versions", Schema.instance.getVersion(), MigrationCoordinator.instance.outstandingVersions()));
        if (REQUIRE_SCHEMAS) {
            throw new RuntimeException("Didn't receive schemas for all known versions within the timeout. Use -Dcassandra.skip_schema_check=true to skip this check.");
        }
    }

    @VisibleForTesting
    public void joinTokenRing(int delay) throws ConfigurationException {
        this.joined = true;
        HashSet<InetAddress> current = new HashSet<InetAddress>();
        if (logger.isDebugEnabled()) {
            logger.debug("Bootstrap variables: {} {} {} {}", new Object[]{DatabaseDescriptor.isAutoBootstrap(), SystemKeyspace.bootstrapInProgress(), SystemKeyspace.bootstrapComplete(), DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress())});
        }
        if (DatabaseDescriptor.isAutoBootstrap() && !SystemKeyspace.bootstrapComplete() && DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress())) {
            logger.info("This node will not auto bootstrap because it is configured to be a seed node.");
        }
        boolean dataAvailable = true;
        if (this.shouldBootstrap()) {
            if (SystemKeyspace.bootstrapInProgress()) {
                logger.warn("Detected previous bootstrap failure; retrying");
            } else {
                SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.IN_PROGRESS);
            }
            this.setMode(Mode.JOINING, "waiting for ring information", true);
            for (int i = 0; i < delay; i += 1000) {
                if (!Schema.instance.getVersion().equals(Schema.emptyVersion)) {
                    logger.debug("got schema: {}", (Object)Schema.instance.getVersion());
                    break;
                }
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            this.waitForSchema(delay);
            this.setMode(Mode.JOINING, "schema complete, ready to bootstrap", true);
            this.setMode(Mode.JOINING, "waiting for pending range calculation", true);
            PendingRangeCalculatorService.instance.blockUntilFinished();
            this.setMode(Mode.JOINING, "calculation complete, ready to bootstrap", true);
            logger.debug("... got ring + schema info");
            if (this.useStrictConsistency && !this.allowSimultaneousMoves() && (this.tokenMetadata.getBootstrapTokens().valueSet().size() > 0 || this.tokenMetadata.getLeavingEndpoints().size() > 0 || this.tokenMetadata.getMovingEndpoints().size() > 0)) {
                throw new UnsupportedOperationException("Other bootstrapping/leaving/moving nodes detected, cannot bootstrap while cassandra.consistent.rangemovement is true");
            }
            if (!this.replacing) {
                if (this.tokenMetadata.isMember(FBUtilities.getBroadcastAddress())) {
                    String s = "This node is already a member of the token ring; bootstrap aborted. (If replacing a dead node, remove the old one from the ring first.)";
                    throw new UnsupportedOperationException(s);
                }
                this.setMode(Mode.JOINING, "getting bootstrap token", true);
                this.bootstrapTokens = BootStrapper.getBootstrapTokens(this.tokenMetadata, FBUtilities.getBroadcastAddress());
            } else {
                if (!StorageService.isReplacingSameAddress()) {
                    try {
                        Thread.sleep(LoadBroadcaster.BROADCAST_INTERVAL);
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                    for (Token token : this.bootstrapTokens) {
                        InetAddress existing = this.tokenMetadata.getEndpoint(token);
                        if (existing != null) {
                            long nanoDelay = (long)delay * 1000000L;
                            if (Gossiper.instance.getEndpointStateForEndpoint(existing).getUpdateTimestamp() > System.nanoTime() - nanoDelay) {
                                throw new UnsupportedOperationException("Cannot replace a live node... ");
                            }
                            current.add(existing);
                            continue;
                        }
                        throw new UnsupportedOperationException("Cannot replace token " + token + " which does not exist!");
                    }
                } else {
                    try {
                        Thread.sleep(RING_DELAY);
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                this.setMode(Mode.JOINING, "Replacing a node with token(s): " + this.bootstrapTokens, true);
            }
            dataAvailable = this.bootstrap(this.bootstrapTokens);
        } else {
            this.bootstrapTokens = SystemKeyspace.getSavedTokens();
            if (this.bootstrapTokens.isEmpty()) {
                Collection<String> initialTokens = DatabaseDescriptor.getInitialTokens();
                if (initialTokens.size() < 1) {
                    this.bootstrapTokens = BootStrapper.getRandomTokens(this.tokenMetadata, DatabaseDescriptor.getNumTokens());
                    if (DatabaseDescriptor.getNumTokens() == 1) {
                        logger.warn("Generated random token {}. Random tokens will result in an unbalanced ring; see http://wiki.apache.org/cassandra/Operations", this.bootstrapTokens);
                    } else {
                        logger.info("Generated random tokens. tokens are {}", this.bootstrapTokens);
                    }
                } else {
                    this.bootstrapTokens = new ArrayList<Token>(initialTokens.size());
                    for (String token : initialTokens) {
                        this.bootstrapTokens.add(this.getTokenFactory().fromString(token));
                    }
                    logger.info("Saved tokens not found. Using configuration value: {}", this.bootstrapTokens);
                }
            } else {
                if (this.bootstrapTokens.size() != DatabaseDescriptor.getNumTokens().intValue()) {
                    throw new ConfigurationException("Cannot change the number of tokens from " + this.bootstrapTokens.size() + " to " + DatabaseDescriptor.getNumTokens());
                }
                logger.info("Using saved tokens {}", this.bootstrapTokens);
            }
        }
        this.setUpDistributedSystemKeyspaces();
        if (!this.isSurveyMode) {
            if (dataAvailable) {
                this.finishJoiningRing(this.bootstrapTokens);
                if (!current.isEmpty()) {
                    Gossiper.runInGossipStageBlocking(() -> {
                        for (InetAddress existing : current) {
                            Gossiper.instance.replacedEndpoint(existing);
                        }
                    });
                }
            } else {
                logger.warn("Some data streaming failed. Use nodetool to check bootstrap state and resume. For more, see `nodetool help bootstrap`. {}", (Object)SystemKeyspace.getBootstrapState());
            }
        } else if (dataAvailable) {
            logger.info("Startup complete, but write survey mode is active, not becoming an active ring member. Use JMX (StorageService->joinRing()) to finalize ring joining.");
        } else {
            logger.warn("Some data streaming failed. Use nodetool to check bootstrap state and resume. For more, see `nodetool help bootstrap`. {}", (Object)SystemKeyspace.getBootstrapState());
        }
    }

    @VisibleForTesting
    public void ensureTraceKeyspace() {
        Optional<Mutation> mutation = MigrationManager.evolveSystemKeyspace(TraceKeyspace.metadata(), 1577836800000001L);
        mutation.ifPresent(value -> FBUtilities.waitOnFuture(MigrationManager.announceWithoutPush(Collections.singleton(value))));
    }

    public static boolean isReplacingSameAddress() {
        return DatabaseDescriptor.getReplaceAddress().equals(FBUtilities.getBroadcastAddress());
    }

    public void gossipSnitchInfo() {
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        String dc = snitch.getDatacenter(FBUtilities.getBroadcastAddress());
        String rack = snitch.getRack(FBUtilities.getBroadcastAddress());
        Gossiper.instance.addLocalApplicationState(ApplicationState.DC, StorageService.instance.valueFactory.datacenter(dc));
        Gossiper.instance.addLocalApplicationState(ApplicationState.RACK, StorageService.instance.valueFactory.rack(rack));
    }

    @Override
    public synchronized void joinRing() throws IOException {
        if (!this.joined) {
            logger.info("Joining ring by operator request");
            try {
                this.joinTokenRing(0);
            }
            catch (ConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        } else if (this.isSurveyMode) {
            if (!this.isBootstrapMode()) {
                this.isSurveyMode = false;
                logger.info("Leaving write survey mode and joining ring at operator request");
                this.finishJoiningRing(SystemKeyspace.getSavedTokens());
                this.daemon.start();
            } else {
                logger.warn("Can't join the ring because in write_survey mode and bootstrap hasn't completed");
            }
        } else if (this.isBootstrapMode()) {
            logger.warn("Can't join the ring because bootstrap hasn't completed.");
        }
    }

    private void finishJoiningRing(Collection<Token> tokens) {
        SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.COMPLETED);
        this.setTokens(tokens);
        assert (this.tokenMetadata.sortedTokens().size() > 0);
        this.doAuthSetup(false);
    }

    private void doAuthSetup(boolean setUpSchema) {
        if (!this.authSetupCalled.getAndSet(true)) {
            if (setUpSchema) {
                Optional<Mutation> mutation = MigrationManager.evolveSystemKeyspace(AuthKeyspace.metadata(), 0L);
                mutation.ifPresent(value -> FBUtilities.waitOnFuture(MigrationManager.announceWithoutPush(Collections.singleton(value))));
            }
            DatabaseDescriptor.getRoleManager().setup();
            DatabaseDescriptor.getAuthenticator().setup();
            DatabaseDescriptor.getAuthorizer().setup();
            MigrationManager.instance.register(new AuthMigrationListener());
        }
    }

    private void setUpDistributedSystemKeyspaces() {
        ArrayList<Mutation> changes = new ArrayList<Mutation>(3);
        MigrationManager.evolveSystemKeyspace(TraceKeyspace.metadata(), 1577836800000001L).ifPresent(changes::add);
        MigrationManager.evolveSystemKeyspace(SystemDistributedKeyspace.metadata(), 2L).ifPresent(changes::add);
        MigrationManager.evolveSystemKeyspace(AuthKeyspace.metadata(), 0L).ifPresent(changes::add);
        if (!changes.isEmpty()) {
            FBUtilities.waitOnFuture(MigrationManager.announceWithoutPush(changes));
        }
    }

    @Override
    public boolean isJoined() {
        return this.tokenMetadata.isMember(FBUtilities.getBroadcastAddress()) && !this.isSurveyMode;
    }

    @Override
    public void rebuild(String sourceDc) {
        if (!this.isRebuilding.compareAndSet(false, true)) {
            throw new IllegalStateException("Node is still rebuilding. Check nodetool netstats.");
        }
        logger.info("rebuild from dc: {}", (Object)(sourceDc == null ? "(any dc)" : sourceDc));
        try {
            RangeStreamer streamer = new RangeStreamer(this.tokenMetadata, null, FBUtilities.getBroadcastAddress(), "Rebuild", !this.replacing && this.useStrictConsistency, DatabaseDescriptor.getEndpointSnitch(), this.streamStateStore);
            streamer.addSourceFilter(new RangeStreamer.FailureDetectorSourceFilter(FailureDetector.instance));
            if (sourceDc != null) {
                streamer.addSourceFilter(new RangeStreamer.SingleDatacenterFilter(DatabaseDescriptor.getEndpointSnitch(), sourceDc));
            }
            for (String keyspaceName : Schema.instance.getNonLocalStrategyKeyspaces()) {
                streamer.addRanges(keyspaceName, this.getLocalRanges(keyspaceName));
            }
            StreamResultFuture resultFuture = streamer.fetchAsync();
            resultFuture.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting on rebuild streaming");
        }
        catch (ExecutionException e) {
            logger.error("Error while rebuilding node", e.getCause());
            throw new RuntimeException("Error while rebuilding node: " + e.getCause().getMessage());
        }
        finally {
            this.isRebuilding.set(false);
        }
    }

    @Override
    public void setStreamThroughputMbPerSec(int value) {
        int oldValue = DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSec();
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(value);
        StreamManager.StreamRateLimiter.updateThroughput();
        logger.info("setstreamthroughput: throttle set to {} Mb/s (was {} Mb/s)", (Object)value, (Object)oldValue);
    }

    @Override
    public int getStreamThroughputMbPerSec() {
        return DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSec();
    }

    @Override
    public void setInterDCStreamThroughputMbPerSec(int value) {
        int oldValue = DatabaseDescriptor.getInterDCStreamThroughputOutboundMegabitsPerSec();
        DatabaseDescriptor.setInterDCStreamThroughputOutboundMegabitsPerSec(value);
        StreamManager.StreamRateLimiter.updateInterDCThroughput();
        logger.info("setinterdcstreamthroughput: throttle set to {} Mb/s (was {} Mb/s)", (Object)value, (Object)oldValue);
    }

    @Override
    public int getInterDCStreamThroughputMbPerSec() {
        return DatabaseDescriptor.getInterDCStreamThroughputOutboundMegabitsPerSec();
    }

    @Override
    public int getConcurrentCompactors() {
        return DatabaseDescriptor.getConcurrentCompactors();
    }

    @Override
    public int getCompactionThroughputMbPerSec() {
        return DatabaseDescriptor.getCompactionThroughputMbPerSec();
    }

    @Override
    public void setCompactionThroughputMbPerSec(int value) {
        DatabaseDescriptor.setCompactionThroughputMbPerSec(value);
        CompactionManager.instance.setRate(value);
    }

    @Override
    public boolean isIncrementalBackupsEnabled() {
        return DatabaseDescriptor.isIncrementalBackupsEnabled();
    }

    @Override
    public void setIncrementalBackupsEnabled(boolean value) {
        DatabaseDescriptor.setIncrementalBackupsEnabled(value);
    }

    @VisibleForTesting
    public void setMovingModeUnsafe() {
        this.setMode(Mode.MOVING, true);
    }

    @VisibleForTesting
    public void setNormalModeUnsafe() {
        this.setMode(Mode.NORMAL, true);
    }

    private void setMode(Mode m, boolean log) {
        this.setMode(m, null, log);
    }

    private void setMode(Mode m, String msg, boolean log) {
        String logMsg;
        this.operationMode = m;
        String string = logMsg = msg == null ? m.toString() : String.format("%s: %s", new Object[]{m, msg});
        if (log) {
            logger.info(logMsg);
        } else {
            logger.debug(logMsg);
        }
    }

    private boolean bootstrap(Collection<Token> tokens) {
        this.isBootstrapMode = true;
        SystemKeyspace.updateTokens(tokens);
        if (!this.replacing || !StorageService.isReplacingSameAddress()) {
            ArrayList<Pair<ApplicationState, VersionedValue>> states = new ArrayList<Pair<ApplicationState, VersionedValue>>();
            states.add(Pair.create(ApplicationState.TOKENS, this.valueFactory.tokens(tokens)));
            states.add(Pair.create(ApplicationState.STATUS, this.replacing ? this.valueFactory.bootReplacing(DatabaseDescriptor.getReplaceAddress()) : this.valueFactory.bootstrapping(tokens)));
            Gossiper.instance.addLocalApplicationStates(states);
            this.setMode(Mode.JOINING, "sleeping " + RING_DELAY + " ms for pending range setup", true);
            Uninterruptibles.sleepUninterruptibly((long)RING_DELAY, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            this.tokenMetadata.updateNormalTokens(tokens, FBUtilities.getBroadcastAddress());
            SystemKeyspace.removeEndpoint(DatabaseDescriptor.getReplaceAddress());
        }
        if (!Gossiper.instance.seenAnySeed()) {
            throw new IllegalStateException("Unable to contact any seeds!");
        }
        if (Boolean.getBoolean("cassandra.reset_bootstrap_progress")) {
            logger.info("Resetting bootstrap progress to start fresh");
            SystemKeyspace.resetAvailableRanges();
        }
        this.setMode(Mode.JOINING, "Starting to bootstrap...", true);
        BootStrapper bootstrapper = new BootStrapper(FBUtilities.getBroadcastAddress(), tokens, this.tokenMetadata);
        bootstrapper.addProgressListener(this.progressSupport);
        ListenableFuture<StreamState> bootstrapStream = bootstrapper.bootstrap(this.streamStateStore, !this.replacing && this.useStrictConsistency);
        try {
            bootstrapStream.get();
            this.bootstrapFinished();
            logger.info("Bootstrap completed for tokens {}", tokens);
            return true;
        }
        catch (Throwable e) {
            logger.error("Error while waiting on bootstrap to complete. Bootstrap will have to be restarted.", e);
            return false;
        }
    }

    private void markViewsAsBuilt() {
        for (String keyspace : Schema.instance.getUserKeyspaces()) {
            for (ViewDefinition view : Schema.instance.getKSMetaData((String)keyspace).views) {
                SystemKeyspace.finishViewBuildStatus(view.ksName, view.viewName);
            }
        }
    }

    private void bootstrapFinished() {
        this.markViewsAsBuilt();
        this.isBootstrapMode = false;
    }

    @Override
    public boolean resumeBootstrap() {
        if (this.isBootstrapMode && SystemKeyspace.bootstrapInProgress()) {
            logger.info("Resuming bootstrap...");
            Collection<Token> tokens = SystemKeyspace.getSavedTokens();
            BootStrapper bootstrapper = new BootStrapper(FBUtilities.getBroadcastAddress(), tokens, this.tokenMetadata);
            bootstrapper.addProgressListener(this.progressSupport);
            ListenableFuture<StreamState> bootstrapStream = bootstrapper.bootstrap(this.streamStateStore, !this.replacing && this.useStrictConsistency);
            Futures.addCallback(bootstrapStream, (FutureCallback)new FutureCallback<StreamState>(){

                public void onSuccess(StreamState streamState) {
                    try {
                        StorageService.this.bootstrapFinished();
                        if (StorageService.this.isSurveyMode) {
                            logger.info("Startup complete, but write survey mode is active, not becoming an active ring member. Use JMX (StorageService->joinRing()) to finalize ring joining.");
                        } else {
                            StorageService.this.isSurveyMode = false;
                            StorageService.this.progressSupport.progress("bootstrap", ProgressEvent.createNotification("Joining ring..."));
                            StorageService.this.finishJoiningRing(StorageService.this.bootstrapTokens);
                        }
                        StorageService.this.progressSupport.progress("bootstrap", new ProgressEvent(ProgressEventType.COMPLETE, 1, 1, "Resume bootstrap complete"));
                        if (!StorageService.this.isNativeTransportRunning()) {
                            StorageService.this.daemon.initializeClientTransports();
                        }
                        StorageService.this.daemon.start();
                        logger.info("Resume complete");
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                        throw e;
                    }
                }

                public void onFailure(Throwable e) {
                    String message = "Error during bootstrap: ";
                    message = e instanceof ExecutionException && e.getCause() != null ? message + e.getCause().getMessage() : message + e.getMessage();
                    logger.error(message, e);
                    StorageService.this.progressSupport.progress("bootstrap", new ProgressEvent(ProgressEventType.ERROR, 1, 1, message));
                    StorageService.this.progressSupport.progress("bootstrap", new ProgressEvent(ProgressEventType.COMPLETE, 1, 1, "Resume bootstrap complete"));
                }
            });
            return true;
        }
        logger.info("Resuming bootstrap is requested, but the node is already bootstrapped.");
        return false;
    }

    @Override
    public boolean isBootstrapMode() {
        return this.isBootstrapMode;
    }

    public TokenMetadata getTokenMetadata() {
        return this.tokenMetadata;
    }

    public void reportSeverity(double incr) {
        bgMonitor.incrCompactionSeverity(incr);
    }

    public void reportManualSeverity(double incr) {
        bgMonitor.incrManualSeverity(incr);
    }

    public double getSeverity(InetAddress endpoint) {
        return bgMonitor.getSeverity(endpoint);
    }

    public void shutdownBGMonitorAndWait(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        bgMonitor.shutdownAndWait(timeout, unit);
    }

    @Override
    public Map<List<String>, List<String>> getRangeToEndpointMap(String keyspace) {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            map.put(entry.getKey().asList(), this.stringify((Iterable<InetAddress>)entry.getValue()));
        }
        return map;
    }

    public String getRpcaddress(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return FBUtilities.getBroadcastRpcAddress().getHostAddress();
        }
        if (Gossiper.instance.getEndpointStateForEndpoint(endpoint).getApplicationState(ApplicationState.RPC_ADDRESS) == null) {
            return endpoint.getHostAddress();
        }
        return Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)ApplicationState.RPC_ADDRESS).value;
    }

    @Override
    public Map<List<String>, List<String>> getRangeToRpcaddressMap(String keyspace) {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            ArrayList<String> rpcaddrs = new ArrayList<String>(entry.getValue().size());
            for (InetAddress endpoint : entry.getValue()) {
                rpcaddrs.add(this.getRpcaddress(endpoint));
            }
            map.put(entry.getKey().asList(), rpcaddrs);
        }
        return map;
    }

    @Override
    public Map<List<String>, List<String>> getPendingRangeToEndpointMap(String keyspace) {
        if (keyspace == null) {
            keyspace = Schema.instance.getNonLocalStrategyKeyspaces().get(0);
        }
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry entry : this.tokenMetadata.getPendingRangesMM(keyspace).asMap().entrySet()) {
            ArrayList<InetAddress> l = new ArrayList<InetAddress>((Collection)entry.getValue());
            map.put(((Range)entry.getKey()).asList(), this.stringify(l));
        }
        return map;
    }

    public Map<Range<Token>, List<InetAddress>> getRangeToAddressMap(String keyspace) {
        return this.getRangeToAddressMap(keyspace, this.tokenMetadata.sortedTokens());
    }

    public Map<Range<Token>, List<InetAddress>> getRangeToAddressMapInLocalDC(String keyspace) {
        Predicate<InetAddress> isLocalDC = new Predicate<InetAddress>(){

            public boolean apply(InetAddress address) {
                return StorageService.this.isLocalDC(address);
            }
        };
        Map<Range<Token>, List<InetAddress>> origMap = this.getRangeToAddressMap(keyspace, this.getTokensInLocalDC());
        HashMap filteredMap = Maps.newHashMap();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : origMap.entrySet()) {
            ArrayList endpointsInLocalDC = Lists.newArrayList((Iterable)Collections2.filter((Collection)entry.getValue(), (Predicate)isLocalDC));
            filteredMap.put(entry.getKey(), endpointsInLocalDC);
        }
        return filteredMap;
    }

    private List<Token> getTokensInLocalDC() {
        ArrayList filteredTokens = Lists.newArrayList();
        for (Token token : this.tokenMetadata.sortedTokens()) {
            InetAddress endpoint = this.tokenMetadata.getEndpoint(token);
            if (!this.isLocalDC(endpoint)) continue;
            filteredTokens.add(token);
        }
        return filteredTokens;
    }

    private boolean isLocalDC(InetAddress targetHost) {
        String remoteDC = DatabaseDescriptor.getEndpointSnitch().getDatacenter(targetHost);
        String localDC = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        return remoteDC.equals(localDC);
    }

    private Map<Range<Token>, List<InetAddress>> getRangeToAddressMap(String keyspace, List<Token> sortedTokens) {
        if (keyspace == null) {
            keyspace = Schema.instance.getNonLocalStrategyKeyspaces().get(0);
        }
        List<Range<Token>> ranges = this.getAllRanges(sortedTokens);
        return this.constructRangeToEndpointMap(keyspace, ranges);
    }

    @Override
    public List<String> describeRingJMX(String keyspace) throws IOException {
        List<TokenRange> tokenRanges;
        try {
            tokenRanges = this.describeRing(keyspace);
        }
        catch (InvalidRequestException e) {
            throw new IOException(e.getMessage());
        }
        ArrayList<String> result = new ArrayList<String>(tokenRanges.size());
        for (TokenRange tokenRange : tokenRanges) {
            result.add(tokenRange.toString());
        }
        return result;
    }

    public List<TokenRange> describeRing(String keyspace) throws InvalidRequestException {
        return this.describeRing(keyspace, false);
    }

    public List<TokenRange> describeLocalRing(String keyspace) throws InvalidRequestException {
        return this.describeRing(keyspace, true);
    }

    private List<TokenRange> describeRing(String keyspace, boolean includeOnlyLocalDC) throws InvalidRequestException {
        if (!Schema.instance.getKeyspaces().contains(keyspace)) {
            throw new InvalidRequestException("No such keyspace: " + keyspace);
        }
        if (keyspace == null || Keyspace.open(keyspace).getReplicationStrategy() instanceof LocalStrategy) {
            throw new InvalidRequestException("There is no ring for the keyspace: " + keyspace);
        }
        ArrayList<TokenRange> ranges = new ArrayList<TokenRange>();
        Token.TokenFactory tf = this.getTokenFactory();
        Map<Range<Token>, List<InetAddress>> rangeToAddressMap = includeOnlyLocalDC ? this.getRangeToAddressMapInLocalDC(keyspace) : this.getRangeToAddressMap(keyspace);
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : rangeToAddressMap.entrySet()) {
            Range<Token> range = entry.getKey();
            List<InetAddress> addresses = entry.getValue();
            ArrayList<String> endpoints = new ArrayList<String>(addresses.size());
            ArrayList<String> rpc_endpoints = new ArrayList<String>(addresses.size());
            ArrayList<EndpointDetails> epDetails = new ArrayList<EndpointDetails>(addresses.size());
            for (InetAddress endpoint : addresses) {
                EndpointDetails details = new EndpointDetails();
                details.host = endpoint.getHostAddress();
                details.datacenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(endpoint);
                details.rack = DatabaseDescriptor.getEndpointSnitch().getRack(endpoint);
                endpoints.add(details.host);
                rpc_endpoints.add(this.getRpcaddress(endpoint));
                epDetails.add(details);
            }
            TokenRange tr = new TokenRange(tf.toString(((Token)range.left).getToken()), tf.toString(((Token)range.right).getToken()), endpoints).setEndpoint_details(epDetails).setRpc_endpoints(rpc_endpoints);
            ranges.add(tr);
        }
        return ranges;
    }

    @Override
    public Map<String, String> getTokenToEndpointMap() {
        Map<Token, InetAddress> mapInetAddress = this.tokenMetadata.getNormalAndBootstrappingTokenToEndpointMap();
        LinkedHashMap<String, String> mapString = new LinkedHashMap<String, String>(mapInetAddress.size());
        ArrayList<Token> tokens = new ArrayList<Token>(mapInetAddress.keySet());
        Collections.sort(tokens);
        for (Token token : tokens) {
            mapString.put(token.toString(), mapInetAddress.get(token).getHostAddress());
        }
        return mapString;
    }

    @Override
    public String getLocalHostId() {
        return this.getTokenMetadata().getHostId(FBUtilities.getBroadcastAddress()).toString();
    }

    public UUID getLocalHostUUID() {
        return this.getTokenMetadata().getHostId(FBUtilities.getBroadcastAddress());
    }

    @Override
    public Map<String, String> getHostIdMap() {
        return this.getEndpointToHostId();
    }

    @Override
    public Map<String, String> getEndpointToHostId() {
        HashMap<String, String> mapOut = new HashMap<String, String>();
        for (Map.Entry<InetAddress, UUID> entry : this.getTokenMetadata().getEndpointToHostIdMapForReading().entrySet()) {
            mapOut.put(entry.getKey().getHostAddress(), entry.getValue().toString());
        }
        return mapOut;
    }

    @Override
    public Map<String, String> getHostIdToEndpoint() {
        HashMap<String, String> mapOut = new HashMap<String, String>();
        for (Map.Entry<InetAddress, UUID> entry : this.getTokenMetadata().getEndpointToHostIdMapForReading().entrySet()) {
            mapOut.put(entry.getValue().toString(), entry.getKey().getHostAddress());
        }
        return mapOut;
    }

    private Map<Range<Token>, List<InetAddress>> constructRangeToEndpointMap(String keyspace, List<Range<Token>> ranges) {
        HashMap<Range<Token>, List<InetAddress>> rangeToEndpointMap = new HashMap<Range<Token>, List<InetAddress>>(ranges.size());
        for (Range<Token> range : ranges) {
            rangeToEndpointMap.put(range, Keyspace.open(keyspace).getReplicationStrategy().getNaturalEndpoints(range.right));
        }
        return rangeToEndpointMap;
    }

    @Override
    public void beforeChange(InetAddress endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        if (state == ApplicationState.STATUS) {
            String moveName;
            String[] pieces = StorageService.splitValue(value);
            assert (pieces.length > 0);
            switch (moveName = pieces[0]) {
                case "BOOT_REPLACE": {
                    this.handleStateBootreplacing(endpoint, pieces);
                    break;
                }
                case "BOOT": {
                    this.handleStateBootstrap(endpoint);
                    break;
                }
                case "NORMAL": {
                    this.handleStateNormal(endpoint, "NORMAL");
                    break;
                }
                case "shutdown": {
                    this.handleStateNormal(endpoint, "shutdown");
                    break;
                }
                case "removing": 
                case "removed": {
                    this.handleStateRemoving(endpoint, pieces);
                    break;
                }
                case "LEAVING": {
                    this.handleStateLeaving(endpoint);
                    break;
                }
                case "LEFT": {
                    this.handleStateLeft(endpoint, pieces);
                    break;
                }
                case "MOVING": {
                    this.handleStateMoving(endpoint, pieces);
                }
            }
        } else {
            EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
            if (epState == null || Gossiper.instance.isDeadState(epState)) {
                logger.debug("Ignoring state change for dead or unknown endpoint: {}", (Object)endpoint);
                return;
            }
            if (this.getTokenMetadata().isMember(endpoint)) {
                LocalAwareExecutorService executor = StageManager.getStage(Stage.MUTATION);
                switch (state) {
                    case RELEASE_VERSION: {
                        SystemKeyspace.updatePeerReleaseVersion(endpoint, value.value, this::refreshMaxNativeProtocolVersion, executor);
                        break;
                    }
                    case DC: {
                        this.updateTopology(endpoint);
                        SystemKeyspace.updatePeerInfo(endpoint, "data_center", value.value, executor);
                        break;
                    }
                    case RACK: {
                        this.updateTopology(endpoint);
                        SystemKeyspace.updatePeerInfo(endpoint, "rack", value.value, executor);
                        break;
                    }
                    case RPC_ADDRESS: {
                        try {
                            SystemKeyspace.updatePeerInfo(endpoint, "rpc_address", InetAddress.getByName(value.value), executor);
                            break;
                        }
                        catch (UnknownHostException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case SCHEMA: {
                        SystemKeyspace.updatePeerInfo(endpoint, "schema_version", UUID.fromString(value.value), executor);
                        MigrationCoordinator.instance.reportEndpointVersion(endpoint, UUID.fromString(value.value));
                        break;
                    }
                    case HOST_ID: {
                        SystemKeyspace.updatePeerInfo(endpoint, "host_id", UUID.fromString(value.value), executor);
                        break;
                    }
                    case RPC_READY: {
                        this.notifyRpcChange(endpoint, epState.isRpcReady());
                        break;
                    }
                    case NET_VERSION: {
                        this.updateNetVersion(endpoint, value);
                    }
                }
            }
        }
    }

    private static String[] splitValue(VersionedValue value) {
        return value.value.split(VersionedValue.DELIMITER_STR, -1);
    }

    private void updateNetVersion(InetAddress endpoint, VersionedValue value) {
        try {
            MessagingService.instance().setVersion(endpoint, Integer.valueOf(value.value));
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)("Got invalid value for NET_VERSION application state: " + value.value));
        }
    }

    public void updateTopology(InetAddress endpoint) {
        if (this.getTokenMetadata().isMember(endpoint)) {
            this.getTokenMetadata().updateTopology(endpoint);
        }
    }

    public void updateTopology() {
        this.getTokenMetadata().updateTopology();
    }

    private void updatePeerInfo(InetAddress endpoint) {
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        LocalAwareExecutorService executor = StageManager.getStage(Stage.MUTATION);
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.states()) {
            switch (entry.getKey()) {
                case RELEASE_VERSION: {
                    SystemKeyspace.updatePeerReleaseVersion(endpoint, entry.getValue().value, this::refreshMaxNativeProtocolVersion, executor);
                    break;
                }
                case DC: {
                    SystemKeyspace.updatePeerInfo(endpoint, "data_center", entry.getValue().value, executor);
                    break;
                }
                case RACK: {
                    SystemKeyspace.updatePeerInfo(endpoint, "rack", entry.getValue().value, executor);
                    break;
                }
                case RPC_ADDRESS: {
                    try {
                        SystemKeyspace.updatePeerInfo(endpoint, "rpc_address", InetAddress.getByName(entry.getValue().value), executor);
                        break;
                    }
                    catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                }
                case SCHEMA: {
                    SystemKeyspace.updatePeerInfo(endpoint, "schema_version", UUID.fromString(entry.getValue().value), executor);
                    break;
                }
                case HOST_ID: {
                    SystemKeyspace.updatePeerInfo(endpoint, "host_id", UUID.fromString(entry.getValue().value), executor);
                }
            }
        }
    }

    private void notifyRpcChange(InetAddress endpoint, boolean ready) {
        if (ready) {
            this.notifyUp(endpoint);
        } else {
            this.notifyDown(endpoint);
        }
    }

    private void notifyUp(InetAddress endpoint) {
        if (!this.isRpcReady(endpoint) || !Gossiper.instance.isAlive(endpoint)) {
            return;
        }
        for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
            subscriber.onUp(endpoint);
        }
    }

    private void notifyDown(InetAddress endpoint) {
        for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
            subscriber.onDown(endpoint);
        }
    }

    private void notifyJoined(InetAddress endpoint) {
        if (!this.isStatus(endpoint, "NORMAL")) {
            return;
        }
        for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
            subscriber.onJoinCluster(endpoint);
        }
    }

    private void notifyMoved(InetAddress endpoint) {
        for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
            subscriber.onMove(endpoint);
        }
    }

    private void notifyLeft(InetAddress endpoint) {
        for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
            subscriber.onLeaveCluster(endpoint);
        }
    }

    private boolean isStatus(InetAddress endpoint, String status) {
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        return state != null && state.getStatus().equals(status);
    }

    public boolean isRpcReady(InetAddress endpoint) {
        if (MessagingService.instance().getVersion(endpoint) < 9) {
            return true;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        return state != null && state.isRpcReady();
    }

    public void setRpcReady(boolean value) {
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(FBUtilities.getBroadcastAddress());
        assert (!value || state != null);
        if (state != null) {
            Gossiper.instance.addLocalApplicationState(ApplicationState.RPC_READY, this.valueFactory.rpcReady(value));
        }
    }

    private Collection<Token> getTokensFor(InetAddress endpoint) {
        try {
            EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
            if (state == null) {
                return Collections.emptyList();
            }
            VersionedValue versionedValue = state.getApplicationState(ApplicationState.TOKENS);
            if (versionedValue == null) {
                return Collections.emptyList();
            }
            return TokenSerializer.deserialize(this.tokenMetadata.partitioner, new DataInputStream(new ByteArrayInputStream(versionedValue.toBytes())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleStateBootstrap(InetAddress endpoint) {
        Collection<Token> tokens = this.getTokensFor(endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} state bootstrapping, token {}", (Object)endpoint, tokens);
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            if (!this.tokenMetadata.isLeaving(endpoint)) {
                logger.info("Node {} state jump to bootstrap", (Object)endpoint);
            }
            this.tokenMetadata.removeEndpoint(endpoint);
        }
        this.tokenMetadata.addBootstrapTokens(tokens, endpoint);
        PendingRangeCalculatorService.instance.update();
        this.tokenMetadata.updateHostId(Gossiper.instance.getHostId(endpoint), endpoint);
    }

    private void handleStateBootreplacing(InetAddress newNode, String[] pieces) {
        InetAddress oldNode;
        try {
            oldNode = InetAddress.getByName(pieces[1]);
        }
        catch (Exception e) {
            logger.error("Node {} tried to replace malformed endpoint {}.", new Object[]{newNode, pieces[1], e});
            return;
        }
        if (FailureDetector.instance.isAlive(oldNode)) {
            throw new RuntimeException(String.format("Node %s is trying to replace alive node %s.", newNode, oldNode));
        }
        Optional<InetAddress> replacingNode = this.tokenMetadata.getReplacingNode(newNode);
        if (replacingNode.isPresent() && !replacingNode.get().equals(oldNode)) {
            throw new RuntimeException(String.format("Node %s is already replacing %s but is trying to replace %s.", newNode, replacingNode.get(), oldNode));
        }
        Collection<Token> tokens = this.getTokensFor(newNode);
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} is replacing {}, tokens {}", new Object[]{newNode, oldNode, tokens});
        }
        this.tokenMetadata.addReplaceTokens(tokens, newNode, oldNode);
        PendingRangeCalculatorService.instance.update();
        this.tokenMetadata.updateHostId(Gossiper.instance.getHostId(newNode), newNode);
    }

    private void ensureUpToDateTokenMetadata(String status, InetAddress endpoint) {
        TreeSet<Token> tokens = new TreeSet<Token>(this.getTokensFor(endpoint));
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} state {}, tokens {}", new Object[]{endpoint, status, tokens});
        }
        if (!this.tokenMetadata.isMember(endpoint)) {
            logger.info("Node {} state jump to {}", (Object)endpoint, (Object)status);
            this.updateTokenMetadata(endpoint, tokens);
        } else if (!tokens.equals(new TreeSet<Token>(this.tokenMetadata.getTokens(endpoint)))) {
            logger.warn("Node {} '{}' token mismatch. Long network partition?", (Object)endpoint, (Object)status);
            this.updateTokenMetadata(endpoint, tokens);
        }
    }

    private void updateTokenMetadata(InetAddress endpoint, Iterable<Token> tokens) {
        this.updateTokenMetadata(endpoint, tokens, new HashSet<InetAddress>());
    }

    private void updateTokenMetadata(InetAddress endpoint, Iterable<Token> tokens, Set<InetAddress> endpointsToRemove) {
        HashSet<Token> tokensToUpdateInMetadata = new HashSet<Token>();
        HashSet<Token> tokensToUpdateInSystemKeyspace = new HashSet<Token>();
        for (Token token : tokens) {
            InetAddress currentOwner = this.tokenMetadata.getEndpoint(token);
            if (currentOwner == null) {
                logger.debug("New node {} at token {}", (Object)endpoint, (Object)token);
                tokensToUpdateInMetadata.add(token);
                tokensToUpdateInSystemKeyspace.add(token);
                continue;
            }
            if (endpoint.equals(currentOwner)) {
                tokensToUpdateInMetadata.add(token);
                tokensToUpdateInSystemKeyspace.add(token);
                continue;
            }
            if (Gossiper.instance.compareEndpointStartup(endpoint, currentOwner) > 0) {
                tokensToUpdateInMetadata.add(token);
                tokensToUpdateInSystemKeyspace.add(token);
                Multimap<InetAddress, Token> epToTokenCopy = this.getTokenMetadata().getEndpointToTokenMapForReading();
                epToTokenCopy.get((Object)currentOwner).remove(token);
                if (epToTokenCopy.get((Object)currentOwner).isEmpty()) {
                    endpointsToRemove.add(currentOwner);
                }
                logger.info("Nodes {} and {} have the same token {}. {} is the new owner", new Object[]{endpoint, currentOwner, token, endpoint});
                continue;
            }
            logger.info("Nodes {} and {} have the same token {}.  Ignoring {}", new Object[]{endpoint, currentOwner, token, endpoint});
        }
        this.tokenMetadata.updateNormalTokens(tokensToUpdateInMetadata, endpoint);
        for (InetAddress ep : endpointsToRemove) {
            this.removeEndpoint(ep);
            if (!this.replacing || !ep.equals(DatabaseDescriptor.getReplaceAddress())) continue;
            Gossiper.instance.replacementQuarantine(ep);
        }
        if (!tokensToUpdateInSystemKeyspace.isEmpty()) {
            SystemKeyspace.updateTokens(endpoint, tokensToUpdateInSystemKeyspace, StageManager.getStage(Stage.MUTATION));
        }
    }

    private void handleStateNormal(InetAddress endpoint, String status) {
        Optional<InetAddress> replacementNode;
        Optional<InetAddress> replacingNode;
        Collection<Token> tokens = this.getTokensFor(endpoint);
        HashSet<InetAddress> endpointsToRemove = new HashSet<InetAddress>();
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} state {}, token {}", new Object[]{endpoint, status, tokens});
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            logger.info("Node {} state jump to {}", (Object)endpoint, (Object)status);
        }
        if (tokens.isEmpty() && status.equals("NORMAL")) {
            logger.error("Node {} is in state normal but it has no tokens, state: {}", (Object)endpoint, (Object)Gossiper.instance.getEndpointStateForEndpoint(endpoint));
        }
        if ((replacingNode = this.tokenMetadata.getReplacingNode(endpoint)).isPresent()) {
            assert (!endpoint.equals(replacingNode.get())) : "Pending replacement endpoint with same address is not supported";
            logger.info("Node {} will complete replacement of {} for tokens {}", new Object[]{endpoint, replacingNode.get(), tokens});
            if (FailureDetector.instance.isAlive(replacingNode.get())) {
                logger.error("Node {} cannot complete replacement of alive node {}.", (Object)endpoint, (Object)replacingNode.get());
                return;
            }
            endpointsToRemove.add(replacingNode.get());
        }
        if ((replacementNode = this.tokenMetadata.getReplacementNode(endpoint)).isPresent()) {
            logger.warn("Node {} is currently being replaced by node {}.", (Object)endpoint, (Object)replacementNode.get());
        }
        this.updatePeerInfo(endpoint);
        UUID hostId = Gossiper.instance.getHostId(endpoint);
        InetAddress existing = this.tokenMetadata.getEndpointForHostId(hostId);
        if (this.replacing && StorageService.isReplacingSameAddress() && Gossiper.instance.getEndpointStateForEndpoint(DatabaseDescriptor.getReplaceAddress()) != null && hostId.equals(Gossiper.instance.getHostId(DatabaseDescriptor.getReplaceAddress()))) {
            logger.warn("Not updating token metadata for {} because I am replacing it", (Object)endpoint);
        } else if (existing != null && !existing.equals(endpoint)) {
            if (existing.equals(FBUtilities.getBroadcastAddress())) {
                logger.warn("Not updating host ID {} for {} because it's mine", (Object)hostId, (Object)endpoint);
                this.tokenMetadata.removeEndpoint(endpoint);
                endpointsToRemove.add(endpoint);
            } else if (Gossiper.instance.compareEndpointStartup(endpoint, existing) > 0) {
                logger.warn("Host ID collision for {} between {} and {}; {} is the new owner", new Object[]{hostId, existing, endpoint, endpoint});
                this.tokenMetadata.removeEndpoint(existing);
                endpointsToRemove.add(existing);
                this.tokenMetadata.updateHostId(hostId, endpoint);
            } else {
                logger.warn("Host ID collision for {} between {} and {}; ignored {}", new Object[]{hostId, existing, endpoint, endpoint});
                this.tokenMetadata.removeEndpoint(endpoint);
                endpointsToRemove.add(endpoint);
            }
        } else {
            this.tokenMetadata.updateHostId(hostId, endpoint);
        }
        boolean isMember = this.tokenMetadata.isMember(endpoint);
        boolean isMoving = this.tokenMetadata.isMoving(endpoint);
        this.updateTokenMetadata(endpoint, tokens, endpointsToRemove);
        if (isMoving || this.operationMode == Mode.MOVING) {
            this.tokenMetadata.removeFromMoving(endpoint);
            this.notifyMoved(endpoint);
        } else if (!isMember) {
            this.notifyJoined(endpoint);
        }
        PendingRangeCalculatorService.instance.update();
    }

    private void handleStateLeaving(InetAddress endpoint) {
        this.ensureUpToDateTokenMetadata("LEAVING", endpoint);
        this.tokenMetadata.addLeavingEndpoint(endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    private void handleStateLeft(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Collection<Token> tokens = this.getTokensFor(endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} state left, tokens {}", (Object)endpoint, tokens);
        }
        this.excise(tokens, endpoint, this.extractExpireTime(pieces));
    }

    private void handleStateMoving(InetAddress endpoint, String[] pieces) {
        this.ensureUpToDateTokenMetadata("MOVING", endpoint);
        assert (pieces.length >= 2);
        Token token = this.getTokenFactory().fromString(pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} state moving, new token {}", (Object)endpoint, (Object)token);
        }
        this.tokenMetadata.addMovingEndpoint(token, endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    private void handleStateRemoving(InetAddress endpoint, String[] pieces) {
        assert (pieces.length > 0);
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            logger.info("Received removenode gossip about myself. Is this node rejoining after an explicit removenode?");
            try {
                this.drain();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            String state = pieces[0];
            Collection<Token> removeTokens = this.tokenMetadata.getTokens(endpoint);
            if ("removed".equals(state)) {
                this.excise(removeTokens, endpoint, this.extractExpireTime(pieces));
            } else if ("removing".equals(state)) {
                this.ensureUpToDateTokenMetadata(state, endpoint);
                if (logger.isDebugEnabled()) {
                    logger.debug("Tokens {} removed manually (endpoint was {})", removeTokens, (Object)endpoint);
                }
                this.tokenMetadata.addLeavingEndpoint(endpoint);
                PendingRangeCalculatorService.instance.update();
                String[] coordinator = StorageService.splitValue(Gossiper.instance.getEndpointStateForEndpoint(endpoint).getApplicationState(ApplicationState.REMOVAL_COORDINATOR));
                UUID hostId = UUID.fromString(coordinator[1]);
                this.restoreReplicaCount(endpoint, this.tokenMetadata.getEndpointForHostId(hostId));
            }
        } else {
            if ("removed".equals(pieces[0])) {
                this.addExpireTimeIfFound(endpoint, this.extractExpireTime(pieces));
            }
            this.removeEndpoint(endpoint);
        }
    }

    private void excise(Collection<Token> tokens, InetAddress endpoint) {
        logger.info("Removing tokens {} for {}", tokens, (Object)endpoint);
        UUID hostId = this.tokenMetadata.getHostId(endpoint);
        if (hostId != null && this.tokenMetadata.isMember(endpoint)) {
            long delay = DatabaseDescriptor.getMinRpcTimeout() + DatabaseDescriptor.getWriteRpcTimeout();
            ScheduledExecutors.optionalTasks.schedule(() -> HintsService.instance.excise(hostId), delay, TimeUnit.MILLISECONDS);
        }
        this.removeEndpoint(endpoint);
        this.tokenMetadata.removeEndpoint(endpoint);
        if (!tokens.isEmpty()) {
            this.tokenMetadata.removeBootstrapTokens(tokens);
        }
        this.notifyLeft(endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    private void excise(Collection<Token> tokens, InetAddress endpoint, long expireTime) {
        this.addExpireTimeIfFound(endpoint, expireTime);
        this.excise(tokens, endpoint);
    }

    private void removeEndpoint(InetAddress endpoint) {
        Gossiper.runInGossipStageBlocking(() -> Gossiper.instance.removeEndpoint(endpoint));
        MigrationCoordinator.instance.removeAndIgnoreEndpoint(endpoint);
        SystemKeyspace.removeEndpoint(endpoint);
    }

    protected void addExpireTimeIfFound(InetAddress endpoint, long expireTime) {
        if (expireTime != 0L) {
            Gossiper.instance.addExpireTimeForEndpoint(endpoint, expireTime);
        }
    }

    protected long extractExpireTime(String[] pieces) {
        return Long.parseLong(pieces[2]);
    }

    private Multimap<InetAddress, Range<Token>> getNewSourceRanges(String keyspaceName, Set<Range<Token>> ranges) {
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        Multimap<Range<Token>, InetAddress> rangeAddresses = Keyspace.open(keyspaceName).getReplicationStrategy().getRangeAddresses(this.tokenMetadata.cloneOnlyTokenMap());
        HashMultimap sourceRanges = HashMultimap.create();
        IFailureDetector failureDetector = FailureDetector.instance;
        block0: for (Range<Token> range : ranges) {
            Collection possibleRanges = rangeAddresses.get(range);
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            List<InetAddress> sources = snitch.getSortedListByProximity(myAddress, possibleRanges);
            assert (!sources.contains(myAddress));
            for (InetAddress source : sources) {
                if (!failureDetector.isAlive(source)) continue;
                sourceRanges.put((Object)source, range);
                continue block0;
            }
        }
        return sourceRanges;
    }

    private void sendReplicationNotification(InetAddress remote) {
        MessageOut msg = new MessageOut(MessagingService.Verb.REPLICATION_FINISHED);
        IFailureDetector failureDetector = FailureDetector.instance;
        if (logger.isDebugEnabled()) {
            logger.debug("Notifying {} of replication completion\n", (Object)remote);
        }
        while (failureDetector.isAlive(remote)) {
            AsyncOneResponse iar = MessagingService.instance().sendRR(msg, remote);
            try {
                iar.get(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
        }
    }

    private void restoreReplicaCount(InetAddress endpoint, final InetAddress notifyEndpoint) {
        HashMultimap rangesToFetch = HashMultimap.create();
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        for (String string : Schema.instance.getNonLocalStrategyKeyspaces()) {
            Object entry22;
            Multimap<Range<Token>, InetAddress> changedRanges = this.getChangedRangesForLeaving(string, endpoint);
            HashSet<Range<Token>> myNewRanges = new HashSet<Range<Token>>();
            for (Object entry22 : changedRanges.entries()) {
                if (!((InetAddress)entry22.getValue()).equals(myAddress)) continue;
                myNewRanges.add((Range<Token>)entry22.getKey());
            }
            Multimap<InetAddress, Range<Token>> sourceRanges = this.getNewSourceRanges(string, myNewRanges);
            entry22 = sourceRanges.asMap().entrySet().iterator();
            while (entry22.hasNext()) {
                Map.Entry entry3 = (Map.Entry)entry22.next();
                rangesToFetch.put((Object)string, (Object)entry3);
            }
        }
        StreamPlan stream = new StreamPlan("Restore replica count");
        for (String keyspaceName : rangesToFetch.keySet()) {
            for (Map.Entry entry : rangesToFetch.get((Object)keyspaceName)) {
                InetAddress source = (InetAddress)entry.getKey();
                InetAddress preferred = SystemKeyspace.getPreferredIP(source);
                Collection ranges = (Collection)entry.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug("Requesting from {} ranges {}", (Object)source, (Object)StringUtils.join((Iterable)ranges, (String)", "));
                }
                stream.requestRanges(source, preferred, keyspaceName, ranges);
            }
        }
        StreamResultFuture streamResultFuture = stream.execute();
        Futures.addCallback((ListenableFuture)streamResultFuture, (FutureCallback)new FutureCallback<StreamState>(){

            public void onSuccess(StreamState finalState) {
                StorageService.this.sendReplicationNotification(notifyEndpoint);
            }

            public void onFailure(Throwable t) {
                logger.warn("Streaming to restore replica count failed", t);
                StorageService.this.sendReplicationNotification(notifyEndpoint);
            }
        });
    }

    private Multimap<Range<Token>, InetAddress> getChangedRangesForLeaving(String keyspaceName, InetAddress endpoint) {
        Collection<Range<Token>> ranges = this.getRangesForEndpoint(keyspaceName, endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("Node {} ranges [{}]", (Object)endpoint, (Object)StringUtils.join(ranges, (String)", "));
        }
        HashMap<Range<Token>, List<InetAddress>> currentReplicaEndpoints = new HashMap<Range<Token>, List<InetAddress>>(ranges.size());
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        for (Range<Token> range : ranges) {
            currentReplicaEndpoints.put(range, Keyspace.open(keyspaceName).getReplicationStrategy().calculateNaturalEndpoints((Token)range.right, metadata));
        }
        TokenMetadata temp = this.tokenMetadata.cloneAfterAllLeft();
        if (temp.isMember(endpoint)) {
            temp.removeEndpoint(endpoint);
        }
        HashMultimap changedRanges = HashMultimap.create();
        for (Range<Token> range : ranges) {
            List<InetAddress> newReplicaEndpoints = Keyspace.open(keyspaceName).getReplicationStrategy().calculateNaturalEndpoints((Token)range.right, temp);
            newReplicaEndpoints.removeAll((Collection)currentReplicaEndpoints.get(range));
            if (logger.isDebugEnabled()) {
                if (newReplicaEndpoints.isEmpty()) {
                    logger.debug("Range {} already in all replicas", range);
                } else {
                    logger.debug("Range {} will be responsibility of {}", range, (Object)StringUtils.join(newReplicaEndpoints, (String)", "));
                }
            }
            changedRanges.putAll(range, newReplicaEndpoints);
        }
        return changedRanges;
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.states()) {
            this.onChange(endpoint, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
        if (this.tokenMetadata.isMember(endpoint)) {
            this.notifyUp(endpoint);
        }
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.tokenMetadata.removeEndpoint(endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
        MessagingService.instance().convict(endpoint);
        this.notifyDown(endpoint);
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState state) {
        VersionedValue netVersion;
        if (state.isAlive()) {
            this.onDead(endpoint, state);
        }
        if ((netVersion = state.getApplicationState(ApplicationState.NET_VERSION)) != null) {
            this.updateNetVersion(endpoint, netVersion);
        }
    }

    @Override
    public String getLoadString() {
        return FileUtils.stringifyFileSize(StorageMetrics.load.getCount());
    }

    @Override
    public Map<String, String> getLoadMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<InetAddress, Double> entry : LoadBroadcaster.instance.getLoadInfo().entrySet()) {
            map.put(entry.getKey().getHostAddress(), FileUtils.stringifyFileSize(entry.getValue()));
        }
        map.put(FBUtilities.getBroadcastAddress().getHostAddress(), this.getLoadString());
        return map;
    }

    @Override
    public final void deliverHints(String host) throws UnknownHostException {
        throw new UnsupportedOperationException();
    }

    public Collection<Token> getLocalTokens() {
        Collection<Token> tokens = SystemKeyspace.getSavedTokens();
        assert (tokens != null && !tokens.isEmpty());
        return tokens;
    }

    @Nullable
    public InetAddress getEndpointForHostId(UUID hostId) {
        return this.tokenMetadata.getEndpointForHostId(hostId);
    }

    @Nullable
    public UUID getHostIdForEndpoint(InetAddress address) {
        return this.tokenMetadata.getHostId(address);
    }

    @Override
    public List<String> getTokens() {
        return this.getTokens(FBUtilities.getBroadcastAddress());
    }

    @Override
    public List<String> getTokens(String endpoint) throws UnknownHostException {
        return this.getTokens(InetAddress.getByName(endpoint));
    }

    private List<String> getTokens(InetAddress endpoint) {
        ArrayList<String> strTokens = new ArrayList<String>();
        for (Token tok : this.getTokenMetadata().getTokens(endpoint)) {
            strTokens.add(tok.toString());
        }
        return strTokens;
    }

    @Override
    public String getReleaseVersion() {
        return FBUtilities.getReleaseVersionString();
    }

    @Override
    public String getSchemaVersion() {
        return Schema.instance.getVersion().toString();
    }

    @Override
    public List<String> getLeavingNodes() {
        return this.stringify(this.tokenMetadata.getLeavingEndpoints());
    }

    @Override
    public List<String> getMovingNodes() {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (Pair<Token, InetAddress> node : this.tokenMetadata.getMovingEndpoints()) {
            endpoints.add(((InetAddress)node.right).getHostAddress());
        }
        return endpoints;
    }

    @Override
    public List<String> getJoiningNodes() {
        return this.stringify(this.tokenMetadata.getBootstrapTokens().valueSet());
    }

    @Override
    public List<String> getLiveNodes() {
        return this.stringify(Gossiper.instance.getLiveMembers());
    }

    public Set<InetAddress> getLiveRingMembers() {
        return this.getLiveRingMembers(false);
    }

    public Set<InetAddress> getLiveRingMembers(boolean excludeDeadStates) {
        HashSet<InetAddress> ret = new HashSet<InetAddress>();
        for (InetAddress ep : Gossiper.instance.getLiveMembers()) {
            EndpointState epState;
            if (excludeDeadStates && ((epState = Gossiper.instance.getEndpointStateForEndpoint(ep)) == null || Gossiper.instance.isDeadState(epState)) || !this.tokenMetadata.isMember(ep)) continue;
            ret.add(ep);
        }
        return ret;
    }

    @Override
    public List<String> getUnreachableNodes() {
        return this.stringify(Gossiper.instance.getUnreachableMembers());
    }

    @Override
    public String[] getAllDataFileLocations() {
        String[] locations = DatabaseDescriptor.getAllDataFileLocations();
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = FileUtils.getCanonicalPath(locations[i]);
        }
        return locations;
    }

    @Override
    public String getCommitLogLocation() {
        return FileUtils.getCanonicalPath(DatabaseDescriptor.getCommitLogLocation());
    }

    @Override
    public String getSavedCachesLocation() {
        return FileUtils.getCanonicalPath(DatabaseDescriptor.getSavedCachesLocation());
    }

    private List<String> stringify(Iterable<InetAddress> endpoints) {
        ArrayList<String> stringEndpoints = new ArrayList<String>();
        for (InetAddress ep : endpoints) {
            stringEndpoints.add(ep.getHostAddress());
        }
        return stringEndpoints;
    }

    @Override
    public int getCurrentGenerationNumber() {
        return Gossiper.instance.getCurrentGenerationNumber(FBUtilities.getBroadcastAddress());
    }

    @Override
    public int forceKeyspaceCleanup(String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.forceKeyspaceCleanup(0, keyspaceName, tables);
    }

    @Override
    public int forceKeyspaceCleanup(int jobs, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        if (Schema.isLocalSystemKeyspace(keyspaceName)) {
            throw new RuntimeException("Cleanup of the system keyspace is neither necessary nor wise");
        }
        CompactionManager.AllSSTableOpStatus status = CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(false, false, keyspaceName, tables)) {
            CompactionManager.AllSSTableOpStatus oneStatus = cfStore.forceCleanup(jobs);
            if (oneStatus == CompactionManager.AllSSTableOpStatus.SUCCESSFUL) continue;
            status = oneStatus;
        }
        return status.statusCode;
    }

    @Override
    public int scrub(boolean disableSnapshot, boolean skipCorrupted, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.scrub(disableSnapshot, skipCorrupted, true, 0, keyspaceName, tables);
    }

    @Override
    public int scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.scrub(disableSnapshot, skipCorrupted, checkData, 0, keyspaceName, tables);
    }

    @Override
    public int scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData, int jobs, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.scrub(disableSnapshot, skipCorrupted, checkData, false, jobs, keyspaceName, tables);
    }

    @Override
    public int scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData, boolean reinsertOverflowedTTL, int jobs, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        CompactionManager.AllSSTableOpStatus status = CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, tables)) {
            CompactionManager.AllSSTableOpStatus oneStatus = cfStore.scrub(disableSnapshot, skipCorrupted, reinsertOverflowedTTL, checkData, jobs);
            if (oneStatus == CompactionManager.AllSSTableOpStatus.SUCCESSFUL) continue;
            status = oneStatus;
        }
        return status.statusCode;
    }

    @Override
    public int verify(boolean extendedVerify, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        CompactionManager.AllSSTableOpStatus status = CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(false, false, keyspaceName, tableNames)) {
            CompactionManager.AllSSTableOpStatus oneStatus = cfStore.verify(extendedVerify);
            if (oneStatus == CompactionManager.AllSSTableOpStatus.SUCCESSFUL) continue;
            status = oneStatus;
        }
        return status.statusCode;
    }

    @Override
    public int upgradeSSTables(String keyspaceName, boolean excludeCurrentVersion, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        return this.upgradeSSTables(keyspaceName, excludeCurrentVersion, 0, tableNames);
    }

    @Override
    public int upgradeSSTables(String keyspaceName, boolean excludeCurrentVersion, int jobs, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        CompactionManager.AllSSTableOpStatus status = CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, true, keyspaceName, tableNames)) {
            CompactionManager.AllSSTableOpStatus oneStatus = cfStore.sstablesRewrite(excludeCurrentVersion, jobs);
            if (oneStatus == CompactionManager.AllSSTableOpStatus.SUCCESSFUL) continue;
            status = oneStatus;
        }
        return status.statusCode;
    }

    @Override
    public void forceKeyspaceCompaction(boolean splitOutput, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, tableNames)) {
            cfStore.forceMajorCompaction(splitOutput);
        }
    }

    @Override
    public void takeSnapshot(String tag, String ... keyspaceNames) throws IOException {
        Iterable<Keyspace> keyspaces;
        if (this.operationMode == Mode.JOINING) {
            throw new IOException("Cannot snapshot until bootstrap completes");
        }
        if (tag == null || tag.equals("")) {
            throw new IOException("You must supply a snapshot name.");
        }
        if (keyspaceNames.length == 0) {
            keyspaces = Keyspace.all();
        } else {
            ArrayList<Keyspace> t = new ArrayList<Keyspace>(keyspaceNames.length);
            for (String keyspaceName : keyspaceNames) {
                t.add(this.getValidKeyspace(keyspaceName));
            }
            keyspaces = t;
        }
        for (Keyspace keyspace : keyspaces) {
            if (!keyspace.snapshotExists(tag)) continue;
            throw new IOException("Snapshot " + tag + " already exists.");
        }
        for (Keyspace keyspace : keyspaces) {
            keyspace.snapshot(tag, null);
        }
    }

    @Override
    public void takeTableSnapshot(String keyspaceName, String tableName, String tag) throws IOException {
        if (keyspaceName == null) {
            throw new IOException("You must supply a keyspace name");
        }
        if (this.operationMode == Mode.JOINING) {
            throw new IOException("Cannot snapshot until bootstrap completes");
        }
        if (tableName == null) {
            throw new IOException("You must supply a table name");
        }
        if (tableName.contains(".")) {
            throw new IllegalArgumentException("Cannot take a snapshot of a secondary index by itself. Run snapshot on the table that owns the index.");
        }
        if (tag == null || tag.equals("")) {
            throw new IOException("You must supply a snapshot name.");
        }
        Keyspace keyspace = this.getValidKeyspace(keyspaceName);
        ColumnFamilyStore columnFamilyStore = keyspace.getColumnFamilyStore(tableName);
        if (columnFamilyStore.snapshotExists(tag)) {
            throw new IOException("Snapshot " + tag + " already exists.");
        }
        columnFamilyStore.snapshot(tag);
    }

    @Override
    public void takeMultipleTableSnapshot(String tag, String ... tableList) throws IOException {
        HashMap keyspaceColumnfamily = new HashMap();
        for (String table : tableList) {
            Keyspace keyspace;
            String tableName;
            String[] splittedString = table.split("\\.");
            if (splittedString.length == 2) {
                String keyspaceName = splittedString[0];
                tableName = splittedString[1];
                if (keyspaceName == null) {
                    throw new IOException("You must supply a keyspace name");
                }
                if (this.operationMode.equals((Object)Mode.JOINING)) {
                    throw new IOException("Cannot snapshot until bootstrap completes");
                }
                if (tableName == null) {
                    throw new IOException("You must supply a table name");
                }
                if (tag == null || tag.equals("")) {
                    throw new IOException("You must supply a snapshot name.");
                }
                keyspace = this.getValidKeyspace(keyspaceName);
                ColumnFamilyStore columnFamilyStore = keyspace.getColumnFamilyStore(tableName);
                if (columnFamilyStore.snapshotExists(tag)) {
                    throw new IOException("Snapshot " + tag + " already exists.");
                }
                if (!keyspaceColumnfamily.containsKey(keyspace)) {
                    keyspaceColumnfamily.put(keyspace, new ArrayList());
                }
            } else {
                throw new IllegalArgumentException("Cannot take a snapshot on secondary index or invalid column family name. You must supply a column family name in the form of keyspace.columnfamily");
            }
            ((List)keyspaceColumnfamily.get(keyspace)).add(tableName);
        }
        for (Map.Entry entry : keyspaceColumnfamily.entrySet()) {
            for (String table : (List)entry.getValue()) {
                ((Keyspace)entry.getKey()).snapshot(tag, table);
            }
        }
    }

    private Keyspace getValidKeyspace(String keyspaceName) throws IOException {
        if (!Schema.instance.getKeyspaces().contains(keyspaceName)) {
            throw new IOException("Keyspace " + keyspaceName + " does not exist");
        }
        return Keyspace.open(keyspaceName);
    }

    @Override
    public void clearSnapshot(String tag, String ... keyspaceNames) throws IOException {
        if (tag == null) {
            tag = "";
        }
        HashSet<String> keyspaces = new HashSet<String>();
        for (String dataDir : DatabaseDescriptor.getAllDataFileLocations()) {
            for (String keyspaceDir : new File(dataDir).list()) {
                if (keyspaceNames.length > 0 && !Arrays.asList(keyspaceNames).contains(keyspaceDir)) continue;
                keyspaces.add(keyspaceDir);
            }
        }
        for (String keyspace : keyspaces) {
            Keyspace.clearSnapshot(tag, keyspace);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Cleared out snapshot directories");
        }
    }

    @Override
    public Map<String, TabularData> getSnapshotDetails() {
        HashMap<String, TabularData> snapshotMap = new HashMap<String, TabularData>();
        for (Keyspace keyspace : Keyspace.all()) {
            if (Schema.isLocalSystemKeyspace(keyspace.getName())) continue;
            for (ColumnFamilyStore cfStore : keyspace.getColumnFamilyStores()) {
                for (Map.Entry<String, Pair<Long, Long>> snapshotDetail : cfStore.getSnapshotDetails().entrySet()) {
                    TabularDataSupport data = (TabularDataSupport)snapshotMap.get(snapshotDetail.getKey());
                    if (data == null) {
                        data = new TabularDataSupport(SnapshotDetailsTabularData.TABULAR_TYPE);
                        snapshotMap.put(snapshotDetail.getKey(), data);
                    }
                    SnapshotDetailsTabularData.from(snapshotDetail.getKey(), keyspace.getName(), cfStore.getColumnFamilyName(), snapshotDetail, data);
                }
            }
        }
        return snapshotMap;
    }

    @Override
    public long trueSnapshotsSize() {
        long total = 0L;
        for (Keyspace keyspace : Keyspace.all()) {
            if (Schema.isLocalSystemKeyspace(keyspace.getName())) continue;
            for (ColumnFamilyStore cfStore : keyspace.getColumnFamilyStores()) {
                total += cfStore.trueSnapshotsSize();
            }
        }
        return total;
    }

    @Override
    public void refreshSizeEstimates() throws ExecutionException {
        this.cleanupSizeEstimates();
        FBUtilities.waitOnFuture(ScheduledExecutors.optionalTasks.submit(SizeEstimatesRecorder.instance));
    }

    @Override
    public void cleanupSizeEstimates() {
        SetMultimap<String, String> sizeEstimates = SystemKeyspace.getTablesWithSizeEstimates();
        for (Map.Entry tablesByKeyspace : sizeEstimates.asMap().entrySet()) {
            String keyspace = (String)tablesByKeyspace.getKey();
            if (!Schema.instance.getKeyspaces().contains(keyspace)) {
                SystemKeyspace.clearSizeEstimates(keyspace);
                continue;
            }
            for (String table : (Collection)tablesByKeyspace.getValue()) {
                if (Schema.instance.hasCF(Pair.create(keyspace, table))) continue;
                SystemKeyspace.clearSizeEstimates(keyspace, table);
            }
        }
    }

    public Iterable<ColumnFamilyStore> getValidColumnFamilies(boolean allowIndexes, boolean autoAddIndexes, String keyspaceName, String ... cfNames) throws IOException {
        Keyspace keyspace = this.getValidKeyspace(keyspaceName);
        return keyspace.getValidColumnFamilies(allowIndexes, autoAddIndexes, cfNames);
    }

    @Override
    public void forceKeyspaceFlush(String keyspaceName, String ... tableNames) throws IOException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, keyspaceName, tableNames)) {
            logger.debug("Forcing flush on keyspace {}, CF {}", (Object)keyspaceName, (Object)cfStore.name);
            cfStore.forceBlockingFlush();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int repairAsync(String keyspace, Map<String, String> repairSpec) {
        RepairOption option = RepairOption.parse(repairSpec, this.tokenMetadata.partitioner);
        if (!option.getRanges().isEmpty()) return this.forceRepairAsync(keyspace, option, false);
        if (option.isPrimaryRange()) {
            if (option.getDataCenters().isEmpty() && option.getHosts().isEmpty()) {
                option.getRanges().addAll(this.getPrimaryRanges(keyspace));
                return this.forceRepairAsync(keyspace, option, false);
            } else {
                if (!option.isInLocalDCOnly()) throw new IllegalArgumentException("You need to run primary range repair on all nodes in the cluster.");
                option.getRanges().addAll(this.getPrimaryRangesWithinDC(keyspace));
            }
            return this.forceRepairAsync(keyspace, option, false);
        } else {
            option.getRanges().addAll(this.getLocalRanges(keyspace));
        }
        return this.forceRepairAsync(keyspace, option, false);
    }

    @Override
    @Deprecated
    public int forceRepairAsync(String keyspace, boolean isSequential, Collection<String> dataCenters, Collection<String> hosts, boolean primaryRange, boolean fullRepair, String ... tableNames) {
        return this.forceRepairAsync(keyspace, isSequential ? RepairParallelism.SEQUENTIAL.ordinal() : RepairParallelism.PARALLEL.ordinal(), dataCenters, hosts, primaryRange, fullRepair, tableNames);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public int forceRepairAsync(String keyspace, int parallelismDegree, Collection<String> dataCenters, Collection<String> hosts, boolean primaryRange, boolean fullRepair, String ... tableNames) {
        if (parallelismDegree < 0 || parallelismDegree > RepairParallelism.values().length - 1) {
            throw new IllegalArgumentException("Invalid parallelism degree specified: " + parallelismDegree);
        }
        RepairParallelism parallelism = RepairParallelism.values()[parallelismDegree];
        if (FBUtilities.isWindows() && parallelism != RepairParallelism.PARALLEL) {
            logger.warn("Snapshot-based repair is not yet supported on Windows.  Reverting to parallel repair.");
            parallelism = RepairParallelism.PARALLEL;
        }
        RepairOption options = new RepairOption(parallelism, primaryRange, !fullRepair, false, 1, Collections.emptyList(), false, false);
        if (dataCenters != null) {
            options.getDataCenters().addAll(dataCenters);
        }
        if (hosts != null) {
            options.getHosts().addAll(hosts);
        }
        if (primaryRange) {
            if (options.getDataCenters().isEmpty() && options.getHosts().isEmpty()) {
                options.getRanges().addAll(this.getPrimaryRanges(keyspace));
            } else {
                if (options.getDataCenters().size() != 1 || !options.getDataCenters().contains(DatabaseDescriptor.getLocalDataCenter())) throw new IllegalArgumentException("You need to run primary range repair on all nodes in the cluster.");
                options.getRanges().addAll(this.getPrimaryRangesWithinDC(keyspace));
            }
        } else {
            options.getRanges().addAll(this.getLocalRanges(keyspace));
        }
        if (tableNames == null) return this.forceRepairAsync(keyspace, options, true);
        for (String table : tableNames) {
            options.getColumnFamilies().add(table);
        }
        return this.forceRepairAsync(keyspace, options, true);
    }

    @Override
    @Deprecated
    public int forceRepairAsync(String keyspace, boolean isSequential, boolean isLocal, boolean primaryRange, boolean fullRepair, String ... tableNames) {
        HashSet dataCenters = null;
        if (isLocal) {
            dataCenters = Sets.newHashSet((Object[])new String[]{DatabaseDescriptor.getLocalDataCenter()});
        }
        return this.forceRepairAsync(keyspace, isSequential, (Collection<String>)dataCenters, null, primaryRange, fullRepair, tableNames);
    }

    @Override
    @Deprecated
    public int forceRepairRangeAsync(String beginToken, String endToken, String keyspaceName, boolean isSequential, Collection<String> dataCenters, Collection<String> hosts, boolean fullRepair, String ... tableNames) {
        return this.forceRepairRangeAsync(beginToken, endToken, keyspaceName, isSequential ? RepairParallelism.SEQUENTIAL.ordinal() : RepairParallelism.PARALLEL.ordinal(), dataCenters, hosts, fullRepair, tableNames);
    }

    @Override
    @Deprecated
    public int forceRepairRangeAsync(String beginToken, String endToken, String keyspaceName, int parallelismDegree, Collection<String> dataCenters, Collection<String> hosts, boolean fullRepair, String ... tableNames) {
        if (parallelismDegree < 0 || parallelismDegree > RepairParallelism.values().length - 1) {
            throw new IllegalArgumentException("Invalid parallelism degree specified: " + parallelismDegree);
        }
        RepairParallelism parallelism = RepairParallelism.values()[parallelismDegree];
        if (FBUtilities.isWindows() && parallelism != RepairParallelism.PARALLEL) {
            logger.warn("Snapshot-based repair is not yet supported on Windows.  Reverting to parallel repair.");
            parallelism = RepairParallelism.PARALLEL;
        }
        if (!fullRepair) {
            logger.warn("Incremental repair can't be requested with subrange repair because each subrange repair would generate an anti-compacted table. The repair will occur but without anti-compaction.");
        }
        Collection<Range<Token>> repairingRange = this.createRepairRangeFrom(beginToken, endToken);
        RepairOption options = new RepairOption(parallelism, false, !fullRepair, false, 1, repairingRange, true, false);
        if (dataCenters != null) {
            options.getDataCenters().addAll(dataCenters);
        }
        if (hosts != null) {
            options.getHosts().addAll(hosts);
        }
        if (tableNames != null) {
            for (String table : tableNames) {
                options.getColumnFamilies().add(table);
            }
        }
        logger.info("starting user-requested repair of range {} for keyspace {} and column families {}", new Object[]{repairingRange, keyspaceName, tableNames});
        return this.forceRepairAsync(keyspaceName, options, true);
    }

    @Override
    @Deprecated
    public int forceRepairRangeAsync(String beginToken, String endToken, String keyspaceName, boolean isSequential, boolean isLocal, boolean fullRepair, String ... tableNames) {
        HashSet dataCenters = null;
        if (isLocal) {
            dataCenters = Sets.newHashSet((Object[])new String[]{DatabaseDescriptor.getLocalDataCenter()});
        }
        return this.forceRepairRangeAsync(beginToken, endToken, keyspaceName, isSequential, (Collection<String>)dataCenters, null, fullRepair, tableNames);
    }

    @VisibleForTesting
    Collection<Range<Token>> createRepairRangeFrom(String beginToken, String endToken) {
        Token parsedBeginToken = this.getTokenFactory().fromString(beginToken);
        Token parsedEndToken = this.getTokenFactory().fromString(endToken);
        ArrayList<Range<Token>> repairingRange = new ArrayList<Range<Token>>();
        ArrayList<Token> tokens = new ArrayList<Token>(this.tokenMetadata.sortedTokens());
        if (!tokens.contains(parsedBeginToken)) {
            tokens.add(parsedBeginToken);
        }
        if (!tokens.contains(parsedEndToken)) {
            tokens.add(parsedEndToken);
        }
        Collections.sort(tokens);
        int start = tokens.indexOf(parsedBeginToken);
        int end = tokens.indexOf(parsedEndToken);
        int i = start;
        while (i != end) {
            Range<RingPosition> range = new Range<RingPosition>(tokens.get(i), tokens.get((i + 1) % tokens.size()));
            repairingRange.add(range);
            i = (i + 1) % tokens.size();
        }
        return repairingRange;
    }

    public Token.TokenFactory getTokenFactory() {
        return this.tokenMetadata.partitioner.getTokenFactory();
    }

    public int forceRepairAsync(String keyspace, RepairOption options, boolean legacy) {
        if (options.getRanges().isEmpty() || Keyspace.open(keyspace).getReplicationStrategy().getReplicationFactor() < 2) {
            return 0;
        }
        int cmd = nextRepairCommand.incrementAndGet();
        new Thread(NamedThreadFactory.threadLocalDeallocator(this.createRepairTask(cmd, keyspace, options, legacy))).start();
        return cmd;
    }

    private FutureTask<Object> createRepairTask(int cmd, String keyspace, RepairOption options, boolean legacy) {
        if (!options.getDataCenters().isEmpty() && !options.getDataCenters().contains(DatabaseDescriptor.getLocalDataCenter())) {
            throw new IllegalArgumentException("the local data center must be part of the repair");
        }
        RepairRunnable task = new RepairRunnable(this, cmd, options, keyspace);
        task.addProgressListener(this.progressSupport);
        if (legacy) {
            task.addProgressListener(this.legacyProgressSupport);
        }
        return new FutureTask<Object>(task, null);
    }

    @Override
    public void forceTerminateAllRepairSessions() {
        ActiveRepairService.instance.terminateSessions();
    }

    @Override
    public void setRepairSessionMaxTreeDepth(int depth) {
        DatabaseDescriptor.setRepairSessionMaxTreeDepth(depth);
    }

    @Override
    public int getRepairSessionMaxTreeDepth() {
        return DatabaseDescriptor.getRepairSessionMaxTreeDepth();
    }

    public Collection<Range<Token>> getPrimaryRangesForEndpoint(String keyspace, InetAddress ep) {
        AbstractReplicationStrategy strategy = Keyspace.open(keyspace).getReplicationStrategy();
        HashSet<Range<Token>> primaryRanges = new HashSet<Range<Token>>();
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        for (Token token : metadata.sortedTokens()) {
            List<InetAddress> endpoints = strategy.calculateNaturalEndpoints(token, metadata);
            if (endpoints.size() <= 0 || !endpoints.get(0).equals(ep)) continue;
            primaryRanges.add(new Range<Token>(metadata.getPredecessor(token), token));
        }
        return primaryRanges;
    }

    public Collection<Range<Token>> getPrimaryRangeForEndpointWithinDC(String keyspace, InetAddress referenceEndpoint) {
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        String localDC = DatabaseDescriptor.getEndpointSnitch().getDatacenter(referenceEndpoint);
        Collection localDcNodes = metadata.getTopology().getDatacenterEndpoints().get((Object)localDC);
        AbstractReplicationStrategy strategy = Keyspace.open(keyspace).getReplicationStrategy();
        HashSet<Range<Token>> localDCPrimaryRanges = new HashSet<Range<Token>>();
        block0: for (Token token : metadata.sortedTokens()) {
            List<InetAddress> endpoints = strategy.calculateNaturalEndpoints(token, metadata);
            for (InetAddress endpoint : endpoints) {
                if (!localDcNodes.contains(endpoint)) continue;
                if (!endpoint.equals(referenceEndpoint)) continue block0;
                localDCPrimaryRanges.add(new Range<Token>(metadata.getPredecessor(token), token));
                continue block0;
            }
        }
        return localDCPrimaryRanges;
    }

    Collection<Range<Token>> getRangesForEndpoint(String keyspaceName, InetAddress ep) {
        return Keyspace.open(keyspaceName).getReplicationStrategy().getAddressRanges().get((Object)ep);
    }

    public List<Range<Token>> getAllRanges(List<Token> sortedTokens) {
        if (logger.isTraceEnabled()) {
            logger.trace("computing ranges for {}", (Object)StringUtils.join(sortedTokens, (String)", "));
        }
        if (sortedTokens.isEmpty()) {
            return Collections.emptyList();
        }
        int size = sortedTokens.size();
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(size + 1);
        for (int i = 1; i < size; ++i) {
            Range<RingPosition> range = new Range<RingPosition>(sortedTokens.get(i - 1), sortedTokens.get(i));
            ranges.add(range);
        }
        Range<RingPosition> range = new Range<RingPosition>(sortedTokens.get(size - 1), sortedTokens.get(0));
        ranges.add(range);
        return ranges;
    }

    @Override
    public List<InetAddress> getNaturalEndpoints(String keyspaceName, String cf, String key) {
        KeyspaceMetadata ksMetaData = Schema.instance.getKSMetaData(keyspaceName);
        if (ksMetaData == null) {
            throw new IllegalArgumentException("Unknown keyspace '" + keyspaceName + "'");
        }
        CFMetaData cfMetaData = ksMetaData.getTableOrViewNullable(cf);
        if (cfMetaData == null) {
            throw new IllegalArgumentException("Unknown table '" + cf + "' in keyspace '" + keyspaceName + "'");
        }
        return this.getNaturalEndpoints(keyspaceName, this.tokenMetadata.partitioner.getToken(cfMetaData.getKeyValidator().fromString(key)));
    }

    @Override
    public List<InetAddress> getNaturalEndpoints(String keyspaceName, ByteBuffer key) {
        return this.getNaturalEndpoints(keyspaceName, this.tokenMetadata.partitioner.getToken(key));
    }

    public List<InetAddress> getNaturalEndpoints(String keyspaceName, RingPosition pos) {
        return Keyspace.open(keyspaceName).getReplicationStrategy().getNaturalEndpoints(pos);
    }

    public Iterable<InetAddress> getNaturalAndPendingEndpoints(String keyspaceName, Token token) {
        return Iterables.concat(this.getNaturalEndpoints(keyspaceName, token), this.tokenMetadata.pendingEndpointsFor(token, keyspaceName));
    }

    public List<InetAddress> getLiveNaturalEndpoints(Keyspace keyspace, ByteBuffer key) {
        return this.getLiveNaturalEndpoints(keyspace, this.tokenMetadata.decorateKey(key));
    }

    public List<InetAddress> getLiveNaturalEndpoints(Keyspace keyspace, RingPosition pos) {
        ArrayList<InetAddress> liveEps = new ArrayList<InetAddress>();
        this.getLiveNaturalEndpoints(keyspace, pos, liveEps);
        return liveEps;
    }

    public void getLiveNaturalEndpoints(Keyspace keyspace, RingPosition pos, List<InetAddress> liveEps) {
        ArrayList<InetAddress> endpoints = keyspace.getReplicationStrategy().getNaturalEndpoints(pos);
        for (InetAddress endpoint : endpoints) {
            if (!FailureDetector.instance.isAlive(endpoint)) continue;
            liveEps.add(endpoint);
        }
    }

    @Override
    public void setLoggingLevel(String classQualifier, String rawLevel) throws Exception {
        ch.qos.logback.classic.Logger logBackLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)classQualifier);
        if (StringUtils.isBlank((CharSequence)classQualifier) && StringUtils.isBlank((CharSequence)rawLevel)) {
            JMXConfiguratorMBean jmxConfiguratorMBean = JMX.newMBeanProxy(ManagementFactory.getPlatformMBeanServer(), new ObjectName("ch.qos.logback.classic:Name=default,Type=ch.qos.logback.classic.jmx.JMXConfigurator"), JMXConfiguratorMBean.class);
            jmxConfiguratorMBean.reloadDefaultConfiguration();
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)classQualifier) && StringUtils.isBlank((CharSequence)rawLevel)) {
            if (logBackLogger.getLevel() != null || this.hasAppenders(logBackLogger)) {
                logBackLogger.setLevel(null);
            }
            return;
        }
        Level level = Level.toLevel((String)rawLevel);
        logBackLogger.setLevel(level);
        logger.info("set log level to {} for classes under '{}' (if the level doesn't look like '{}' then the logger couldn't parse '{}')", new Object[]{level, classQualifier, rawLevel, rawLevel});
    }

    @Override
    public Map<String, String> getLoggingLevels() {
        LinkedHashMap logLevelMaps = Maps.newLinkedHashMap();
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (ch.qos.logback.classic.Logger logger : lc.getLoggerList()) {
            if (logger.getLevel() == null && !this.hasAppenders(logger)) continue;
            logLevelMaps.put(logger.getName(), logger.getLevel().toString());
        }
        return logLevelMaps;
    }

    private boolean hasAppenders(ch.qos.logback.classic.Logger logger) {
        Iterator it = logger.iteratorForAppenders();
        return it.hasNext();
    }

    public List<Pair<Range<Token>, Long>> getSplits(String keyspaceName, String cfName, Range<Token> range, int keysPerSplit) {
        Keyspace t = Keyspace.open(keyspaceName);
        ColumnFamilyStore cfs = t.getColumnFamilyStore(cfName);
        List<DecoratedKey> keys = this.keySamples(Collections.singleton(cfs), range);
        long totalRowCountEstimate = cfs.estimatedKeysForRange(range);
        int minSamplesPerSplit = 4;
        int maxSplitCount = keys.size() / minSamplesPerSplit + 1;
        int splitCount = Math.max(1, Math.min(maxSplitCount, (int)(totalRowCountEstimate / (long)keysPerSplit)));
        List<Token> tokens = this.keysToTokens(range, keys);
        return this.getSplits(tokens, splitCount, cfs);
    }

    private List<Pair<Range<Token>, Long>> getSplits(List<Token> tokens, int splitCount, ColumnFamilyStore cfs) {
        double step = (double)(tokens.size() - 1) / (double)splitCount;
        Token prevToken = tokens.get(0);
        ArrayList splits = Lists.newArrayListWithExpectedSize((int)splitCount);
        for (int i = 1; i <= splitCount; ++i) {
            int index = (int)Math.round((double)i * step);
            Token token = tokens.get(index);
            Range<Token> range = new Range<Token>(prevToken, token);
            splits.add(Pair.create(range, Math.max((long)cfs.metadata.params.minIndexInterval, cfs.estimatedKeysForRange(range))));
            prevToken = token;
        }
        return splits;
    }

    private List<Token> keysToTokens(Range<Token> range, List<DecoratedKey> keys) {
        ArrayList tokens = Lists.newArrayListWithExpectedSize((int)(keys.size() + 2));
        tokens.add(range.left);
        for (DecoratedKey key : keys) {
            tokens.add(key.getToken());
        }
        tokens.add(range.right);
        return tokens;
    }

    private List<DecoratedKey> keySamples(Iterable<ColumnFamilyStore> cfses, Range<Token> range) {
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (ColumnFamilyStore cfs : cfses) {
            Iterables.addAll(keys, cfs.keySamples(range));
        }
        FBUtilities.sortSampledKeys(keys, range);
        return keys;
    }

    private void startLeaving() {
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.leaving(this.getLocalTokens()));
        this.tokenMetadata.addLeavingEndpoint(FBUtilities.getBroadcastAddress());
        PendingRangeCalculatorService.instance.update();
    }

    @Override
    public void decommission() throws InterruptedException {
        if (!this.tokenMetadata.isMember(FBUtilities.getBroadcastAddress())) {
            throw new UnsupportedOperationException("local node is not a member of the token ring yet");
        }
        if (this.tokenMetadata.cloneAfterAllLeft().sortedTokens().size() < 2) {
            throw new UnsupportedOperationException("no other normal nodes in the ring; decommission would be pointless");
        }
        if (!this.isNormal()) {
            throw new UnsupportedOperationException("Node in " + (Object)((Object)this.operationMode) + " state; wait for status to become normal or restart");
        }
        PendingRangeCalculatorService.instance.blockUntilFinished();
        for (String keyspaceName : Schema.instance.getNonLocalStrategyKeyspaces()) {
            if (this.tokenMetadata.getPendingRanges(keyspaceName, FBUtilities.getBroadcastAddress()).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DECOMMISSIONING");
        }
        this.startLeaving();
        long timeout = Math.max((long)RING_DELAY, BatchlogManager.instance.getBatchlogTimeout());
        this.setMode(Mode.LEAVING, "sleeping " + timeout + " ms for batch processing and pending range setup", true);
        Thread.sleep(timeout);
        Runnable finishLeaving = new Runnable(){

            @Override
            public void run() {
                StorageService.this.shutdownClientServers();
                Gossiper.instance.stop();
                try {
                    MessagingService.instance().shutdown();
                }
                catch (IOError ioe) {
                    logger.info("failed to shutdown message service: {}", (Throwable)ioe);
                }
                StageManager.shutdownNow();
                SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.DECOMMISSIONED);
                StorageService.this.setMode(Mode.DECOMMISSIONED, true);
            }
        };
        this.unbootstrap(finishLeaving);
    }

    private void leaveRing() {
        SystemKeyspace.setBootstrapState(SystemKeyspace.BootstrapState.NEEDS_BOOTSTRAP);
        this.tokenMetadata.removeEndpoint(FBUtilities.getBroadcastAddress());
        PendingRangeCalculatorService.instance.update();
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.left(this.getLocalTokens(), Gossiper.computeExpireTime()));
        int delay = Math.max(RING_DELAY, 2000);
        logger.info("Announcing that I have left the ring for {}ms", (Object)delay);
        Uninterruptibles.sleepUninterruptibly((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void unbootstrap(Runnable onFinish) {
        HashMap<String, Multimap<Range<Token>, InetAddress>> rangesToStream = new HashMap<String, Multimap<Range<Token>, InetAddress>>();
        for (String keyspaceName : Schema.instance.getNonLocalStrategyKeyspaces()) {
            Multimap<Range<Token>, InetAddress> rangesMM = this.getChangedRangesForLeaving(keyspaceName, FBUtilities.getBroadcastAddress());
            if (logger.isDebugEnabled()) {
                logger.debug("Ranges needing transfer are [{}]", (Object)StringUtils.join((Iterable)rangesMM.keySet(), (String)","));
            }
            rangesToStream.put(keyspaceName, rangesMM);
        }
        this.setMode(Mode.LEAVING, "replaying batch log and streaming data to other nodes", true);
        Future<?> batchlogReplay = BatchlogManager.instance.startBatchlogReplay();
        Future<StreamState> streamSuccess = this.streamRanges(rangesToStream);
        logger.debug("waiting for batch log processing.");
        try {
            batchlogReplay.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.setMode(Mode.LEAVING, "streaming hints to other nodes", true);
        Future hintsSuccess = this.streamHints();
        logger.debug("waiting for stream acks.");
        try {
            streamSuccess.get();
            hintsSuccess.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        logger.debug("stream acks all received.");
        this.leaveRing();
        onFinish.run();
    }

    private Future streamHints() {
        return HintsService.instance.transferHints(this::getPreferredHintsStreamTarget);
    }

    private UUID getPreferredHintsStreamTarget() {
        ArrayList<InetAddress> candidates = new ArrayList<InetAddress>(instance.getTokenMetadata().cloneAfterAllLeft().getAllEndpoints());
        candidates.remove(FBUtilities.getBroadcastAddress());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            InetAddress address = (InetAddress)iter.next();
            if (FailureDetector.instance.isAlive(address)) continue;
            iter.remove();
        }
        if (candidates.isEmpty()) {
            logger.warn("Unable to stream hints since no live endpoints seen");
            throw new RuntimeException("Unable to stream hints since no live endpoints seen");
        }
        DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getBroadcastAddress(), candidates);
        InetAddress hintsDestinationHost = (InetAddress)candidates.get(0);
        return this.tokenMetadata.getHostId(hintsDestinationHost);
    }

    @Override
    public void move(String newToken) throws IOException {
        try {
            this.getTokenFactory().validate(newToken);
        }
        catch (ConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        this.move(this.getTokenFactory().fromString(newToken));
    }

    private void move(Token newToken) throws IOException {
        if (newToken == null) {
            throw new IOException("Can't move to the undefined (null) token.");
        }
        if (this.tokenMetadata.sortedTokens().contains(newToken)) {
            throw new IOException("target token " + newToken + " is already owned by another node.");
        }
        InetAddress localAddress = FBUtilities.getBroadcastAddress();
        if (this.getTokenMetadata().getTokens(localAddress).size() > 1) {
            logger.error("Invalid request to move(Token); This node has more than one token and cannot be moved thusly.");
            throw new UnsupportedOperationException("This node has more than one token and cannot be moved thusly.");
        }
        List<String> keyspacesToProcess = Schema.instance.getNonLocalStrategyKeyspaces();
        PendingRangeCalculatorService.instance.blockUntilFinished();
        for (String keyspaceName : keyspacesToProcess) {
            if (this.tokenMetadata.getPendingRanges(keyspaceName, localAddress).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.moving(newToken));
        this.setMode(Mode.MOVING, String.format("Moving %s from %s to %s.", localAddress, this.getLocalTokens().iterator().next(), newToken), true);
        this.setMode(Mode.MOVING, String.format("Sleeping %s ms before start streaming/fetching ranges", RING_DELAY), true);
        Uninterruptibles.sleepUninterruptibly((long)RING_DELAY, (TimeUnit)TimeUnit.MILLISECONDS);
        RangeRelocator relocator = new RangeRelocator(Collections.singleton(newToken), keyspacesToProcess);
        if (relocator.streamsNeeded()) {
            this.setMode(Mode.MOVING, "fetching new ranges and streaming old ranges", true);
            try {
                relocator.stream().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Interrupted while waiting for stream/fetch ranges to finish: " + e.getMessage());
            }
        } else {
            this.setMode(Mode.MOVING, "No ranges to fetch/stream", true);
        }
        this.setTokens(Collections.singleton(newToken));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully moved to new token {}", (Object)this.getLocalTokens().iterator().next());
        }
    }

    @Override
    public String getRemovalStatus() {
        if (this.removingNode == null) {
            return "No token removals in process.";
        }
        return String.format("Removing token (%s). Waiting for replication confirmation from [%s].", this.tokenMetadata.getToken(this.removingNode), StringUtils.join(this.replicatingNodes, (String)","));
    }

    @Override
    public void forceRemoveCompletion() {
        if (!this.replicatingNodes.isEmpty() || !this.tokenMetadata.getLeavingEndpoints().isEmpty()) {
            logger.warn("Removal not confirmed for for {}", (Object)StringUtils.join(this.replicatingNodes, (String)","));
            for (InetAddress endpoint : this.tokenMetadata.getLeavingEndpoints()) {
                UUID hostId = this.tokenMetadata.getHostId(endpoint);
                Gossiper.instance.advertiseTokenRemoved(endpoint, hostId);
                this.excise(this.tokenMetadata.getTokens(endpoint), endpoint);
            }
            this.replicatingNodes.clear();
            this.removingNode = null;
        } else {
            logger.warn("No tokens to force removal on, call 'removenode' first");
        }
    }

    @Override
    public void removeNode(String hostIdString) {
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        UUID localHostId = this.tokenMetadata.getHostId(myAddress);
        UUID hostId = UUID.fromString(hostIdString);
        InetAddress endpoint = this.tokenMetadata.getEndpointForHostId(hostId);
        if (endpoint == null) {
            throw new UnsupportedOperationException("Host ID not found.");
        }
        Collection<Token> tokens = this.tokenMetadata.getTokens(endpoint);
        if (endpoint.equals(myAddress)) {
            throw new UnsupportedOperationException("Cannot remove self");
        }
        if (Gossiper.instance.getLiveMembers().contains(endpoint)) {
            throw new UnsupportedOperationException("Node " + endpoint + " is alive and owns this ID. Use decommission command to remove it from the ring");
        }
        if (this.tokenMetadata.isLeaving(endpoint)) {
            logger.warn("Node {} is already being removed, continuing removal anyway", (Object)endpoint);
        }
        if (!this.replicatingNodes.isEmpty()) {
            throw new UnsupportedOperationException("This node is already processing a removal. Wait for it to complete, or use 'removenode force' if this has failed.");
        }
        for (String keyspaceName : Schema.instance.getNonLocalStrategyKeyspaces()) {
            if (Keyspace.open(keyspaceName).getReplicationStrategy().getReplicationFactor() == 1) continue;
            Multimap<Range<Token>, InetAddress> changedRanges = this.getChangedRangesForLeaving(keyspaceName, endpoint);
            IFailureDetector failureDetector = FailureDetector.instance;
            for (InetAddress ep : changedRanges.values()) {
                if (failureDetector.isAlive(ep)) {
                    this.replicatingNodes.add(ep);
                    continue;
                }
                logger.warn("Endpoint {} is down and will not receive data for re-replication of {}", (Object)ep, (Object)endpoint);
            }
        }
        this.removingNode = endpoint;
        this.tokenMetadata.addLeavingEndpoint(endpoint);
        PendingRangeCalculatorService.instance.update();
        Gossiper.instance.advertiseRemoving(endpoint, hostId, localHostId);
        this.restoreReplicaCount(endpoint, myAddress);
        while (!this.replicatingNodes.isEmpty()) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.excise(tokens, endpoint);
        Gossiper.instance.advertiseTokenRemoved(endpoint, hostId);
        this.replicatingNodes.clear();
        this.removingNode = null;
    }

    public void confirmReplication(InetAddress node) {
        if (!this.replicatingNodes.isEmpty()) {
            this.replicatingNodes.remove(node);
        } else {
            logger.info("Received unexpected REPLICATION_FINISHED message from {}. Was this node recently a removal coordinator?", (Object)node);
        }
    }

    @Override
    public String getOperationMode() {
        return this.operationMode.toString();
    }

    @Override
    public boolean isStarting() {
        return this.operationMode == Mode.STARTING;
    }

    public boolean isMoving() {
        return this.operationMode == Mode.MOVING;
    }

    public boolean isJoining() {
        return this.operationMode == Mode.JOINING;
    }

    @Override
    public boolean isDrained() {
        return this.operationMode == Mode.DRAINED;
    }

    @Override
    public boolean isDraining() {
        return this.operationMode == Mode.DRAINING;
    }

    public boolean isNormal() {
        return this.operationMode == Mode.NORMAL;
    }

    @Override
    public String getDrainProgress() {
        return String.format("Drained %s/%s ColumnFamilies", this.remainingCFs, this.totalCFs);
    }

    @Override
    public synchronized void drain() throws IOException, InterruptedException, ExecutionException {
        this.drain(false);
    }

    protected synchronized void drain(boolean isFinalShutdown) throws IOException, InterruptedException, ExecutionException {
        LocalAwareExecutorService counterMutationStage = StageManager.getStage(Stage.COUNTER_MUTATION);
        LocalAwareExecutorService viewMutationStage = StageManager.getStage(Stage.VIEW_MUTATION);
        LocalAwareExecutorService mutationStage = StageManager.getStage(Stage.MUTATION);
        if (mutationStage.isTerminated() && counterMutationStage.isTerminated() && viewMutationStage.isTerminated()) {
            if (!isFinalShutdown) {
                logger.warn("Cannot drain node (did it already happen?)");
            }
            return;
        }
        assert (!this.isShutdown);
        this.isShutdown = true;
        try {
            this.setMode(Mode.DRAINING, "starting drain process", !isFinalShutdown);
            try {
                BatchlogManager.instance.shutdownAndWait(1L, TimeUnit.MINUTES);
            }
            catch (TimeoutException t) {
                logger.error("Batchlog manager timed out shutting down", (Throwable)t);
            }
            HintsService.instance.pauseDispatch();
            if (this.daemon != null) {
                this.shutdownClientServers();
            }
            ScheduledExecutors.optionalTasks.shutdown();
            Gossiper.instance.stop();
            if (!isFinalShutdown) {
                this.setMode(Mode.DRAINING, "shutting down MessageService", false);
            }
            MessagingService.instance().shutdown();
            if (!isFinalShutdown) {
                this.setMode(Mode.DRAINING, "clearing mutation stage", false);
            }
            viewMutationStage.shutdown();
            counterMutationStage.shutdown();
            mutationStage.shutdown();
            viewMutationStage.awaitTermination(3600L, TimeUnit.SECONDS);
            counterMutationStage.awaitTermination(3600L, TimeUnit.SECONDS);
            mutationStage.awaitTermination(3600L, TimeUnit.SECONDS);
            StorageProxy.instance.verifyNoHintsInProgress();
            if (!isFinalShutdown) {
                this.setMode(Mode.DRAINING, "flushing column families", false);
            }
            this.disableAutoCompaction();
            this.totalCFs = 0;
            for (Keyspace keyspace : Keyspace.nonSystem()) {
                this.totalCFs += keyspace.getColumnFamilyStores().size();
            }
            this.remainingCFs = this.totalCFs;
            ArrayList<ListenableFuture<ReplayPosition>> flushes = new ArrayList<ListenableFuture<ReplayPosition>>();
            for (Keyspace keyspace : Keyspace.nonSystem()) {
                for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                    flushes.add(cfs.forceFlush());
                }
            }
            for (Future future : flushes) {
                try {
                    FBUtilities.waitOnFuture(future);
                }
                catch (Throwable t) {
                    JVMStabilityInspector.inspectThrowable(t);
                    logger.warn("Caught exception while waiting for memtable flushes during shutdown hook", t);
                }
                --this.remainingCFs;
            }
            CompactionManager.instance.forceShutdown();
            flushes.clear();
            for (Keyspace keyspace : Keyspace.system()) {
                for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                    flushes.add(cfs.forceFlush());
                }
            }
            FBUtilities.waitOnFutures(flushes);
            HintsService.instance.shutdownBlocking();
            CompactionManager.instance.forceShutdown();
            CommitLog.instance.forceRecycleAllSegments();
            CommitLog.instance.shutdownBlocking();
            ScheduledExecutors.nonPeriodicTasks.shutdown();
            if (!ScheduledExecutors.nonPeriodicTasks.awaitTermination(1L, TimeUnit.MINUTES)) {
                logger.warn("Unable to terminate non-periodic tasks within 1 minute.");
            }
            ColumnFamilyStore.shutdownPostFlushExecutor();
            this.setMode(Mode.DRAINED, !isFinalShutdown);
        }
        catch (Throwable t) {
            logger.error("Caught an exception while draining ", t);
        }
    }

    @VisibleForTesting
    public void disableAutoCompaction() {
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                cfs.disableAutoCompaction();
            }
        }
    }

    synchronized void checkServiceAllowedToStart(String service) {
        if (this.isDraining()) {
            throw new IllegalStateException(String.format("Unable to start %s because the node is draining.", service));
        }
        if (this.isShutdown()) {
            throw new IllegalStateException(String.format("Unable to start %s because the node was drained.", service));
        }
        if (!this.isNormal()) {
            throw new IllegalStateException(String.format("Unable to start %s because the node is not in the normal state.", service));
        }
    }

    @VisibleForTesting
    public IPartitioner setPartitionerUnsafe(IPartitioner newPartitioner) {
        IPartitioner oldPartitioner = DatabaseDescriptor.setPartitionerUnsafe(newPartitioner);
        this.tokenMetadata = this.tokenMetadata.cloneWithNewPartitioner(newPartitioner);
        this.valueFactory = new VersionedValue.VersionedValueFactory(newPartitioner);
        return oldPartitioner;
    }

    TokenMetadata setTokenMetadataUnsafe(TokenMetadata tmd) {
        TokenMetadata old = this.tokenMetadata;
        this.tokenMetadata = tmd;
        return old;
    }

    @Override
    public void truncate(String keyspace, String table) throws TimeoutException, IOException {
        try {
            StorageProxy.truncateBlocking(keyspace, table);
        }
        catch (UnavailableException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public Map<InetAddress, Float> getOwnership() {
        ArrayList<Token> sortedTokens = this.tokenMetadata.sortedTokens();
        TreeMap<Token, Float> tokenMap = new TreeMap<Token, Float>(this.tokenMetadata.partitioner.describeOwnership(sortedTokens));
        LinkedHashMap<InetAddress, Float> nodeMap = new LinkedHashMap<InetAddress, Float>();
        for (Map.Entry entry : tokenMap.entrySet()) {
            InetAddress endpoint = this.tokenMetadata.getEndpoint((Token)entry.getKey());
            Float tokenOwnership = (Float)entry.getValue();
            if (nodeMap.containsKey(endpoint)) {
                nodeMap.put(endpoint, Float.valueOf(((Float)nodeMap.get(endpoint)).floatValue() + tokenOwnership.floatValue()));
                continue;
            }
            nodeMap.put(endpoint, tokenOwnership);
        }
        return nodeMap;
    }

    public LinkedHashMap<InetAddress, Float> effectiveOwnership(String keyspace) throws IllegalStateException {
        AbstractReplicationStrategy strategy;
        if (keyspace != null) {
            Keyspace keyspaceInstance = Schema.instance.getKeyspaceInstance(keyspace);
            if (keyspaceInstance == null) {
                throw new IllegalArgumentException("The keyspace " + keyspace + ", does not exist");
            }
            if (keyspaceInstance.getReplicationStrategy() instanceof LocalStrategy) {
                throw new IllegalStateException("Ownership values for keyspaces with LocalStrategy are meaningless");
            }
            strategy = keyspaceInstance.getReplicationStrategy();
        } else {
            Keyspace keyspaceInstance;
            List<String> userKeyspaces = Schema.instance.getUserKeyspaces();
            if (userKeyspaces.size() > 0) {
                keyspace = userKeyspaces.get(0);
                AbstractReplicationStrategy replicationStrategy = Schema.instance.getKeyspaceInstance(keyspace).getReplicationStrategy();
                for (String string : userKeyspaces) {
                    if (Schema.instance.getKeyspaceInstance(string).getReplicationStrategy().hasSameSettings(replicationStrategy)) continue;
                    throw new IllegalStateException("Non-system keyspaces don't have the same replication settings, effective ownership information is meaningless");
                }
            } else {
                keyspace = "system_traces";
            }
            if ((keyspaceInstance = Schema.instance.getKeyspaceInstance(keyspace)) == null) {
                throw new IllegalArgumentException("The node does not have " + keyspace + " yet, probably still bootstrapping");
            }
            strategy = keyspaceInstance.getReplicationStrategy();
        }
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        ArrayList<Collection> endpointsGroupedByDc = new ArrayList<Collection>();
        TreeMap sortedDcsToEndpoints = new TreeMap();
        sortedDcsToEndpoints.putAll(metadata.getTopology().getDatacenterEndpoints().asMap());
        for (Collection endpoints : sortedDcsToEndpoints.values()) {
            endpointsGroupedByDc.add(endpoints);
        }
        Map<Token, Float> map = this.tokenMetadata.partitioner.describeOwnership(this.tokenMetadata.sortedTokens());
        LinkedHashMap finalOwnership = Maps.newLinkedHashMap();
        Multimap<InetAddress, Range<Token>> endpointToRanges = strategy.getAddressRanges();
        for (Collection endpoints : endpointsGroupedByDc) {
            for (InetAddress endpoint : endpoints) {
                float ownership = 0.0f;
                for (Range range : endpointToRanges.get((Object)endpoint)) {
                    if (!map.containsKey(range.right)) continue;
                    ownership += map.get(range.right).floatValue();
                }
                finalOwnership.put(endpoint, Float.valueOf(ownership));
            }
        }
        return finalOwnership;
    }

    @Override
    public List<String> getKeyspaces() {
        ArrayList<String> keyspaceNamesList = new ArrayList<String>(Schema.instance.getKeyspaces());
        return Collections.unmodifiableList(keyspaceNamesList);
    }

    @Override
    public List<String> getNonSystemKeyspaces() {
        return Collections.unmodifiableList(Schema.instance.getNonSystemKeyspaces());
    }

    @Override
    public List<String> getNonLocalStrategyKeyspaces() {
        return Collections.unmodifiableList(Schema.instance.getNonLocalStrategyKeyspaces());
    }

    @Override
    public void updateSnitch(String epSnitchClassName, Boolean dynamic, Integer dynamicUpdateInterval, Integer dynamicResetInterval, Double dynamicBadnessThreshold) throws ClassNotFoundException {
        IEndpointSnitch newSnitch;
        IEndpointSnitch oldSnitch = DatabaseDescriptor.getEndpointSnitch();
        try {
            newSnitch = (IEndpointSnitch)FBUtilities.construct(epSnitchClassName, "snitch");
        }
        catch (ConfigurationException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        if (dynamic.booleanValue()) {
            DatabaseDescriptor.setDynamicUpdateInterval(dynamicUpdateInterval);
            DatabaseDescriptor.setDynamicResetInterval(dynamicResetInterval);
            DatabaseDescriptor.setDynamicBadnessThreshold(dynamicBadnessThreshold);
            newSnitch = new DynamicEndpointSnitch(newSnitch);
        }
        DatabaseDescriptor.setEndpointSnitch(newSnitch);
        for (String ks : Schema.instance.getKeyspaces()) {
            Keyspace.open((String)ks).getReplicationStrategy().snitch = newSnitch;
        }
        if (oldSnitch instanceof DynamicEndpointSnitch) {
            ((DynamicEndpointSnitch)oldSnitch).unregisterMBean();
        }
        this.updateTopology();
    }

    private Future<StreamState> streamRanges(Map<String, Multimap<Range<Token>, InetAddress>> rangesToStreamByKeyspace) {
        Map<InetAddress, LinkedList<Range>> rangesPerEndpoint;
        HashMap<String, Map<InetAddress, LinkedList<Range>>> sessionsToStreamByKeyspace = new HashMap<String, Map<InetAddress, LinkedList<Range>>>();
        for (Map.Entry<String, Multimap<Range<Token>, InetAddress>> entry : rangesToStreamByKeyspace.entrySet()) {
            String keyspace = entry.getKey();
            Multimap<Range<Token>, InetAddress> rangesWithEndpoints = entry.getValue();
            if (rangesWithEndpoints.isEmpty()) continue;
            rangesPerEndpoint = new HashMap();
            for (Map.Entry entry2 : rangesWithEndpoints.entries()) {
                Range range = (Range)entry2.getKey();
                InetAddress endpoint = (InetAddress)entry2.getValue();
                LinkedList<Range> curRanges = (LinkedList<Range>)rangesPerEndpoint.get(endpoint);
                if (curRanges == null) {
                    curRanges = new LinkedList<Range>();
                    rangesPerEndpoint.put(endpoint, curRanges);
                }
                curRanges.add(range);
            }
            sessionsToStreamByKeyspace.put(keyspace, rangesPerEndpoint);
        }
        StreamPlan streamPlan = new StreamPlan("Unbootstrap");
        for (Map.Entry entry : sessionsToStreamByKeyspace.entrySet()) {
            String keyspaceName = (String)entry.getKey();
            rangesPerEndpoint = (Map)entry.getValue();
            for (Map.Entry entry3 : rangesPerEndpoint.entrySet()) {
                List ranges = (List)entry3.getValue();
                InetAddress newEndpoint = (InetAddress)entry3.getKey();
                InetAddress preferred = SystemKeyspace.getPreferredIP(newEndpoint);
                streamPlan.transferRanges(newEndpoint, preferred, keyspaceName, ranges);
            }
        }
        return streamPlan.execute();
    }

    public Pair<Set<Range<Token>>, Set<Range<Token>>> calculateStreamAndFetchRanges(Collection<Range<Token>> current, Collection<Range<Token>> updated) {
        boolean intersect;
        HashSet<Range<Token>> toStream = new HashSet<Range<Token>>();
        HashSet<Range<Token>> toFetch = new HashSet<Range<Token>>();
        for (Range<Token> r1 : current) {
            intersect = false;
            for (Range<Token> r2 : updated) {
                if (!r1.intersects(r2)) continue;
                toStream.addAll(r1.subtract(r2));
                intersect = true;
            }
            if (intersect) continue;
            toStream.add(r1);
        }
        for (Range<Token> r2 : updated) {
            intersect = false;
            for (Range<Token> r1 : current) {
                if (!r2.intersects(r1)) continue;
                toFetch.addAll(r2.subtract(r1));
                intersect = true;
            }
            if (intersect) continue;
            toFetch.add(r2);
        }
        return Pair.create(toStream, toFetch);
    }

    @Override
    public void bulkLoad(String directory) {
        try {
            this.bulkLoadInternal(directory).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String bulkLoadAsync(String directory) {
        return this.bulkLoadInternal((String)directory).planId.toString();
    }

    private StreamResultFuture bulkLoadInternal(String directory) {
        File dir = new File(directory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory " + directory);
        }
        SSTableLoader.Client client = new SSTableLoader.Client(){
            private String keyspace;

            @Override
            public void init(String keyspace) {
                this.keyspace = keyspace;
                try {
                    for (Map.Entry<Range<Token>, List<InetAddress>> entry : instance.getRangeToAddressMap(keyspace).entrySet()) {
                        Range<Token> range = entry.getKey();
                        for (InetAddress endpoint : entry.getValue()) {
                            this.addRangeForEndpoint(range, endpoint);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public CFMetaData getTableMetadata(String tableName) {
                return Schema.instance.getCFMetaData(this.keyspace, tableName);
            }
        };
        return new SSTableLoader(dir, client, new OutputHandler.LogOutput()).stream();
    }

    @Override
    public void rescheduleFailedDeletions() {
        LifecycleTransaction.rescheduleFailedDeletions();
    }

    @Override
    public void loadNewSSTables(String ksName, String cfName) {
        if (!this.isInitialized()) {
            throw new RuntimeException("Not yet initialized, can't load new sstables");
        }
        ColumnFamilyStore.loadNewSSTables(ksName, cfName);
    }

    @Override
    public List<String> sampleKeyRange() {
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (Keyspace keyspace : Keyspace.nonLocalStrategy()) {
            for (Range<Token> range : this.getPrimaryRangesForEndpoint(keyspace.getName(), FBUtilities.getBroadcastAddress())) {
                keys.addAll(this.keySamples(keyspace.getColumnFamilyStores(), range));
            }
        }
        ArrayList<String> sampledKeys = new ArrayList<String>(keys.size());
        for (DecoratedKey key : keys) {
            sampledKeys.add(key.getToken().toString());
        }
        return sampledKeys;
    }

    @Override
    public void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        String[] indices = Arrays.asList(idxNames).stream().map(p -> SecondaryIndexManager.isIndexColumnFamily(p) ? SecondaryIndexManager.getIndexName(p) : p).collect(Collectors.toList()).toArray(new String[idxNames.length]);
        ColumnFamilyStore.rebuildSecondaryIndex(ksName, cfName, indices);
    }

    @Override
    public void resetLocalSchema() throws IOException {
        MigrationManager.resetLocalSchema();
    }

    @Override
    public void reloadLocalSchema() {
        SchemaKeyspace.reloadSchemaAndAnnounceVersion();
    }

    @Override
    public void setTraceProbability(double probability) {
        this.traceProbability = probability;
    }

    @Override
    public double getTraceProbability() {
        return this.traceProbability;
    }

    @Override
    public void disableAutoCompaction(String ks, String ... tables) throws IOException {
        for (ColumnFamilyStore cfs : this.getValidColumnFamilies(true, true, ks, tables)) {
            cfs.disableAutoCompaction();
        }
    }

    @Override
    public synchronized void enableAutoCompaction(String ks, String ... tables) throws IOException {
        this.checkServiceAllowedToStart("auto compaction");
        for (ColumnFamilyStore cfs : this.getValidColumnFamilies(true, true, ks, tables)) {
            cfs.enableAutoCompaction();
        }
    }

    @Override
    public String getClusterName() {
        return DatabaseDescriptor.getClusterName();
    }

    @Override
    public String getPartitionerName() {
        return DatabaseDescriptor.getPartitionerName();
    }

    @Override
    public int getTombstoneWarnThreshold() {
        return DatabaseDescriptor.getTombstoneWarnThreshold();
    }

    @Override
    public void setTombstoneWarnThreshold(int threshold) {
        DatabaseDescriptor.setTombstoneWarnThreshold(threshold);
        logger.info("updated tombstone_warn_threshold to {}", (Object)threshold);
    }

    @Override
    public int getTombstoneFailureThreshold() {
        return DatabaseDescriptor.getTombstoneFailureThreshold();
    }

    @Override
    public void setTombstoneFailureThreshold(int threshold) {
        DatabaseDescriptor.setTombstoneFailureThreshold(threshold);
        logger.info("updated tombstone_failure_threshold to {}", (Object)threshold);
    }

    @Override
    public int getCachedReplicaRowsWarnThreshold() {
        return DatabaseDescriptor.getCachedReplicaRowsWarnThreshold();
    }

    @Override
    public void setCachedReplicaRowsWarnThreshold(int threshold) {
        DatabaseDescriptor.setCachedReplicaRowsWarnThreshold(threshold);
        logger.info("updated replica_filtering_protection.cached_rows_warn_threshold to {}", (Object)threshold);
    }

    @Override
    public int getCachedReplicaRowsFailThreshold() {
        return DatabaseDescriptor.getCachedReplicaRowsFailThreshold();
    }

    @Override
    public void setCachedReplicaRowsFailThreshold(int threshold) {
        DatabaseDescriptor.setCachedReplicaRowsFailThreshold(threshold);
        logger.info("updated replica_filtering_protection.cached_rows_fail_threshold to {}", (Object)threshold);
    }

    @Override
    public int getBatchSizeFailureThreshold() {
        return DatabaseDescriptor.getBatchSizeFailThresholdInKB();
    }

    @Override
    public void setBatchSizeFailureThreshold(int threshold) {
        DatabaseDescriptor.setBatchSizeFailThresholdInKB(threshold);
        logger.info("updated batch_size_fail_threshold_in_kb to {}", (Object)threshold);
    }

    @Override
    public void setHintedHandoffThrottleInKB(int throttleInKB) {
        DatabaseDescriptor.setHintedHandoffThrottleInKB(throttleInKB);
        logger.info("updated hinted_handoff_throttle_in_kb to {}", (Object)throttleInKB);
    }

    @VisibleForTesting
    public void shutdownServer() {
        if (this.drainOnShutdown != null) {
            Runtime.getRuntime().removeShutdownHook(this.drainOnShutdown);
        }
    }

    @Override
    public Map<String, Set<InetAddress>> getOutstandingSchemaVersions() {
        Map<UUID, Set<InetAddress>> outstanding = MigrationCoordinator.instance.outstandingVersions();
        return outstanding.entrySet().stream().collect(Collectors.toMap(e -> ((UUID)e.getKey()).toString(), Map.Entry::getValue));
    }

    private class RangeRelocator {
        private final StreamPlan streamPlan = new StreamPlan("Relocation");

        private RangeRelocator(Collection<Token> tokens, List<String> keyspaceNames) {
            this.calculateToFromStreams(tokens, keyspaceNames);
        }

        private void calculateToFromStreams(Collection<Token> newTokens, List<String> keyspaceNames) {
            InetAddress localAddress = FBUtilities.getBroadcastAddress();
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            TokenMetadata tokenMetaCloneAllSettled = StorageService.this.tokenMetadata.cloneAfterAllSettled();
            TokenMetadata tokenMetaClone = StorageService.this.tokenMetadata.cloneOnlyTokenMap();
            for (String keyspace : keyspaceNames) {
                AbstractReplicationStrategy strategy = Keyspace.open(keyspace).getReplicationStrategy();
                Multimap<InetAddress, Range<Token>> endpointToRanges = strategy.getAddressRanges();
                logger.debug("Calculating ranges to stream and request for keyspace {}", (Object)keyspace);
                for (Token newToken : newTokens) {
                    Iterator toFetch2;
                    Collection currentRanges = endpointToRanges.get((Object)localAddress);
                    Collection<Range<Token>> updatedRanges = strategy.getPendingAddressRanges(tokenMetaClone, newToken, localAddress);
                    Multimap<Range<Token>, InetAddress> rangeAddresses = strategy.getRangeAddresses(tokenMetaClone);
                    Pair<Set<Range<Token>>, Set<Range<Token>>> rangesPerKeyspace = StorageService.this.calculateStreamAndFetchRanges(currentRanges, updatedRanges);
                    ArrayListMultimap rangesToFetchWithPreferredEndpoints = ArrayListMultimap.create();
                    for (Iterator toFetch2 : (Set)rangesPerKeyspace.right) {
                        for (Range range : rangeAddresses.keySet()) {
                            if (!range.contains(toFetch2)) continue;
                            ArrayList endpoints = null;
                            if (StorageService.this.useStrictConsistency) {
                                HashSet oldEndpoints = Sets.newHashSet((Iterable)rangeAddresses.get((Object)range));
                                HashSet newEndpoints = Sets.newHashSet(strategy.calculateNaturalEndpoints((Token)((Range)((Object)toFetch2)).right, tokenMetaCloneAllSettled));
                                if (oldEndpoints.size() == strategy.getReplicationFactor()) {
                                    oldEndpoints.removeAll(newEndpoints);
                                    if (oldEndpoints.isEmpty()) continue;
                                    assert (oldEndpoints.size() == 1) : "Expected 1 endpoint but found " + oldEndpoints.size();
                                }
                                endpoints = Lists.newArrayList((Object[])new InetAddress[]{(InetAddress)oldEndpoints.iterator().next()});
                            } else {
                                endpoints = snitch.getSortedListByProximity(localAddress, rangeAddresses.get((Object)range));
                            }
                            rangesToFetchWithPreferredEndpoints.putAll(toFetch2, endpoints);
                        }
                        Collection addressList = rangesToFetchWithPreferredEndpoints.get((Object)toFetch2);
                        if (addressList == null || addressList.isEmpty() || !StorageService.this.useStrictConsistency) continue;
                        if (addressList.size() > 1) {
                            throw new IllegalStateException("Multiple strict sources found for " + toFetch2);
                        }
                        InetAddress sourceIp = (InetAddress)addressList.iterator().next();
                        if (!Gossiper.instance.isEnabled() || Gossiper.instance.getEndpointStateForEndpoint(sourceIp).isAlive()) continue;
                        throw new RuntimeException("A node required to move the data consistently is down (" + sourceIp + ").  If you wish to move the data from a potentially inconsistent replica, restart the node with -Dcassandra.consistent.rangemovement=false");
                    }
                    HashMultimap endpointRanges = HashMultimap.create();
                    for (Range toStream : (Set)rangesPerKeyspace.left) {
                        ImmutableSet currentEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)toStream.right, tokenMetaClone));
                        ImmutableSet newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)toStream.right, tokenMetaCloneAllSettled));
                        logger.debug("Range: {} Current endpoints: {} New endpoints: {}", new Object[]{toStream, currentEndpoints, newEndpoints});
                        for (InetAddress address : Sets.difference((Set)newEndpoints, (Set)currentEndpoints)) {
                            logger.debug("Range {} has new owner {}", (Object)toStream, (Object)address);
                            endpointRanges.put((Object)address, (Object)toStream);
                        }
                    }
                    toFetch2 = endpointRanges.keySet().iterator();
                    while (toFetch2.hasNext()) {
                        InetAddress address = (InetAddress)toFetch2.next();
                        logger.debug("Will stream range {} of keyspace {} to endpoint {}", new Object[]{endpointRanges.get((Object)address), keyspace, address});
                        InetAddress preferred = SystemKeyspace.getPreferredIP(address);
                        this.streamPlan.transferRanges(address, preferred, keyspace, endpointRanges.get((Object)address));
                    }
                    Multimap<InetAddress, Range<Token>> workMap = RangeStreamer.getWorkMap((Multimap<Range<Token>, InetAddress>)rangesToFetchWithPreferredEndpoints, keyspace, FailureDetector.instance, StorageService.this.useStrictConsistency);
                    for (InetAddress address : workMap.keySet()) {
                        logger.debug("Will request range {} of keyspace {} from endpoint {}", new Object[]{workMap.get((Object)address), keyspace, address});
                        InetAddress preferred = SystemKeyspace.getPreferredIP(address);
                        this.streamPlan.requestRanges(address, preferred, keyspace, workMap.get((Object)address));
                    }
                    logger.debug("Keyspace {}: work map {}.", (Object)keyspace, workMap);
                }
            }
        }

        public Future<StreamState> stream() {
            return this.streamPlan.execute();
        }

        public boolean streamsNeeded() {
            return !this.streamPlan.isEmpty();
        }
    }

    private static enum Mode {
        STARTING,
        NORMAL,
        JOINING,
        LEAVING,
        DECOMMISSIONED,
        MOVING,
        DRAINING,
        DRAINED;

    }
}

