/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;

public final class ChannelProxy
extends SharedCloseableImpl {
    private final String filePath;
    private final FileChannel channel;

    public static FileChannel openChannel(File file) {
        try {
            return FileChannel.open(file.toPath(), StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ChannelProxy(String path) {
        this(new File(path));
    }

    public ChannelProxy(File file) {
        this(file.getPath(), ChannelProxy.openChannel(file));
    }

    public ChannelProxy(String filePath, FileChannel channel) {
        super((RefCounted.Tidy)new Cleanup(filePath, channel));
        this.filePath = filePath;
        this.channel = channel;
    }

    public ChannelProxy(ChannelProxy copy) {
        super((SharedCloseableImpl)copy);
        this.filePath = copy.filePath;
        this.channel = copy.channel;
    }

    public ChannelProxy sharedCopy() {
        return new ChannelProxy(this);
    }

    public String filePath() {
        return this.filePath;
    }

    public int read(ByteBuffer buffer, long position) {
        try {
            return this.channel.read(buffer, position);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
    }

    public long transferTo(long position, long count, WritableByteChannel target) {
        try {
            return this.channel.transferTo(position, count, target);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
    }

    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) {
        try {
            return this.channel.map(mode, position, size);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
    }

    public long size() {
        try {
            return this.channel.size();
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
    }

    public int getFileDescriptor() {
        return NativeLibrary.getfd((FileChannel)this.channel);
    }

    public String toString() {
        return this.filePath();
    }

    private static final class Cleanup
    implements RefCounted.Tidy {
        final String filePath;
        final FileChannel channel;

        Cleanup(String filePath, FileChannel channel) {
            this.filePath = filePath;
            this.channel = channel;
        }

        public String name() {
            return this.filePath;
        }

        public void tidy() {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, this.filePath);
            }
        }
    }
}

