/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.utils.concurrent.OpOrder;

public interface Index {
    public Callable<?> getInitializationTask();

    public IndexMetadata getIndexMetadata();

    public Callable<?> getMetadataReloadTask(IndexMetadata var1);

    public void register(IndexRegistry var1);

    public Optional<ColumnFamilyStore> getBackingTable();

    public Callable<?> getBlockingFlushTask();

    public Callable<?> getInvalidateTask();

    public Callable<?> getTruncateTask(long var1);

    public boolean shouldBuildBlocking();

    public boolean dependsOn(ColumnDefinition var1);

    public boolean supportsExpression(ColumnDefinition var1, Operator var2);

    public AbstractType<?> customExpressionValueType();

    public RowFilter getPostIndexQueryFilter(RowFilter var1);

    public long getEstimatedResultRows();

    public void validate(PartitionUpdate var1) throws InvalidRequestException;

    public Indexer indexerFor(DecoratedKey var1, PartitionColumns var2, int var3, OpOrder.Group var4, IndexTransaction.Type var5);

    default public void validate(ReadCommand command) throws InvalidRequestException {
    }

    default public boolean supportsReplicaFilteringProtection(RowFilter rowFilter) {
        return true;
    }

    public BiFunction<PartitionIterator, ReadCommand, PartitionIterator> postProcessorFor(ReadCommand var1);

    public Searcher searcherFor(ReadCommand var1);

    public static interface Searcher {
        public UnfilteredPartitionIterator search(ReadOrderGroup var1);
    }

    public static interface Indexer {
        public void begin();

        public void partitionDelete(DeletionTime var1);

        public void rangeTombstone(RangeTombstone var1);

        public void insertRow(Row var1);

        public void updateRow(Row var1, Row var2);

        public void removeRow(Row var1);

        public void finish();
    }
}

